/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.wsdl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.sql.project.dbmodel.DBMetaData;
import org.netbeans.modules.sql.project.dbmodel.Parameter;
import org.netbeans.modules.sql.project.dbmodel.PrepStmt;
import org.netbeans.modules.sql.project.dbmodel.Procedure;
import org.netbeans.modules.sql.project.dbmodel.ResultSetColumn;
import org.netbeans.modules.sql.project.dbmodel.ResultSetColumns;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLGenerator {
    public static HashMap builtInTypes = new HashMap();
    private static Logger logger = Logger.getLogger(WSDLGenerator.class.getName());
    private static WSDLFactory factory;
    private static DocumentBuilderFactory docBuilderfactory;
    private Definition def;
    private DBMetaData dbmeta;
    private String sqlFileName;
    private List sqlFileList = null;
    private String schema;
    private String wsdlFileLocation;
    private String engineFileName;
    private Document doc;
    private String STATEMENT_TYPE = null;
    private String wsdlFileName = null;
    private boolean wsdlFileExsits = false;
    private Connection conn;
    private DatabaseConnection dbConn;
    private JFrame frame;
    private static final String SELECT_STATEMENT = "SELECT";
    private static final String INSERT_STATEMENT = "INSERT";
    private static final String UPDATE_STATEMENT = "UPDATE";
    private static final String DELETE_STATEMENT = "DELETE";
    private static final String DDL_STATEMENT_CREATE = "CREATE";
    private static final String DDL_STATEMENT_ALTER = "ALTER";
    private static final String DDL_STATEMENT_DROP = "DROP";
    private static final String TRUNCATE_STATEMENT = "TRUNCATE";
    private static final String PROC_STATEMENT = "EXEC";

    public WSDLGenerator(DBMetaData dBMetaData, String string, String string2, String string3) {
        this.dbmeta = dBMetaData;
        this.sqlFileName = string;
        this.wsdlFileLocation = string2;
        this.engineFileName = string3.substring(0, string3.indexOf(".xml"));
    }

    public WSDLGenerator(Connection connection, List list, String string, String string2, String string3) {
        this.conn = connection;
        this.sqlFileList = list;
        this.wsdlFileLocation = string2;
        this.wsdlFileName = string;
        this.engineFileName = string3.substring(0, string3.indexOf(".xml"));
    }

    private static void initFactory() {
        if (factory == null) {
            try {
                factory = WSDLFactory.newInstance();
                docBuilderfactory = DocumentBuilderFactory.newInstance();
            }
            catch (WSDLException wSDLException) {
                logger.log(Level.WARNING, wSDLException.getMessage(), wSDLException);
            }
        }
    }

    private Definition getWsdlTemplate() throws WSDLException, ParserConfigurationException, SAXException, IOException {
        Definition definition = null;
        try {
            URL uRL = WSDLGenerator.class.getResource("sqlpro.wsdl.template");
            if (uRL != null) {
                String string = uRL.getFile().indexOf(".jar") > 0 ? "jar:" + uRL.getFile() : uRL.getFile();
                definition = this.readWSDLFile(string);
            } else {
                logger.log(Level.WARNING, "Unable to locate the wsdl template");
            }
        }
        catch (WSDLException wSDLException) {
            logger.log(Level.SEVERE, wSDLException.getMessage(), wSDLException);
            throw wSDLException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.log(Level.SEVERE, parserConfigurationException.getMessage(), parserConfigurationException);
            throw parserConfigurationException;
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, sAXException.getMessage(), sAXException);
            throw sAXException;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            throw iOException;
        }
        return definition;
    }

    private Definition readWSDLFile(String string) throws SAXException, IOException, ParserConfigurationException, WSDLException {
        WSDLReader wSDLReader = factory.newWSDLReader();
        docBuilderfactory.setNamespaceAware(true);
        docBuilderfactory.setValidating(false);
        this.doc = docBuilderfactory.newDocumentBuilder().parse(string);
        Definition definition = wSDLReader.readWSDL(string, this.doc);
        return definition;
    }

    public Definition generateWSDL() throws Exception {
        try {
            File file = new File(this.wsdlFileLocation + File.separator + this.wsdlFileName + ".wsdl");
            File file2 = new File(this.wsdlFileLocation + File.separator + this.wsdlFileName + ".wsdl_old");
            if (file.exists()) {
                try {
                    int n;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    byte[] byArray = new byte[1024];
                    while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    ((InputStream)fileInputStream).close();
                    ((OutputStream)fileOutputStream).close();
                    System.out.println("File copied.");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.log(Level.WARNING, fileNotFoundException.getMessage(), fileNotFoundException);
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, iOException.getMessage(), iOException);
                }
            }
            this.def = this.getWsdlTemplate();
            this.modifyWSDL();
            this.writeWsdl();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        return this.def;
    }

    private Definition loadExistingWSDLFile(String string) {
        try {
            URI uRI = new File(this.wsdlFileLocation + File.separator + string + ".wsdl").toURI();
            Definition definition = this.readWSDLFile(uRI.getPath());
            return definition;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Unable to load existing wsdl file " + string + " Reason: " + exception.getLocalizedMessage());
            return null;
        }
    }

    private void modifyWSDL() throws Exception {
        try {
            this.modifyName();
            if (this.sqlFileList != null) {
                for (int i = 0; i < this.sqlFileList.size(); ++i) {
                    File file = (File)this.sqlFileList.get(i);
                    this.sqlFileName = file.getName().trim().substring(0, file.getName().indexOf(".sql"));
                    this.modifyMessageTypes(file);
                    this.createMessages();
                    PortType portType = this.createPortType();
                    Binding binding = this.createBinding(portType);
                    this.modifyServices(binding);
                }
                this.modifyPartnerLink();
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void modifyName() {
        QName qName = this.def.getQName();
        qName = new QName(qName.getNamespaceURI(), this.wsdlFileName);
        this.def.setQName(qName);
    }

    private void modifyMessageTypes(File file) throws Exception {
        block41: {
            try {
                Element element = null;
                Element element2 = null;
                Element element3 = null;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(string);
                }
                this.dbmeta = new DBMetaData(this.conn, stringBuffer.toString());
                logger.log(Level.INFO, "SQL Statement is:[" + this.dbmeta.getSQLText() + "]");
                this.parseSQLStatement(stringBuffer.toString());
                Types types = this.def.getTypes();
                if (null == types) break block41;
                List list = types.getExtensibilityElements();
                for (Object e : list) {
                    if (e instanceof Schema) {
                        Schema schema = (Schema)e;
                        Element element4 = schema.getElement();
                        element = this.getElementByName(element4, this.sqlFileName + "Request");
                        if (element == null) {
                            element = this.createElementWithComplexType(this.sqlFileName + "Request");
                        }
                        if (this.STATEMENT_TYPE != null) {
                            if (this.STATEMENT_TYPE.equalsIgnoreCase(SELECT_STATEMENT)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                if (element2 == null) {
                                    element2 = this.createElementWithComplexTypeSelect(this.sqlFileName + "Response");
                                    element3 = this.createElementWithComplexTypeRecord("record");
                                }
                                this.generateSelectSchemaElements(element, element3);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(INSERT_STATEMENT)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                this.removeSchemaElements(element, element2);
                                if (element2 == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((element2 = this.getElementByName(element4, "numRowsEffected")) == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateInsertSchemaElements(element, element2);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(UPDATE_STATEMENT)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                this.removeSchemaElements(element, element2);
                                if (element2 == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((element2 = this.getElementByName(element4, "numRowsEffected")) == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateInsertSchemaElements(element, element2);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DELETE_STATEMENT)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                this.removeSchemaElements(element, element2);
                                if (element2 == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((element2 = this.getElementByName(element4, "numRowsEffected")) == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateInsertSchemaElements(element, element2);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_CREATE)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                this.removeSchemaElements(element, element2);
                                if (element2 == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((element2 = this.getElementByName(element4, "numRowsEffected")) == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateCreateSchemaElements(element, element2);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_ALTER)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                this.removeSchemaElements(element, element2);
                                if (element2 == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((element2 = this.getElementByName(element4, "numRowsEffected")) == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateAlterSchemaElements(element, element2);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_DROP)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                this.removeSchemaElements(element, element2);
                                if (element2 == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((element2 = this.getElementByName(element4, "numRowsEffected")) == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateDropSchemaElements(element, element2);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(TRUNCATE_STATEMENT)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                this.removeSchemaElements(element, element2);
                                if (element2 == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                if ((element2 = this.getElementByName(element4, "numRowsEffected")) == null) {
                                    element2 = this.createElement("numRowsEffected", "xsd:int");
                                }
                                this.generateTruncateSchemaElements(element, element2);
                            } else if (this.STATEMENT_TYPE.equalsIgnoreCase(PROC_STATEMENT)) {
                                element2 = this.getElementByName(element4, this.sqlFileName + "Response");
                                if (element2 == null) {
                                    element2 = this.createElementWithComplexType(this.sqlFileName + "Response");
                                }
                                this.generateProcSchemaElements(element, element2);
                            }
                            element4.appendChild(element);
                            element4.appendChild(element2);
                            if (element3 == null && !this.STATEMENT_TYPE.equalsIgnoreCase(SELECT_STATEMENT)) continue;
                            element4.appendChild(element3);
                            continue;
                        }
                        throw new Exception("Unsupported SQL Statement entered: " + stringBuffer);
                    }
                    if (!(e instanceof UnknownExtensibilityElement)) continue;
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                JOptionPane.showMessageDialog(this.frame, NbBundle.getMessage(WSDLGenerator.class, (String)"LBL_MSG"), "Warning", 2);
                throw exception;
            }
        }
    }

    private void createMessages() {
        QName qName = null;
        QName qName2 = null;
        Message message = this.def.createMessage();
        QName qName3 = new QName(this.def.getTargetNamespace(), this.sqlFileName + "Request");
        Part part = this.def.createPart();
        part.setName(this.sqlFileName + "RequestPart");
        part.setElementName(qName3);
        message.addPart(part);
        message.setQName(qName3);
        message.setUndefined(false);
        this.def.addMessage(message);
        Message message2 = this.def.createMessage();
        Part part2 = this.def.createPart();
        if (this.STATEMENT_TYPE.equalsIgnoreCase(SELECT_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(PROC_STATEMENT)) {
            qName2 = new QName(this.def.getTargetNamespace(), this.sqlFileName + "Response");
        } else if (this.STATEMENT_TYPE.equalsIgnoreCase(INSERT_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(UPDATE_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(DELETE_STATEMENT) || this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_CREATE) || this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_ALTER) || this.STATEMENT_TYPE.equalsIgnoreCase(DDL_STATEMENT_DROP) || this.STATEMENT_TYPE.equalsIgnoreCase(TRUNCATE_STATEMENT)) {
            qName2 = new QName(this.def.getTargetNamespace(), "numRowsEffected");
        }
        part2.setName(this.sqlFileName + "ResponsePart");
        part2.setElementName(qName2);
        message2.addPart(part2);
        qName = new QName(this.def.getTargetNamespace(), this.sqlFileName + "Response");
        message2.setQName(qName);
        message2.setUndefined(false);
        this.def.addMessage(message2);
    }

    private PortType createPortType() {
        QName qName = new QName(this.def.getTargetNamespace(), this.wsdlFileName + "_sqlsePortType");
        PortType portType = this.def.getPortType(qName);
        if (portType == null) {
            portType = this.def.createPortType();
            portType.setQName(qName);
            portType.setUndefined(false);
            this.def.addPortType(portType);
        }
        this.createPortTypeOperations(portType);
        return portType;
    }

    private void createPortTypeOperations(PortType portType) {
        Operation operation = portType.getOperation(this.sqlFileName, this.sqlFileName + "Request", this.sqlFileName + "Response");
        if (operation == null) {
            operation = this.def.createOperation();
            operation.setName(this.sqlFileName);
            Input input = this.def.createInput();
            Output output = this.def.createOutput();
            input.setMessage(this.getMessageByName(this.sqlFileName + "Request"));
            input.setName(this.sqlFileName + "Request");
            output.setMessage(this.getMessageByName(this.sqlFileName + "Response"));
            output.setName(this.sqlFileName + "Response");
            operation.setInput(input);
            operation.setOutput(output);
            operation.setUndefined(false);
            portType.addOperation(operation);
        }
    }

    private Binding createBinding(PortType portType) {
        BindingOperation bindingOperation;
        PortType portType2;
        QName qName = new QName(this.def.getTargetNamespace(), this.wsdlFileName + "Binding");
        Binding binding = this.def.getBinding(qName);
        if (binding == null) {
            binding = this.def.createBinding();
            binding.setQName(qName);
            binding.setUndefined(false);
            binding.setPortType(portType);
            this.def.addBinding(binding);
        } else {
            portType2 = binding.getPortType();
            if (portType2.equals(portType)) {
                bindingOperation = binding.getBindingOperation(this.sqlFileName, this.sqlFileName + "Request", this.sqlFileName + "Response");
                if (bindingOperation != null) {
                    return binding;
                }
            } else {
                binding.setPortType(portType2);
                portType = portType2;
            }
        }
        portType2 = this.def.createBindingOperation();
        portType2.setName(this.sqlFileName);
        if (portType != null && (bindingOperation = portType.getOperation(this.sqlFileName, this.sqlFileName + "Request", this.sqlFileName + "Response")) != null) {
            portType2.setOperation((Operation)bindingOperation);
            BindingInput bindingInput = this.def.createBindingInput();
            bindingInput.setName(this.sqlFileName + "Request");
            portType2.setBindingInput(bindingInput);
            BindingOutput bindingOutput = this.def.createBindingOutput();
            bindingOutput.setName(this.sqlFileName + "Response");
            portType2.setBindingOutput(bindingOutput);
            binding.addBindingOperation((BindingOperation)portType2);
        }
        return binding;
    }

    private Message getMessageByName(String string) {
        QName qName = new QName("http://com.sun.jbi/sqlse/sqlseengine", string);
        return this.def.getMessage(qName);
    }

    private void modifyMessageElementName(Message message, String string, String string2) {
        Part part = message.getPart(string);
        if (part != null) {
            QName qName = new QName("http://com.sun.jbi/sqlse/sqlseengine", string2);
            part.setElementName(qName);
        }
    }

    private void modifyServices(Binding binding) {
        Port port = null;
        QName qName = new QName(this.def.getTargetNamespace(), this.wsdlFileName + "_sqlseService");
        Service service = this.def.getService(qName);
        if (service == null) {
            service = this.def.createService();
            service.setQName(qName);
            port = this.def.createPort();
            port.setBinding(binding);
            port.setName(this.wsdlFileName + "_sqlsePort");
            service.addPort(port);
            this.def.addService(service);
        }
    }

    private void modifyPartnerLink() {
        if (!this.wsdlFileExsits) {
            List list = this.def.getExtensibilityElements();
            UnknownExtensibilityElement unknownExtensibilityElement = (UnknownExtensibilityElement)list.get(0);
            unknownExtensibilityElement.getElement();
            String string = unknownExtensibilityElement.getElement().getAttribute("name");
            unknownExtensibilityElement.getElement().setAttribute("name", this.wsdlFileName + "_" + string);
            NodeList nodeList = unknownExtensibilityElement.getElement().getChildNodes();
            Element element = (Element)nodeList.item(1);
            element.setAttribute("name", this.wsdlFileName + "_" + element.getAttribute("name"));
            String string2 = element.getAttribute("portType").substring("tns:".length());
            element.setAttribute("portType", "tns:" + this.wsdlFileName + "_" + string2);
        }
    }

    private void generateDeleteSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            PrepStmt prepStmt = this.dbmeta.getPrepStmtMetaData();
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (prepStmt.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prepStmt, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prepStmt, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void generateCreateSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            PrepStmt prepStmt = this.dbmeta.getPrepStmtMetaData();
            if (this.dbmeta.getErrPrepStmtMetaData()) {
                JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
            }
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (prepStmt.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prepStmt, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prepStmt, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
        }
    }

    private void generateAlterSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            PrepStmt prepStmt = this.dbmeta.getPrepStmtMetaData();
            if (this.dbmeta.getErrPrepStmtMetaData()) {
                JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
            }
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (prepStmt.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prepStmt, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prepStmt, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void generateDropSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            PrepStmt prepStmt = this.dbmeta.getPrepStmtMetaData();
            if (this.dbmeta.getErrPrepStmtMetaData()) {
                JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
            }
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (prepStmt.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prepStmt, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prepStmt, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void generateTruncateSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            PrepStmt prepStmt = this.dbmeta.getPrepStmtMetaData();
            if (this.dbmeta.getErrPrepStmtMetaData()) {
                JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
            }
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (prepStmt.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prepStmt, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prepStmt, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void generateInsertSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            PrepStmt prepStmt = this.dbmeta.getPrepStmtMetaData();
            if (this.dbmeta.getErrPrepStmtMetaData()) {
                JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
            }
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (prepStmt.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prepStmt, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prepStmt, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void generateSelectSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            PrepStmt prepStmt = this.dbmeta.getPrepStmtMetaData();
            if (this.dbmeta.getErrPrepStmtMetaData()) {
                JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
            }
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (prepStmt.getNumParameters() > 0) {
                    this.addPreparedStmtParametersToElement(prepStmt, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addResultSetColumnsToElement(prepStmt, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void generateProcSchemaElements(Element element, Element element2) throws Exception {
        try {
            Element element3;
            String string = this.conn.getCatalog();
            this.schema = this.dbConn.getSchema();
            String string2 = this.getProcName();
            if (string == null) {
                string = "";
            }
            Procedure procedure = this.dbmeta.getProcedureMetaData(string, this.schema, string2, "Procedure");
            if (this.dbmeta.getErrProcMetaData()) {
                JOptionPane.showMessageDialog(this.frame, "Problem in generating the message types for WSDL.Update the generated WSDL if needed.Please see the log for more details.", "Warning", 2);
            }
            if (procedure.getHasReturn()) {
                // empty if block
            }
            if (element != null && (element3 = this.getElementByName(element, "xsd:sequence")) != null) {
                if (procedure.getNumParameters() > 0) {
                    this.addProcedureParametersToElement(procedure, element3);
                } else {
                    NodeList nodeList = element3.getChildNodes();
                    if (nodeList != null) {
                        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                            element3.removeChild(nodeList.item(i));
                        }
                    }
                }
            }
            if (element2 != null && (element3 = this.getElementByName(element2, "xsd:sequence")) != null) {
                this.addProcedureResultSetColumnsToElement(procedure, element3);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw exception;
        }
    }

    private void addResultSetColumnsToElement(PrepStmt prepStmt, Element element) throws WSDLException {
        int n;
        ResultSetColumn[] resultSetColumnArray;
        String string = null;
        if (element != null && (resultSetColumnArray = element.getChildNodes()) != null) {
            for (n = resultSetColumnArray.getLength() - 1; n >= 0; --n) {
                element.removeChild(resultSetColumnArray.item(n));
            }
        }
        if (prepStmt != null && (resultSetColumnArray = prepStmt.getResultSetColumns()) != null && resultSetColumnArray.length > 0) {
            for (n = 0; n < resultSetColumnArray.length; ++n) {
                try {
                    string = resultSetColumnArray[n].getJavaType();
                    Element element2 = null;
                    if (!WSDLGenerator.isBuiltInType(string)) {
                        throw new WSDLException("INVALID_WSDL", "Invalid datatype encountered");
                    }
                    element2 = this.createElement(resultSetColumnArray[n].getName(), (String)builtInTypes.get(string));
                    element.appendChild(element2);
                    continue;
                }
                catch (WSDLException wSDLException) {
                    logger.log(Level.SEVERE, wSDLException.getLocalizedMessage());
                    throw new WSDLException("INVALID_WSDL", "Check if the sql entered is valid");
                }
            }
        }
    }

    private void addProcedureResultSetColumnsToElement(Procedure procedure, Element element) throws WSDLException {
        int n;
        ResultSetColumns[] resultSetColumnsArray;
        String string = null;
        if (element != null && (resultSetColumnsArray = element.getChildNodes()) != null) {
            for (n = resultSetColumnsArray.getLength() - 1; n >= 0; --n) {
                element.removeChild(resultSetColumnsArray.item(n));
            }
        }
        if (procedure != null) {
            resultSetColumnsArray = procedure.getResultSetColumnsArray();
            for (n = 0; n < resultSetColumnsArray.length; ++n) {
                ResultSetColumn resultSetColumn = resultSetColumnsArray[n].get(n);
                if (resultSetColumn == null) continue;
                try {
                    string = resultSetColumn.getJavaType();
                    Element element2 = null;
                    if (!WSDLGenerator.isBuiltInType(string)) {
                        throw new WSDLException("INVALID_WSDL", "Invalid datatype encountered");
                    }
                    element2 = this.createElement(resultSetColumn.getName(), (String)builtInTypes.get(string));
                    element.appendChild(element2);
                    continue;
                }
                catch (WSDLException wSDLException) {
                    logger.log(Level.SEVERE, wSDLException.getLocalizedMessage());
                    throw new WSDLException("INVALID_WSDL", "Check if the sql entered is valid");
                }
            }
        }
    }

    private void addPreparedStmtParametersToElement(PrepStmt prepStmt, Element element) {
        if (prepStmt.getNumParameters() > 0 && element != null) {
            NodeList nodeList = element.getChildNodes();
            if (nodeList != null) {
                for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                    element.removeChild(nodeList.item(i));
                }
            }
            Parameter[] parameterArray = prepStmt.getParameters();
            for (int i = 0; i < prepStmt.getNumParameters(); ++i) {
                Element element2 = this.createElement(parameterArray[i].getName(), (String)builtInTypes.get(parameterArray[i].getJavaType()));
                element.appendChild(element2);
            }
        }
    }

    private void addProcedureParametersToElement(Procedure procedure, Element element) {
        if (procedure.getNumParameters() > 0 && element != null) {
            NodeList nodeList = element.getChildNodes();
            if (nodeList != null) {
                for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                    element.removeChild(nodeList.item(i));
                }
            }
            Parameter[] parameterArray = procedure.getParameters();
            for (int i = 0; i < procedure.getNumParameters(); ++i) {
                Element element2 = this.createElement(parameterArray[i].getName(), (String)builtInTypes.get(parameterArray[i].getJavaType()));
                element.appendChild(element2);
            }
        }
    }

    private Element getElementByName(Element element, String string) {
        if (element.getAttribute("name").equalsIgnoreCase(string)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        Element element3 = null;
        for (int i = 0; i < nodeList.getLength() && element3 == null; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            if (element2.getAttribute("name").equalsIgnoreCase(string) || element2.getTagName().equalsIgnoreCase(string) || element2.getLocalName() != null && element2.getLocalName().equalsIgnoreCase(string)) {
                element3 = element2;
                break;
            }
            element3 = this.getElementByName(element2, string);
            if (element3 == null || !element3.getAttribute("name").equalsIgnoreCase(string)) continue;
            return element3;
        }
        return element3;
    }

    private void parseSQLStatement(String string) {
        String string2 = (string = string.trim()).toUpperCase();
        this.STATEMENT_TYPE = string2.startsWith(SELECT_STATEMENT) ? SELECT_STATEMENT : (string2.startsWith(INSERT_STATEMENT) ? INSERT_STATEMENT : (string2.startsWith(UPDATE_STATEMENT) ? UPDATE_STATEMENT : (string2.startsWith(DELETE_STATEMENT) ? DELETE_STATEMENT : (string2.startsWith(TRUNCATE_STATEMENT) ? TRUNCATE_STATEMENT : (string2.startsWith(DDL_STATEMENT_CREATE) ? DDL_STATEMENT_CREATE : (string2.startsWith(DDL_STATEMENT_ALTER) ? DDL_STATEMENT_ALTER : (string2.startsWith(DDL_STATEMENT_DROP) ? DDL_STATEMENT_DROP : PROC_STATEMENT)))))));
    }

    private void writeWsdl() throws WSDLException {
        try {
            WSDLWriter wSDLWriter = factory.newWSDLWriter();
            String string = this.wsdlFileLocation + File.separator + this.wsdlFileName + ".wsdl";
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, FileEncodingQuery.getDefaultEncoding());
            wSDLWriter.writeWSDL(this.def, (Writer)outputStreamWriter);
            logger.log(Level.INFO, "Successfully generated wsdl file :" + string + " using the file encoding:" + FileEncodingQuery.getDefaultEncoding());
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                logger.log(Level.SEVERE, exception.getMessage());
            }
            if (exception instanceof IOException) {
                logger.log(Level.SEVERE, exception.getMessage());
            }
            if (exception instanceof WSDLException) {
                if (((WSDLException)((Object)exception)).getMessage().indexOf("Unsupported Java encoding for writing wsdl file") != -1) {
                    try {
                        WSDLWriter wSDLWriter = factory.newWSDLWriter();
                        String string = this.wsdlFileLocation + File.separator + this.wsdlFileName + ".wsdl";
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                        wSDLWriter.writeWSDL(this.def, (Writer)outputStreamWriter);
                        logger.log(Level.INFO, "Successfully generated wsdl file :" + string + " using the file encoding: UTF-8");
                    }
                    catch (Exception exception2) {
                        logger.log(Level.SEVERE, exception2.getMessage());
                    }
                } else {
                    logger.log(Level.SEVERE, exception.getMessage());
                }
            }
            logger.log(Level.SEVERE, exception.getMessage());
        }
    }

    private void indentWSDLFile(Writer writer) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.doc);
            PrintWriter printWriter = new PrintWriter(writer);
            StreamResult streamResult = new StreamResult(printWriter);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("media-type", "text/xml");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
            }
            catch (Exception exception) {
                // empty catch block
            }
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unable to indent wsdl file " + exception.getLocalizedMessage());
        }
    }

    public static boolean isBuiltInType(String string) {
        return builtInTypes.get(string) != null;
    }

    private Element createElementWithComplexTypeSelect(String string) {
        Element element = this.doc.createElement("xsd:element");
        element.setAttribute("name", string);
        Element element2 = this.doc.createElement("xsd:complexType");
        Element element3 = this.doc.createElement("xsd:sequence");
        Element element4 = this.doc.createElement("xsd:element");
        element4.setAttribute("ref", "record");
        element4.setAttribute("maxOccurs", "unbounded");
        element3.appendChild(element4);
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    private Element createElementWithComplexTypeRecord(String string) {
        Element element = this.doc.createElement("xsd:element");
        element.setAttribute("name", string);
        Element element2 = this.doc.createElement("xsd:complexType");
        Element element3 = this.doc.createElement("xsd:sequence");
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    private Element createElementWithComplexType(String string) {
        Element element = this.doc.createElement("xsd:element");
        element.setAttribute("name", string);
        Element element2 = this.doc.createElement("xsd:complexType");
        Element element3 = this.doc.createElement("xsd:sequence");
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    private Element createElement(String string, String string2) {
        Element element = this.doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        element.setAttribute("name", string);
        element.setAttribute("type", string2);
        return element;
    }

    private void removeSchemaElements(Element element, Element element2) {
        try {
            NodeList nodeList;
            Object object;
            if (element != null && (object = this.getElementByName(element, "xsd:sequence")) != null && (nodeList = object.getChildNodes()) != null) {
                for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                    object.removeChild(nodeList.item(i));
                }
            }
            if (element2 != null && element2 != null && (object = element2.getChildNodes()) != null) {
                for (int i = object.getLength() - 1; i >= 0; --i) {
                    element2.removeChild(object.item(i));
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getLocalizedMessage());
        }
    }

    public void setDBConnection(DatabaseConnection databaseConnection) {
        this.dbConn = databaseConnection;
        this.schema = this.schema;
    }

    private String getProcName() {
        String string = "";
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.dbmeta.getSQLText(), " ");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            int n = 0;
            if ((string3 = string3.toLowerCase()).endsWith("call")) {
                ++n;
                string = (String)stringTokenizer.nextElement();
                if (string.contains(".")) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, ".");
                    string2 = stringTokenizer2.nextToken();
                    string = stringTokenizer2.nextToken();
                }
                if (string.contains("(")) {
                    int n2 = string.indexOf("(");
                    string = string.substring(0, n2);
                }
                if (string.contains("}")) {
                    int n3 = string.indexOf("}");
                    string = string.substring(0, n3);
                }
            }
            if (n <= 0) continue;
            break;
        }
        return string;
    }

    static {
        builtInTypes.put("byte[]", "xsd:base64Binary");
        builtInTypes.put("boolean", "xsd:boolean");
        builtInTypes.put("byte", "xsd:byte");
        builtInTypes.put("java.util.Calendar", "xsd:dateTime");
        builtInTypes.put("java.math.BigDecimal", "xsd:decimal");
        builtInTypes.put("double", "xsd:double");
        builtInTypes.put("float", "xsd:float");
        builtInTypes.put("byte[]", "xsd:hexBinary");
        builtInTypes.put("int", "xsd:int");
        builtInTypes.put("java.math.BigInteger", "xsd:integer");
        builtInTypes.put("long", "xsd:long");
        builtInTypes.put("javax.xml.namespace.QName", "xsd:QName");
        builtInTypes.put("short", "xsd:short");
        builtInTypes.put("java.lang.String", "xsd:string");
        builtInTypes.put("java.sql.Time", "xsd:string");
        builtInTypes.put("java.sql.Timestamp", "xsd:string");
        builtInTypes.put("java.sql.Date", "xsd:string");
        builtInTypes.put("java.sql.Blob", "xsd:string");
        builtInTypes.put("java.sql.Clob", "xsd:string");
        builtInTypes.put("java.sql.ResultSet", "xsd:ResultSet");
        WSDLGenerator.initFactory();
    }
}

