/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.events;

import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeEventSupport {
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.myLock.writeLock();
    private WeakHashMap<ChangeEventListener, Class<? extends BpelEntity>> myListeners = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeEventListener(ChangeEventListener changeEventListener) {
        this.writeLock.lock();
        try {
            this.myListeners.put(changeEventListener, null);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeEventListener(ChangeEventListener changeEventListener, Class<? extends BpelEntity> clazz) {
        this.writeLock.lock();
        try {
            this.myListeners.put(changeEventListener, clazz);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeEventListener(ChangeEventListener changeEventListener) {
        assert (changeEventListener != null);
        this.writeLock.lock();
        try {
            this.myListeners.remove(changeEventListener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeEvent(ChangeEvent changeEvent) {
        ChangeEventListener[] changeEventListenerArray;
        assert (changeEvent != null);
        this.writeLock.lock();
        try {
            ChangeEventListener[] changeEventListenerArray2 = this.myListeners.keySet();
            changeEventListenerArray = changeEventListenerArray2.toArray(new ChangeEventListener[changeEventListenerArray2.size()]);
        }
        finally {
            this.writeLock.unlock();
        }
        for (ChangeEventListener changeEventListener : changeEventListenerArray) {
            try {
                this.notifyChangeEvent(changeEventListener, changeEvent);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    private void notifyChangeEvent(ChangeEventListener changeEventListener, ChangeEvent changeEvent) {
        if (changeEventListener == null) {
            return;
        }
        if (changeEvent instanceof PropertyRemoveEvent) {
            changeEventListener.notifyPropertyRemoved((PropertyRemoveEvent)changeEvent);
        } else if (changeEvent instanceof PropertyUpdateEvent) {
            changeEventListener.notifyPropertyUpdated((PropertyUpdateEvent)changeEvent);
        } else if (changeEvent instanceof EntityInsertEvent) {
            changeEventListener.notifyEntityInserted((EntityInsertEvent)changeEvent);
        } else if (changeEvent instanceof EntityRemoveEvent) {
            changeEventListener.notifyEntityRemoved((EntityRemoveEvent)changeEvent);
        } else if (changeEvent instanceof EntityUpdateEvent) {
            changeEventListener.notifyEntityUpdated((EntityUpdateEvent)changeEvent);
        } else if (changeEvent instanceof ArrayUpdateEvent) {
            changeEventListener.notifyArrayUpdated((ArrayUpdateEvent)changeEvent);
        }
    }
}

