/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.references.SchemaReferenceBuilder;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalogsupport.util.ProjectUtilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.netbeans.modules.xml.xpath.ext.spi.ExternalModelResolver;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelExternalModelResolver
implements ExternalModelResolver {
    private BpelModel mBpelModel;
    private CatalogReader mCatalogReader;

    public BpelExternalModelResolver(BpelModel bpelModel) {
        this.mBpelModel = bpelModel;
    }

    public BpelExternalModelResolver(BpelModel bpelModel, CatalogReader catalogReader) {
        this.mBpelModel = bpelModel;
        this.mCatalogReader = catalogReader;
    }

    public Collection<SchemaModel> getModels(String string) {
        return SchemaReferenceBuilder.getSchemaModels(this.mBpelModel, string, true);
    }

    public Collection<SchemaModel> getVisibleModels() {
        Definitions definitions;
        WSDLModel wSDLModel;
        Object object;
        Object object22;
        ArrayList<SchemaModel> arrayList = new ArrayList<SchemaModel>();
        Project project = Utils.safeGetProject(this.mBpelModel);
        List list = ProjectUtilities.getXSDFilesRecursively((Project)project, (boolean)false);
        for (Object object22 : list) {
            object = Utils.getSchemaModel((FileObject)object22);
            if (object == null) continue;
            arrayList.add((SchemaModel)object);
        }
        List list2 = ProjectUtilities.getWSDLFilesRecursively((Project)project, (boolean)false);
        object22 = list2.iterator();
        while (object22.hasNext()) {
            Types types;
            object = (FileObject)object22.next();
            wSDLModel = Utils.getWsdlModel((FileObject)object);
            if (wSDLModel == null || (definitions = wSDLModel.getDefinitions()) == null || (types = definitions.getTypes()) == null) continue;
            Collection collection = types.getSchemas();
            for (Schema schema : collection) {
                SchemaModel schemaModel = schema.getModel();
                if (schemaModel == null) continue;
                arrayList.add(schemaModel);
            }
        }
        if (this.mCatalogReader != null) {
            object22 = this.mCatalogReader.getPublicIDs();
            while (object22.hasNext()) {
                try {
                    object = object22.next();
                    wSDLModel = CatalogModelFactory.getDefault().getCatalogModel(this.mBpelModel.getModelSource()).getModelSource(new URI(object.toString()));
                    if (wSDLModel == null || (definitions = SchemaModelFactory.getDefault().getModel((ModelSource)wSDLModel)) == null) continue;
                    arrayList.add((SchemaModel)definitions);
                }
                catch (CatalogModelException catalogModelException) {
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        arrayList.add(SchemaModelFactory.getDefault().getPrimitiveTypesModel());
        return arrayList;
    }

    public boolean isSchemaVisible(String string) {
        Collection<SchemaModel> collection = this.getVisibleModels();
        for (SchemaModel schemaModel : collection) {
            String string2 = schemaModel.getSchema().getTargetNamespace();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

