/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Documentation;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.ExtensionEntity;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.impl.BpelBuilderImpl;
import org.netbeans.modules.bpel.model.impl.BpelContainerImpl;
import org.netbeans.modules.bpel.model.impl.BpelModelImpl;
import org.netbeans.modules.bpel.model.impl.DocumentationImpl;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.netbeans.modules.bpel.model.xam.BpelTypes;
import org.netbeans.modules.bpel.model.xam.BpelTypesEnum;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibleElementsImpl
extends BpelContainerImpl
implements ExtensibleElements {
    private static AtomicReference<Attribute[]> myAttributes = new AtomicReference();

    public ExtensibleElementsImpl(BpelModelImpl bpelModelImpl, Element element) {
        super(bpelModelImpl, element);
    }

    public ExtensibleElementsImpl(BpelBuilderImpl bpelBuilderImpl, String string) {
        super(bpelBuilderImpl, string);
    }

    @Override
    public String getDocumentation() {
        Documentation[] documentationArray = this.getDocumentations();
        if (documentationArray == null || documentationArray.length == 0) {
            return null;
        }
        Documentation documentation = documentationArray[0];
        if (documentation == null) {
            return null;
        }
        return documentation.getContent();
    }

    @Override
    public void setDocumentation(String string) throws VetoException {
        String string2 = this.getContent(string);
        if (string2 == null) {
            if (this.sizeOfDocumentations() != 0) {
                this.removeDocumentation(0);
            }
        } else if (this.sizeOfDocumentations() == 0) {
            Documentation documentation = this.getBpelModel().getBuilder().createDocumentation();
            documentation.setContent(string2);
            this.insertDocumentation(documentation, 0);
        } else {
            Documentation documentation = this.getDocumentation(0);
            documentation.setContent(string2);
        }
    }

    private String getContent(String string) {
        if (string == null) {
            return null;
        }
        if (this.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private boolean isEmpty(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ' || string.charAt(i) == '\r' || string.charAt(i) == '\n') continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeDocumentation() throws VetoException {
        this.setDocumentation(null);
    }

    @Override
    public void addDocumentation(Documentation documentation) {
        this.addChildAfter(documentation, Documentation.class, BpelTypesEnum.DOCUMENTATION);
    }

    @Override
    public Documentation getDocumentation(int n) {
        return this.getChild(Documentation.class, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Documentation[] getDocumentations() {
        this.readLock();
        try {
            List<Documentation> list = this.getChildren(Documentation.class);
            Documentation[] documentationArray = list.toArray(new Documentation[list.size()]);
            return documentationArray;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void insertDocumentation(Documentation documentation, int n) {
        this.insertAtIndexAfter(documentation, Documentation.class, n, BpelTypesEnum.DOCUMENTATION);
    }

    @Override
    public void removeDocumentation(int n) {
        this.removeChild(Documentation.class, n);
    }

    @Override
    public void setDocumentation(Documentation documentation, int n) {
        this.setChildAtIndex(documentation, Documentation.class, n);
    }

    @Override
    public void setDocumentations(Documentation[] documentationArray) {
        this.setArrayAfter(documentationArray, Documentation.class, new BpelTypes[]{BpelTypesEnum.DOCUMENTATION});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeOfDocumentations() {
        this.readLock();
        try {
            int n = this.getChildren(Documentation.class).size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T extends ExtensionEntity> void addExtensionEntity(Class<T> clazz, T t) {
        assert (t.canExtend(this));
        this.addChildAfter(t, clazz, BpelTypesEnum.DOCUMENTATION);
    }

    @Override
    public List<ExtensionEntity> getExtensionChildren() {
        return this.getChildren(ExtensionEntity.class);
    }

    @Override
    protected BpelEntity create(Element element) {
        if (BpelElements.DOCUMENTATION.getName().equals(element.getLocalName())) {
            return new DocumentationImpl(this.getModel(), element);
        }
        return null;
    }

    @Override
    protected Attribute[] getDomainAttributes() {
        if (myAttributes.get() == null) {
            Attribute[] attributeArray = new Attribute[]{};
            myAttributes.compareAndSet(null, attributeArray);
        }
        return myAttributes.get();
    }
}

