/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.references.MappedReference;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.ProcessImpl;
import org.netbeans.modules.bpel.model.impl.references.BpelAttributesType;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;
import org.netbeans.modules.bpel.model.xam.BpelAttributes;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportChangeHandlingService
extends InnerEventDispatcherAdapter {
    @Override
    public boolean isApplicable(ChangeEvent changeEvent) {
        if (changeEvent instanceof PropertyUpdateEvent || changeEvent instanceof PropertyRemoveEvent) {
            if (changeEvent.getParent() != null && changeEvent.getParent().getElementType().equals(Import.class)) {
                BpelEntity bpelEntity = changeEvent.getParent();
                return bpelEntity instanceof BpelEntityImpl ? ((BpelEntityImpl)bpelEntity).isInTree() : true;
            }
        } else {
            if (changeEvent instanceof EntityUpdateEvent) {
                return ((EntityUpdateEvent)changeEvent).getNewValue() instanceof Import || ((EntityUpdateEvent)changeEvent).getOldValue() instanceof Import;
            }
            if (changeEvent instanceof EntityRemoveEvent) {
                return ((EntityRemoveEvent)changeEvent).getOldValue() instanceof Import;
            }
            if (changeEvent instanceof EntityInsertEvent) {
                return ((EntityInsertEvent)changeEvent).getValue() instanceof Import;
            }
            if (changeEvent instanceof ArrayUpdateEvent) {
                BpelEntity[] bpelEntityArray = ((ArrayUpdateEvent)changeEvent).getNewArray();
                if (bpelEntityArray != null && bpelEntityArray.length > 0) {
                    return bpelEntityArray[0].getElementType().equals(Import.class);
                }
                bpelEntityArray = ((ArrayUpdateEvent)changeEvent).getOldArray();
                if (bpelEntityArray != null && bpelEntityArray.length > 0) {
                    return bpelEntityArray[0].getElementType().equals(Import.class);
                }
            }
        }
        return false;
    }

    @Override
    public void postDispatch(ChangeEvent changeEvent) {
        if (this.handlePropertyChange(changeEvent)) {
            return;
        }
        if (this.handleInsertEvent(changeEvent)) {
            return;
        }
        if (this.handleRemoveEvent(changeEvent)) {
            return;
        }
        if (this.handleUpdateEvent(changeEvent)) {
            return;
        }
        this.handleArrayUpdateEvent(changeEvent);
    }

    private boolean handleInsertEvent(ChangeEvent changeEvent) {
        boolean bl = changeEvent instanceof EntityInsertEvent;
        if (!bl) {
            return false;
        }
        Object t = ((EntityInsertEvent)changeEvent).getValue();
        assert (t instanceof Import);
        String string = ((Import)t).getImportType();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(string) || "http://www.w3.org/2001/XMLSchema".equals(string)) {
            String string2 = ((Import)t).getNamespace();
            String string3 = ((Import)t).getLocation();
            if (string2 != null && string3 != null) {
                this.visitRefereces((ProcessImpl)t.getBpelModel().getProcess(), string2, null);
            }
        }
        return bl;
    }

    private boolean handleRemoveEvent(ChangeEvent changeEvent) {
        boolean bl = changeEvent instanceof EntityRemoveEvent;
        if (!bl) {
            return false;
        }
        Object t = ((EntityRemoveEvent)changeEvent).getOldValue();
        assert (t instanceof Import);
        String string = ((Import)t).getImportType();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(string) || "http://www.w3.org/2001/XMLSchema".equals(string)) {
            String string2 = ((Import)t).getNamespace();
            String string3 = ((Import)t).getLocation();
            if (string2 != null && string3 != null) {
                this.visitRefereces((ProcessImpl)t.getBpelModel().getProcess(), string2, null);
            }
        }
        return bl;
    }

    private boolean handleUpdateEvent(ChangeEvent changeEvent) {
        boolean bl = changeEvent instanceof EntityUpdateEvent;
        if (!bl) {
            return false;
        }
        Object t = ((EntityUpdateEvent)changeEvent).getOldValue();
        Object t2 = ((EntityUpdateEvent)changeEvent).getOldValue();
        assert (t instanceof Import || t2 instanceof Import);
        String string = ((Import)t).getImportType();
        String string2 = ((Import)t2).getImportType();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(string) || "http://www.w3.org/2001/XMLSchema".equals(string) || "http://schemas.xmlsoap.org/wsdl/".equals(string2) || "http://schemas.xmlsoap.org/wsdl/".equals(string2)) {
            String string3 = ((Import)t).getNamespace();
            String string4 = ((Import)t2).getNamespace();
            String string5 = ((Import)t).getLocation();
            String string6 = ((Import)t2).getLocation();
            if (!(string3 == null && string4 == null || string5 == null && string6 == null)) {
                Object t3 = t == null ? t2 : t;
                this.visitRefereces((ProcessImpl)t3.getBpelModel().getProcess(), string3, string4);
            }
        }
        return bl;
    }

    private void handleArrayUpdateEvent(ChangeEvent changeEvent) {
        boolean bl = changeEvent instanceof ArrayUpdateEvent;
        if (!bl) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        BpelEntity[] bpelEntityArray = ((ArrayUpdateEvent)changeEvent).getOldArray();
        this.handleChangesInArray(hashSet, bpelEntityArray);
        BpelEntity[] bpelEntityArray2 = ((ArrayUpdateEvent)changeEvent).getNewArray();
        this.handleChangesInArray(hashSet, bpelEntityArray2);
    }

    private boolean handlePropertyChange(ChangeEvent changeEvent) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (changeEvent instanceof PropertyUpdateEvent) {
            bl = true;
            string = ((PropertyUpdateEvent)changeEvent).getName();
            string2 = (String)((PropertyUpdateEvent)changeEvent).getOldValue();
            string3 = (String)((PropertyUpdateEvent)changeEvent).getNewValue();
        } else if (changeEvent instanceof PropertyRemoveEvent) {
            bl = true;
            string = ((PropertyRemoveEvent)changeEvent).getName();
            string2 = (String)((PropertyRemoveEvent)changeEvent).getOldValue();
        }
        if (!bl) {
            return false;
        }
        if (!string.equals("namespace")) {
            string3 = string2 = changeEvent.getParent().getAttribute(BpelAttributes.NAMESPACE);
        }
        this.visitRefereces((ProcessImpl)changeEvent.getParent().getBpelModel().getProcess(), string2, string3);
        return bl;
    }

    private void visitRefereces(BpelEntityImpl bpelEntityImpl, String string, String string2) {
        Collection<Attribute> collection;
        if (bpelEntityImpl instanceof ReferenceCollection) {
            Reference[] referenceArray;
            collection = new HashSet();
            for (Reference reference : referenceArray = ((ReferenceCollection)((Object)bpelEntityImpl)).getReferences()) {
                if (reference instanceof MappedReference) {
                    Attribute attribute = ((MappedReference)reference).getAttribute();
                    if (collection.contains(attribute)) continue;
                    collection.add(attribute);
                }
                this.handleReference(bpelEntityImpl, reference, string, string2);
            }
        }
        collection = bpelEntityImpl.getChildren(BpelEntityImpl.class);
        for (BpelEntityImpl bpelEntityImpl2 : collection) {
            this.visitRefereces(bpelEntityImpl2, string, string2);
        }
    }

    private void handleReference(BpelEntityImpl bpelEntityImpl, Reference reference, String string, String string2) {
        if (reference instanceof BpelAttributesType && reference instanceof NamedComponentReference) {
            NamedComponentReference namedComponentReference = (NamedComponentReference)reference;
            BpelAttributesType.AttrType attrType = ((BpelAttributesType)reference).getAttributeType();
            if (attrType.equals((Object)BpelAttributesType.AttrType.QNAME)) {
                if (string != null && string.equals(namedComponentReference.getEffectiveNamespace())) {
                    bpelEntityImpl.getAttributeAccess().fireUpdateReference((Reference)namedComponentReference);
                    return;
                }
                if (string2 != null && string2.equals(namedComponentReference.getEffectiveNamespace())) {
                    bpelEntityImpl.getAttributeAccess().fireUpdateReference((Reference)namedComponentReference);
                    return;
                }
            }
        }
    }

    private void handleChangesInArray(Set<String> set, BpelEntity[] bpelEntityArray) {
        for (BpelEntity bpelEntity : bpelEntityArray) {
            assert (bpelEntity instanceof Import);
            String string = ((Import)bpelEntity).getImportType();
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(string) && !"http://www.w3.org/2001/XMLSchema".equals(string)) continue;
            String string2 = ((Import)bpelEntity).getNamespace();
            String string3 = ((Import)bpelEntity).getLocation();
            if (string2 == null || string3 == null || set.contains(string2)) continue;
            set.add(string2);
            this.visitRefereces((ProcessImpl)bpelEntity.getBpelModel().getProcess(), string2, null);
        }
    }
}

