/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl.references;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.references.MappedReference;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.references.AbstractNamedComponentReference;
import org.netbeans.modules.bpel.model.impl.references.BpelAttributesType;
import org.netbeans.modules.bpel.model.impl.references.CorrelationPropertyResolver;
import org.netbeans.modules.bpel.model.impl.references.MessageResolver;
import org.netbeans.modules.bpel.model.impl.references.OperationResolver;
import org.netbeans.modules.bpel.model.impl.references.PartResolver;
import org.netbeans.modules.bpel.model.impl.references.PartnerLinkTypeResolver;
import org.netbeans.modules.bpel.model.impl.references.PortTypeResolver;
import org.netbeans.modules.bpel.model.impl.references.RoleResolver;
import org.netbeans.modules.bpel.model.impl.references.WSDLReference;
import org.netbeans.modules.bpel.model.impl.references.WSDLReferenceFactory;
import org.netbeans.modules.bpel.model.xam.spi.ExternalModelRetriever;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSDLReferenceBuilder {
    private static final WSDLReferenceBuilder INSTANCE = new WSDLReferenceBuilder();
    private static Collection myRetrievers;
    private Collection<WSDLReferenceFactory> myCollection;

    private WSDLReferenceBuilder() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ExternalModelRetriever.class));
        myRetrievers = result.allInstances();
        this.myCollection = new LinkedList<WSDLReferenceFactory>();
        this.myCollection.add(new PartResolver());
        this.myCollection.add(new MessageResolver());
        this.myCollection.add(new PartnerLinkTypeResolver());
        this.myCollection.add(new PortTypeResolver());
        this.myCollection.add(new CorrelationPropertyResolver());
        this.myCollection.add(new RoleResolver());
        this.myCollection.add(new OperationResolver());
    }

    public static WSDLReferenceBuilder getInstance() {
        return INSTANCE;
    }

    public <T extends ReferenceableWSDLComponent> WSDLReference<T> build(Class<T> clazz, BpelEntityImpl bpelEntityImpl, Attribute attribute) {
        WSDLReference<T> wSDLReference = this.build(clazz, (AbstractDocumentComponent)bpelEntityImpl, bpelEntityImpl.getAttribute(attribute));
        if (wSDLReference instanceof MappedReference) {
            ((MappedReference)((Object)wSDLReference)).setAttribute(attribute);
        }
        return wSDLReference;
    }

    public <T extends ReferenceableWSDLComponent> WSDLReference<T> build(Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent, String string) {
        if (string == null) {
            return null;
        }
        for (WSDLReferenceFactory wSDLReferenceFactory : this.myCollection) {
            if (!wSDLReferenceFactory.isApplicable(clazz)) continue;
            return wSDLReferenceFactory.createUnresolvedReference(clazz, abstractDocumentComponent, string);
        }
        return null;
    }

    public <T extends ReferenceableWSDLComponent> WSDLReference<T> build(T t, Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent) {
        for (WSDLReferenceFactory wSDLReferenceFactory : this.myCollection) {
            if (!wSDLReferenceFactory.isApplicable(clazz)) continue;
            return wSDLReferenceFactory.create(t, clazz, abstractDocumentComponent);
        }
        return null;
    }

    public BpelAttributesType.AttrType getAttributeType(Attribute attribute) {
        Class clazz = null;
        clazz = List.class.isAssignableFrom(attribute.getType()) ? attribute.getMemberType() : attribute.getType();
        for (WSDLReferenceFactory wSDLReferenceFactory : this.myCollection) {
            if (!wSDLReferenceFactory.isApplicable(clazz)) continue;
            return wSDLReferenceFactory.getAttributeType();
        }
        assert (false);
        return null;
    }

    public void setAttribute(org.netbeans.modules.bpel.model.api.references.WSDLReference wSDLReference, Attribute attribute) {
        if (wSDLReference instanceof MappedReference) {
            ((MappedReference)((Object)wSDLReference)).setAttribute(attribute);
        }
    }

    static Collection<WSDLModel> getWSDLModels(AbstractDocumentComponent abstractDocumentComponent, String string) {
        assert (abstractDocumentComponent instanceof BpelEntity);
        ExNamespaceContext exNamespaceContext = ((BpelEntity)abstractDocumentComponent).getNamespaceContext();
        Collection<WSDLModel> collection = WSDLReferenceBuilder.getWSDLModels(((BpelEntity)abstractDocumentComponent).getBpelModel(), exNamespaceContext.getNamespaceURI(string));
        return collection;
    }

    static Collection<WSDLModel> getWSDLModels(BpelModel bpelModel, String string) {
        return WSDLReferenceBuilder.getInstance().getModels(bpelModel, string);
    }

    private Collection<WSDLModel> getModels(BpelModel bpelModel, String string) {
        LinkedList<WSDLModel> linkedList = new LinkedList<WSDLModel>();
        if (myRetrievers.size() == 1) {
            return ((ExternalModelRetriever)myRetrievers.iterator().next()).getWSDLModels(bpelModel, string);
        }
        for (Object e : myRetrievers) {
            ExternalModelRetriever externalModelRetriever = (ExternalModelRetriever)e;
            Collection<WSDLModel> collection = externalModelRetriever.getWSDLModels(bpelModel, string);
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface WSDLResolver {
        public <T extends ReferenceableWSDLComponent> T resolve(AbstractNamedComponentReference<T> var1);
    }
}

