/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl.services;

import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;
import org.netbeans.modules.bpel.model.xam.BpelAttributes;
import org.netbeans.modules.xml.xam.dom.Attribute;

public class CheckNameService
extends InnerEventDispatcherAdapter {
    public boolean isApplicable(ChangeEvent changeEvent) {
        if (changeEvent instanceof PropertyUpdateEvent) {
            PropertyUpdateEvent propertyUpdateEvent = (PropertyUpdateEvent)changeEvent;
            if (propertyUpdateEvent.getParent() == null || propertyUpdateEvent.getParent().getModel().inSync()) {
                return false;
            }
            Object object = propertyUpdateEvent.getNewValue();
            if (object == null) {
                return false;
            }
            if (object instanceof String) {
                Attribute attribute = BpelAttributes.forName(propertyUpdateEvent.getName());
                return attribute instanceof BpelAttributes && ((BpelAttributes)attribute).getAttributeType() != BpelAttributes.AttrType.STRING;
            }
            return false;
        }
        return false;
    }

    public void preDispatch(ChangeEvent changeEvent) throws VetoException {
        assert (changeEvent instanceof PropertyUpdateEvent);
        PropertyUpdateEvent propertyUpdateEvent = (PropertyUpdateEvent)changeEvent;
        Attribute attribute = BpelAttributes.forName(propertyUpdateEvent.getName());
        BpelAttributes.AttrType attrType = ((BpelAttributes)attribute).getAttributeType();
        if (this.checkURI(propertyUpdateEvent, attrType)) {
            return;
        }
        if (attrType != BpelAttributes.AttrType.NCNAME && attrType != BpelAttributes.AttrType.VARIABLE) {
            return;
        }
        this.checkNCNameAndVariable(propertyUpdateEvent, attrType);
    }

    private boolean checkURI(PropertyUpdateEvent propertyUpdateEvent, BpelAttributes.AttrType attrType) throws VetoException {
        if (attrType == BpelAttributes.AttrType.URI) {
            String string = (String)propertyUpdateEvent.getNewValue();
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string2 = Utils.getResourceString("BAD_ATTRIBUTE_URI_VALUE", string, propertyUpdateEvent.getName());
                throw new VetoException(string2, propertyUpdateEvent);
            }
            return true;
        }
        return false;
    }

    private void checkNCNameAndVariable(PropertyUpdateEvent propertyUpdateEvent, BpelAttributes.AttrType attrType) throws VetoException {
        String string = (String)propertyUpdateEvent.getNewValue();
        if (!Utils.checkNCName(string)) {
            this.throwVetoException(propertyUpdateEvent, string);
        }
        if (attrType == BpelAttributes.AttrType.VARIABLE && string.indexOf(46) != -1) {
            this.throwVetoException(propertyUpdateEvent, string);
        }
        this.checkVariableName(propertyUpdateEvent, string);
    }

    private void checkVariableName(PropertyUpdateEvent propertyUpdateEvent, String string) throws VetoException {
        if (propertyUpdateEvent.getParent() instanceof Variable && propertyUpdateEvent.getName().equals("name") && string.indexOf(46) != -1) {
            this.throwVetoException(propertyUpdateEvent, string);
        }
    }

    private void throwVetoException(PropertyUpdateEvent propertyUpdateEvent, String string) throws VetoException {
        String string2 = Utils.getResourceString("BAD_ATTRIBUTE_VALUE", string, propertyUpdateEvent.getName());
        throw new VetoException(string2, propertyUpdateEvent);
    }
}

