/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.bpel.core.wizard.NewBpelFilePanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BpelOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SERVICE_NAME = NbBundle.getMessage(BpelOptionsPanel.class, (String)"TXT_defaultServiceName");
    private static final String DEFAULT_PROJECT_NAME = NbBundle.getMessage(BpelOptionsPanel.class, (String)"TXT_defaultProjectName");
    private static final String TARGET_URL_PREFIX = NbBundle.getMessage(BpelOptionsPanel.class, (String)"TXT_defaultTNS");
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JTextField namespaceTextField;
    private NewBpelFilePanel newBpelFilePanel;
    private JTextField fileNameTF;
    private String prevNamespace;
    private boolean nameSpaceModifiedFlag;

    public BpelOptionsPanel(NewBpelFilePanel newBpelFilePanel) {
        this.initComponents();
        this.newBpelFilePanel = newBpelFilePanel;
        NameSpaceListener nameSpaceListener = new NameSpaceListener();
        this.namespaceTextField.getDocument().addDocumentListener(nameSpaceListener);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BpelOptionsPanel.class, (String)"LBL_Namespace"));
        this.namespaceTextField = new JTextField();
        this.jLabel1.setLabelFor(this.namespaceTextField);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1, -1, 144, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.namespaceTextField, -2, 460, -2)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(4, 4, 4).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.namespaceTextField, -2, -1, -2).add((Component)this.jLabel1, -2, 22, -2)).add(198, 198, 198)));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/bpel/core/wizard/Bundle");
        this.jLabel1.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NamespaceLabel"));
        this.namespaceTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_NamespaceTextField"));
        this.namespaceTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_NamespaceTextFieldDescription"));
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("namespace", (Object)this.namespaceTextField.getText());
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    protected void setNamespaceTextField(String string) {
        this.namespaceTextField.setText(string);
    }

    protected String getNamespaceTextField() {
        return this.namespaceTextField.getText();
    }

    String getWsName() {
        if (this.fileNameTF != null) {
            return this.fileNameTF.getText();
        }
        return DEFAULT_SERVICE_NAME;
    }

    void attachFileNameListener(JTextField jTextField) {
        Object object;
        this.fileNameTF = jTextField;
        if (this.fileNameTF != null) {
            object = new DocListener();
            Document document = this.fileNameTF.getDocument();
            document.addDocumentListener((DocumentListener)object);
        }
        object = this.generateNamespace();
        this.namespaceTextField.setText((String)object);
        this.prevNamespace = object;
    }

    private String generateNamespace() {
        Object object;
        String string = null;
        Project project = this.newBpelFilePanel.getProject();
        if (project != null && (object = ProjectUtils.getInformation((Project)project)) != null) {
            string = object.getName();
        }
        if (string == null || string.length() == 0) {
            string = DEFAULT_PROJECT_NAME;
        }
        object = null;
        if (this.fileNameTF != null) {
            object = this.fileNameTF.getText();
        }
        if (object == null || object.length() == 0) {
            object = DEFAULT_SERVICE_NAME;
        }
        String string2 = MessageFormat.format(TARGET_URL_PREFIX, string, object);
        return string2;
    }

    private void doUpdate() {
        if (this.namespaceTextField.getText() != null && this.prevNamespace != null && !this.namespaceTextField.getText().equals(this.prevNamespace)) {
            this.nameSpaceModifiedFlag = true;
        }
        if (!this.nameSpaceModifiedFlag) {
            String string = this.generateNamespace();
            this.namespaceTextField.setText(string);
            this.prevNamespace = string;
        }
    }

    private void checkValidNamespace() {
        if (this.newBpelFilePanel.getTemplateWizard() == null) {
            return;
        }
        if (this.namespaceTextField.getText().contains(" ")) {
            this.newBpelFilePanel.getTemplateWizard().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(BpelOptionsPanel.class, (String)"MSG_Namespace_Contains_Space"));
        } else {
            this.newBpelFilePanel.getTemplateWizard().putProperty("WizardPanel_errorMessage", null);
        }
    }

    private class NameSpaceListener
    implements DocumentListener {
        private NameSpaceListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BpelOptionsPanel.this.checkValidNamespace();
            BpelOptionsPanel.this.newBpelFilePanel.fireChange();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BpelOptionsPanel.this.checkValidNamespace();
            BpelOptionsPanel.this.newBpelFilePanel.fireChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BpelOptionsPanel.this.checkValidNamespace();
            BpelOptionsPanel.this.newBpelFilePanel.fireChange();
        }
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BpelOptionsPanel.this.doUpdate();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BpelOptionsPanel.this.doUpdate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BpelOptionsPanel.this.doUpdate();
        }
    }
}

