/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.mobility.project.PropertyDescriptor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.PlatformConvertor;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.MIDletsCacheHelper;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.MIDletScanner;
import org.netbeans.modules.mobility.project.ui.wizard.ClassPreloader;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.netbeans.spi.mobility.project.ProjectPropertiesDescriptor;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2MEProjectGenerator {
    public static final Pattern IMPORT_EXCLUDES = Pattern.compile("^(.*/)?(([^/]*~)|(#[^/]*#)|(\\.#[^/]*)|(%[^/]*%)|(\\._[^/]*)|(CVS)|(CVS/.*)|(\\.cvsignore)|(SCCS)|(SCCS/.*)|(vssver\\.scc)|(\\.svn)|(\\.svn/.*)|(\\.DS_Store)|([^/]*\\.class)|([^/]*\\.adContent)|([^/]*\\.jad)|([^/]*\\.nbattrs))$");
    public static final Pattern IMPORT_SRC_EXCLUDES = Pattern.compile("^(.*/)?(([^/]*~)|(#[^/]*#)|(\\.#[^/]*)|(%[^/]*%)|(\\._[^/]*)|(CVS)|(CVS/.*)|(\\.cvsignore)|(SCCS)|(SCCS/.*)|(vssver\\.scc)|(\\.svn)|(\\.svn/.*)|(\\.DS_Store)|([^/]*\\.class)|([^/]*\\.adContent)|([^/]*\\.jad)|([^/]*\\.jar)|([^/]*\\.zip)|([^/]*\\.nbattrs))$");
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String EMPTY = "";
    private static final HashSet<String> KNOWN_ATTRIBUTES = new HashSet<String>(Arrays.asList("MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version", "MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"));
    private static final String PRIVATE_PREFIX = "private.";
    private static final String SRC = "src";
    private static final String NAME = "name";
    private static final String MIDLET = "MIDlet-";

    private J2MEProjectGenerator() {
    }

    public static AntProjectHelper createProjectFromSources(File file, String string, PlatformSelectionPanel.PlatformDescription platformDescription, final String string2, final String string3) throws IOException {
        return J2MEProjectGenerator.createProject(file, string, platformDescription, new ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper antProjectHelper, FileObject fileObject, File file, ArrayList arrayList) throws IOException {
                J2MEProjectGenerator.setSourceRoot(antProjectHelper, J2MEProjectGenerator.getReferenceHelper(project), string2);
                J2MEProjectGenerator.loadJadManifest(antProjectHelper, new File(string3));
                J2MEProjectGenerator.fillMissingMIDlets(project, antProjectHelper);
            }
        });
    }

    public static AntProjectHelper createProjectFromSuite(File file, String string, PlatformSelectionPanel.PlatformDescription platformDescription, final String string2, final String string3) throws IOException {
        return J2MEProjectGenerator.createProject(file, string, platformDescription, new ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper antProjectHelper, FileObject fileObject, File file, ArrayList arrayList) throws IOException {
                J2MEProjectGenerator.setSourceRoot(antProjectHelper, J2MEProjectGenerator.getReferenceHelper(project), string3);
                J2MEProjectGenerator.loadSettingFromSuite(antProjectHelper, new File(string2));
                J2MEProjectGenerator.fillMissingMIDlets(project, antProjectHelper);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(File file, File file2, Pattern pattern) throws IOException {
        if (J2MEProjectGenerator.isParent(file, file2)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                File file3 = fileArray[i];
                if (pattern.matcher(file3.getAbsolutePath().replace('\\', '/')).matches()) continue;
                if (file3.isDirectory()) {
                    object = new File(file2, file3.getName());
                    ((File)object).mkdirs();
                    J2MEProjectGenerator.copyFolder(file3, (File)object, pattern);
                    continue;
                }
                object = null;
                FileOutputStream fileOutputStream = null;
                try {
                    object = new FileInputStream(file3);
                    fileOutputStream = new FileOutputStream(new File(file2, file3.getName()));
                    FileUtil.copy((InputStream)object, (OutputStream)fileOutputStream);
                    continue;
                }
                finally {
                    if (object != null) {
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public static AntProjectHelper createProjectFromWtkProject(File file, String string, PlatformSelectionPanel.PlatformDescription platformDescription, final String string2) throws IOException {
        return J2MEProjectGenerator.createProject(file, string, platformDescription, new ProjectGeneratorCallback(){

            public void doPostGeneration(Project project, AntProjectHelper antProjectHelper, FileObject fileObject, File file, ArrayList arrayList) throws IOException {
                ReferenceHelper referenceHelper = J2MEProjectGenerator.getReferenceHelper(project);
                FileObject fileObject2 = fileObject.createFolder(J2MEProjectGenerator.SRC);
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                FileObject fileObject3 = fileObject.createFolder("lib");
                File file3 = FileUtil.toFile((FileObject)fileObject3);
                FileObject fileObject4 = fileObject.createFolder("res");
                File file4 = FileUtil.toFile((FileObject)fileObject4);
                J2MEProjectGenerator.copyJavaFolder(new File(string2, J2MEProjectGenerator.SRC), file2, IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder(new File(string2, "res"), file4, IMPORT_SRC_EXCLUDES);
                J2MEProjectGenerator.copyFolder(new File(string2, "lib"), file3, IMPORT_EXCLUDES);
                File file5 = J2MEProjectGenerator.findWtkJadFile(string2);
                File file6 = J2MEProjectGenerator.findWtkManifestFile(string2);
                J2MEProjectGenerator.loadJadAndManifest(antProjectHelper, file5, file6);
                J2MEProjectGenerator.loadWTKProperties(antProjectHelper, file);
                File[] fileArray = file3.listFiles();
                File[] fileArray2 = null;
                if (fileArray == null) {
                    fileArray2 = new File[1];
                } else {
                    fileArray2 = new File[fileArray.length + 1];
                    System.arraycopy(fileArray, 0, fileArray2, 1, fileArray.length);
                }
                fileArray2[0] = file4;
                J2MEProjectGenerator.loadLibraries(antProjectHelper, referenceHelper, fileArray2);
                J2MEProjectGenerator.fillMissingMIDlets(project, antProjectHelper);
            }
        });
    }

    public static AntProjectHelper duplicateProject(J2MEProject j2MEProject, File file, String string, boolean bl) throws IOException {
        Object object;
        ProjectConfiguration[] projectConfigurationArray;
        Object object22;
        FileObject fileObject = J2MEProjectGenerator.createProjectLocation(file);
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.kjava.j2meproject");
        AntProjectHelper antProjectHelper2 = (AntProjectHelper)j2MEProject.getLookup().lookup(AntProjectHelper.class);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2me-project", NAME);
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/j2me-project", "minimum-ant-version");
        element3.appendChild(document.createTextNode("1.6"));
        element.appendChild(element3);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper2.getProperties("nbproject/project.properties").cloneProperties();
        EditableProperties editableProperties2 = antProjectHelper2.getProperties("nbproject/private/private.properties").cloneProperties();
        editableProperties.setProperty("src.dir", SRC);
        editableProperties.setProperty(NAME, string);
        File file2 = FileUtil.toFile((FileObject)fileObject);
        assert (file2 != null) : "FileUtil.toFile convertion failed for: " + fileObject;
        for (Object object22 : editableProperties.keySet()) {
            String string2;
            if (!((String)object22).startsWith("file.reference.") && !((String)object22).startsWith("project.") || (projectConfigurationArray = editableProperties.getProperty((String)object22)).indexOf("${") >= 0) continue;
            object = antProjectHelper2.resolveFile((String)projectConfigurationArray);
            if (CollocationQuery.areCollocated((File)file2, (File)object) && (string2 = PropertyUtils.relativizeFile((File)file2, (File)object)) != null) {
                editableProperties.put((String)object22, string2);
                continue;
            }
            editableProperties.remove(object22);
            editableProperties2.put((String)object22, ((File)object).getAbsolutePath());
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        object22 = (ProjectConfigurationsHelper)j2MEProject.getLookup().lookup(ProjectConfigurationsHelper.class);
        projectConfigurationArray = ((ProjectConfigurationsHelper)object22).getConfigurations().toArray(new ProjectConfiguration[0]);
        object = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            if (((ProjectConfigurationsHelper)object22).getDefaultConfiguration().equals(projectConfigurationArray[i])) continue;
            ((ProjectConfigurationsHelper)object).addConfiguration(projectConfigurationArray[i].getDisplayName());
        }
        ReferenceHelper referenceHelper = (ReferenceHelper)j2MEProject.getLookup().lookup(ReferenceHelper.class);
        ReferenceHelper referenceHelper2 = (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class);
        ReferenceHelper.RawReference[] rawReferenceArray = referenceHelper.getRawReferences();
        if (rawReferenceArray != null) {
            for (int i = 0; i < rawReferenceArray.length; ++i) {
                referenceHelper2.addRawReference(rawReferenceArray[i]);
            }
        }
        if (project instanceof J2MEProject) {
            ((J2MEProject)project).hookNewProjectCreated();
        }
        FileObject fileObject2 = fileObject.createFolder(SRC);
        if (bl) {
            J2MEProjectGenerator.copyJavaFolder(antProjectHelper2.resolveFile(antProjectHelper2.getStandardPropertyEvaluator().getProperty("src.dir")), FileUtil.toFile((FileObject)fileObject2), IMPORT_SRC_EXCLUDES);
        }
        J2MEProjectGenerator.refreshProject(fileObject, fileObject2);
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }

    public static AntProjectHelper createNewProject(File file, String string, PlatformSelectionPanel.PlatformDescription platformDescription, Collection<DataObject> collection, Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> set) throws IOException {
        ClassPreloader.stop();
        return J2MEProjectGenerator.createProject(file, string, platformDescription, new NewProjectGeneratorCallback(collection, set));
    }

    public static AntProjectHelper createProjectFromTemplate(final FileObject fileObject, File file, String string, PlatformSelectionPanel.PlatformDescription platformDescription) throws IOException {
        return J2MEProjectGenerator.createProject(file, string, platformDescription, new ProjectGeneratorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doPostGeneration(Project project, AntProjectHelper antProjectHelper, FileObject fileObject3, File file, ArrayList<String> arrayList) throws IOException {
                FileObject fileObject2 = null;
                if (fileObject.getExt().endsWith("zip")) {
                    File file2;
                    File file3;
                    J2MEProjectGenerator.unzip(fileObject.getInputStream(), file);
                    File file4 = Utils.findAnyFile(file.listFiles(), "jad");
                    if (file4 != null) {
                        J2MEProjectGenerator.loadJadManifest(antProjectHelper, file4);
                        file4.delete();
                    }
                    if ((file3 = new File(file2 = new File(file, "META-INF"), "project.properties")).exists() && file3.canRead()) {
                        Properties properties = new Properties();
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(file3);
                            properties.load(fileInputStream);
                            Enumeration<Object> enumeration = properties.keys();
                            while (enumeration.hasMoreElements()) {
                                String string = (String)enumeration.nextElement();
                                if (!string.startsWith("configs.")) continue;
                                int n = (string = string.substring("configs.".length())).indexOf(46);
                                if (n >= 0) {
                                    string = string.substring(0, n);
                                }
                                if (arrayList.contains(string)) continue;
                                arrayList.add(string);
                            }
                            J2MEProjectGenerator.setProperties(antProjectHelper, properties);
                        }
                        finally {
                            if (fileInputStream != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        J2MEProjectGenerator.deleteAll(file2);
                    }
                    fileObject3.refresh(false);
                } else {
                    fileObject2 = fileObject3.createFolder(J2MEProjectGenerator.SRC);
                }
                J2MEProjectGenerator.refreshProject(fileObject3, fileObject2);
            }
        });
    }

    public static AntProjectHelper createProject(File file, String string, PlatformSelectionPanel.PlatformDescription platformDescription, ProjectGeneratorCallback projectGeneratorCallback) throws IOException {
        ProjectConfigurationsHelper projectConfigurationsHelper;
        Object object222;
        FileObject fileObject = J2MEProjectGenerator.createProjectLocation(file);
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.kjava.j2meproject");
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2me-project", NAME);
        element2.appendChild(document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/j2me-project", "minimum-ant-version");
        element3.appendChild(document.createTextNode("1.6"));
        element.appendChild(element3);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
        for (Object object222 : Lookup.getDefault().lookup(new Lookup.Template(ProjectPropertiesDescriptor.class)).allInstances()) {
            for (PropertyDescriptor object3 : object222.getPropertyDescriptors()) {
                if (object3.getDefaultValue() == null) continue;
                (object3.isShared() ? editableProperties : editableProperties2).setProperty(object3.getName(), object3.getDefaultValue());
            }
        }
        editableProperties.setProperty("build.root.dir", "build");
        editableProperties.setProperty("dist.root.dir", "dist");
        editableProperties.setProperty(NAME, string);
        editableProperties.setProperty("preprocessed.dir", "${build.dir}/preprocessed");
        editableProperties.setProperty("build.classes.dir", "${build.dir}/compiled");
        editableProperties.setProperty("obfuscator.srcjar", "${build.dir}/before-obfuscation.jar");
        editableProperties.setProperty("obfuscator.destjar", "${build.dir}/obfuscated.jar");
        editableProperties.setProperty("obfuscated.classes.dir", "${build.dir}/obfuscated");
        editableProperties.setProperty("preverify.sources.dir", "${build.dir}/preverifysrc");
        editableProperties.setProperty("preverify.classes.dir", "${build.dir}/preverified");
        String string2 = PropertyUtils.getUsablePropertyName((String)string);
        editableProperties.setProperty("dist.jar", (String)string2 + ".jar");
        editableProperties.setProperty("dist.jad", (String)string2 + ".jad");
        editableProperties.setProperty("dist.javadoc.dir", "${dist.dir}/doc");
        editableProperties.setProperty("deployment.copy.target", "deploy");
        editableProperties.setProperty("javac.encoding", FileEncodingQuery.getDefaultEncoding().name());
        object222 = new HashMap();
        ((HashMap)object222).put("MIDlet-Name", string);
        ((HashMap)object222).put("MIDlet-Vendor", "Vendor");
        ((HashMap)object222).put("MIDlet-Version", "1.0");
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.others", (HashMap<String, String>)object222);
        if (platformDescription != null) {
            editableProperties.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)platformDescription.platform, (J2MEPlatform.Device)platformDescription.device, (String)platformDescription.configuration, (String)platformDescription.profile));
        } else {
            editableProperties.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)J2MEProjectGenerator.findPlatform(null), null, null, null));
        }
        editableProperties2.setProperty("netbeans.user", System.getProperty("netbeans.user"));
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        File file2 = FileUtil.toFile((FileObject)fileObject);
        assert (file2 != null) : "FileUtil.toFile convertion failed for: " + fileObject;
        ArrayList<String> arrayList = new ArrayList<String>();
        Project project = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject(project);
        if (projectGeneratorCallback != null) {
            projectGeneratorCallback.doPostGeneration(project, antProjectHelper, fileObject, file2, arrayList);
        }
        if (!arrayList.isEmpty() && (projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class)) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = arrayList.get(i);
                projectConfigurationsHelper.addConfiguration(string3);
            }
        }
        if (project instanceof J2MEProject) {
            ((J2MEProject)project).hookNewProjectCreated();
        }
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }

    protected static void loadJadManifest(AntProjectHelper antProjectHelper, File file) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        J2MEProjectGenerator.loadJadManifest(hashMap, file);
        J2MEProjectGenerator.loadPropertiesFromMap(antProjectHelper, hashMap, hashMap);
    }

    public static void loadJadManifest(Map<String, String> map, File file) throws IOException {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            return;
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ("jad".equals(string.toLowerCase())) {
            J2MEProjectGenerator.loadJad(map, file);
        } else {
            J2MEProjectGenerator.loadManifest(map, file);
        }
    }

    protected static void loadJadAndManifest(AntProjectHelper antProjectHelper, File file, File file2) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (file != null) {
            J2MEProjectGenerator.loadJad(hashMap, file);
        }
        if (file2 != null) {
            J2MEProjectGenerator.loadManifest(hashMap2, file2);
        }
        J2MEProjectGenerator.loadPropertiesFromMap(antProjectHelper, hashMap.isEmpty() ? hashMap2 : hashMap, hashMap2.isEmpty() ? hashMap : hashMap2);
    }

    public static void loadJadAndManifest(Map<String, String> map, File file, File file2) throws IOException {
        if (file != null) {
            J2MEProjectGenerator.loadJad(map, file);
        }
        if (file2 != null) {
            J2MEProjectGenerator.loadManifest(map, file2);
        }
    }

    private static void removeInvalidProperties(Map<String, String> map) {
        map.remove("MIDlet-Jar-RSA-SHA1");
        map.remove("MIDlet-Jar-Size");
        map.remove("MIDlet-Jar-URL");
        map.remove("MicroEdition-Configuration");
        map.remove("MicroEdition-Profile");
        int n = 1;
        while (true) {
            int n2 = 1;
            while (map.remove(MessageFormat.format("MIDlet-Certificate-{0}-{1}", Integer.toString(n), Integer.toString(n2))) != null) {
                ++n2;
            }
            if (n2 <= 1) break;
            ++n;
        }
    }

    protected static void setProperties(AntProjectHelper antProjectHelper, Map map) {
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.putAll(map);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    private static void loadPropertiesFromMap(AntProjectHelper antProjectHelper, Map<String, String> map, Map<String, String> map2) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.putAll(map2);
        J2MEProjectGenerator.removeInvalidProperties(hashMap);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        HashMap hashMap5 = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(editableProperties.getProperty("manifest.others"), null, null);
        HashMap<String, String> hashMap6 = new HashMap<String, String>();
        HashMap<String, String> hashMap7 = new HashMap<String, String>();
        for (String string : hashMap.keySet()) {
            String string2;
            if (string == null || (string2 = hashMap.get(string)) == null) continue;
            if ("MIDlet-Permissions".equalsIgnoreCase(string)) {
                hashMap3.put(string, string2);
                continue;
            }
            if ("MIDlet-Permissions-Opt".equalsIgnoreCase(string)) {
                hashMap3.put(string, string2);
                continue;
            }
            if (J2MEProjectGenerator.isNumberedProperty(string, MIDLET)) {
                hashMap2.put(string, string2);
                continue;
            }
            if (J2MEProjectGenerator.isNumberedProperty(string, "MIDlet-Push-")) {
                hashMap4.put(string, string2);
                continue;
            }
            if (!map.containsKey(string) && !KNOWN_ATTRIBUTES.contains(string)) {
                hashMap6.put(string, string2);
                continue;
            }
            if (!map2.containsKey(string) && !KNOWN_ATTRIBUTES.contains(string)) {
                hashMap7.put(string, string2);
                continue;
            }
            hashMap5.put(string, string2);
        }
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.midlets", hashMap2);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.apipermissions", hashMap3);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.pushregistry", hashMap4);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.others", hashMap5);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.jad", hashMap7);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.manifest", hashMap6);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    private static boolean isNumberedProperty(String string, String string2) {
        if (!string.startsWith(string2)) {
            return false;
        }
        try {
            Integer.parseInt(string.substring(string2.length()));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static void storeManifestProperties(EditableProperties editableProperties, String string, HashMap<String, String> hashMap) {
        editableProperties.setProperty(string, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(hashMap, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadJad(Map<String, String> map, File file) throws IOException {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (EMPTY.equals(string) || (n = string.indexOf(58)) < 0) continue;
                map.put(string.substring(0, n), string.substring(n + 1).trim());
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadManifest(Map<String, String> map, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Manifest manifest = new Manifest(fileInputStream);
            Iterator<Attributes> iterator = manifest.getEntries().values().iterator();
            while (iterator.hasNext()) {
                J2MEProjectGenerator.putAllAsStrings(map, iterator.next());
            }
            J2MEProjectGenerator.putAllAsStrings(map, manifest.getMainAttributes());
            map.remove("Manifest-Version");
            map.remove("Created-By");
        }
        finally {
            fileInputStream.close();
        }
    }

    private static void putAllAsStrings(Map<String, String> map, Attributes attributes) {
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            map.put(entry.getKey().toString(), (String)entry.getValue());
        }
    }

    protected static void loadSettingFromSuite(AntProjectHelper antProjectHelper, File file) throws IOException {
        Document document = J2MEProjectGenerator.getDocumentForSuite(file);
        J2MEProjectGenerator.loadSettingFromSuite(antProjectHelper, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocumentForSuite(File file) throws IOException {
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        Document document = null;
        try {
            document = XMLUtil.parse((InputSource)new InputSource(fileInputStream), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw new SAXException(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw new SAXException(sAXParseException);
                }

                public void warning(SAXParseException sAXParseException) {
                }
            }, null);
        }
        catch (SAXException sAXException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MEProjectGenerator.class, (String)"MSG_ProjectGen_CannotParseSuite")));
            Document document2 = null;
            return document2;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return document;
    }

    private static void loadSettingFromSuite(AntProjectHelper antProjectHelper, Document document) throws IOException {
        Node node;
        Profile[] profileArray;
        if (document == null) {
            return;
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        HashMap hashMap4 = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(editableProperties.getProperty("manifest.others"), null, null);
        Profile profile = null;
        Profile profile2 = null;
        Node node2 = document.getFirstChild();
        if ("2.0".equals(J2MEProjectGenerator.getAttributeValue(node2, "version"))) {
            for (profileArray = node2.getFirstChild(); profileArray != null; profileArray = profileArray.getNextSibling()) {
                if ("attribute".equalsIgnoreCase(profileArray.getNodeName())) {
                    for (node = profileArray.getFirstChild(); node != null; node = node.getNextSibling()) {
                        String string;
                        String string2;
                        String string3;
                        String string4;
                        if ("midlet".equalsIgnoreCase(node.getNodeName())) {
                            string4 = J2MEProjectGenerator.getAttributeValue(node, "order");
                            string3 = J2MEProjectGenerator.getAttributeValue(node, "class");
                            string2 = J2MEProjectGenerator.getAttributeValue(node, "icon");
                            string = J2MEProjectGenerator.getAttributeValue(node, NAME);
                            if (string4 == null || string3 == null || string2 == null || string == null) continue;
                            hashMap.put(MIDLET + string4, string + ", " + string2 + ", " + string3);
                            continue;
                        }
                        if ("permission".equalsIgnoreCase(node.getNodeName())) {
                            string4 = J2MEProjectGenerator.getAttributeValue(node, NAME);
                            if (string4 == null) continue;
                            hashSet.add(string4);
                            continue;
                        }
                        if ("permission-opt".equalsIgnoreCase(node.getNodeName())) {
                            string4 = J2MEProjectGenerator.getAttributeValue(node, NAME);
                            if (string4 == null) continue;
                            hashSet2.add(string4);
                            continue;
                        }
                        if ("required".equalsIgnoreCase(node.getNodeName()) || "optional".equalsIgnoreCase(node.getNodeName()) || "user".equalsIgnoreCase(node.getNodeName()) || "security".equalsIgnoreCase(node.getNodeName())) {
                            string4 = J2MEProjectGenerator.getAttributeValue(node, NAME);
                            string3 = J2MEProjectGenerator.getAttributeValue(node, "value");
                            if (string4 == null || string3 == null) continue;
                            hashMap4.put(string4, string3);
                            continue;
                        }
                        if (!"push".equalsIgnoreCase(node.getNodeName())) continue;
                        string4 = J2MEProjectGenerator.getAttributeValue(node, "protocol");
                        string3 = J2MEProjectGenerator.getAttributeValue(node, "host");
                        string2 = J2MEProjectGenerator.getAttributeValue(node, "class");
                        string = J2MEProjectGenerator.getAttributeValue(node, "order");
                        if (string4 == null || string3 == null || string2 == null || string == null) continue;
                        hashMap.put("MIDlet-Push-" + string, string4 + ", " + string2 + ", " + string3);
                    }
                    continue;
                }
                if ("Configuration".equalsIgnoreCase(profileArray.getNodeName())) {
                    profile = J2MEProjectGenerator.name2profile(J2MEProjectGenerator.getAttributeValue((Node)profileArray, "value"));
                    continue;
                }
                if (!"Profile".equalsIgnoreCase(profileArray.getNodeName())) continue;
                profile2 = J2MEProjectGenerator.name2profile(J2MEProjectGenerator.getAttributeValue((Node)profileArray, "value"));
            }
        }
        if (!hashSet.isEmpty()) {
            hashMap3.put("MIDlet-Permissions", J2MEProjectGenerator.hashMapToCommaSeparatedString(hashSet));
        }
        if (!hashSet2.isEmpty()) {
            hashMap3.put("MIDlet-Permissions-Opt", J2MEProjectGenerator.hashMapToCommaSeparatedString(hashSet2));
        }
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.midlets", hashMap);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.apipermissions", hashMap3);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.pushregistry", hashMap2);
        J2MEProjectGenerator.removeInvalidProperties(hashMap4);
        J2MEProjectGenerator.storeManifestProperties(editableProperties, "manifest.others", hashMap4);
        if (profile != null || profile2 != null) {
            profileArray = new Profile[profile == null || profile2 == null ? 1 : 2];
            profileArray[0] = profile;
            if (profile2 != null) {
                profileArray[profileArray.length - 1] = profile2;
            }
            if ((node = J2MEProjectGenerator.findPlatform(profileArray)) != null) {
                editableProperties.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)node, null, (String)profile.toString(), (String)profile2.toString()));
            }
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    private static String hashMapToCommaSeparatedString(HashSet<String> hashSet) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : hashSet) {
            if (string == null) continue;
            stringBuffer.append(string);
            if (!bl) {
                stringBuffer.append(", ");
                continue;
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static String getAttributeValue(Node node, String string) {
        try {
            if (node == null) {
                return null;
            }
            if ((node = node.getAttributes().getNamedItem(string)) == null) {
                return null;
            }
            return node.getNodeValue();
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    public static File findWtkJadFile(String string) {
        File[] fileArray;
        if (string == null) {
            return null;
        }
        File file = null;
        File file2 = new File(string, "bin");
        if (file2.exists() && file2.isDirectory() && file2.canRead() && (file = Utils.findSubFile(fileArray = file2.listFiles(), new File(string).getName() + ".jad")) == null) {
            file = Utils.findAnyFile(fileArray, "jad");
        }
        return file;
    }

    public static File findWtkManifestFile(String string) {
        File[] fileArray;
        if (string == null) {
            return null;
        }
        File file = null;
        File file2 = new File(string, "bin");
        if (file2.exists() && file2.isDirectory() && file2.canRead() && (file = Utils.findSubFile(fileArray = file2.listFiles(), "manifest.mf")) == null) {
            file = Utils.findAnyFile(fileArray, "mf");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadWTKProperties(AntProjectHelper antProjectHelper, File file) throws IOException {
        J2MEPlatform j2MEPlatform;
        File file2 = new File(file, "project.properties");
        if (!file2.exists() || !file2.isFile()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            properties.load(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        Profile profile = J2MEProjectGenerator.wtkName2profile(properties.getProperty("configuration"), "CLDC");
        if (profile != null && (j2MEPlatform = J2MEProjectGenerator.findPlatform(new Profile[]{profile})) != null) {
            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
            editableProperties.putAll(PlatformConvertor.extractPlatformProperties((String)EMPTY, (J2MEPlatform)j2MEPlatform, null, (String)profile.toString(), null));
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
    }

    private static Profile wtkName2profile(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(string2)) {
            if ((string = string.substring(string2.length())).startsWith("-")) {
                string = string.substring(1);
            }
            string = string2 + "-" + string;
        }
        return J2MEProjectGenerator.name2profile(string);
    }

    private static Profile name2profile(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(45);
        try {
            if (n >= 0) {
                return new Profile(string.substring(0, n), new SpecificationVersion(string.substring(n + 1)));
            }
            return new Profile(string, new SpecificationVersion("1.0"));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static J2MEPlatform findPlatform(Profile[] profileArray) {
        JavaPlatform[] javaPlatformArray = profileArray != null ? JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null, profileArray)) : JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            if (!(javaPlatformArray[i] instanceof J2MEPlatform)) continue;
            return (J2MEPlatform)javaPlatformArray[i];
        }
        return null;
    }

    private static FileObject createProjectLocation(File file) throws IOException {
        Object object;
        File file2 = file = file.getCanonicalFile();
        while (file2 != null && !(file2 = file2.getParentFile()).exists()) {
        }
        if (file2 == null) {
            throw new IOException("Cannot find existing parent from " + file.toString());
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
        assert (fileObject != null) : "FileObject for " + file2 + "does not exist !";
        if (file2 != file) {
            object = file.getAbsolutePath().substring(file2.getAbsolutePath().length());
            if (((String)object).startsWith(File.separator)) {
                object = ((String)object).substring(1);
            }
            fileObject = FileUtil.createFolder((FileObject)fileObject, (String)object);
        }
        fileObject.refresh(false);
        assert (fileObject.isFolder()) : "Not really a dir: " + file;
        object = FileUtil.toFile((FileObject)fileObject);
        if (object != null) {
            object = ((File)object).getParentFile();
        }
        if (object != null) {
            ProjectChooser.setProjectsFolder((File)object);
        }
        return fileObject;
    }

    public static void copyJavaFolder(File file, File file2, Pattern pattern) throws IOException {
        J2MEProjectGenerator.copyJavaFolder(file, file2, file2, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyJavaFolder(File file, File file2, File file3, Pattern pattern) throws IOException {
        if (file == null || file2 == null || file3 == null) {
            return;
        }
        if (J2MEProjectGenerator.isParent(file, file3)) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                Closeable closeable;
                Object object;
                File file4;
                File file5 = fileArray[i];
                if (pattern.matcher(file5.getAbsolutePath().replace('\\', '/')).matches()) continue;
                if (file5.isDirectory()) {
                    file4 = new File(file3, file5.getName());
                    file4.mkdirs();
                    J2MEProjectGenerator.copyJavaFolder(file5, file2, file4, pattern);
                    continue;
                }
                file4 = new File(file3, file5.getName());
                if (file5.getName().toLowerCase().endsWith(".java")) {
                    Object object2;
                    block37: {
                        object = null;
                        closeable = null;
                        try {
                            int n;
                            int n2;
                            closeable = new BufferedReader(new FileReader(file5));
                            while (true) {
                                if ((object2 = ((BufferedReader)closeable).readLine()) == null) {
                                    break block37;
                                }
                                for (n2 = 0; n2 < ((String)object2).length() && ((String)object2).charAt(n2) == ' '; ++n2) {
                                }
                                if (!((String)object2).startsWith("package", n2)) continue;
                                int n3 = n2 += "package".length();
                                while (n2 < ((String)object2).length() && ((String)object2).charAt(n2) == ' ') {
                                    ++n2;
                                }
                                if (n3 == n2) continue;
                                for (n = n2; n < ((String)object2).length() && (Character.isJavaIdentifierPart(((String)object2).charAt(n)) || ((String)object2).charAt(n) == '.'); ++n) {
                                }
                                if (n != n2 && (n >= ((String)object2).length() || Character.isWhitespace(((String)object2).charAt(n)) || ((String)object2).charAt(n) == ';')) break;
                            }
                            object = ((String)object2).substring(n2, n);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (closeable != null) {
                                try {
                                    ((BufferedReader)closeable).close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (object != null && !EMPTY.equals(object)) {
                        object2 = new File(file2, ((String)object).replace('.', File.separatorChar));
                        ((File)object2).mkdirs();
                        file4 = new File((File)object2, file5.getName());
                    }
                }
                object = null;
                closeable = null;
                try {
                    object = new FileInputStream(file5);
                    closeable = new FileOutputStream(file4);
                    FileUtil.copy((InputStream)object, (OutputStream)closeable);
                    continue;
                }
                finally {
                    if (object != null) {
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (closeable != null) {
                        try {
                            ((FileOutputStream)closeable).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private static boolean isParent(File file, File file2) {
        while (file2 != null) {
            if (file.equals(file2)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unzip(InputStream inputStream, File file) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                file2.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    FileUtil.copy((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                }
                finally {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    protected static void deleteAll(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                J2MEProjectGenerator.deleteAll(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    public static void loadLibraries(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, File[] fileArray) {
        StringBuffer stringBuffer = null;
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] == null || !fileArray[i].exists()) continue;
                String string = fileArray[i].getName().toLowerCase();
                if (fileArray[i].isFile() && !string.endsWith(".jar") && !string.endsWith(".zip")) continue;
                if (stringBuffer != null) {
                    stringBuffer.append(File.pathSeparatorChar);
                } else {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(referenceHelper.createForeignFileReference(FileUtil.normalizeFile((File)fileArray[i]), "anyfile"));
            }
        }
        if (stringBuffer == null) {
            return;
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.put("libs.classpath", stringBuffer.toString());
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    public static void copyMIDletProperty(Project project, AntProjectHelper antProjectHelper, String string, String string2) throws IOException {
        if (string == null || string2 == null) {
            return;
        }
        ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        ProjectConfiguration[] projectConfigurationArray = projectConfigurationsHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string3 = editableProperties.getProperty("manifest.midlets");
        HashMap hashMap = string3 != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string3, null, null) : new HashMap();
        J2MEProjectGenerator.copyMIDletProperty(hashMap, string, string2);
        editableProperties.put("manifest.midlets", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(hashMap, null, null));
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            String string4;
            ProjectConfiguration projectConfiguration = projectConfigurationArray[i];
            String string5 = projectConfiguration.getDisplayName();
            String string6 = VisualPropertySupport.translatePropertyName(string5, "manifest.midlets", false);
            if (string6 == null || (string4 = editableProperties.getProperty(string6)) == null) continue;
            hashMap = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string3, null, null);
            J2MEProjectGenerator.copyMIDletProperty(hashMap, string, string2);
            editableProperties.put(string6, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(hashMap, null, null));
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    private static void copyMIDletProperty(HashMap<String, String> hashMap, String string, String string2) {
        String string3;
        String string4 = null;
        int n = 1;
        while ((string3 = hashMap.get(MIDLET + n)) != null) {
            int n2 = string3.lastIndexOf(44);
            if (n2 >= 0 && string.equals(string3.substring(n2 + 1).trim())) {
                string4 = string3.substring(0, n2 + 1) + string2;
            }
            ++n;
        }
        if (string4 != null) {
            hashMap.put(MIDLET + n, string4);
        }
    }

    public static void addMIDletProperty(Project project, AntProjectHelper antProjectHelper, String string, String string2, String string3) throws IOException {
        if (string == null) {
            string = EMPTY;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        if (string3 == null) {
            string3 = EMPTY;
        }
        ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        ProjectConfiguration[] projectConfigurationArray = projectConfigurationsHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string4 = editableProperties.getProperty("manifest.midlets");
        HashMap hashMap = string4 != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string4, null, null) : new HashMap();
        J2MEProjectGenerator.addMIDletProperty(hashMap, string, string2, string3);
        editableProperties.put("manifest.midlets", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(hashMap, null, null));
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            String string5;
            ProjectConfiguration projectConfiguration = projectConfigurationArray[i];
            String string6 = projectConfiguration.getDisplayName();
            String string7 = VisualPropertySupport.translatePropertyName(string6, "manifest.midlets", false);
            if (string7 == null || (string5 = editableProperties.getProperty(string7)) == null) continue;
            hashMap = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string4, null, null);
            J2MEProjectGenerator.addMIDletProperty(hashMap, string, string2, string3);
            editableProperties.put(string7, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(hashMap, null, null));
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
    }

    private static void addMIDletProperty(Map<String, String> map, String string, String string2, String string3) {
        int n = 1;
        while (map.containsKey(MIDLET + n)) {
            ++n;
        }
        map.put(MIDLET + n, string + ", " + string3 + ", " + string2);
    }

    public static void refreshProject(FileObject fileObject, FileObject fileObject2) {
        if (fileObject != null) {
            fileObject.refresh(false);
        }
        if (fileObject2 != null) {
            fileObject2.refresh();
        }
    }

    protected static void fillMissingMIDlets(final Project project, final AntProjectHelper antProjectHelper) {
        ReferenceHelper referenceHelper = (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class);
        ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        MIDletScanner mIDletScanner = MIDletScanner.getDefault(new J2MEProjectProperties(project, antProjectHelper, referenceHelper, projectConfigurationsHelper));
        final DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        mIDletScanner.scan(defaultComboBoxModel, null, null, new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MIDletsCacheHelper mIDletsCacheHelper = (MIDletsCacheHelper)project.getLookup().lookup(MIDletsCacheHelper.class);
                for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                    try {
                        String string = (String)defaultComboBoxModel.getElementAt(i);
                        if (mIDletsCacheHelper.contains(string)) continue;
                        J2MEProjectGenerator.addMIDletProperty(project, antProjectHelper, string.substring(string.lastIndexOf(46) + 1), string, null);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (project instanceof J2MEProject) {
                    ((J2MEProject)project).hookNewProjectCreated();
                }
                try {
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected static void setSourceRoot(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, String string) {
        String string2 = referenceHelper.createForeignFileReference(antProjectHelper.resolveFile(string), "anyfile");
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.put("src.dir", string2);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        J2MEProjectGenerator.refreshProject(antProjectHelper.getProjectDirectory(), antProjectHelper.resolveFileObject(string));
    }

    protected static ReferenceHelper getReferenceHelper(Project project) {
        return (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NewProjectGeneratorCallback
    implements ProjectGeneratorCallback,
    Runnable {
        private final Collection<DataObject> createHelloMIDlet;
        private final Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> cfgTemplates;
        private ArrayList<String> configurations;
        private File projectLocationFile;
        private FileObject projectLocation;
        private AntProjectHelper helper;
        private Project project;

        public NewProjectGeneratorCallback(Collection<DataObject> collection, Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> set) {
            this.createHelloMIDlet = collection;
            this.cfgTemplates = set;
        }

        @Override
        public void doPostGeneration(Project project, AntProjectHelper antProjectHelper, FileObject fileObject, File file, ArrayList<String> arrayList) throws IOException {
            this.project = project;
            this.helper = antProjectHelper;
            this.projectLocation = fileObject;
            this.projectLocationFile = file;
            this.configurations = arrayList;
            RequestProcessor.getDefault().post((Runnable)this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                Object object;
                String string;
                Object object2;
                DataFolder dataFolder;
                FileObject fileObject;
                FileObject fileObject2 = this.projectLocation.createFolder(J2MEProjectGenerator.SRC);
                if (this.createHelloMIDlet != null) {
                    void var5_8;
                    fileObject = fileObject2.createFolder("hello");
                    if (fileObject == null) {
                        fileObject = fileObject2;
                    }
                    dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                    FileObject fileObject3 = fileSystem.findResource("Templates/MIDP/HelloMIDlet.java");
                    if (fileObject3 == null) {
                        FileObject fileObject4 = fileSystem.findResource("Templates/MIDP/Midlet.java");
                    }
                    if (var5_8 != null && (object2 = DataObject.find((FileObject)var5_8)) != null) {
                        string = object2.getName();
                        if (string.endsWith(".java")) {
                            string = string.substring(0, string.length() - 5);
                        }
                        object = object2.createFromTemplate(dataFolder);
                        try {
                            object.setValid(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            propertyVetoException.printStackTrace();
                        }
                        object = DataObject.find((FileObject)object.getPrimaryFile());
                        this.createHelloMIDlet.add((DataObject)object);
                        J2MEProjectGenerator.addMIDletProperty(this.project, this.helper, string, fileObject != fileObject2 ? "hello." + string : string, J2MEProjectGenerator.EMPTY);
                        OpenCookie openCookie = (OpenCookie)object.getLookup().lookup(OpenCookie.class);
                        if (openCookie != null) {
                            openCookie.open();
                        }
                    }
                }
                if (this.cfgTemplates != null) {
                    fileObject = this.helper.getProperties("nbproject/private/private.properties");
                    dataFolder = this.helper.getProperties("nbproject/project.properties");
                    for (ProjectConfigurationFactory.ConfigurationTemplateDescriptor configurationTemplateDescriptor : this.cfgTemplates) {
                        object2 = configurationTemplateDescriptor.getCfgName();
                        string = "configs." + (String)object2 + '.';
                        if (this.configurations.contains(object2)) continue;
                        this.configurations.add((String)object2);
                        object = configurationTemplateDescriptor.getPrivateProperties();
                        if (object != null) {
                            for (Map.Entry entry : object.entrySet()) {
                                if (fileObject.containsKey(entry.getKey())) continue;
                                fileObject.put((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        if ((object = configurationTemplateDescriptor.getProjectGlobalProperties()) != null) {
                            for (Map.Entry entry : object.entrySet()) {
                                if (dataFolder.containsKey(entry.getKey())) continue;
                                dataFolder.put((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        if ((object = configurationTemplateDescriptor.getProjectConfigurationProperties()) == null) continue;
                        for (Map.Entry entry : object.entrySet()) {
                            dataFolder.put(string + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    this.helper.putProperties("nbproject/private/private.properties", (EditableProperties)fileObject);
                    this.helper.putProperties("nbproject/project.properties", (EditableProperties)dataFolder);
                }
                J2MEProjectGenerator.refreshProject(this.projectLocation, fileObject2);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProjectGeneratorCallback {
        public void doPostGeneration(Project var1, AntProjectHelper var2, FileObject var3, File var4, ArrayList<String> var5) throws IOException;
    }
}

