/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.jam;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JAMServlet
extends HttpServlet {
    private static final long serialVersionUID = 5518842704648404246L;

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return NbBundle.getMessage(JAMServlet.class, (String)"LAB_ServletInfo");
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.handleRepositoryRequest(httpServletRequest, httpServletResponse);
    }

    protected boolean handleRepositoryRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            return false;
        }
        if ("status".equals(string)) {
            return false;
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = URLDecoder.decode(string);
        }
        File file = new File(string);
        if (!file.isFile()) {
            return false;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project instanceof J2MEProject) {
            return this.sendFile(httpServletResponse, file);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendFile(HttpServletResponse httpServletResponse, File file) throws IOException {
        String string = "content/unknown";
        if (file.getName().endsWith(".jad")) {
            string = "text/vnd.sun.j2me.app-descriptor";
        } else if (file.getName().endsWith(".jar")) {
            string = "application/java-archive";
        } else {
            return false;
        }
        httpServletResponse.setContentType(string);
        int n = (int)file.length();
        httpServletResponse.setContentLength(n);
        httpServletResponse.setDateHeader("Last-Modified", file.lastModified());
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                JAMServlet.copyStream(fileInputStream, (OutputStream)servletOutputStream);
            }
            finally {
                servletOutputStream.close();
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            byte[] byArray = new byte[8000];
            int n = 8000;
            while ((n = inputStream.read(byArray, 0, 8000)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            outputStream.flush();
        }
    }
}

