/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanelGUI;
import org.openide.WizardDescriptor;
import org.openide.loaders.TemplateWizard;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformSelectionPanel
implements WizardDescriptor.FinishablePanel {
    public static final String REQUIRED_CONFIGURATION = "RequiredConfiguration";
    public static final String REQUIRED_PROFILE = "RequiredProfile";
    public static final String PLATFORM_DESCRIPTION = "PlatformDescription";
    private PlatformSelectionPanelGUI gui;
    private String reqCfg;
    private String reqProf;
    private boolean first = true;

    public boolean isFinishPanel() {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public synchronized Component getComponent() {
        if (this.gui == null) {
            this.gui = new PlatformSelectionPanelGUI();
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(PlatformSelectionPanel.class);
    }

    public boolean isValid() {
        return true;
    }

    public void readSettings(Object object) {
        if (this.first) {
            Profile profile;
            this.first = false;
            this.getComponent();
            TemplateWizard templateWizard = (TemplateWizard)object;
            this.reqCfg = (String)templateWizard.getProperty(REQUIRED_CONFIGURATION);
            this.reqProf = (String)templateWizard.getProperty(REQUIRED_PROFILE);
            ArrayList<Profile> arrayList = new ArrayList<Profile>();
            Profile profile2 = PlatformSelectionPanel.parseProfile(this.reqCfg);
            if (profile2 != null) {
                arrayList.add(profile2);
            }
            if ((profile = PlatformSelectionPanel.parseProfile(this.reqProf)) != null) {
                arrayList.add(profile);
            }
            J2MEPlatform j2MEPlatform = PlatformSelectionPanel.findTheBestPlatform(arrayList.toArray(new Profile[arrayList.size()]));
            assert (j2MEPlatform != null);
            this.gui.setValues(templateWizard, j2MEPlatform, this.findDevice(j2MEPlatform, arrayList), this.reqCfg, this.reqProf);
        } else {
            this.gui.updateErrorMessage();
        }
    }

    private static Profile parseProfile(String string) {
        if (string != null) {
            try {
                int n = string.lastIndexOf(45);
                return n > 0 ? new Profile(string.substring(0, n).trim(), new SpecificationVersion(string.substring(n + 1).trim())) : new Profile(string.trim(), null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean compareProfiles(Profile profile, Profile profile2) {
        if (!profile.getName().equalsIgnoreCase(profile2.getName())) {
            return false;
        }
        return profile2.getVersion() == null || profile.getVersion() != null && profile.getVersion().compareTo((Object)profile2.getVersion()) >= 0;
    }

    private static int ratePlatform(J2MEPlatform j2MEPlatform, Profile[] profileArray) {
        int n = 0;
        if (j2MEPlatform.getName().startsWith("J2ME_Wireless_Toolkit")) {
            ++n;
        }
        if (j2MEPlatform.getName().startsWith("J2ME_Wireless_Toolkit_2")) {
            ++n;
        }
        if (profileArray == null) {
            return n;
        }
        Profile[] profileArray2 = j2MEPlatform.getSpecification().getProfiles();
        for (int i = 0; i < profileArray.length; ++i) {
            for (int j = 0; j < profileArray2.length; ++j) {
                if (!PlatformSelectionPanel.compareProfiles(profileArray2[j], profileArray[i])) continue;
                n += 3;
                j = profileArray2.length;
            }
        }
        return n;
    }

    private static J2MEPlatform findTheBestPlatform(Profile[] profileArray) {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null, null));
        J2MEPlatform j2MEPlatform = null;
        int n = -1;
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            int n2;
            if (!(javaPlatformArray[i] instanceof J2MEPlatform) || (n2 = PlatformSelectionPanel.ratePlatform((J2MEPlatform)javaPlatformArray[i], profileArray)) <= n) continue;
            n = n2;
            j2MEPlatform = (J2MEPlatform)javaPlatformArray[i];
        }
        return j2MEPlatform;
    }

    private J2MEPlatform.Device findDevice(J2MEPlatform j2MEPlatform, ArrayList<Profile> arrayList) {
        J2MEPlatform.Device[] deviceArray = j2MEPlatform.getDevices();
        for (int i = 0; i < deviceArray.length; ++i) {
            if (!new HashSet<J2MEPlatform.J2MEProfile>(Arrays.asList(deviceArray[i].getProfiles())).containsAll(arrayList)) continue;
            return deviceArray[i];
        }
        return null;
    }

    public void storeSettings(Object object) {
        PlatformDescription platformDescription = new PlatformDescription();
        this.getComponent();
        J2MEPlatform j2MEPlatform = this.gui.getPlatform();
        J2MEPlatform.Device device = this.gui.getDevice();
        J2MEPlatform.J2MEProfile j2MEProfile = this.gui.getConfiguration();
        J2MEPlatform.J2MEProfile j2MEProfile2 = this.gui.getProfile();
        platformDescription.platform = j2MEPlatform;
        if (j2MEProfile != null) {
            platformDescription.configuration = j2MEProfile.toString();
        }
        if (j2MEProfile2 != null) {
            platformDescription.profile = j2MEProfile2.toString();
        }
        platformDescription.device = device;
        TemplateWizard templateWizard = (TemplateWizard)object;
        templateWizard.putProperty(PLATFORM_DESCRIPTION, (Object)platformDescription);
    }

    public static class PlatformDescription {
        public J2MEPlatform platform;
        public J2MEPlatform.Device device;
        public String configuration;
        public String profile;
    }
}

