/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.html.lexer;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTMLLexer
implements Lexer<HTMLTokenId> {
    private static final Logger LOGGER = Logger.getLogger(HTMLLexer.class.getName());
    private static final boolean LOG = Boolean.getBoolean("j2ee_lexer_debug");
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<HTMLTokenId> tokenFactory;
    private static final String SCRIPT = "script";
    private static final String STYLE = "style";
    private int lexerSubState = 0;
    private int lexerState = 0;
    private String attributeName;
    private int lexerEmbeddingState = 0;
    private static final int ISI_SCRIPT = 1;
    private static final int ISI_STYLE = 2;
    private static final int INIT = 0;
    private static final int ISI_TEXT = 1;
    private static final int ISI_ERROR = 2;
    private static final int ISA_LT = 3;
    private static final int ISA_SLASH = 4;
    private static final int ISI_ENDTAG = 5;
    private static final int ISP_ENDTAG_X = 6;
    private static final int ISP_ENDTAG_WS = 7;
    private static final int ISI_TAG = 8;
    private static final int ISP_TAG_X = 9;
    private static final int ISP_TAG_WS = 10;
    private static final int ISI_ARG = 11;
    private static final int ISP_ARG_X = 12;
    private static final int ISP_ARG_WS = 13;
    private static final int ISP_EQ = 14;
    private static final int ISP_EQ_WS = 15;
    private static final int ISI_VAL = 16;
    private static final int ISI_VAL_QUOT = 17;
    private static final int ISI_VAL_DQUOT = 18;
    private static final int ISA_SGML_ESCAPE = 19;
    private static final int ISA_SGML_DASH = 20;
    private static final int ISI_HTML_COMMENT = 21;
    private static final int ISA_HTML_COMMENT_DASH = 22;
    private static final int ISI_HTML_COMMENT_WS = 23;
    private static final int ISI_SGML_DECL = 24;
    private static final int ISA_SGML_DECL_DASH = 25;
    private static final int ISI_SGML_COMMENT = 26;
    private static final int ISA_SGML_COMMENT_DASH = 27;
    private static final int ISA_REF = 28;
    private static final int ISI_REF_NAME = 29;
    private static final int ISA_REF_HASH = 30;
    private static final int ISI_REF_DEC = 31;
    private static final int ISA_REF_X = 32;
    private static final int ISI_REF_HEX = 33;
    private static final int ISI_TAG_SLASH = 34;
    private static final int ISI_SCRIPT_CONTENT = 35;
    private static final int ISI_SCRIPT_CONTENT_AFTER_LT = 36;
    private static final int ISI_SCRIPT_CONTENT_ENDTAG = 37;
    private static final int ISI_STYLE_CONTENT = 38;
    private static final int ISI_STYLE_CONTENT_AFTER_LT = 39;
    private static final int ISI_STYLE_CONTENT_ENDTAG = 40;
    private static final int ISI_SGML_DECL_WS = 41;
    static final Set<String> EVENT_HANDLER_NAMES = new HashSet<String>();

    public Object state() {
        if (this.attributeName != null) {
            return new CompoundState(this.lexerState, this.lexerSubState, this.lexerEmbeddingState, this.attributeName);
        }
        return this.lexerSubState * 1000000 + this.lexerState * 1000 + this.lexerEmbeddingState;
    }

    public HTMLLexer(LexerRestartInfo<HTMLTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        if (lexerRestartInfo.state() == null) {
            this.lexerSubState = 0;
            this.lexerState = 0;
            this.lexerEmbeddingState = 0;
        } else {
            Object object = lexerRestartInfo.state();
            if (object instanceof CompoundState) {
                CompoundState compoundState = (CompoundState)object;
                this.lexerState = compoundState.lexerState;
                this.lexerSubState = compoundState.lexerSubState;
                this.lexerEmbeddingState = compoundState.lexerEmbeddingState;
                this.attributeName = compoundState.attributeName;
            } else {
                int n = (Integer)lexerRestartInfo.state();
                this.lexerSubState = n / 1000000;
                int n2 = n % 1000000;
                this.lexerState = n2 / 1000;
                this.lexerEmbeddingState = n2 % 1000;
            }
        }
    }

    private final boolean isAZ(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    private final boolean isName(int n) {
        return Character.isLetterOrDigit(n) || n == 45 || n == 95 || n == 46 || n == 58;
    }

    private final boolean isWS(int n) {
        return Character.isWhitespace(n);
    }

    private boolean isJavascriptEventHandlerName(CharSequence charSequence) {
        if (charSequence.length() > 2) {
            char c = charSequence.charAt(0);
            char c2 = charSequence.charAt(1);
            if (!(c != 'o' && c != 'O' || c2 != 'n' && c2 != 'N')) {
                return EVENT_HANDLER_NAMES.contains(((Object)charSequence).toString().toLowerCase(Locale.ENGLISH));
            }
        }
        return false;
    }

    private boolean followsCloseTag(CharSequence charSequence) {
        int n;
        int n2 = this.input.readLength();
        int n3 = 0;
        do {
            n = this.input.read();
            ++n3;
        } while ((Character.isLetter(n) || Character.isDigit(n) || n == 95 || n == 45 || n == 58 || n == 46 || n == 47) && n != -1);
        CharSequence charSequence2 = this.input.readText().subSequence(n2, n2 + n3 - 1);
        this.input.backup(n3);
        return this.equals(charSequence, charSequence2, true, true) && n == 62;
    }

    public Token<HTMLTokenId> nextToken() {
        while (true) {
            int n;
            if ((n = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                break;
            }
            block0 : switch (this.lexerState) {
                case 0: {
                    switch (n) {
                        case 60: {
                            this.lexerState = 3;
                            break block0;
                        }
                        case 38: {
                            this.lexerState = 28;
                            this.lexerSubState = 1;
                            break block0;
                        }
                    }
                    this.lexerState = 1;
                    break;
                }
                case 1: {
                    switch (n) {
                        case 38: 
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            if (this.input.readLength() <= 0) break;
                            return this.token(HTMLTokenId.TEXT);
                        }
                    }
                    break;
                }
                case 2: {
                    this.lexerState = 0;
                    return this.token(HTMLTokenId.ERROR);
                }
                case 3: {
                    if (this.isAZ(n)) {
                        this.lexerState = 8;
                        if (this.input.readLength() <= 1) break;
                        this.input.backup(1);
                        return this.token(HTMLTokenId.TAG_OPEN_SYMBOL);
                    }
                    switch (n) {
                        case 47: {
                            this.lexerState = 4;
                            return this.token(HTMLTokenId.TAG_OPEN_SYMBOL);
                        }
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                        case 33: {
                            this.lexerState = 19;
                            break block0;
                        }
                    }
                    this.input.backup(1);
                    this.lexerState = 1;
                    break;
                }
                case 4: {
                    if (this.isAZ(n)) {
                        this.lexerState = 5;
                        break;
                    }
                    switch (n) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    break;
                }
                case 5: {
                    if (this.isName(n)) break;
                    this.lexerState = 6;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.TAG_CLOSE);
                }
                case 6: {
                    if (this.isWS(n)) {
                        this.lexerState = 7;
                        break;
                    }
                    switch (n) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            break block0;
                        }
                    }
                    this.lexerState = 2;
                    this.input.backup(1);
                    break;
                }
                case 7: {
                    if (this.isWS(n)) break;
                    this.lexerState = 6;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 8: {
                    if (this.isName(n)) break;
                    this.lexerState = 9;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    if (this.equals(SCRIPT, this.input.readText(), true, true)) {
                        this.lexerEmbeddingState = 1;
                    }
                    if (this.equals(STYLE, this.input.readText(), true, true)) {
                        this.lexerEmbeddingState = 2;
                    }
                    return this.token(HTMLTokenId.TAG_OPEN);
                }
                case 9: {
                    if (this.isWS(n)) {
                        this.lexerState = 10;
                        break;
                    }
                    if (this.isAZ(n)) {
                        this.lexerState = 11;
                        break;
                    }
                    switch (n) {
                        case 47: {
                            this.lexerState = 34;
                            break block0;
                        }
                        case 62: {
                            switch (this.lexerEmbeddingState) {
                                case 0: {
                                    this.lexerState = 0;
                                    break;
                                }
                                case 1: {
                                    this.lexerState = 35;
                                    break;
                                }
                                case 2: {
                                    this.lexerState = 38;
                                }
                            }
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            break block0;
                        }
                    }
                    this.lexerState = 2;
                    this.input.backup(1);
                    break;
                }
                case 10: {
                    if (this.isWS(n)) break;
                    this.lexerState = 9;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(HTMLTokenId.WS);
                    }
                }
                case 34: {
                    switch (n) {
                        case 62: {
                            this.lexerEmbeddingState = 0;
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.TAG_CLOSE_SYMBOL);
                        }
                    }
                    this.lexerState = 2;
                    this.input.backup(1);
                    break;
                }
                case 35: {
                    switch (n) {
                        case 60: {
                            this.lexerState = 36;
                            break block0;
                        }
                    }
                    break;
                }
                case 36: {
                    if (n == 47 && this.followsCloseTag(SCRIPT)) {
                        this.lexerEmbeddingState = 0;
                        this.lexerState = 0;
                        this.input.backup(this.input.readLength() > 2 ? 2 : this.input.readLength());
                        if (this.input.readLength() <= 0) break;
                        return this.token(HTMLTokenId.SCRIPT);
                    }
                    this.lexerState = 35;
                    break;
                }
                case 38: {
                    switch (n) {
                        case 60: {
                            this.lexerState = 39;
                            break block0;
                        }
                    }
                    break;
                }
                case 39: {
                    if (n == 47 && this.followsCloseTag(STYLE)) {
                        this.lexerEmbeddingState = 0;
                        this.lexerState = 0;
                        this.input.backup(this.input.readLength() > 2 ? 2 : this.input.readLength());
                        if (this.input.readLength() <= 0) break;
                        return this.token(HTMLTokenId.STYLE);
                    }
                    this.lexerState = 38;
                    break;
                }
                case 11: {
                    if (this.isName(n)) break;
                    this.lexerState = 12;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    this.attributeName = this.isJavascriptEventHandlerName(this.input.readText()) ? ((Object)this.input.readText()).toString() : null;
                    return this.token(HTMLTokenId.ARGUMENT);
                }
                case 12: {
                    if (this.isWS(n)) {
                        this.lexerState = 13;
                        break;
                    }
                    if (this.isAZ(n)) {
                        this.lexerState = 11;
                        break;
                    }
                    switch (n) {
                        case 47: 
                        case 62: {
                            this.input.backup(1);
                            this.lexerState = 9;
                            break block0;
                        }
                        case 60: {
                            this.lexerState = 0;
                            this.input.backup(1);
                            break block0;
                        }
                        case 61: {
                            this.lexerState = 14;
                            return this.token(HTMLTokenId.OPERATOR);
                        }
                    }
                    this.lexerState = 2;
                    this.input.backup(1);
                    break;
                }
                case 13: {
                    if (this.isWS(n)) break;
                    this.lexerState = 12;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 14: {
                    if (this.isWS(n)) {
                        this.lexerState = 15;
                        break;
                    }
                    switch (n) {
                        case 39: {
                            this.lexerState = 17;
                            break block0;
                        }
                        case 34: {
                            this.lexerState = 18;
                            break block0;
                        }
                        case 47: 
                        case 62: {
                            this.input.backup(1);
                            this.lexerState = 9;
                            break block0;
                        }
                    }
                    this.lexerState = 16;
                    break;
                }
                case 15: {
                    if (this.isWS(n)) break;
                    this.lexerState = 14;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 16: {
                    if (!this.isWS(n) && n != 47 && n != 62 && n != 60) break;
                    this.lexerState = 9;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    if (this.attributeName != null) {
                        this.attributeName = null;
                        return this.token(HTMLTokenId.VALUE_JAVASCRIPT);
                    }
                    this.attributeName = null;
                    return this.token(HTMLTokenId.VALUE);
                }
                case 17: {
                    switch (n) {
                        case 39: {
                            this.lexerState = 9;
                            if (this.attributeName != null) {
                                this.attributeName = null;
                                return this.token(HTMLTokenId.VALUE_JAVASCRIPT);
                            }
                            this.attributeName = null;
                            return this.token(HTMLTokenId.VALUE);
                        }
                    }
                    break;
                }
                case 18: {
                    switch (n) {
                        case 34: {
                            this.lexerState = 9;
                            if (this.attributeName != null) {
                                this.attributeName = null;
                                return this.token(HTMLTokenId.VALUE_JAVASCRIPT);
                            }
                            this.attributeName = null;
                            return this.token(HTMLTokenId.VALUE);
                        }
                    }
                    break;
                }
                case 19: {
                    if (this.isAZ(n)) {
                        this.lexerState = 24;
                        break;
                    }
                    switch (n) {
                        case 45: {
                            this.lexerState = 20;
                            break block0;
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    break;
                }
                case 20: {
                    switch (n) {
                        case 45: {
                            this.lexerState = 21;
                            break block0;
                        }
                    }
                    this.lexerState = 1;
                    this.input.backup(1);
                    break;
                }
                case 21: {
                    switch (n) {
                        case 45: {
                            this.lexerState = 22;
                            break block0;
                        }
                        case 10: {
                            return this.token(HTMLTokenId.BLOCK_COMMENT);
                        }
                    }
                    break;
                }
                case 22: {
                    switch (n) {
                        case 45: {
                            this.lexerState = 23;
                            break block0;
                        }
                    }
                    this.lexerState = 21;
                    break;
                }
                case 23: {
                    switch (n) {
                        case 62: {
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.BLOCK_COMMENT);
                        }
                    }
                    this.lexerState = 21;
                    this.input.backup(2);
                    break;
                }
                case 24: {
                    if (Character.isWhitespace(n)) {
                        this.lexerState = 41;
                        if (this.input.readLength() <= 1) break;
                        this.input.backup(1);
                        return this.token(HTMLTokenId.DECLARATION);
                    }
                    switch (n) {
                        case 62: {
                            if (this.input.readLength() > 1) {
                                this.input.backup(1);
                                return this.token(HTMLTokenId.DECLARATION);
                            }
                            this.lexerState = 0;
                            return this.token(HTMLTokenId.DECLARATION);
                        }
                    }
                    break;
                }
                case 41: {
                    if (n == 45) {
                        if (this.input.readLength() == 1) {
                            this.lexerState = 25;
                            break;
                        }
                        if (this.input.readLength() <= 1) break;
                        this.input.backup(1);
                        return this.token(HTMLTokenId.DECLARATION);
                    }
                    if (Character.isWhitespace(n)) break;
                    this.lexerState = 24;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.WS);
                }
                case 25: {
                    if (n == 45) {
                        this.lexerState = 26;
                        break;
                    }
                    this.lexerState = 24;
                    this.input.backup(1);
                    break;
                }
                case 26: {
                    switch (n) {
                        case 45: {
                            this.lexerState = 27;
                        }
                    }
                    break;
                }
                case 27: {
                    if (n == 45) {
                        this.lexerState = 24;
                        return this.token(HTMLTokenId.SGML_COMMENT);
                    }
                    this.lexerState = 26;
                    this.input.backup(1);
                    break;
                }
                case 28: {
                    if (this.isAZ(n)) {
                        this.lexerState = 29;
                        break;
                    }
                    if (n == 35) {
                        this.lexerState = 30;
                        break;
                    }
                    this.lexerState = this.lexerSubState;
                    this.input.backup(1);
                    break;
                }
                case 29: {
                    if (this.isName(n)) break;
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    if (n != 59) {
                        this.input.backup(1);
                    }
                    return this.token(HTMLTokenId.CHARACTER);
                }
                case 30: {
                    if (n >= 48 && n <= 57) {
                        this.lexerState = 31;
                        break;
                    }
                    if (n == 120 || n == 88) {
                        this.lexerState = 32;
                        break;
                    }
                    if (this.isAZ(n)) {
                        this.lexerState = this.lexerSubState;
                        return this.token(HTMLTokenId.ERROR);
                    }
                    this.lexerState = this.lexerSubState;
                    this.input.backup(1);
                    break;
                }
                case 31: {
                    if (n >= 48 && n <= 57) break;
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    if (n != 59) {
                        this.input.backup(1);
                    }
                    return this.token(HTMLTokenId.CHARACTER);
                }
                case 32: {
                    if (n >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70) {
                        this.lexerState = 33;
                        break;
                    }
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    this.input.backup(1);
                    return this.token(HTMLTokenId.ERROR);
                }
                case 33: {
                    if (n >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70) break;
                    this.lexerState = this.lexerSubState;
                    if (this.input.readLength() <= 1) break;
                    if (n != 59) {
                        this.input.backup(1);
                    }
                    return this.token(HTMLTokenId.CHARACTER);
                }
            }
        }
        this.input.backup(1);
        switch (this.lexerState) {
            case 0: {
                if (this.input.readLength() != 0) break;
                return null;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: 
            case 20: 
            case 34: {
                return this.token(HTMLTokenId.TEXT);
            }
            case 28: 
            case 30: {
                if (this.lexerSubState == 1) {
                    return this.token(HTMLTokenId.TEXT);
                }
                return this.token(HTMLTokenId.VALUE);
            }
            case 21: 
            case 22: 
            case 23: {
                return this.token(HTMLTokenId.BLOCK_COMMENT);
            }
            case 8: {
                this.lexerState = 9;
                if (this.equals(SCRIPT, this.input.readText(), true, true)) {
                    this.lexerEmbeddingState = 1;
                }
                if (this.equals(STYLE, this.input.readText(), true, true)) {
                    this.lexerEmbeddingState = 2;
                }
                return this.token(HTMLTokenId.TAG_OPEN);
            }
            case 5: {
                return this.token(HTMLTokenId.TAG_CLOSE);
            }
            case 11: {
                return this.token(HTMLTokenId.ARGUMENT);
            }
            case 2: {
                return this.token(HTMLTokenId.ERROR);
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                return this.token(HTMLTokenId.WS);
            }
            case 6: 
            case 9: 
            case 12: 
            case 14: {
                return this.token(HTMLTokenId.WS);
            }
            case 16: 
            case 17: 
            case 18: {
                if (this.attributeName != null) {
                    return this.token(HTMLTokenId.VALUE_JAVASCRIPT);
                }
                return this.token(HTMLTokenId.VALUE);
            }
            case 24: 
            case 25: 
            case 41: {
                return this.token(HTMLTokenId.DECLARATION);
            }
            case 26: 
            case 27: {
                return this.token(HTMLTokenId.SGML_COMMENT);
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                return this.token(HTMLTokenId.CHARACTER);
            }
            case 35: 
            case 36: 
            case 37: {
                return this.token(HTMLTokenId.SCRIPT);
            }
            case 38: 
            case 39: 
            case 40: {
                return this.token(HTMLTokenId.STYLE);
            }
        }
        assert (this.input.readLength() == 0) : "Returning null even if some chars still needs to be tokenized! lexer state=" + this.lexerState + "; " + "lexer substate=" + this.lexerSubState + "; " + "lexer embedding state=" + this.lexerEmbeddingState + "; " + "readtext='" + this.input.readText() + "'";
        return null;
    }

    private Token<HTMLTokenId> token(HTMLTokenId hTMLTokenId) {
        if (LOG) {
            if (this.input.readLength() == 0) {
                LOGGER.log(Level.INFO, "Found zero length token: ");
            }
            LOGGER.log(Level.INFO, "[" + this.getClass().getSimpleName() + "] token ('" + ((Object)this.input.readText()).toString() + "'; id=" + (Object)((Object)hTMLTokenId) + "; state=" + this.state() + ")\n");
        }
        return this.tokenFactory.createToken((TokenId)hTMLTokenId);
    }

    public void release() {
    }

    private boolean equals(CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2) {
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            char c;
            char c2 = bl && !bl2 ? Character.toLowerCase(charSequence.charAt(i)) : charSequence.charAt(i);
            char c3 = c = bl ? Character.toLowerCase(charSequence2.charAt(i)) : charSequence2.charAt(i);
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    static {
        EVENT_HANDLER_NAMES.add("onload");
        EVENT_HANDLER_NAMES.add("onunload");
        EVENT_HANDLER_NAMES.add("onclick");
        EVENT_HANDLER_NAMES.add("ondblclick");
        EVENT_HANDLER_NAMES.add("onmousedown");
        EVENT_HANDLER_NAMES.add("onmouseup");
        EVENT_HANDLER_NAMES.add("onmouseover");
        EVENT_HANDLER_NAMES.add("onmousemove");
        EVENT_HANDLER_NAMES.add("onmouseout");
        EVENT_HANDLER_NAMES.add("onfocus");
        EVENT_HANDLER_NAMES.add("onblur");
        EVENT_HANDLER_NAMES.add("onkeypress");
        EVENT_HANDLER_NAMES.add("onkeydown");
        EVENT_HANDLER_NAMES.add("onkeyup");
        EVENT_HANDLER_NAMES.add("onsubmit");
        EVENT_HANDLER_NAMES.add("onreset");
        EVENT_HANDLER_NAMES.add("onselect");
        EVENT_HANDLER_NAMES.add("onchange");
    }

    class CompoundState {
        private int lexerState;
        private int lexerSubState;
        private int lexerEmbeddingState;
        private String attributeName;

        public CompoundState(int n, int n2, int n3, String string) {
            this.lexerState = n;
            this.lexerSubState = n2;
            this.lexerEmbeddingState = n3;
            this.attributeName = string;
        }

        public String toString() {
            int n = this.lexerSubState * 1000000 + this.lexerState * 1000 + this.lexerEmbeddingState;
            return Integer.toString(n) + "," + this.attributeName.toString();
        }
    }
}

