/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.CalendarMonthBase;
import com.sun.rave.web.ui.component.DateManager;
import com.sun.rave.web.ui.component.DropDown;
import com.sun.rave.web.ui.component.IconHyperlink;
import com.sun.rave.web.ui.component.NextMonthListener;
import com.sun.rave.web.ui.component.PreviousMonthListener;
import com.sun.rave.web.ui.model.Option;
import com.sun.rave.web.ui.model.ScheduledEvent;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.IntegerConverter;

public class CalendarMonth
extends CalendarMonthBase
implements NamingContainer {
    public static final String MONTH_MENU_ID = "monthMenu";
    public static final String YEAR_MENU_ID = "yearMenu";
    public static final String PREVIOUS_MONTH_LINK_ID = "previousMonthLink";
    public static final String NEXT_MONTH_LINK_ID = "nextMonthLink";
    public static final String DATE_LINK_ID = "dateLink";
    public static final String DATE_FIELD_ID = "dateField";
    public static final String DATE_FORMAT_ATTR = "dateFormatAttr";
    public static final String DATE_FORMAT_PATTERN_ATTR = "dateFormatPatternAttr";
    private static final String TIME_ZONE_ATTR = "timeZoneAttr";
    protected Calendar calendar = null;
    private static final boolean DEBUG = false;
    private String javaScriptObjectName = null;

    public boolean isDateSelected(Calendar current, Calendar endDate) {
        Object value = this.getValue();
        if (value == null) {
            return false;
        }
        if (value instanceof Date) {
            Calendar calendar = this.getCalendar();
            calendar.setTime((Date)value);
            return this.compareDate(calendar, current);
        }
        if (value instanceof ScheduledEvent) {
            Iterator dates = ((ScheduledEvent)value).getDates(endDate);
            Calendar calendar = null;
            while (dates.hasNext()) {
                calendar = (Calendar)dates.next();
                if (!this.compareDate(calendar, current)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean compareDate(Calendar selected, Calendar current) {
        return selected.get(1) == current.get(1) && selected.get(2) == current.get(2) && selected.get(5) == current.get(5);
    }

    protected Locale getLocale() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            this.initializeCalendar();
        }
        return (Calendar)this.calendar.clone();
    }

    private void initializeCalendar() {
        UIComponent parent = this.getParent();
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        if (parent instanceof DateManager) {
            TimeZone tz = ((DateManager)parent).getTimeZone();
            if (tz == null) {
                this.calendar = Calendar.getInstance(locale);
                this.getAttributes().put(TIME_ZONE_ATTR, this.calendar.getTimeZone());
            } else {
                this.calendar = Calendar.getInstance(tz, locale);
                this.getAttributes().put(TIME_ZONE_ATTR, tz);
            }
        } else {
            this.calendar = Calendar.getInstance(locale);
        }
    }

    public DateFormat getDateFormat() {
        Object o = this.getAttributes().get(DATE_FORMAT_ATTR);
        DateFormat dateFormat = null;
        if (o != null && o instanceof DateFormat) {
            dateFormat = (DateFormat)o;
        } else {
            dateFormat = SimpleDateFormat.getDateInstance(3, this.getLocale());
            dateFormat.setCalendar(this.getCalendar());
            String pattern = null;
            UIComponent parent = this.getParent();
            if (parent != null && parent instanceof DateManager) {
                pattern = ((DateManager)parent).getDateFormatPattern();
            }
            if (pattern != null) {
                ((SimpleDateFormat)dateFormat).applyPattern(pattern);
                this.getAttributes().put(DATE_FORMAT_PATTERN_ATTR, pattern);
            } else {
                String defaultPattern = ((SimpleDateFormat)dateFormat).toPattern();
                if (defaultPattern.indexOf("yyyy") == -1) {
                    defaultPattern = defaultPattern.replaceFirst("yy", "yyyy");
                }
                if (defaultPattern.indexOf("MM") == -1) {
                    defaultPattern = defaultPattern.replaceFirst("M", "MM");
                }
                if (defaultPattern.indexOf("dd") == -1) {
                    defaultPattern = defaultPattern.replaceFirst("d", "dd");
                }
                ((SimpleDateFormat)dateFormat).applyPattern(defaultPattern);
                this.getAttributes().put(DATE_FORMAT_PATTERN_ATTR, defaultPattern);
            }
            this.getAttributes().put(DATE_FORMAT_ATTR, dateFormat);
        }
        return dateFormat;
    }

    public TimeZone getTimeZone() {
        Object o = this.getAttributes().get(TIME_ZONE_ATTR);
        if (o != null && o instanceof TimeZone) {
            return (TimeZone)o;
        }
        this.initializeCalendar();
        o = this.getAttributes().get(TIME_ZONE_ATTR);
        if (o != null && o instanceof TimeZone) {
            return (TimeZone)o;
        }
        return TimeZone.getDefault();
    }

    public DropDown getMonthMenu() {
        UIComponent comp = this.getFacet(MONTH_MENU_ID);
        DropDown monthMenu = null;
        if (comp == null || !(comp instanceof DropDown)) {
            monthMenu = new DropDown();
            monthMenu.setSubmitForm(true);
            monthMenu.setConverter((Converter)new IntegerConverter());
            monthMenu.setId(MONTH_MENU_ID);
            if (!this.isPopup()) {
                monthMenu.setImmediate(true);
            }
            this.getFacets().put(MONTH_MENU_ID, monthMenu);
        } else {
            monthMenu = (DropDown)comp;
        }
        return monthMenu;
    }

    public DropDown getYearMenu() {
        DropDown yearMenu = (DropDown)this.getFacets().get(YEAR_MENU_ID);
        if (yearMenu == null) {
            yearMenu = new DropDown();
            yearMenu.setSubmitForm(true);
            yearMenu.setId(YEAR_MENU_ID);
            yearMenu.setConverter((Converter)new IntegerConverter());
            if (!this.isPopup()) {
                yearMenu.setImmediate(true);
            }
            this.getFacets().put(YEAR_MENU_ID, yearMenu);
        }
        return yearMenu;
    }

    public IconHyperlink getPreviousMonthLink() {
        IconHyperlink link = (IconHyperlink)this.getFacets().get(PREVIOUS_MONTH_LINK_ID);
        if (link == null) {
            link = new IconHyperlink();
            link.setId(PREVIOUS_MONTH_LINK_ID);
            link.setIcon("SCHEDULER_BACKWARD");
            link.setBorder(0);
            if (!this.isPopup()) {
                link.setImmediate(true);
                link.addActionListener(new PreviousMonthListener());
            }
            this.getFacets().put(PREVIOUS_MONTH_LINK_ID, link);
        }
        return link;
    }

    public IconHyperlink getNextMonthLink() {
        IconHyperlink link = (IconHyperlink)this.getFacets().get(NEXT_MONTH_LINK_ID);
        if (link == null) {
            link = new IconHyperlink();
            link.setId(NEXT_MONTH_LINK_ID);
            link.setIcon("SCHEDULER_FORWARD");
            link.setBorder(0);
            if (!this.isPopup()) {
                link.addActionListener(new NextMonthListener());
                link.setImmediate(true);
            }
            this.getFacets().put(NEXT_MONTH_LINK_ID, link);
        }
        return link;
    }

    protected Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public void initCalendarControls(String jsName) {
        StringBuffer js = new StringBuffer("javascript: ").append(jsName).append(".decreaseMonth(); return false;");
        IconHyperlink link = this.getPreviousMonthLink();
        link.setIcon("CALENDAR_BACKWARD");
        link.setOnClick(js.toString());
        js = new StringBuffer("javascript: ").append(jsName).append(".increaseMonth(); return false;");
        link = this.getNextMonthLink();
        link.setIcon("CALENDAR_FORWARD");
        link.setOnClick(js.toString());
        this.getMonthMenu().setOnChange(jsName.concat(".redrawCalendar(false); return false;"));
        this.getYearMenu().setOnChange(jsName.concat(".redrawCalendar(false); return false;"));
    }

    public void showNextMonth() {
        Integer month = this.getCurrentMonth();
        DropDown monthMenu = this.getMonthMenu();
        if (month < 12) {
            int newMonth = month + 1;
            monthMenu.setSubmittedValue(new String[]{String.valueOf(newMonth)});
        } else if (this.showNextYear()) {
            monthMenu.setSubmittedValue(new String[]{"1"});
        }
    }

    public void showPreviousMonth() {
        Integer month = this.getCurrentMonth();
        DropDown monthMenu = this.getMonthMenu();
        if (month > 1) {
            int newMonth = month - 1;
            monthMenu.setSubmittedValue(new String[]{String.valueOf(newMonth)});
        } else if (this.showPreviousYear()) {
            monthMenu.setSubmittedValue(new String[]{"12"});
        }
    }

    private boolean showNextYear() {
        DropDown yearMenu = this.getYearMenu();
        int year = this.getCurrentYear();
        Option[] options = yearMenu.getOptions();
        Integer lastYear = (Integer)options[options.length - 1].getValue();
        if (lastYear >= ++year) {
            yearMenu.setSubmittedValue(new String[]{String.valueOf(year)});
            return true;
        }
        return false;
    }

    private boolean showPreviousYear() {
        DropDown yearMenu = this.getYearMenu();
        int year = this.getCurrentYear();
        Option[] options = yearMenu.getOptions();
        Integer firstYear = (Integer)options[0].getValue();
        if (firstYear <= --year) {
            yearMenu.setSubmittedValue(new String[]{String.valueOf(year)});
            return true;
        }
        return false;
    }

    public Integer getCurrentMonth() {
        DropDown monthMenu = this.getMonthMenu();
        Object value = monthMenu.getSubmittedValue();
        Integer month = null;
        if (value != null) {
            try {
                String[] vals = (String[])value;
                month = Integer.decode(vals[0]);
            }
            catch (Exception ex) {}
        } else {
            value = monthMenu.getValue();
            if (value != null && value instanceof Integer) {
                month = (Integer)value;
            }
        }
        return month;
    }

    public Integer getCurrentYear() {
        DropDown yearMenu = this.getYearMenu();
        Object value = yearMenu.getSubmittedValue();
        Integer year = null;
        if (value != null) {
            try {
                String[] vals = (String[])value;
                year = Integer.decode(vals[0]);
            }
            catch (NumberFormatException ex) {}
        } else {
            value = yearMenu.getValue();
            if (value != null && value instanceof Integer) {
                year = (Integer)value;
            }
        }
        return year;
    }

    public String getJavaScriptObjectName() {
        return this.javaScriptObjectName;
    }

    public void setJavaScriptObjectName(String javaScriptObjectName) {
        this.javaScriptObjectName = javaScriptObjectName;
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }

    public String getDateFormatPattern() {
        Object o = this.getAttributes().get(DATE_FORMAT_PATTERN_ATTR);
        String pattern = null;
        if (o == null || !(o instanceof String)) {
            this.getDateFormat();
            pattern = (String)this.getAttributes().get(DATE_FORMAT_PATTERN_ATTR);
        } else {
            pattern = (String)o;
        }
        return pattern;
    }

    public void displayValue() {
        DropDown monthMenu = this.getMonthMenu();
        DropDown yearMenu = this.getYearMenu();
        Object value = this.getValue();
        if (value == null) {
            monthMenu.setValue(null);
            yearMenu.setValue(null);
        } else if (value instanceof Date) {
            Calendar calendar = this.getCalendar();
            calendar.setTime((Date)value);
            int newMonth = calendar.get(2) + 1;
            monthMenu.setValue(new Integer(newMonth));
            int newYear = calendar.get(1);
            yearMenu.setValue(new Integer(newYear));
        } else if (value instanceof ScheduledEvent) {
            Date date = ((ScheduledEvent)value).getStartTime();
            if (date != null) {
                Calendar calendar = this.getCalendar();
                calendar.setTime(date);
                int newMonth = calendar.get(2) + 1;
                monthMenu.setValue(new Integer(newMonth));
                int newYear = calendar.get(1);
                yearMenu.setValue(new Integer(newYear));
            } else {
                monthMenu.setValue(null);
                yearMenu.setValue(null);
            }
        }
        monthMenu.setSubmittedValue(null);
        yearMenu.setSubmittedValue(null);
    }
}

