/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.ImageComponent;
import com.sun.rave.web.ui.component.Label;
import com.sun.rave.web.ui.component.RbCbSelectorBase;
import com.sun.rave.web.ui.util.ConversionUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public class RbCbSelector
extends RbCbSelectorBase {
    public static final String IMAGE_FACET = "image";
    private static final String IMAGE_URL_PROP = "imageURL";
    private static final String URL_PROP = "url";
    private static final String ALT_PROP = "alt";
    public static final String LABEL_FACET = "label";
    private static final String LABEL_PROP = "label";
    private static final String TEXT_PROP = "text";
    private static final String LABEL_LEVEL_PROP = "labelLevel";
    private static final String TOOLTIP_PROP = "toolTip";
    private static final String VISIBLE_PROP = "visible";
    private static final String RENDERED_PROP = "rendered";
    private static final String ID_SEPARATOR = "_";
    private static final Boolean trueSelectedValue = Boolean.TRUE;

    protected void addToRequestMap(FacesContext context, String groupName) {
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String groupName = this.getName();
        if (groupName == null || !this.isValid() || !this.isChecked()) {
            return;
        }
        this.addToRequestMap(context, groupName);
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            return renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
        }
        return this.getConvertedValue(context, this, submittedValue);
    }

    public Object getConvertedValue(FacesContext context, RbCbSelector component, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            throw new ConverterException("The submitted value is null. The submitted value must be a String or String array.");
        }
        boolean isStringArray = submittedValue instanceof String[];
        boolean isString = submittedValue instanceof String;
        if (!isStringArray && !isString) {
            throw new ConverterException("The submitted value must be a String or String array.");
        }
        String rawValue = null;
        if (isStringArray) {
            if (((String[])submittedValue).length > 0) {
                rawValue = ((String[])submittedValue)[0];
            }
        } else if (isString) {
            rawValue = (String)submittedValue;
        }
        boolean unselected = rawValue == null || rawValue.length() == 0;
        Object newValue = null;
        Object selectedValue = this.getSelectedValue();
        if (unselected) {
            newValue = ConversionUtilities.convertRenderedValue(context, rawValue, (UIComponent)this);
            if (!ConversionUtilities.renderedNull((UIComponent)component) && selectedValue instanceof Boolean && newValue == null) {
                newValue = (Boolean)selectedValue != false ? Boolean.FALSE : Boolean.TRUE;
            }
            return this.getUnselectedValue(context, (UIComponent)component, newValue);
        }
        newValue = ConversionUtilities.convertValueToObject((UIComponent)component, rawValue, context);
        return newValue == rawValue ? selectedValue : newValue;
    }

    private Object getUnselectedValue(FacesContext context, UIComponent component, Object noValue) {
        ValueBinding valueBinding = component.getValueBinding("value");
        if (valueBinding == null) {
            return noValue;
        }
        Class clazz = valueBinding.getType(context);
        if (clazz == null) {
            return noValue;
        }
        if (clazz.isPrimitive()) {
            return this.getPrimitiveUnselectedValue(clazz, noValue);
        }
        return noValue;
    }

    private Object getPrimitiveUnselectedValue(Class clazz, Object booleanUnselectedValue) {
        if (clazz.equals(Boolean.TYPE)) {
            return booleanUnselectedValue;
        }
        if (clazz.equals(Byte.TYPE)) {
            return new Integer(-128);
        }
        if (clazz.equals(Double.TYPE)) {
            return new Double(Double.MIN_VALUE);
        }
        if (clazz.equals(Float.TYPE)) {
            return new Float(Float.MIN_VALUE);
        }
        if (clazz.equals(Integer.TYPE)) {
            return new Integer(Integer.MIN_VALUE);
        }
        if (clazz.equals(Character.TYPE)) {
            return new Character('\u0000');
        }
        if (clazz.equals(Short.TYPE)) {
            return new Short(Short.MIN_VALUE);
        }
        return new Long(Long.MIN_VALUE);
    }

    public Object getSelectedValue() {
        Object sv = super.getSelectedValue();
        return sv == null ? trueSelectedValue : sv;
    }

    public boolean isChecked() {
        Object selectedValue = this.getSelectedValue();
        Object selected = this.getSelected();
        if (selectedValue == null || selected == null) {
            return false;
        }
        if (this.getValueBinding("selected") == null && selected instanceof String && selectedValue instanceof Boolean) {
            return selectedValue.equals(Boolean.valueOf((String)selected));
        }
        return selected.equals(selectedValue);
    }

    public UIComponent getLabelComponent() {
        UIComponent labelComponent = this.getFacet("label");
        if (labelComponent != null) {
            return labelComponent;
        }
        return this.getLabel() != null ? this.createLabelComponent() : null;
    }

    public UIComponent getImageComponent() {
        UIComponent imageComponent = this.getFacet(IMAGE_FACET);
        if (imageComponent != null) {
            return imageComponent;
        }
        return this.getImageURL() != null ? this.createImageComponent() : null;
    }

    protected UIComponent createLabelComponent() {
        Label label = new Label();
        label.setId(this.getId() + ID_SEPARATOR + "label");
        label.setParent((UIComponent)this);
        if (label != null) {
            label.setLabeledComponent((UIComponent)this);
            if (!this.passValueBinding((UIComponent)label, "label", TEXT_PROP)) {
                label.setText(this.getLabel());
            }
            if (!this.passValueBinding((UIComponent)label, LABEL_LEVEL_PROP, LABEL_LEVEL_PROP)) {
                label.setLabelLevel(this.getLabelLevel());
            }
            if (!this.passValueBinding((UIComponent)label, TOOLTIP_PROP, TOOLTIP_PROP)) {
                label.setToolTip(this.getToolTip());
            }
        }
        return label;
    }

    protected UIComponent createImageComponent() {
        ImageComponent image = new ImageComponent();
        image.setId(this.getId() + ID_SEPARATOR + IMAGE_FACET);
        image.setParent((UIComponent)this);
        if (image != null) {
            if (!this.passValueBinding((UIComponent)image, IMAGE_URL_PROP, URL_PROP)) {
                image.setUrl(this.getImageURL());
            }
            if (!this.passValueBinding((UIComponent)image, TOOLTIP_PROP, TOOLTIP_PROP)) {
                image.setToolTip(this.getToolTip());
            }
            if (!this.passValueBinding((UIComponent)image, TOOLTIP_PROP, ALT_PROP)) {
                image.setAlt(this.getToolTip());
            }
        }
        return image;
    }

    private boolean passValueBinding(UIComponent component, String fromAttr, String toAttr) {
        ValueBinding vb = this.getValueBinding(fromAttr);
        if (vb != null) {
            component.setValueBinding(toAttr, vb);
        }
        return vb != null;
    }
}

