/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import [Ljava.lang.Object;;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataFilter;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.TableDataSorter;
import com.sun.data.provider.impl.BasicTableDataFilter;
import com.sun.data.provider.impl.BasicTableDataSorter;
import com.sun.data.provider.impl.ObjectArrayDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import com.sun.rave.web.ui.component.HiddenField;
import com.sun.rave.web.ui.component.SavedState;
import com.sun.rave.web.ui.component.StaticText;
import com.sun.rave.web.ui.component.Table;
import com.sun.rave.web.ui.component.TableColumn;
import com.sun.rave.web.ui.component.TableFooter;
import com.sun.rave.web.ui.component.TableHeader;
import com.sun.rave.web.ui.component.TableRowGroupBase;
import com.sun.rave.web.ui.component.WrapperEvent;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ConversionUtilities;
import com.sun.rave.web.ui.util.LogUtil;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class TableRowGroup
extends TableRowGroupBase
implements NamingContainer {
    public static final String COLUMN_FOOTER_BAR_ID = "_columnFooterBar";
    public static final String COLUMN_HEADER_BAR_ID = "_columnHeaderBar";
    public static final String EMPTY_DATA_COLUMN_ID = "_emptyDataColumn";
    public static final String EMPTY_DATA_COLUMN_FACET = "emptyDataColumn";
    public static final String EMPTY_DATA_TEXT_ID = "_emptyDataText";
    public static final String EMPTY_DATA_TEXT_FACET = "emptyDataText";
    public static final String FOOTER_FACET = "footer";
    public static final String GROUP_FOOTER_BAR_ID = "_groupFooterBar";
    public static final String GROUP_FOOTER_ID = "_groupFooter";
    public static final String GROUP_FOOTER_FACET = "groupFooter";
    public static final String GROUP_HEADER_BAR_ID = "_groupHeaderBar";
    public static final String GROUP_HEADER_ID = "_groupHeader";
    public static final String GROUP_HEADER_FACET = "groupHeader";
    public static final String HEADER_FACET = "header";
    public static final String TABLE_COLUMN_FOOTER_BAR_ID = "_tableColumnFooterBar";
    private static final String REQUEST_KEY_PREFIX = "com.sun.rave.web.ui_";
    private static final String PROPERTIES = "_properties";
    private Map saved = new HashMap();
    private transient TableDataFilter filter = null;
    private transient TableDataSorter sorter = null;
    private boolean paginated = false;
    private boolean paginated_set = false;
    private TableRowDataProvider provider = null;
    private Table table = null;

    public Table getTableAncestor() {
        if (this.table == null) {
            TableRowGroup component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.table = (Table)((Object)component);
                break;
            }
        }
        return this.table;
    }

    public Iterator getTableColumnChildren() {
        ArrayList<UIComponent> tableColumnChildren;
        Properties properties = this.getProperties();
        ArrayList<UIComponent> arrayList = tableColumnChildren = properties != null ? properties.getTableColumnChildren() : null;
        if (tableColumnChildren == null) {
            tableColumnChildren = new ArrayList<UIComponent>();
            Iterator kids = this.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (!(kid instanceof TableColumn)) continue;
                tableColumnChildren.add(kid);
            }
            if (properties != null) {
                properties.setTableColumnChildren(tableColumnChildren);
            }
        }
        return tableColumnChildren.iterator();
    }

    public int getColumnCount() {
        int columnCount;
        Properties properties = this.getProperties();
        int n = columnCount = properties != null ? properties.getColumnCount() : -1;
        if (columnCount == -1) {
            columnCount = 0;
            Iterator kids = this.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                columnCount += col.getColumnCount();
            }
            if (properties != null) {
                properties.setColumnCount(columnCount);
            }
        }
        return columnCount;
    }

    public UIComponent getEmptyDataColumn() {
        UIComponent facet = this.getFacet(EMPTY_DATA_COLUMN_FACET);
        if (facet != null) {
            return facet;
        }
        TableColumn child = new TableColumn();
        child.setId(EMPTY_DATA_COLUMN_ID);
        child.setColSpan(this.getColumnCount());
        child.getChildren().add(this.getEmptyDataText());
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getEmptyDataText() {
        RowKey[] rowKeys;
        UIComponent facet = this.getFacet(EMPTY_DATA_TEXT_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        String msg = null;
        msg = this.getEmptyDataMsg() != null ? this.getEmptyDataMsg() : ((rowKeys = this.getRowKeys()) != null && rowKeys.length > 0 ? theme.getMessage("table.filteredData") : theme.getMessage("table.emptyData"));
        StaticText child = new StaticText();
        child.setId(EMPTY_DATA_TEXT_ID);
        child.setStyleClass(theme.getStyleClass("TblMsgTxt"));
        child.setText(msg);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupFooter() {
        UIComponent facet = this.getFacet(GROUP_FOOTER_FACET);
        if (facet != null) {
            return facet;
        }
        TableFooter child = new TableFooter();
        child.setId(GROUP_FOOTER_ID);
        child.setColSpan(this.getColumnCount());
        child.setExtraHtml(this.getExtraFooterHtml());
        child.setGroupFooter(true);
        facet = this.getFacet(FOOTER_FACET);
        if (!(facet != null && facet.isRendered() || this.getFooterText() != null)) {
            child.setRendered(false);
        } else {
            this.log("getGroupFooter", "Group footer not rendered, nothing to display");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupHeader() {
        UIComponent facet = this.getFacet(GROUP_HEADER_FACET);
        if (facet != null) {
            return facet;
        }
        TableHeader child = new TableHeader();
        child.setId(GROUP_HEADER_ID);
        child.setScope("colgroup");
        child.setColSpan(this.getColumnCount());
        child.setExtraHtml(this.getExtraHeaderHtml());
        child.setGroupHeader(true);
        boolean emptyTable = this.getRowCount() == 0;
        boolean renderControls = !emptyTable && (this.isSelectMultipleToggleButton() || this.isGroupToggleButton());
        facet = this.getFacet(HEADER_FACET);
        if (!(facet != null && facet.isRendered() || this.getHeaderText() != null || renderControls)) {
            child.setRendered(false);
        } else {
            this.log("getGroupHeader", "Group header not rendered, nothing to display");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public void clearFilter() {
        this.getTableDataFilter().setFilterCriteria(null);
        this.setFirst(0);
        Properties properties = this.getProperties();
        if (properties != null) {
            properties.setFilteredRowKeys(null);
            properties.setSortedRowKeys(null);
        } else {
            this.log("clearFilter", "Cannot clear filtered and sorted row keys, Properties is null");
        }
    }

    public RowKey[] getFilteredRowKeys() {
        RowKey[] filteredRowKeys;
        Properties properties = this.getProperties();
        RowKey[] rowKeyArray = filteredRowKeys = properties != null ? properties.getFilteredRowKeys() : null;
        if (filteredRowKeys != null) {
            return filteredRowKeys;
        }
        filteredRowKeys = this.getRowKeys();
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider == null) {
            this.log("getFilteredRowKeys", "Cannot obtain filtered row keys, TableDataProvider is null");
            return filteredRowKeys;
        }
        TableDataFilter filter = this.getTableDataFilter();
        if (provider != filter) {
            filteredRowKeys = filter.filter(provider, filteredRowKeys);
        } else {
            this.log("getFilteredRowKeys", "Row keys already filtered, TableDataFilter and TableDataProvider are the same instance");
        }
        if (properties != null) {
            properties.setFilteredRowKeys(filteredRowKeys);
        } else {
            this.log("getFilteredRowKeys", "Cannot save filtered row keys, Properties is null");
        }
        return filteredRowKeys;
    }

    public TableDataFilter getTableDataFilter() {
        TableDataFilter tdf = super.getTableDataFilter();
        if (tdf != null) {
            return tdf;
        }
        if (this.filter == null) {
            this.filter = new BasicTableDataFilter();
        }
        return this.filter;
    }

    public void setFilterCriteria(FilterCriteria[] filterCriteria) {
        this.clearFilter();
        this.getTableDataFilter().setFilterCriteria(filterCriteria);
    }

    public void setTableDataFilter(TableDataFilter filter) {
        this.filter = filter;
    }

    public int getFirst() {
        int last = this.getLast();
        int first = this.isPaginated() ? Math.max(0, super.getFirst()) : 0;
        return first < last ? first : last;
    }

    public void setFirst(int first) {
        if (first < 0) {
            this.log("setFirst", "First row cannot be < 0");
            throw new IllegalArgumentException(Integer.toString(first));
        }
        super.setFirst(first);
    }

    public int getLast() {
        return Math.max(0, this.getPages() - 1) * this.getRows();
    }

    public int getPage() {
        if (!this.isPaginated()) {
            return 1;
        }
        return this.getFirst() / this.getRows() + 1;
    }

    public int getPages() {
        if (!this.isPaginated()) {
            return 1;
        }
        int rowCount = this.getRowCount();
        int rows = this.getRows();
        int modulus = rows > 0 ? rowCount % rows : 0;
        int result = rows > 0 ? rowCount / rows : 1;
        return modulus > 0 ? ++result : result;
    }

    public boolean isPaginated() {
        if (!this.paginated_set) {
            Table table = this.getTableAncestor();
            if (table != null) {
                this.setPaginated(table.isPaginationControls());
            } else {
                this.log("isPaginated", "Cannot initialize paginated state, Table is null");
            }
        }
        return this.paginated;
    }

    public void setPage(int page) {
        int row = (page - 1) * this.getRows();
        int result = Math.min(row, this.getLast());
        this.setFirst(Math.min(Math.max(result, 0), this.getRowCount()));
    }

    public void setPaginated(boolean paginated) {
        this.paginated = paginated;
        this.paginated_set = true;
    }

    public int getRows() {
        return this.isPaginated() ? Math.max(1, super.getRows()) : 0;
    }

    public void setRows(int rows) {
        if (rows < 0) {
            this.log("setRows", "Paginated rows cannot be < 0");
            throw new IllegalArgumentException(Integer.toString(rows));
        }
        super.setRows(rows);
    }

    public boolean isRowAvailable() {
        boolean result = false;
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider != null) {
            result = provider.isRowAvailable(this.getRowKey());
        } else {
            this.log("isRowAvailable", "Cannot determine if row is available, TableDataProvider is null");
        }
        return result;
    }

    public RowKey[] getHiddenRowKeys() {
        if (!this.isPaginated()) {
            return null;
        }
        RowKey[] rowKeys = this.getSortedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        int first = this.getFirst();
        int rows = this.getRows();
        for (int i = 0; i < rowKeys.length; ++i) {
            if (i >= first && i < first + rows) continue;
            list.add(rowKeys[i]);
        }
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public FieldKey getFieldKey(String fieldId) {
        return this.getTableRowDataProvider().getFieldKey(fieldId);
    }

    public int getRowCount() {
        RowKey[] rowKeys = this.getFilteredRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey getRowKey() {
        return this.getTableRowDataProvider().getTableRow();
    }

    public RowKey[] getRowKeys() {
        RowKey[] rowKeys = null;
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider == null) {
            this.log("getRowKeys", "Cannot obtain row keys, TableDataProvider is null");
            return rowKeys;
        }
        if (Beans.isDesignTime()) {
            this.log("getRowKeys", "Creating dummy data for design-time behavior");
            rowKeys = provider.getRowKeys(provider.getRowCount(), null);
            if (this.getRows() == 0 || rowKeys == null || rowKeys.length == 0) {
                this.log("getRowKeys", "Cannot create dummy data, DataProvider has no rows");
                return rowKeys;
            }
            ArrayList<RowKey> list = new ArrayList<RowKey>();
            for (int i = 0; i < this.getRows() + 1; ++i) {
                list.add(rowKeys[i % rowKeys.length]);
            }
            rowKeys = new RowKey[list.size()];
            return list.toArray(rowKeys);
        }
        int rowCount = provider.getRowCount();
        if (rowCount == -1) {
            this.log("getRowKeys", "Manually calculating row count, DataProvider.getRowCount() is -1");
            int index = 0;
            while ((rowKeys = provider.getRowKeys(rowCount = 1000000 * ++index, null)) != null && rowKeys.length - 1 == rowCount) {
            }
        } else {
            rowKeys = provider.getRowKeys(rowCount, null);
        }
        return rowKeys;
    }

    protected TableRowDataProvider getTableRowDataProvider() {
        TableRowDataProvider provider;
        Properties properties = this.getProperties();
        TableRowDataProvider tableRowDataProvider = provider = properties != null ? properties.getTableRowDataProvider() : null;
        if (provider == null) {
            TableDataProvider tdp;
            this.log("getTableRowDataProvider", "Re-evaluating sourceData, TableRowDataProvider is null");
            Object obj = this.getSourceData();
            if (obj == null) {
                tdp = null;
            } else if (obj instanceof TableDataProvider) {
                tdp = (TableDataProvider)obj;
            } else if (obj instanceof List) {
                tdp = new ObjectListDataProvider((List)obj);
            } else if (Object;.class.isAssignableFrom(obj.getClass())) {
                tdp = new ObjectArrayDataProvider((Object[])obj);
            } else {
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(obj);
                tdp = new ObjectListDataProvider(list);
            }
            provider = new TableRowDataProvider(tdp);
            if (properties != null) {
                properties.setTableRowDataProvider(provider);
            } else {
                this.log("getTableRowDataProvider", "Cannot save TableRowDataProvider, Properties is null");
            }
        }
        return provider;
    }

    public Class getType(FieldKey fieldKey) {
        return this.getTableRowDataProvider().getType(fieldKey);
    }

    public RowKey[] getRenderedRowKeys() {
        RowKey[] rowKeys = this.getSortedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        int first = this.getFirst();
        int rows = this.getRows();
        for (int i = first; !(i >= rowKeys.length || this.isPaginated() && i >= first + rows); ++i) {
            list.add(rowKeys[i]);
        }
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public void setRowKey(RowKey rowKey) {
        this.saveDescendantState();
        this.getTableRowDataProvider().setTableRow(rowKey);
        String sourceVar = this.getSourceVar();
        if (sourceVar != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowKey == null) {
                requestMap.remove(sourceVar);
            } else if (this.isRowAvailable()) {
                requestMap.put(sourceVar, this.getTableRowDataProvider());
            } else {
                requestMap.remove(sourceVar);
            }
        } else {
            this.log("setRowKey", "Cannot set row key, sourceVar property is null");
        }
        this.restoreDescendantState();
    }

    public void setSourceData(Object sourceData) {
        super.setSourceData(sourceData);
        this.init();
    }

    public int getHiddenSelectedRowsCount() {
        RowKey[] rowKeys = this.getHiddenSelectedRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey[] getHiddenSelectedRowKeys() {
        RowKey[] rowKeys = this.getHiddenRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKeys[i]);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public int getSelectedRowsCount() {
        RowKey[] rowKeys = this.getSelectedRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey[] getSelectedRowKeys() {
        RowKey[] rowKeys = this.getFilteredRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKeys[i]);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public int getRenderedSelectedRowsCount() {
        RowKey[] rowKeys = this.getRenderedSelectedRowKeys();
        return rowKeys != null ? rowKeys.length : 0;
    }

    public RowKey[] getRenderedSelectedRowKeys() {
        RowKey[] rowKeys = this.getRenderedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKeys[i]);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public void addSort(SortCriteria criteria) {
        if (criteria == null) {
            return;
        }
        TableDataSorter sorter = this.getTableDataSorter();
        SortCriteria[] oldCriteria = sorter.getSortCriteria();
        if (oldCriteria != null) {
            for (int i = 0; i < oldCriteria.length; ++i) {
                String key;
                if (oldCriteria[i] == null || (key = oldCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                oldCriteria[i] = criteria;
                return;
            }
        }
        int oldLength = oldCriteria != null ? oldCriteria.length : 0;
        SortCriteria[] newCriteria = new SortCriteria[oldLength + 1];
        for (int i = 0; i < oldLength; ++i) {
            newCriteria[i] = oldCriteria[i];
        }
        newCriteria[oldLength] = criteria;
        sorter.setSortCriteria(newCriteria);
        this.setFirst(0);
        Properties properties = this.getProperties();
        if (properties != null) {
            properties.setSortedRowKeys(null);
        } else {
            this.log("addSort", "Cannot clear sorted row keys, Properties is null");
        }
    }

    public void clearSort() {
        this.getTableDataSorter().setSortCriteria(null);
        this.setFirst(0);
        Properties properties = this.getProperties();
        if (properties != null) {
            properties.setSortedRowKeys(null);
        } else {
            this.log("clearSort", "Cannot clear sorted row keys, Properties is null");
        }
    }

    public int getSortCount() {
        int result = 0;
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            result = sortCriteria.length;
        }
        return result;
    }

    public int getSortLevel(SortCriteria criteria) {
        int result = -1;
        if (criteria == null) {
            return result;
        }
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            for (int i = 0; i < sortCriteria.length; ++i) {
                String key;
                if (sortCriteria[i] == null || (key = sortCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                result = i + 1;
                break;
            }
        }
        return result;
    }

    public boolean isDescendingSort(SortCriteria criteria) {
        boolean result = false;
        if (criteria == null) {
            return result;
        }
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            for (int i = 0; i < sortCriteria.length; ++i) {
                String key;
                if (sortCriteria[i] == null || (key = sortCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                result = !sortCriteria[i].isAscending();
                break;
            }
        }
        return result;
    }

    public RowKey[] getSortedRowKeys() {
        RowKey[] sortedRowKeys;
        Properties properties = this.getProperties();
        RowKey[] rowKeyArray = sortedRowKeys = properties != null ? properties.getSortedRowKeys() : null;
        if (sortedRowKeys != null) {
            return sortedRowKeys;
        }
        sortedRowKeys = this.getFilteredRowKeys();
        TableDataProvider provider = this.getTableRowDataProvider().getTableDataProvider();
        if (provider == null) {
            this.log("getSortedRowKeys", "Cannot obtain sorted row keys, TableDataProvider is null");
            return sortedRowKeys;
        }
        TableDataSorter sorter = this.getTableDataSorter();
        if (provider != sorter) {
            sortedRowKeys = sorter.sort(provider, sortedRowKeys);
        }
        if (properties != null) {
            properties.setSortedRowKeys(sortedRowKeys);
        } else {
            this.log("getSortedRowKeys", "Cannot save sorted row keys, Properties is null");
        }
        return sortedRowKeys;
    }

    public TableDataSorter getTableDataSorter() {
        TableDataSorter tds = super.getTableDataSorter();
        if (tds != null) {
            return tds;
        }
        if (this.sorter == null) {
            this.sorter = new BasicTableDataSorter();
        }
        return this.sorter;
    }

    public void setTableDataSorter(TableDataSorter sorter) {
        this.sorter = sorter;
    }

    public void setSortCriteria(SortCriteria[] sortCriteria) {
        this.clearSort();
        this.getTableDataSorter().setSortCriteria(sortCriteria);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.saved = (Map)values[1];
        this.setPaginated((Boolean)values[2]);
        TableDataSorter sorter = this.getTableDataSorter();
        sorter.setSortCriteria((SortCriteria[])values[3]);
        TableDataFilter filter = this.getTableDataFilter();
        filter.setFilterCriteria((FilterCriteria[])values[4]);
        Properties properties = this.getProperties();
        if (properties != null) {
            properties.setFilteredRowKeys((RowKey[])values[5]);
            properties.setSortedRowKeys((RowKey[])values[6]);
        } else {
            this.log("restoreState", "Cannot save sorted and filtered row keys, Properties is null");
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[8];
        values[0] = super.saveState(context);
        values[1] = this.saved;
        values[2] = this.isPaginated() ? Boolean.TRUE : Boolean.FALSE;
        values[3] = this.getTableDataSorter().getSortCriteria();
        values[4] = this.getTableDataFilter().getFilterCriteria();
        values[5] = this.getFilteredRowKeys();
        values[6] = this.getSortedRowKeys();
        return values;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if ("sourceData".equals(name)) {
            this.init();
        } else if ("sourceVar".equals(name)) {
            this.log("setValueBinding", "sourceVar cannot equal given name");
            throw new IllegalArgumentException();
        }
        super.setValueBinding(name, binding);
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            this.log("getClientId", "Cannot obtain client Id, FacesContext is null");
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (this.getRowKey() != null) {
            return baseClientId + ':' + this.getRowKey().getRowId();
        }
        return baseClientId;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new WrapperEvent((UIComponent)this, event, this.getRowKey()));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof WrapperEvent)) {
            super.broadcast(event);
            return;
        }
        WrapperEvent revent = (WrapperEvent)event;
        RowKey oldRowKey = this.getRowKey();
        this.setRowKey(revent.getRowKey());
        FacesEvent rowEvent = revent.getFacesEvent();
        rowEvent.getComponent().broadcast(rowEvent);
        this.setRowKey(oldRowKey);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.isNestedWithinTableRowGroup()) {
            this.init();
        }
        if (!this.keepSaved(context)) {
            this.saved = new HashMap();
        }
        super.encodeBegin(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            this.log("processDecodes", "Cannot decode, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processDecodes", "Component not rendered, nothing to decode");
            return;
        }
        if (this.saved == null || !this.keepSaved(context)) {
            this.saved = new HashMap();
        }
        this.iterate(context, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            this.log("processValidators", "Cannot validate, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processValidators", "Component not rendered, nothing to validate");
            return;
        }
        this.iterate(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processUpdates(FacesContext context) {
        UIComponent field;
        if (context == null) {
            this.log("processUpdates", "Cannot update, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processUpdates", "Component not rendered, nothing to update");
            return;
        }
        this.iterate(context, PhaseId.UPDATE_MODEL_VALUES);
        UIComponent header = this.getFacet(GROUP_HEADER_ID);
        UIComponent uIComponent = field = header != null ? (UIComponent)header.getFacets().get("_collapsedHiddenField") : null;
        if (field instanceof HiddenField) {
            Boolean value = field != null ? (Boolean)((HiddenField)field).getValue() : null;
            this.setCollapsed(value);
        } else {
            this.log("processUpdates", "Cannot obtain collapsed hidden field value");
        }
    }

    private Properties getProperties() {
        String propertiesId;
        Properties properties;
        String propertiesMapId;
        Table table = this.getTableAncestor();
        if (table == null) {
            this.log("getProperties", "Cannot obtain Properties, Table is null");
            return null;
        }
        FacesContext context = this.getFacesContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap<String, Properties> propertiesMap = (HashMap<String, Properties>)requestMap.get(propertiesMapId = REQUEST_KEY_PREFIX + table.getClientId(context) + PROPERTIES);
        if (propertiesMap == null) {
            propertiesMap = new HashMap<String, Properties>();
            requestMap.put(propertiesMapId, propertiesMap);
        }
        if ((properties = (Properties)propertiesMap.get(propertiesId = super.getClientId(context))) == null) {
            properties = new Properties();
            propertiesMap.put(propertiesId, properties);
        }
        return properties;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private void init() {
        String propertiesId;
        this.setFirst(0);
        Table table = this.getTableAncestor();
        if (table == null) {
            this.log("init", "Cannot initialize Properties, Table is null");
            return;
        }
        FacesContext context = this.getFacesContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        Map propertiesMap = (Map)requestMap.get(propertiesId = REQUEST_KEY_PREFIX + table.getClientId(context) + PROPERTIES);
        if (propertiesMap != null) {
            propertiesMap.put(super.getClientId(context), null);
        } else {
            this.log("init", "Cannot initialize Properties, request properties map is null");
        }
    }

    private boolean isNestedWithinTableRowGroup() {
        TableRowGroup parent = this;
        while (null != (parent = parent.getParent())) {
            if (!(parent instanceof TableRowGroup)) continue;
            return true;
        }
        return false;
    }

    private void iterate(FacesContext context, PhaseId phaseId) {
        if (this.isNestedWithinTableRowGroup()) {
            this.init();
        }
        this.setRowKey(null);
        Iterator facets = this.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            UIComponent facet = (UIComponent)this.getFacets().get(facets.next());
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                facet.processDecodes(context);
                continue;
            }
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                facet.processValidators(context);
                continue;
            }
            if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                facet.processUpdates(context);
                continue;
            }
            this.log("iterate", "Cannot process component facets, Invalid phase ID");
            throw new IllegalArgumentException();
        }
        this.setRowKey(null);
        Iterator kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = (TableColumn)((Object)kids.next());
            if (!kid.isRendered()) {
                this.log("iterate", "Cannot process TableColumn facets, TableColumn not rendered");
                continue;
            }
            this.iterateTableColumnFacets(context, kid, phaseId);
        }
        RowKey[] rowKeys = this.getRenderedRowKeys();
        if (rowKeys == null) {
            this.log("iterate", "Cannot iterate over TableColumn children, RowKey array is null");
            return;
        }
        for (int i = 0; i < rowKeys.length; ++i) {
            this.setRowKey(rowKeys[i]);
            if (!this.isRowAvailable()) {
                this.log("iterate", "Cannot iterate over TableColumn children, row not available");
                break;
            }
            kids = this.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn kid = (TableColumn)((Object)kids.next());
                if (!kid.isRendered()) {
                    this.log("iterate", "Cannot process TableColumn, not rendered");
                    continue;
                }
                Iterator grandkids = kid.getChildren().iterator();
                while (grandkids.hasNext()) {
                    UIComponent grandkid = (UIComponent)grandkids.next();
                    if (!grandkid.isRendered()) {
                        this.log("iterate", "Cannot process TableColumn child, not rendered");
                        continue;
                    }
                    this.iterateTableColumnChildren(context, grandkid, phaseId);
                }
            }
        }
        this.setRowKey(null);
    }

    private void iterateTableColumnFacets(FacesContext context, TableColumn component, PhaseId phaseId) {
        if (component == null) {
            this.log("iterateTableColumnFacets", "Cannot iterate over TableColumn facets, TableColumn is null");
            return;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                this.iterateTableColumnFacets(context, col, phaseId);
            }
        } else {
            Iterator facets = component.getFacets().keySet().iterator();
            while (facets.hasNext()) {
                UIComponent facet = (UIComponent)component.getFacets().get(facets.next());
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    facet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    facet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    facet.processUpdates(context);
                    continue;
                }
                this.log("iterateTableColumnFacets", "Cannot iterate over TableColumn facets, Invalid phase ID");
                throw new IllegalArgumentException();
            }
        }
    }

    private void iterateTableColumnChildren(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (component == null) {
            this.log("iterateTableColumnChildren", "Cannot iterate over TableColumn children, UIComponent is null");
            return;
        }
        if (component instanceof TableColumn) {
            Iterator kids = component.getChildren().iterator();
            if (kids.hasNext()) {
                while (kids.hasNext()) {
                    UIComponent kid = (UIComponent)kids.next();
                    this.iterateTableColumnChildren(context, kid, phaseId);
                }
            }
        } else if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            component.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            component.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            component.processUpdates(context);
        } else {
            this.log("iterateTableColumnChildren", "Cannot iterate over TableColumn children, Invalid phase ID");
            throw new IllegalArgumentException();
        }
    }

    private boolean keepSaved(FacesContext context) {
        Iterator clientIds = this.saved.keySet().iterator();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            SavedState state = (SavedState)this.saved.get(clientId);
            if (state == null || state.getSubmittedValue() == null) continue;
            return true;
        }
        Iterator messages = context.getMessages();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (message.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
            return true;
        }
        return this.isNestedWithinTableRowGroup();
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = (TableColumn)((Object)kids.next());
            if (!kid.isRendered()) continue;
            this.restoreDescendantState((UIComponent)kid, context);
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
            ConversionUtilities.restoreRenderedValueState(context, component);
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.restoreDescendantState((UIComponent)kids.next(), context);
        }
    }

    private void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = (TableColumn)((Object)kids.next());
            if (!kid.isRendered()) {
                this.log("saveDescendantState", "Cannot save descendant state, TableColumn not rendered");
                continue;
            }
            this.saveDescendantState((UIComponent)kid, context);
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
                this.saved.put(clientId, state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
            ConversionUtilities.saveRenderedValueState(context, component);
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.saveDescendantState((UIComponent)kids.next(), context);
        }
    }

    private class Properties {
        private TableRowDataProvider provider = null;
        private RowKey[] filteredRowKeys = null;
        private RowKey[] sortedRowKeys = null;
        private List tableColumnChildren = null;
        private int columnCount = -1;

        public int getColumnCount() {
            return this.columnCount;
        }

        public void setColumnCount(int columnCount) {
            this.columnCount = columnCount;
        }

        public RowKey[] getFilteredRowKeys() {
            return this.filteredRowKeys;
        }

        public void setFilteredRowKeys(RowKey[] filteredRowKeys) {
            this.filteredRowKeys = filteredRowKeys;
        }

        public RowKey[] getSortedRowKeys() {
            return this.sortedRowKeys;
        }

        public void setSortedRowKeys(RowKey[] sortedRowKeys) {
            this.sortedRowKeys = sortedRowKeys;
        }

        public List getTableColumnChildren() {
            return this.tableColumnChildren;
        }

        public void setTableColumnChildren(List tableColumnChildren) {
            this.tableColumnChildren = tableColumnChildren;
        }

        public TableRowDataProvider getTableRowDataProvider() {
            return this.provider;
        }

        public void setTableRowDataProvider(TableRowDataProvider provider) {
            this.provider = provider;
        }
    }
}

