/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component.util.event;

import com.sun.rave.web.ui.component.util.event.OutputType;
import com.sun.rave.web.ui.component.util.event.RequestAttributeOutputType;
import com.sun.rave.web.ui.component.util.event.SessionAttributeOutputType;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;

public class OutputTypeManager {
    private static Map _outputTypes = new HashMap(8);
    private static Map _instances = new HashMap(2);
    private static OutputTypeManager _defaultInstance = new OutputTypeManager();
    public static final String OUTPUT_TYPE_MANAGER_KEY = "outputTypeManagerImpl";
    public static final String REQUEST_ATTRIBUTE_TYPE = "attribute";
    public static final String SESSION_ATTRIBUTE_TYPE = "session";

    protected OutputTypeManager() {
    }

    public static OutputTypeManager getInstance() {
        return _defaultInstance;
    }

    public static OutputTypeManager getManager(FacesContext context) {
        if (context == null) {
            return _defaultInstance;
        }
        String className = null;
        Map initParams = context.getExternalContext().getInitParameterMap();
        if (initParams.containsKey(OUTPUT_TYPE_MANAGER_KEY)) {
            className = (String)initParams.get(OUTPUT_TYPE_MANAGER_KEY);
        }
        return OutputTypeManager.getManager(className);
    }

    public static OutputTypeManager getManager(String className) {
        if (className == null) {
            return _defaultInstance;
        }
        OutputTypeManager ldm = (OutputTypeManager)_instances.get(className);
        if (ldm == null) {
            try {
                ldm = (OutputTypeManager)Class.forName(className).getMethod("getInstance", null).invoke(null, null);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            catch (NullPointerException ex) {
                throw new RuntimeException(ex);
            }
            catch (ClassCastException ex) {
                throw new RuntimeException(ex);
            }
            _instances.put(className, ldm);
        }
        return ldm;
    }

    public OutputType getOutputType(String name) {
        return (OutputType)_outputTypes.get(name);
    }

    public void setOutputType(String name, OutputType outputType) {
        _outputTypes.put(name, outputType);
    }

    static {
        _outputTypes.put(REQUEST_ATTRIBUTE_TYPE, new RequestAttributeOutputType());
        _outputTypes.put(SESSION_ATTRIBUTE_TYPE, new SessionAttributeOutputType());
    }
}

