/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Alert;
import com.sun.rave.web.ui.component.Hyperlink;
import com.sun.rave.web.ui.component.IconHyperlink;
import com.sun.rave.web.ui.component.util.Util;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class AlertRenderer
extends AbstractRenderer {
    public static final String ALERT_TYPE_ERROR = "error";
    public static final String ALERT_TYPE_WARN = "warning";
    public static final String ALERT_TYPE_INFO = "information";
    public static final String ALERT_TYPE_SUCCESS = "success";
    public static final String ALERT_TYPE_DEFAULT = "error";
    private static final String ICON_HYPERLINK_FACTORY = "com.sun.rave.web.ui.component.util.factories.IconHyperlinkFactory";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderOuterDiv(FacesContext context, Alert alert, ResponseWriter writer) throws IOException {
        String styleClass = alert.getStyleClass();
        String style = alert.getStyle();
        String id = alert.getClientId(context);
        writer.startElement("div", (UIComponent)alert);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)alert, styleClass);
    }

    protected void renderOpeningTable(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("table", (UIComponent)alert);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
        String tableStyle = theme.getStyleClass("AlrtTbl");
        writer.writeAttribute("class", (Object)tableStyle, null);
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)alert);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)alert);
        writer.writeAttribute("valign", (Object)"middle", null);
        writer.writeText((Object)"\n", null);
    }

    protected void renderAlertIcon(FacesContext context, Alert alert, String type, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent alertIcon = alert.getAlertIcon();
        RenderingUtilities.renderComponent(alertIcon, context);
    }

    protected void renderAlertSummaryText(Alert alert, ResponseWriter writer) throws IOException {
        String summary = alert.getSummary();
        writer.writeText((Object)summary, null);
    }

    protected void renderAlertDetailArea(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        String detail = alert.getDetail();
        List children = alert.getChildren();
        if ((detail == null || detail.trim().length() == 0) && children.size() <= 0) {
            return;
        }
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)theme.getStyleClass("AlrtMsgTxt"), null);
        if (detail != null) {
            writer.writeText((Object)detail, null);
        }
        super.encodeChildren(context, (UIComponent)alert);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderAlertLink(FacesContext context, Alert alert, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent link = alert.getAlertLink();
        if (link == null) {
            return;
        }
        if (Hyperlink.class.isAssignableFrom(link.getClass()) && ((Hyperlink)link).getText() == null && ((Hyperlink)link).getUrl() == null) {
            return;
        }
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)theme.getStyleClass("AlrtLnkDiv"), null);
        RenderingUtilities.renderComponent(link, context);
        writer.endElement("div");
    }

    protected void renderClosingTags(ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Alert alert = (Alert)component;
        String summary = alert.getSummary();
        if (summary == null || summary.trim().length() == 0) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderOuterDiv(context, alert, writer);
        this.renderOpeningTable(context, alert, theme, writer);
        String type = alert.getType();
        if (type == null) {
            type = "error";
        }
        type = type.toLowerCase();
        String textStyle = this.getAlertTextStyle(type, theme);
        writer.startElement("div", (UIComponent)alert);
        writer.writeAttribute("class", (Object)textStyle, null);
        this.renderAlertIcon(context, alert, type, theme, writer);
        this.renderAlertSummaryText(alert, writer);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        this.renderAlertDetailArea(context, alert, theme, writer);
        this.renderAlertLink(context, alert, theme, writer);
        this.renderClosingTags(writer);
    }

    private IconHyperlink getAlertLink(Alert alert, String text, String url, Theme theme) {
        Properties props = new Properties();
        props.setProperty("styleClass", theme.getStyleClass("AlrtLnk"));
        props.setProperty("text", text);
        props.setProperty("textPosition", "right");
        props.setProperty("icon", "HREF_LINK");
        props.put("border", new Integer(0));
        props.setProperty("alt", "");
        props.setProperty("url", url);
        String prop = alert.getLinkTarget();
        if (prop != null && prop.length() > 0) {
            props.setProperty("target", prop);
        }
        if ((prop = alert.getLinkToolTip()) != null && prop.length() > 0) {
            props.setProperty("toolTip", prop);
        }
        IconHyperlink link = (IconHyperlink)Util.getChild((UIComponent)alert, alert.getId() + "_alertLink", ICON_HYPERLINK_FACTORY, props);
        return link;
    }

    private String getAlertTextStyle(String type, Theme theme) {
        String style = type.equals(ALERT_TYPE_INFO) ? theme.getStyleClass("AlrtInfTxt") : (type.equals(ALERT_TYPE_SUCCESS) ? theme.getStyleClass("AlrtInfTxt") : (type.equals(ALERT_TYPE_WARN) ? theme.getStyleClass("AlrtWrnTxt") : theme.getStyleClass("AlrtErrTxt")));
        return style;
    }
}

