/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupportRedirector;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintPreferences;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    static final RequestProcessor RP = new RequestProcessor("Document Processing");
    static final RequestProcessor RPPostprocessing = new RequestProcessor("Document Postprocessing");
    public static final String EDITOR_MODE = "editor";
    private static final String PROP_PANE = "CloneableEditorSupport.Pane";
    private static final int DOCUMENT_NO = 0;
    private static final int DOCUMENT_LOADING = 1;
    private static final int DOCUMENT_READY = 2;
    private static final int DOCUMENT_RELOADING = 3;
    private static final ThreadLocal<Boolean> LOCAL_LOAD_TASK = new ThreadLocal();
    private static final Logger ERR = Logger.getLogger("org.openide.text.CloneableEditorSupport");
    private boolean inUserQuestionExceptionHandler;
    private Task prepareTask;
    private EditorKit kit;
    private StrongRef doc;
    private boolean isStrongSet = false;
    private int counterGetDocument = 0;
    private int counterOpenDocument = 0;
    private int counterPrepareDocument = 0;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set lineSet;
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private Set<ChangeListener> listeners;
    private transient Reference<Pane> lastSelected;
    private long lastSaveTime;
    private boolean reloadDialogOpened;
    private PropertyChangeSupport propertyChangeSupport;
    private Lookup lookup;
    private boolean alreadyModified;
    private boolean revertingUndoOrReloading;
    private boolean justRevertedToNotModified;
    private int documentStatus = 0;
    private Throwable prepareDocumentRuntimeException;
    private Map<Line, Reference<Line>> lineSetWHM;
    private boolean annotationsLoaded;
    private static Reference<CloneableTopComponent> lastReusable = new WeakReference<Object>(null);

    public CloneableEditorSupport(Env env) {
        this(env, Lookup.EMPTY);
    }

    public CloneableEditorSupport(Env env, Lookup lookup) {
        super((CloneableOpenSupport.Env)env);
        this.lookup = lookup;
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected String messageHtmlName() {
        return null;
    }

    protected String documentID() {
        return this.messageName();
    }

    protected abstract String messageToolTip();

    protected String messageLine(Line line) {
        return NbBundle.getMessage(Line.class, (String)"FMT_CESLineDisplayName", (Object)this.messageName(), (Object)(line.getLineNumber() + 1));
    }

    final Env cesEnv() {
        return (Env)this.env;
    }

    final EditorKit cesKit() {
        return this.kit;
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getUndoRedo();
        }
        if (this.undoRedo == null) {
            this.undoRedo = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    void ensureAnnotationsLoaded() {
        if (!this.annotationsLoaded) {
            this.annotationsLoaded = true;
            Line.Set set = this.getLineSet();
            for (AnnotationProvider annotationProvider : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
                annotationProvider.annotate(set, this.lookup);
            }
        }
    }

    private void askUserAndDoOpen(UserQuestionException userQuestionException, Callable<Void> callable) {
        while (userQuestionException != null) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
            confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                try {
                    userQuestionException.confirmed();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
            } else {
                return;
            }
            userQuestionException = null;
            try {
                callable.call();
            }
            catch (UserQuestionException userQuestionException2) {
                userQuestionException = userQuestionException2;
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, null, iOException);
            }
            catch (Exception exception) {
                ERR.log(Level.SEVERE, null, exception);
            }
        }
    }

    public void open() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.open();
            return;
        }
        try {
            if (this.getListener().loadExc instanceof UserQuestionException) {
                this.getListener().loadExc = null;
                this.prepareTask = null;
                this.documentStatus = 0;
            }
            this.openDocument();
            super.open();
        }
        catch (UserQuestionException userQuestionException) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Query
            implements Runnable,
            Callable<Void> {
                Query() {
                }

                @Override
                public void run() {
                    CloneableEditorSupport.this.askUserAndDoOpen(userQuestionException, this);
                }

                @Override
                public Void call() throws IOException {
                    CloneableEditorSupport.this.getListener().loadExc = null;
                    CloneableEditorSupport.this.prepareTask = null;
                    CloneableEditorSupport.this.documentStatus = 0;
                    CloneableEditorSupport.this.openDocument();
                    CloneableEditorSupport.super.open();
                    return null;
                }
            }
            Query query = new Query();
            Mutex.EVENT.readAccess((Runnable)query);
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, null, iOException);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.propertyChangeSupport;
    }

    private boolean canReleaseDoc() {
        return this.counterGetDocument == 0 && this.counterOpenDocument == 0 && this.counterPrepareDocument == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task prepareDocument() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.prepareDocument();
        }
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    this.documentStatus = 1;
                    ++this.counterPrepareDocument;
                    Task task = this.prepareDocument(false);
                    if (task != null) {
                        task.addTaskListener(new TaskListener(){

                            public void taskFinished(Task task) {
                                CloneableEditorSupport.this.counterPrepareDocument--;
                                if (CloneableEditorSupport.this.isStrongSet && CloneableEditorSupport.this.canReleaseDoc()) {
                                    CloneableEditorSupport.this.isStrongSet = false;
                                    CloneableEditorSupport.this.doc.setStrong(false);
                                }
                                task.removeTaskListener((TaskListener)this);
                            }
                        });
                    } else {
                        --this.counterPrepareDocument;
                        if (this.isStrongSet && this.canReleaseDoc()) {
                            this.isStrongSet = false;
                            if (this.doc != null) {
                                this.doc.setStrong(false);
                            }
                        }
                    }
                    return task;
                }
            }
            if (this.prepareTask == null) {
                throw new IllegalStateException();
            }
            return this.prepareTask;
        }
    }

    private Task prepareDocument(boolean bl) {
        assert (Thread.holdsLock(this.getLock()));
        if (this.prepareTask != null) {
            return this.prepareTask;
        }
        boolean bl2 = true;
        try {
            this.env.removePropertyChangeListener((PropertyChangeListener)this.getListener());
            this.env.addPropertyChangeListener((PropertyChangeListener)this.getListener());
            this.kit = this.createEditorKit();
            final StyledDocument[] styledDocumentArray = new StyledDocument[]{this.getDoc()};
            if (styledDocumentArray[0] == null) {
                styledDocumentArray[0] = this.createStyledDocument(this.kit);
                this.setDoc(styledDocumentArray[0], true);
                this.isStrongSet = true;
            }
            this.prepareTask = RP.post(new Runnable(){
                private boolean runningInAtomicLock;

                public void run() {
                    this.doRun();
                    styledDocumentArray[0] = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void doRun() {
                    if (!this.runningInAtomicLock) {
                        this.runningInAtomicLock = true;
                        NbDocument.runAtomic(styledDocumentArray[0], this);
                        return;
                    }
                    Object object = CloneableEditorSupport.this.getLock();
                    synchronized (object) {
                        if (CloneableEditorSupport.this.documentStatus == 0) {
                            return;
                        }
                        if (CloneableEditorSupport.this.getDoc() != styledDocumentArray[0]) {
                            return;
                        }
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                        int n = 0;
                        try {
                            CloneableEditorSupport.this.getListener().run();
                            CloneableEditorSupport.this.documentStatus = 2;
                            CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.getDoc(), false);
                            n = 2;
                            CloneableEditorSupport.this.getDoc().addUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                        }
                        catch (DelegateIOExc delegateIOExc) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = delegateIOExc;
                            CloneableEditorSupport.this.prepareTask = null;
                        }
                        catch (RuntimeException runtimeException) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = runtimeException;
                            CloneableEditorSupport.this.prepareTask = null;
                            Exceptions.printStackTrace((Throwable)runtimeException);
                            throw runtimeException;
                        }
                        catch (Error error) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = error;
                            CloneableEditorSupport.this.prepareTask = null;
                            Exceptions.printStackTrace((Throwable)error);
                            throw error;
                        }
                        finally {
                            Object object2 = CloneableEditorSupport.this.getLock();
                            synchronized (object2) {
                                CloneableEditorSupport.this.documentStatus = n;
                                CloneableEditorSupport.this.getLock().notifyAll();
                            }
                        }
                    }
                }
            });
            if (RP.isRequestProcessorThread()) {
                this.prepareTask.waitFinished();
            }
            bl2 = false;
        }
        catch (RuntimeException runtimeException) {
            this.prepareDocumentRuntimeException = runtimeException;
            throw runtimeException;
        }
        catch (Error error) {
            this.prepareDocumentRuntimeException = error;
            throw error;
        }
        finally {
            if (bl2) {
                this.documentStatus = 0;
                this.getLock().notifyAll();
            }
        }
        return this.prepareTask;
    }

    final void addRemoveDocListener(Document document, boolean bl) {
        if (Boolean.TRUE.equals(document.getProperty("supportsModificationListener"))) {
            if (bl) {
                document.putProperty("modificationListener", this.getListener());
            } else {
                document.putProperty("modificationListener", null);
            }
        } else if (bl) {
            document.addDocumentListener(this.getListener());
        } else {
            document.removeDocumentListener(this.getListener());
        }
    }

    private void clearDocument() {
        NbDocument.runAtomic(this.getDoc(), new Runnable(){

            public void run() {
                try {
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), false);
                    CloneableEditorSupport.this.getDoc().remove(0, CloneableEditorSupport.this.getDoc().getLength());
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), true);
                }
                catch (BadLocationException badLocationException) {
                    ERR.log(Level.INFO, null, badLocationException);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument openDocument() throws IOException {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.openDocument();
        }
        Object object = this.getLock();
        synchronized (object) {
            StyledDocument styledDocument;
            block8: {
                try {
                    StyledDocument styledDocument2;
                    ++this.counterOpenDocument;
                    styledDocument = styledDocument2 = this.openDocumentCheckIOE();
                    --this.counterOpenDocument;
                    if (!this.isStrongSet || !this.canReleaseDoc()) break block8;
                    this.isStrongSet = false;
                }
                catch (Throwable throwable) {
                    --this.counterOpenDocument;
                    if (this.isStrongSet && this.canReleaseDoc()) {
                        this.isStrongSet = false;
                        this.doc.setStrong(false);
                    }
                    throw throwable;
                }
                this.doc.setStrong(false);
            }
            return styledDocument;
        }
    }

    private StyledDocument openDocumentCheckIOE() throws IOException {
        StyledDocument styledDocument = this.openDocumentImpl();
        IOException iOException = this.getListener().checkLoadException();
        if (iOException != null) {
            throw iOException;
        }
        return styledDocument;
    }

    private StyledDocument openDocumentImpl() throws IOException, InterruptedIOException {
        switch (this.documentStatus) {
            case 0: {
                this.documentStatus = 1;
                this.prepareDocument(false);
                return this.openDocumentImpl();
            }
            case 2: 
            case 3: {
                StyledDocument styledDocument = this.getDoc();
                assert (styledDocument != null) : "no document although status is " + this.documentStatus + "; doc=" + this.doc;
                return styledDocument;
            }
        }
        try {
            this.getLock().wait();
        }
        catch (InterruptedException interruptedException) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(interruptedException);
        }
        if (this.prepareDocumentRuntimeException != null) {
            if (this.prepareDocumentRuntimeException instanceof DelegateIOExc) {
                throw (IOException)this.prepareDocumentRuntimeException.getCause();
            }
            if (this.prepareDocumentRuntimeException instanceof Error) {
                throw (Error)this.prepareDocumentRuntimeException;
            }
            throw (RuntimeException)this.prepareDocumentRuntimeException;
        }
        return this.openDocumentImpl();
    }

    Throwable getPrepareDocumentRuntimeException() {
        return this.prepareDocumentRuntimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument getDocument() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getDocument();
        }
        Object object = this.getLock();
        synchronized (object) {
            StyledDocument styledDocument;
            block15: {
                switch (this.documentStatus) {
                    case 0: {
                        return null;
                    }
                }
                if (LOCAL_LOAD_TASK.get() != null) {
                    return this.getDoc();
                }
                try {
                    StyledDocument styledDocument2;
                    ++this.counterGetDocument;
                    styledDocument = styledDocument2 = this.openDocumentCheckIOE();
                    --this.counterGetDocument;
                    if (!this.isStrongSet || !this.canReleaseDoc()) break block15;
                    this.isStrongSet = false;
                }
                catch (IOException iOException) {
                    StyledDocument styledDocument3;
                    block16: {
                        try {
                            styledDocument3 = null;
                            --this.counterGetDocument;
                            if (!this.isStrongSet || !this.canReleaseDoc()) break block16;
                            this.isStrongSet = false;
                        }
                        catch (Throwable throwable) {
                            --this.counterGetDocument;
                            if (this.isStrongSet && this.canReleaseDoc()) {
                                this.isStrongSet = false;
                                this.doc.setStrong(false);
                            }
                            throw throwable;
                        }
                        this.doc.setStrong(false);
                    }
                    return styledDocument3;
                }
                this.doc.setStrong(false);
            }
            return styledDocument;
        }
    }

    public boolean isModified() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isModified();
        }
        return this.cesEnv().isModified();
    }

    public void saveDocument() throws IOException {
        long l;
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.saveDocument();
            return;
        }
        if (!this.cesEnv().isModified()) {
            return;
        }
        final StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            return;
        }
        long l2 = this.lastSaveTime;
        if (l2 != -1L && (l = this.cesEnv().getTime().getTime()) > l2) {
            throw new UserQuestionException(this.mimeType){

                public String getLocalizedMessage() {
                    return NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change_write", (Object)styledDocument.getProperty("title"));
                }

                public void confirmed() throws IOException {
                    CloneableEditorSupport.this.setLastSaveTime(l);
                    CloneableEditorSupport.this.saveDocument();
                }
            };
        }
        Runnable runnable = (Runnable)styledDocument.getProperty("beforeSaveRunnable");
        if (runnable != null) {
            runnable.run();
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SaveAsReader
        implements Runnable {
            private boolean doMarkAsUnmodified;
            private IOException ex;

            SaveAsReader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedOutputStream bufferedOutputStream = null;
                    long l = CloneableEditorSupport.this.lastSaveTime;
                    try {
                        CloneableEditorSupport.this.setLastSaveTime(-1L);
                        bufferedOutputStream = new BufferedOutputStream(CloneableEditorSupport.this.cesEnv().outputStream());
                        CloneableEditorSupport.this.saveFromKitToStream(styledDocument, CloneableEditorSupport.this.kit, bufferedOutputStream);
                        ((OutputStream)bufferedOutputStream).close();
                        bufferedOutputStream = null;
                        ERR.fine("Save ok, assign new time, while old was: " + l);
                        CloneableEditorSupport.this.setLastSaveTime(CloneableEditorSupport.this.cesEnv().getTime().getTime());
                        this.doMarkAsUnmodified = true;
                        ERR.fine("doMarkAsUnmodified");
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    finally {
                        if (CloneableEditorSupport.this.lastSaveTime == -1L) {
                            ERR.fine("restoring old save time");
                            CloneableEditorSupport.this.setLastSaveTime(l);
                        }
                        if (bufferedOutputStream != null) {
                            ((OutputStream)bufferedOutputStream).close();
                        }
                    }
                    CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
                    CloneableEditorSupport.this.updateLineSet(true);
                }
                catch (IOException iOException) {
                    this.ex = iOException;
                }
            }

            public void after() throws IOException {
                if (this.doMarkAsUnmodified) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsReader saveAsReader = new SaveAsReader();
        styledDocument.render(saveAsReader);
        saveAsReader.after();
    }

    public JEditorPane[] getOpenedPanes() {
        assert (SwingUtilities.isEventDispatchThread());
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getOpenedPanes();
        }
        LinkedList<JEditorPane> linkedList = new LinkedList<JEditorPane>();
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane == null && cloneableTopComponent instanceof Pane) {
                pane = (Pane)cloneableTopComponent;
            }
            if (pane != null) {
                JEditorPane jEditorPane = pane.getEditorPane();
                if (jEditorPane == null) continue;
                if (this.getLastSelected() == pane) {
                    linkedList.addFirst(jEditorPane);
                    continue;
                }
                linkedList.add(jEditorPane);
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return linkedList.isEmpty() ? null : linkedList.toArray(new JEditorPane[linkedList.size()]);
    }

    final Pane getLastSelected() {
        Reference<Pane> reference = this.lastSelected;
        return reference == null ? null : reference.get();
    }

    final void setLastSelected(Pane pane) {
        this.lastSelected = new WeakReference<Pane>(pane);
    }

    public Line.Set getLineSet() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getLineSet();
        }
        return this.updateLineSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<Line, Reference<Line>> findWeakHashMap() {
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.lineSetWHM != null) {
                return this.lineSetWHM;
            }
            this.lineSetWHM = new WeakHashMap<Line, Reference<Line>>();
            return this.lineSetWHM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.print();
            return;
        }
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            object = PrinterJob.getPrinterJob();
            Object object2 = NbDocument.findPageable(this.openDocument());
            if (object2 instanceof Pageable) {
                ((PrinterJob)object).setPageable((Pageable)object2);
            } else {
                PageFormat pageFormat = PrintPreferences.getPageFormat((PrinterJob)object);
                ((PrinterJob)object).setPrintable((Printable)object2, pageFormat);
            }
            if (((PrinterJob)object).printDialog()) {
                ((PrinterJob)object).print();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CloneableEditorSupport.notifyProblem(fileNotFoundException, "CTL_Bad_File");
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (PrinterAbortException printerAbortException) {
            CloneableEditorSupport.notifyProblem(printerAbortException, "CTL_Printer_Abort");
        }
        catch (PrinterException printerException) {
            CloneableEditorSupport.notifyProblem(printerException, "EXC_Printer_Problem");
        }
        finally {
            Object object3 = this.LOCK_PRINTING;
            synchronized (object3) {
                this.printing = false;
            }
        }
    }

    private static void notifyProblem(Exception exception, String string) {
        String string2 = NbBundle.getMessage(CloneableEditorSupport.class, (String)string, (Object)exception.getLocalizedMessage());
        Exceptions.attachLocalizedMessage((Throwable)exception, (String)string2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)exception));
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        Pane pane = this.createPane();
        pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
        return pane.getComponent();
    }

    protected Pane createPane() {
        CloneableEditor cloneableEditor = this.createCloneableEditor();
        this.initializeCloneableEditor(cloneableEditor);
        return cloneableEditor;
    }

    protected Component wrapEditorComponent(Component component) {
        return component;
    }

    protected boolean canClose() {
        if (this.cesEnv().isModified()) {
            class SafeAWTAccess
            implements Runnable {
                boolean running;
                boolean finished;
                int ret;

                SafeAWTAccess() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SafeAWTAccess safeAWTAccess = this;
                    synchronized (safeAWTAccess) {
                        this.running = true;
                        this.notifyAll();
                    }
                    try {
                        this.ret = CloneableEditorSupport.this.canCloseImpl();
                    }
                    finally {
                        safeAWTAccess = this;
                        synchronized (safeAWTAccess) {
                            this.finished = true;
                            this.notifyAll();
                        }
                    }
                }

                public synchronized void waitForResult() throws InterruptedException {
                    if (!this.running) {
                        this.wait(10000L);
                    }
                    if (!this.running) {
                        throw new InterruptedException("Waiting 10s for AWT and nothing! Exiting to prevent deadlock");
                    }
                    while (!this.finished) {
                        this.wait();
                    }
                }
            }
            SafeAWTAccess safeAWTAccess = new SafeAWTAccess();
            if (SwingUtilities.isEventDispatchThread()) {
                safeAWTAccess.run();
            } else {
                SwingUtilities.invokeLater(safeAWTAccess);
                try {
                    safeAWTAccess.waitForResult();
                }
                catch (InterruptedException interruptedException) {
                    ERR.log(Level.INFO, null, interruptedException);
                    return false;
                }
            }
            if (safeAWTAccess.ret == 0) {
                return false;
            }
            if (safeAWTAccess.ret == 1) {
                try {
                    this.saveDocument();
                }
                catch (UserCancelException userCancelException) {
                    return false;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return false;
                }
            }
        }
        return true;
    }

    private int canCloseImpl() {
        String string = this.messageSave();
        ResourceBundle resourceBundle = NbBundle.getBundle(CloneableEditorSupport.class);
        JButton jButton = new JButton(resourceBundle.getString("CTL_Save"));
        jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Save"));
        jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Save"));
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Discard"));
        jButton2.setMnemonic(resourceBundle.getString("CTL_Discard_Mnemonic").charAt(0));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, resourceBundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (NotifyDescriptor.CANCEL_OPTION.equals(object) || NotifyDescriptor.CLOSED_OPTION.equals(object)) {
            return 0;
        }
        if (jButton.equals(object)) {
            return 1;
        }
        return -1;
    }

    public boolean isDocumentLoaded() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isDocumentLoaded();
        }
        return this.documentStatus != 0;
    }

    private boolean isDocumentReady() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isDocumentReady();
        }
        return this.documentStatus == 2;
    }

    public void setMIMEType(String string) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.setMIMEType(string);
            return;
        }
        this.mimeType = string;
    }

    @Deprecated
    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ChangeListener>(8);
        }
        this.listeners.add(changeListener);
    }

    @Deprecated
    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    public final PositionRef createPositionRef(int n, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), n, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new CESUndoRedoManager(this);
    }

    public InputStream getInputStream() throws IOException {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getInputStream();
        }
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            return this.cesEnv().inputStream();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveFromKitToStream(styledDocument, this.kit, byteArrayOutputStream);
        }
        catch (BadLocationException badLocationException) {
            ERR.log(Level.INFO, null, badLocationException);
            throw (IllegalStateException)new IllegalStateException(badLocationException.getMessage()).initCause(badLocationException);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        editorKit.write(outputStream, (Document)styledDocument, 0, styledDocument.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        editorKit.read(inputStream, (Document)styledDocument, 0);
    }

    protected Task reloadDocument() {
        ERR.fine("reloadDocument in " + Thread.currentThread());
        if (this.getDoc() != null) {
            final JEditorPane[] jEditorPaneArray = this.getOpenedPanes();
            NbDocument.runAtomic(this.getDoc(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int[] nArray;
                    CloneableEditorSupport.this.getDoc().removeUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                    if (jEditorPaneArray != null) {
                        nArray = new int[jEditorPaneArray.length];
                        for (int i = 0; i < jEditorPaneArray.length; ++i) {
                            nArray[i] = jEditorPaneArray[i].getCaretPosition();
                        }
                    } else {
                        nArray = new int[]{};
                    }
                    CloneableEditorSupport.this.documentStatus = 3;
                    CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Query
                    implements Runnable,
                    Callable<Void> {
                        int targetStatus = 0;
                        UserQuestionException e;

                        Query() {
                        }

                        @Override
                        public void run() {
                            CloneableEditorSupport.this.askUserAndDoOpen(this.e, this);
                        }

                        @Override
                        public Void call() {
                            CloneableEditorSupport.this.getPositionManager().documentClosed();
                            CloneableEditorSupport.this.updateLineSet(true);
                            CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.getDoc(), true);
                            ERR.fine("clearDocument");
                            CloneableEditorSupport.this.clearDocument();
                            CloneableEditorSupport.this.prepareTask = new Task((Runnable)CloneableEditorSupport.this.getListener());
                            ERR.fine("new prepare task: " + CloneableEditorSupport.this.prepareTask);
                            CloneableEditorSupport.this.prepareTask.run();
                            ERR.fine("prepareTask finished");
                            CloneableEditorSupport.this.documentStatus = 2;
                            CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.getDoc(), false);
                            this.targetStatus = 2;
                            return null;
                        }
                    }
                    Query query = new Query();
                    try {
                        query.call();
                    }
                    catch (RuntimeException runtimeException) {
                        if (runtimeException.getCause() instanceof UserQuestionException) {
                            query.e = (UserQuestionException)runtimeException.getCause();
                            Mutex.EVENT.readAccess((Runnable)query);
                            return;
                        }
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = runtimeException;
                        CloneableEditorSupport.this.prepareTask = null;
                        throw runtimeException;
                    }
                    catch (Error error) {
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = error;
                        CloneableEditorSupport.this.prepareTask = null;
                        throw error;
                    }
                    finally {
                        Object object = CloneableEditorSupport.this.getLock();
                        synchronized (object) {
                            if (query.targetStatus == 0) {
                                CloneableEditorSupport.this.setDoc(null, false);
                            }
                            CloneableEditorSupport.this.documentStatus = query.targetStatus;
                            CloneableEditorSupport.this.getLock().notifyAll();
                        }
                    }
                    ERR.fine("post-reload task posting to AWT");
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (CloneableEditorSupport.this.getDoc() == null) {
                                return;
                            }
                            if (jEditorPaneArray != null) {
                                for (int i = 0; i < jEditorPaneArray.length; ++i) {
                                    int n = jEditorPaneArray[i].getDocument().getLength();
                                    if (nArray[i] > n) {
                                        nArray[i] = n;
                                    }
                                    jEditorPaneArray[i].setCaretPosition(nArray[i]);
                                }
                            }
                            ERR.fine("task-discardAllEdits");
                            CloneableEditorSupport.this.getUndoRedo().discardAllEdits();
                            ERR.fine("task-undoableEditHappened");
                            CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent((Object)CloneableEditorSupport.this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
                            ERR.fine("task-check already modified");
                            if (CloneableEditorSupport.this.isAlreadyModified()) {
                                ERR.fine("task-callNotifyUnmodified");
                                CloneableEditorSupport.this.callNotifyUnmodified();
                            }
                            CloneableEditorSupport.this.updateLineSet(true);
                            ERR.fine("task-addUndoableEditListener");
                            CloneableEditorSupport.this.getDoc().addUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                        }
                    };
                    if (CloneableEditorSupport.this.getDoc() != null) {
                        ERR.fine("Posting the AWT runnable: " + runnable);
                        SwingUtilities.invokeLater(runnable);
                        ERR.fine("Posted in " + Thread.currentThread());
                    }
                }
            });
            return this.prepareTask;
        }
        return this.prepareDocument();
    }

    public static EditorKit getEditorKit(String string) {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
        EditorKit editorKit = (EditorKit)lookup.lookup(EditorKit.class);
        if (editorKit == null) {
            lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/plain"));
            editorKit = (EditorKit)lookup.lookup(EditorKit.class);
        }
        return editorKit != null ? (EditorKit)editorKit.clone() : new PlainEditorKit();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = CloneableEditorSupport.getEditorKit(this.mimeType);
        } else {
            String string = this.cesEnv().getMimeType();
            this.kit = CloneableEditorSupport.getEditorKit(string);
        }
        return this.kit;
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = CloneableEditorSupport.createNetBeansDocument(editorKit.createDefaultDocument());
        styledDocument.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.cesEnv().getMimeType());
        return styledDocument;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        this.updateTitles();
    }

    final boolean callNotifyModified() {
        if (!this.isAlreadyModified() && !this.revertingUndoOrReloading) {
            this.setAlreadyModified(true);
            if (!this.notifyModified()) {
                this.setAlreadyModified(false);
                this.revertingUndoOrReloading = true;
                this.revertPreviousOrUpcomingUndo();
                this.revertingUndoOrReloading = false;
                return false;
            }
        }
        return true;
    }

    final void callNotifyUnmodified() {
        this.setAlreadyModified(false);
        this.notifyUnmodified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean bl = true;
        try {
            this.env.markModified();
        }
        catch (UserQuestionException userQuestionException) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    RP.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
                            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                                try {
                                    userQuestionException.confirmed();
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            bl = false;
        }
        catch (IOException iOException) {
            String string = null;
            string = iOException.getMessage() != iOException.getLocalizedMessage() ? iOException.getLocalizedMessage() : Exceptions.findLocalizedMessage((Throwable)iOException);
            if (string != null) {
                StatusDisplayer.getDefault().setStatusText(string);
            }
            bl = false;
        }
        if (!bl) {
            return false;
        }
        lastReusable.clear();
        this.updateTitles();
        return true;
    }

    private void revertPreviousOrUpcomingUndo() {
        UndoRedo.Manager manager = this.getUndoRedo();
        Listener listener = this.getListener();
        if (Boolean.TRUE.equals(this.getDocument().getProperty("supportsModificationListener"))) {
            SearchBeforeModificationEdit searchBeforeModificationEdit = new SearchBeforeModificationEdit();
            try {
                while (true) {
                    searchBeforeModificationEdit.delegate = null;
                    manager.undoableEditHappened(new UndoableEditEvent(this.getDocument(), searchBeforeModificationEdit));
                    if (searchBeforeModificationEdit.delegate == null) break;
                    if (searchBeforeModificationEdit.delegate instanceof BeforeModificationEdit) {
                        if (searchBeforeModificationEdit.delegate == null) break;
                        manager.undo();
                    }
                    if (searchBeforeModificationEdit.delegate instanceof BeforeSaveEdit) break;
                    manager.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {}
        } else {
            listener.setUndoTask(new Runnable(){

                public void run() {
                    CloneableEditorSupport.this.undoAll();
                }
            });
            manager.addChangeListener((ChangeListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void undoAll() {
        StyledDocument styledDocument = this.getDoc();
        if (styledDocument == null) {
            return;
        }
        UndoRedo.Manager manager = this.getUndoRedo();
        this.addRemoveDocListener(styledDocument, false);
        try {
            if (manager.canUndo()) {
                Toolkit.getDefaultToolkit().beep();
                manager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            ERR.log(Level.INFO, null, cannotUndoException);
        }
        finally {
            this.addRemoveDocListener(styledDocument, true);
        }
    }

    protected void notifyClosed() {
        this.closeDocument();
    }

    boolean isEnvReadOnly() {
        return false;
    }

    final StyledDocument getDocumentHack() {
        return this.getDoc();
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set updateLineSet(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.lineSet != null && !bl) {
                return this.lineSet;
            }
            Line.Set set = this.lineSet;
            this.lineSet = this.getDoc() == null || this.documentStatus == 3 ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.getDoc());
            return this.lineSet;
        }
    }

    /*
     * Exception decompiling
     */
    private void loadDocument(EditorKit var1_1, StyledDocument var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean close(boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.close(bl);
        }
        if (!super.close(bl)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDocument() {
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    return;
                }
            }
            this.doCloseDocument();
            return;
        }
    }

    private void doCloseDocument() {
        this.prepareTask = null;
        this.cesEnv().removePropertyChangeListener(this.getListener());
        this.callNotifyUnmodified();
        if (this.getDoc() != null) {
            this.getDoc().removeUndoableEditListener((UndoableEditListener)this.getUndoRedo());
            this.addRemoveDocListener(this.getDoc(), false);
        }
        if (this.positionManager != null) {
            this.positionManager.documentClosed();
            this.documentStatus = 0;
            this.fireDocumentChange(this.getDoc(), true);
        }
        this.documentStatus = 0;
        this.setDoc(null, false);
        this.kit = null;
        this.getUndoRedo().discardAllEdits();
        this.updateLineSet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReload(boolean bl) {
        StyledDocument styledDocument;
        Object object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            styledDocument = this.getDoc();
        }
        if (!bl && !this.reloadDialogOpened) {
            object = NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change", (Object)styledDocument.getProperty("title"));
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object, 0);
            this.reloadDialogOpened = true;
            try {
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (NotifyDescriptor.YES_OPTION.equals(object2)) {
                    bl = true;
                }
            }
            finally {
                this.reloadDialogOpened = false;
            }
        }
        object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            if (bl) {
                this.reloadDocument();
            }
        }
    }

    private static StyledDocument createNetBeansDocument(Document document) {
        if (document instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    private final void fireDocumentChange(StyledDocument styledDocument, boolean bl) {
        this.fireStateChangeEvent(styledDocument, bl);
        this.firePropertyChange("document", bl ? styledDocument : null, bl ? null : styledDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fireStateChangeEvent(StyledDocument styledDocument, boolean bl) {
        if (this.listeners == null) return;
        EnhancedChangeEvent enhancedChangeEvent = new EnhancedChangeEvent(this, styledDocument, bl);
        ChangeListener[] changeListenerArray = this;
        synchronized (this) {
            ChangeListener[] changeListenerArray2 = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (ChangeListener changeListener : changeListenerArray2) {
                changeListener.stateChanged(enhancedChangeEvent);
            }
            return;
        }
    }

    protected void updateTitles() {
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane == null && cloneableTopComponent instanceof Pane) {
                pane = (Pane)cloneableTopComponent;
            }
            if (pane != null) {
                pane.updateName();
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
    }

    private static void replaceTc(TopComponent topComponent, TopComponent topComponent2) {
        int n = topComponent.getTabPosition();
        topComponent.close();
        topComponent2.openAtTabPosition(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pane openPane(boolean bl) {
        String string;
        Pane pane = null;
        boolean bl2 = false;
        Object object = this.getLock();
        synchronized (object) {
            pane = this.getAnyEditor();
            if (pane == null) {
                string = this.messageOpening();
                if (string != null) {
                    StatusDisplayer.getDefault().setStatusText(string);
                }
                this.prepareDocument();
                pane = this.createPane();
                pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
                pane.getComponent().setReference(this.allEditors);
                bl2 = true;
            }
        }
        object = pane.getComponent();
        if (bl && bl2) {
            string = lastReusable.get();
            if (string != null) {
                CloneableEditorSupport.replaceTc((TopComponent)string, (TopComponent)object);
            } else {
                object.open();
            }
            lastReusable = new WeakReference<Object>(object);
        } else {
            object.open();
        }
        if (bl2) {
            string = this.messageOpened();
            if (string == null) {
                string = "";
            }
            StatusDisplayer.getDefault().setStatusText(string);
        }
        return pane;
    }

    Pane getAnyEditor() {
        CloneableTopComponent cloneableTopComponent = this.allEditors.getArbitraryComponent();
        if (cloneableTopComponent == null) {
            return null;
        }
        Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
        if (pane != null) {
            return pane;
        }
        if (cloneableTopComponent instanceof Pane) {
            return (Pane)cloneableTopComponent;
        }
        Enumeration enumeration = this.allEditors.getComponents();
        if (enumeration.hasMoreElements()) {
            cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane != null) {
                return pane;
            }
            if (cloneableTopComponent instanceof Pane) {
                return (Pane)cloneableTopComponent;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    final Pane openReuse(PositionRef positionRef, int n, int n2) {
        if (n2 == 5) {
            lastReusable.clear();
        }
        return this.openAtImpl(positionRef, n, true);
    }

    final Pane openReuse(PositionRef positionRef, int n, Line.ShowOpenType showOpenType) {
        if (showOpenType == Line.ShowOpenType.REUSE_NEW) {
            lastReusable.clear();
        }
        return this.openAtImpl(positionRef, n, true);
    }

    protected final Pane openAt(PositionRef positionRef, int n) {
        return this.openAtImpl(positionRef, n, false);
    }

    private final Pane openAtImpl(final PositionRef positionRef, final int n, boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.openAtImpl(positionRef, n, bl);
        }
        final Pane pane = this.openPane(bl);
        Task task = this.prepareDocument();
        pane.ensureVisible();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Selector
        implements TaskListener,
        Runnable {
            private boolean documentLocked = false;

            Selector() {
            }

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(this);
                task.removeTaskListener((TaskListener)this);
            }

            @Override
            public void run() {
                JEditorPane jEditorPane = pane.getEditorPane();
                if (jEditorPane == null) {
                    return;
                }
                StyledDocument styledDocument = CloneableEditorSupport.this.getDocument();
                if (styledDocument == null) {
                    return;
                }
                if (!this.documentLocked) {
                    this.documentLocked = true;
                    styledDocument.render(this);
                } else {
                    Caret caret = jEditorPane.getCaret();
                    if (caret == null) {
                        return;
                    }
                    Element element = NbDocument.findLineRootElement(styledDocument);
                    int n2 = (element = element.getElement(element.getElementIndex(positionRef.getOffset()))).getStartOffset() + Math.max(0, n);
                    if (n2 > element.getEndOffset()) {
                        n2 = Math.max(element.getStartOffset(), element.getEndOffset() - 1);
                    }
                    caret.setDot(n2);
                    try {
                        Rectangle rectangle = jEditorPane.modelToView(n2);
                        if (rectangle != null) {
                            rectangle.height *= 5;
                            jEditorPane.scrollRectToVisible(rectangle);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        ERR.log(Level.WARNING, "Can't scroll to text: pos.getOffset=" + positionRef.getOffset() + ", column=" + n + ", offset=" + n2 + ", doc.getLength=" + styledDocument.getLength(), badLocationException);
                    }
                }
            }
        }
        task.addTaskListener((TaskListener)new Selector());
        return pane;
    }

    final Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    void howToReproduceDeadlock40766(boolean bl) {
    }

    final void setLastSaveTime(long l) {
        ERR.fine("Setting new lastSaveTime to " + l);
        this.lastSaveTime = l;
    }

    final boolean isAlreadyModified() {
        return this.alreadyModified;
    }

    final void setAlreadyModified(boolean bl) {
        ERR.log(Level.FINE, null, new Exception("Setting to modified: " + bl));
        this.alreadyModified = bl;
        this.doc.setStrong(bl);
    }

    private StyledDocument getDoc() {
        StrongRef strongRef = this.doc;
        return strongRef != null ? strongRef.get() : null;
    }

    private void setDoc(StyledDocument styledDocument, boolean bl) {
        if (styledDocument == null) {
            this.doc = null;
            return;
        }
        this.doc = new StrongRef(styledDocument, bl);
        Logger.getLogger("TIMER").log(Level.FINE, "TextDocument", styledDocument);
    }

    static final class DelegateIOExc
    extends IllegalStateException {
        public DelegateIOExc(IOException iOException) {
            super(iOException.getMessage());
            this.initCause(iOException);
        }
    }

    private static final class CESUndoRedoManager
    extends UndoRedo.Manager {
        private CloneableEditorSupport support;

        public CESUndoRedoManager(CloneableEditorSupport cloneableEditorSupport) {
            this.support = cloneableEditorSupport;
            super.setLimit(1000);
        }

        public void redo() throws CannotRedoException {
            StyledDocument styledDocument = this.support.getDocument();
            if (styledDocument == null) {
                throw new CannotRedoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(0, styledDocument);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        public void undo() throws CannotUndoException {
            StyledDocument styledDocument = this.support.getDocument();
            if (styledDocument == null) {
                throw new CannotUndoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(1, styledDocument);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        public boolean canRedo() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)2, (StyledDocument)styledDocument).booleanResult;
        }

        public boolean canUndo() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)3, (StyledDocument)styledDocument).booleanResult;
        }

        public int getLimit() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)4, (StyledDocument)styledDocument).intResult;
        }

        public void discardAllEdits() {
            StyledDocument styledDocument = this.support.getDocument();
            new RenderUndo(5, styledDocument);
        }

        public void setLimit(int n) {
            StyledDocument styledDocument = this.support.getDocument();
            new RenderUndo(6, styledDocument, n);
        }

        public boolean canUndoOrRedo() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)7, (StyledDocument)styledDocument).booleanResult;
        }

        public String getUndoOrRedoPresentationName() {
            if (this.support.isDocumentReady()) {
                StyledDocument styledDocument = this.support.getDocument();
                return (CESUndoRedoManager)this.new RenderUndo((int)8, (StyledDocument)styledDocument).stringResult;
            }
            return "";
        }

        public String getRedoPresentationName() {
            if (this.support.isDocumentReady()) {
                StyledDocument styledDocument = this.support.getDocument();
                return (CESUndoRedoManager)this.new RenderUndo((int)9, (StyledDocument)styledDocument).stringResult;
            }
            return "";
        }

        public String getUndoPresentationName() {
            if (this.support.isDocumentReady()) {
                StyledDocument styledDocument = this.support.getDocument();
                return (CESUndoRedoManager)this.new RenderUndo((int)10, (StyledDocument)styledDocument).stringResult;
            }
            return "";
        }

        public void undoOrRedo() throws CannotUndoException, CannotRedoException {
            StyledDocument styledDocument = this.support.getDocument();
            if (styledDocument == null) {
                throw new CannotUndoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(11, styledDocument);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        private final class RenderUndo
        implements Runnable {
            private final int type;
            public boolean booleanResult;
            public int intResult;
            public String stringResult;

            public RenderUndo(int n, StyledDocument styledDocument) {
                this(n, styledDocument, 0);
            }

            public RenderUndo(int n, StyledDocument styledDocument, int n2) {
                this.type = n;
                this.intResult = n2;
                if (styledDocument instanceof NbDocument.WriteLockable) {
                    ((NbDocument.WriteLockable)((Object)styledDocument)).runAtomic(this);
                } else {
                    this.run();
                }
            }

            public void run() {
                switch (this.type) {
                    case 0: {
                        CESUndoRedoManager.super.redo();
                        break;
                    }
                    case 1: {
                        CESUndoRedoManager.super.undo();
                        break;
                    }
                    case 2: {
                        this.booleanResult = CESUndoRedoManager.super.canRedo();
                        break;
                    }
                    case 3: {
                        this.booleanResult = CESUndoRedoManager.super.canUndo();
                        break;
                    }
                    case 4: {
                        this.intResult = CESUndoRedoManager.super.getLimit();
                        break;
                    }
                    case 5: {
                        CESUndoRedoManager.super.discardAllEdits();
                        break;
                    }
                    case 6: {
                        CESUndoRedoManager.super.setLimit(this.intResult);
                        break;
                    }
                    case 7: {
                        CESUndoRedoManager.super.canUndoOrRedo();
                        break;
                    }
                    case 8: {
                        this.stringResult = CESUndoRedoManager.super.getUndoOrRedoPresentationName();
                        break;
                    }
                    case 9: {
                        this.stringResult = CESUndoRedoManager.super.getRedoPresentationName();
                        break;
                    }
                    case 10: {
                        this.stringResult = CESUndoRedoManager.super.getUndoPresentationName();
                        break;
                    }
                    case 11: {
                        CESUndoRedoManager.super.undoOrRedo();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + this.type);
                    }
                }
            }
        }
    }

    private class SearchBeforeModificationEdit
    extends FilterUndoableEdit {
        SearchBeforeModificationEdit() {
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null) {
                this.delegate = undoableEdit;
                return true;
            }
            return false;
        }
    }

    private class BeforeModificationEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeModificationEdit(long l, UndoableEdit undoableEdit) {
            this.saveTime = l;
            this.delegate = undoableEdit;
            ERR.log(Level.FINEST, null, new Exception("new BeforeModificationEdit(" + l + ")"));
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null && !(undoableEdit instanceof SearchBeforeModificationEdit)) {
                this.delegate = undoableEdit;
                return true;
            }
            return this.delegate.addEdit(undoableEdit);
        }

        public void undo() {
            super.undo();
            boolean bl = this.saveTime == CloneableEditorSupport.this.lastSaveTime;
            ERR.fine("Comparing saveTime and lastSaveTime: " + this.saveTime + "==" + CloneableEditorSupport.this.lastSaveTime + " is " + bl);
            if (bl) {
                CloneableEditorSupport.this.justRevertedToNotModified = true;
            }
        }
    }

    private class BeforeSaveEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeSaveEdit(long l) {
            this.saveTime = l;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null) {
                this.delegate = undoableEdit;
                return true;
            }
            return false;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (!(undoableEdit instanceof BeforeModificationEdit) && !(undoableEdit instanceof SearchBeforeModificationEdit)) {
                CloneableEditorSupport.this.getUndoRedo().addEdit((UndoableEdit)new BeforeModificationEdit(this.saveTime, undoableEdit));
                return true;
            }
            return false;
        }

        public void redo() {
            super.redo();
            if (this.saveTime == CloneableEditorSupport.this.lastSaveTime) {
                CloneableEditorSupport.this.justRevertedToNotModified = true;
            }
        }

        public boolean isSignificant() {
            return this.delegate != null;
        }
    }

    private class FilterUndoableEdit
    implements UndoableEdit {
        protected UndoableEdit delegate;

        FilterUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            if (this.delegate != null) {
                this.delegate.undo();
            }
        }

        public boolean canUndo() {
            if (this.delegate != null) {
                return this.delegate.canUndo();
            }
            return false;
        }

        public void redo() throws CannotRedoException {
            if (this.delegate != null) {
                this.delegate.redo();
            }
        }

        public boolean canRedo() {
            if (this.delegate != null) {
                return this.delegate.canRedo();
            }
            return false;
        }

        public void die() {
            if (this.delegate != null) {
                this.delegate.die();
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.delegate != null) {
                return this.delegate.addEdit(undoableEdit);
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate != null) {
                return this.delegate.replaceEdit(undoableEdit);
            }
            return false;
        }

        public boolean isSignificant() {
            if (this.delegate != null) {
                return this.delegate.isSignificant();
            }
            return true;
        }

        public String getPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getPresentationName();
            }
            return "";
        }

        public String getUndoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getUndoPresentationName();
            }
            return "";
        }

        public String getRedoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getRedoPresentationName();
            }
            return "";
        }
    }

    private final class Listener
    implements ChangeListener,
    DocumentListener,
    PropertyChangeListener,
    Runnable,
    VetoableChangeListener {
        private boolean revertModifiedFlag;
        private IOException loadExc;
        private Runnable undoTask;

        Listener() {
        }

        public IOException checkLoadException() {
            IOException iOException = this.loadExc;
            return iOException;
        }

        public void setUndoTask(Runnable runnable) {
            this.undoTask = runnable;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CloneableEditorSupport.this.getUndoRedo().removeChangeListener((ChangeListener)this);
            this.undoTask.run();
            this.undoTask = null;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    boolean bl = CloneableEditorSupport.this.isAlreadyModified();
                    if (!CloneableEditorSupport.this.callNotifyModified()) {
                        throw new PropertyVetoException("Not allowed", propertyChangeEvent);
                    }
                    this.revertModifiedFlag = !bl;
                } else if (this.revertModifiedFlag) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("expectedTime".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.lastSaveTime = ((Date)propertyChangeEvent.getNewValue()).getTime();
            }
            if ("time".equals(propertyChangeEvent.getPropertyName())) {
                final Date date = (Date)propertyChangeEvent.getNewValue();
                ERR.fine("PROP_TIME new value: " + date + ", " + (date != null ? date.getTime() : -1L));
                ERR.fine("       lastSaveTime: " + new Date(CloneableEditorSupport.this.lastSaveTime) + ", " + CloneableEditorSupport.this.lastSaveTime);
                boolean bl = CloneableEditorSupport.this.lastSaveTime != -1L && (date == null || date.getTime() > CloneableEditorSupport.this.lastSaveTime);
                ERR.fine("             reload: " + bl);
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(){
                        boolean inWriteAccess;

                        public void run() {
                            if (!this.inWriteAccess) {
                                this.inWriteAccess = true;
                                StyledDocument styledDocument = CloneableEditorSupport.this.getDoc();
                                if (styledDocument == null) {
                                    return;
                                }
                                CloneableEditorSupport.this.revertingUndoOrReloading = true;
                                NbDocument.runAtomic(styledDocument, this);
                                CloneableEditorSupport.this.revertingUndoOrReloading = false;
                                return;
                            }
                            ERR.fine("checkReload starting");
                            boolean bl = date == null || !CloneableEditorSupport.this.isModified();
                            ERR.fine("checkReload noAsk: " + bl);
                            CloneableEditorSupport.this.checkReload(bl);
                        }
                    });
                    ERR.fine("reload task posted");
                }
            }
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.firePropertyChange("modified", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }

        public void run() {
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), false);
            try {
                this.loadExc = null;
                LOCAL_LOAD_TASK.set(true);
                CloneableEditorSupport.this.loadDocument(CloneableEditorSupport.this.kit, CloneableEditorSupport.this.getDoc());
            }
            catch (IOException iOException) {
                this.loadExc = iOException;
                throw new DelegateIOExc(iOException);
            }
            finally {
                LOCAL_LOAD_TASK.set(null);
            }
            CloneableEditorSupport.this.getPositionManager().documentOpened(CloneableEditorSupport.this.doc);
            CloneableEditorSupport.this.updateLineSet(true);
            CloneableEditorSupport.this.setLastSaveTime(CloneableEditorSupport.this.cesEnv().getTime().getTime());
            CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), true);
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        public Object clone() {
            return new PlainEditorKit();
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element element) {
            return new WrappedPlainView(element);
        }

        public void install(JEditorPane jEditorPane) {
            super.install(jEditorPane);
            jEditorPane.setFont(new Font("Monospaced", 0, jEditorPane.getFont().getSize() + 1));
        }
    }

    public static interface Pane {
        public JEditorPane getEditorPane();

        public CloneableTopComponent getComponent();

        public void updateName();

        public void ensureVisible();
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StrongRef
    extends WeakReference<StyledDocument>
    implements Runnable {
        private StyledDocument doc;

        public StrongRef(StyledDocument styledDocument, boolean bl) {
            super(styledDocument, Utilities.activeReferenceQueue());
            if (bl) {
                this.doc = styledDocument;
            }
        }

        @Override
        public StyledDocument get() {
            return this.doc != null ? this.doc : (StyledDocument)super.get();
        }

        @Override
        public void run() {
            CloneableEditorSupport.this.closeDocument();
        }

        private void setStrong(boolean bl) {
            this.doc = bl ? (StyledDocument)super.get() : null;
        }

        public String toString() {
            return "StrongRef[doc=" + this.doc + ",super.get=" + super.get() + "]";
        }
    }
}

