/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.java.generator;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.xml.tools.java.generator.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

public final class GenerationUtils {
    static final String CLASS_TEMPLATE = "Templates/Classes/Class.java";
    static final String INTERFACE_TEMPLATE = "Templates/Classes/Interface.java";
    private final WorkingCopy copy;
    static final /* synthetic */ boolean $assertionsDisabled;

    private GenerationUtils(WorkingCopy workingCopy) {
        this.copy = workingCopy;
    }

    public static GenerationUtils newInstance(WorkingCopy workingCopy) {
        Parameters.notNull((CharSequence)"copy", (Object)workingCopy);
        return new GenerationUtils(workingCopy);
    }

    public static FileObject createClass(FileObject fileObject, String string, String string2) throws IOException {
        return GenerationUtils.createClass(CLASS_TEMPLATE, fileObject, string, string2, Collections.emptyMap());
    }

    public static FileObject createClass(String string, FileObject fileObject, String string2, String string3, Map map) throws IOException {
        Parameters.notNull((CharSequence)"template", (Object)string);
        Parameters.notNull((CharSequence)"targetFolder", (Object)fileObject);
        Parameters.javaIdentifier((CharSequence)"className", (CharSequence)string2);
        FileObject fileObject2 = GenerationUtils.createDataObjectFromTemplate(string, fileObject, string2, map).getPrimaryFile();
        return fileObject2;
    }

    public static FileObject createInterface(FileObject fileObject, String string, String string2) throws IOException {
        return GenerationUtils.createClass(INTERFACE_TEMPLATE, fileObject, string, string2, Collections.emptyMap());
    }

    private static DataObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2, Map map) throws IOException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || string2 != null && string2.trim().length() > 0)) {
            throw new AssertionError();
        }
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject2 = fileSystem.findResource(string);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, string2, map);
    }

    public Tree createType(String string, TypeElement typeElement) {
        TreeMaker treeMaker = this.getTreeMaker();
        TypeKind typeKind = null;
        if ("boolean".equals(string)) {
            typeKind = TypeKind.BOOLEAN;
        } else if ("byte".equals(string)) {
            typeKind = TypeKind.BYTE;
        } else if ("short".equals(string)) {
            typeKind = TypeKind.SHORT;
        } else if ("int".equals(string)) {
            typeKind = TypeKind.INT;
        } else if ("long".equals(string)) {
            typeKind = TypeKind.LONG;
        } else if ("char".equals(string)) {
            typeKind = TypeKind.CHAR;
        } else if ("float".equals(string)) {
            typeKind = TypeKind.FLOAT;
        } else if ("double".equals(string)) {
            typeKind = TypeKind.DOUBLE;
        } else if ("void".equals(string)) {
            typeKind = TypeKind.VOID;
        }
        if (typeKind != null) {
            return this.getTreeMaker().PrimitiveType(typeKind);
        }
        Tree tree = this.makeQualIdent(string);
        if (tree == null) {
            TypeMirror typeMirror = this.copy.getTreeUtilities().parseType(string, typeElement);
            tree = treeMaker.Type(typeMirror);
        }
        return tree;
    }

    public ModifiersTree createModifiers(Modifier modifier) {
        return this.getTreeMaker().Modifiers(EnumSet.of(modifier), Collections.emptyList());
    }

    public ClassTree ensureNoArgConstructor(ClassTree classTree) {
        Tree tree;
        TypeElement typeElement = SourceUtils.classTree2TypeElement((CompilationController)this.copy, classTree);
        if (typeElement == null) {
            throw new IllegalArgumentException("No TypeElement for ClassTree " + classTree.getSimpleName());
        }
        ExecutableElement executableElement = SourceUtils.getNoArgConstructor((CompilationController)this.copy, typeElement);
        MethodTree methodTree = executableElement != null ? this.copy.getTrees().getTree(executableElement) : null;
        MethodTree methodTree2 = null;
        TreeMaker treeMaker = this.getTreeMaker();
        if (executableElement != null) {
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                tree = methodTree.getModifiers();
                EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
                methodTree2 = treeMaker.Constructor(treeMaker.Modifiers(enumSet), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), methodTree.getBody());
            }
        } else {
            methodTree2 = treeMaker.Constructor(this.createModifiers(Modifier.PUBLIC), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ }");
        }
        tree = classTree;
        if (methodTree2 != null) {
            if (methodTree != null) {
                tree = treeMaker.removeClassMember(tree, (Tree)methodTree);
            }
            tree = treeMaker.addClassMember(tree, (Tree)methodTree2);
        }
        return tree;
    }

    public MethodTree createAssignmentConstructor(ModifiersTree modifiersTree, String string, List list) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"constructorName", (CharSequence)string);
        Parameters.notNull((CharSequence)"parameters", (Object)list);
        StringBuilder stringBuilder = new StringBuilder(list.size() * 30);
        stringBuilder.append("{");
        for (int i = 0; i < list.size(); ++i) {
            VariableTree variableTree = (VariableTree)list.get(i);
            String string2 = variableTree.getName().toString();
            stringBuilder.append("this." + string2 + " = " + string2 + ";");
        }
        stringBuilder.append("}");
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Constructor(modifiersTree, Collections.emptyList(), list, Collections.emptyList(), stringBuilder.toString());
    }

    public MethodTree createConstructor(ModifiersTree modifiersTree, String string, List list, String string2) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"constructorName", (CharSequence)string);
        Parameters.notNull((CharSequence)"parameters", (Object)list);
        TreeMaker treeMaker = this.getTreeMaker();
        return treeMaker.Constructor(modifiersTree, Collections.emptyList(), list, Collections.emptyList(), string2);
    }

    public VariableTree createField(TypeElement typeElement, ModifiersTree modifiersTree, String string, String string2, ExpressionTree expressionTree) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"fieldName", (CharSequence)string);
        Parameters.notNull((CharSequence)"fieldType", (Object)string2);
        return this.getTreeMaker().Variable(modifiersTree, (CharSequence)string, this.createType(string2, typeElement), expressionTree);
    }

    public VariableTree createVariable(TypeElement typeElement, String string, String string2) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)string);
        Parameters.notNull((CharSequence)"variableType", (Object)string2);
        return this.createField(typeElement, this.createEmptyModifiers(), string, string2, null);
    }

    public VariableTree createVariable(String string, Tree tree) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)string);
        Parameters.notNull((CharSequence)"variableType", (Object)tree);
        return this.getTreeMaker().Variable(this.createEmptyModifiers(), (CharSequence)string, tree, null);
    }

    public ClassTree addClassFields(ClassTree classTree, List list) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"fieldTrees", (Object)list);
        int n = 0;
        Iterator<? extends Tree> iterator = classTree.getMembers().iterator();
        while (iterator.hasNext() && iterator.next().getKind() == Tree.Kind.VARIABLE) {
            ++n;
        }
        TreeMaker treeMaker = this.getTreeMaker();
        ClassTree classTree2 = classTree;
        for (int i = 0; i < list.size(); ++i) {
            VariableTree variableTree = (VariableTree)list.get(i);
            classTree2 = treeMaker.insertClassMember(classTree2, n, (Tree)variableTree);
            ++n;
        }
        return classTree2;
    }

    public ClassTree addImplementsClause(ClassTree classTree, String string) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"interfaceType", (Object)string);
        ExpressionTree expressionTree = this.createQualIdent(string);
        return this.getTreeMaker().addClassImplementsClause(classTree, (Tree)expressionTree);
    }

    private TreeMaker getTreeMaker() {
        return this.copy.getTreeMaker();
    }

    private ModifiersTree createEmptyModifiers() {
        return this.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList());
    }

    public ExpressionTree createQualIdent(String string) {
        ExpressionTree expressionTree = this.makeQualIdent(string);
        if (expressionTree == null) {
            throw new IllegalArgumentException("Cannot create a QualIdent for " + string);
        }
        return expressionTree;
    }

    public ExpressionTree makeQualIdent(String string) {
        TypeElement typeElement = this.copy.getElements().getTypeElement(string);
        if (typeElement != null) {
            return this.getTreeMaker().QualIdent((Element)typeElement);
        }
        return null;
    }

    public static String findJavaPackage(FileObject fileObject) {
        if (!$assertionsDisabled && !fileObject.isFolder()) {
            throw new AssertionError(fileObject);
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        return classPath.getResourceName(fileObject, '.', false);
    }

    static {
        $assertionsDisabled = !GenerationUtils.class.desiredAssertionStatus();
    }
}

