/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.tasklist.impl.ScanResult;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskCache {
    private WeakHashMap<FileObject, ScanResult> cache = new WeakHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    TaskCache() {
    }

    public boolean isUpToDate(FileObject fileObject, FileTaskScanner fileTaskScanner) {
        boolean bl = false;
        this.lock.readLock().lock();
        ScanResult scanResult = this.cache.get(fileObject);
        if (null != scanResult) {
            bl = scanResult.isUpToDate(fileObject, fileTaskScanner);
        }
        this.lock.readLock().unlock();
        return bl;
    }

    public void scanned(FileObject fileObject, FileTaskScanner fileTaskScanner, List<? extends Task> list) {
        this.lock.writeLock().lock();
        ScanResult scanResult = this.cache.get(fileObject);
        if (null == scanResult) {
            scanResult = new ScanResult();
            this.cache.put(fileObject, scanResult);
        }
        scanResult.put(fileTaskScanner, list);
        this.lock.writeLock().unlock();
    }

    public void getTasks(FileObject fileObject, FileTaskScanner fileTaskScanner, List<Task> list) {
        this.lock.readLock().lock();
        ScanResult scanResult = this.cache.get(fileObject);
        if (null != scanResult) {
            scanResult.get(fileTaskScanner, list);
        }
        this.lock.readLock().unlock();
    }

    public void clear(FileTaskScanner fileTaskScanner) {
        this.lock.writeLock().lock();
        ArrayList<FileObject> arrayList = null;
        for (FileObject fileObject : this.cache.keySet()) {
            ScanResult scanResult = this.cache.get(fileObject);
            scanResult.remove(fileTaskScanner);
            if (!scanResult.isEmpty()) continue;
            if (null == arrayList) {
                arrayList = new ArrayList<FileObject>();
            }
            arrayList.add(fileObject);
        }
        if (null != arrayList) {
            for (FileObject fileObject : arrayList) {
                this.cache.remove(fileObject);
            }
        }
        this.lock.writeLock().unlock();
    }

    public void clear(FileTaskScanner fileTaskScanner, FileObject[] fileObjectArray) {
        this.lock.writeLock().lock();
        for (FileObject fileObject : fileObjectArray) {
            ScanResult scanResult = this.cache.get(fileObject);
            if (null == scanResult) continue;
            scanResult.remove(fileTaskScanner);
            if (!scanResult.isEmpty()) continue;
            this.cache.remove(fileObject);
        }
        this.lock.writeLock().unlock();
    }

    public void clear(FileObject fileObject) {
        this.lock.writeLock().lock();
        ScanResult scanResult = this.cache.get(fileObject);
        if (null != scanResult) {
            this.cache.remove(fileObject);
        }
        this.lock.writeLock().unlock();
    }

    public void clear() {
        this.lock.writeLock().lock();
        this.cache.clear();
        this.lock.writeLock().unlock();
    }
}

