/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskList {
    private ArrayList<Task> sortedTasks = new ArrayList(0);
    private Set<Task> allTasks = new HashSet<Task>(0);
    private Map<PushTaskScanner, List<Task>> pushScanner2tasks = new HashMap<PushTaskScanner, List<Task>>(10);
    private Map<FileTaskScanner, List<Task>> fileScanner2tasks = new HashMap<FileTaskScanner, List<Task>>(10);
    private Map<TaskGroup, List<Task>> group2tasks = new HashMap<TaskGroup, List<Task>>(10);
    private final WeakSet<Listener> listeners = new WeakSet(2);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Comparator<Task> comparator;

    void setTasks(PushTaskScanner pushTaskScanner, FileObject fileObject, List<? extends Task> list, TaskFilter taskFilter) {
        this.lock.writeLock().lock();
        List<Task> list2 = this.clear(pushTaskScanner, fileObject);
        ArrayList<Task> arrayList = null;
        int n = this.countTasks(pushTaskScanner);
        for (Task task : list) {
            TaskGroup taskGroup;
            List<Task> list3;
            List<Task> list4;
            if (!taskFilter.accept(task) || taskFilter.isTaskCountLimitReached(n)) continue;
            ++n;
            if (this.allTasks.contains(task)) continue;
            if (null == arrayList) {
                arrayList = new ArrayList<Task>(list.size());
            }
            if (null == (list4 = this.pushScanner2tasks.get(pushTaskScanner))) {
                list4 = new LinkedList<Task>();
                this.pushScanner2tasks.put(pushTaskScanner, list4);
            }
            if (null == (list3 = this.group2tasks.get(taskGroup = Accessor.getGroup(task)))) {
                list3 = new LinkedList<Task>();
                this.group2tasks.put(taskGroup, list3);
            }
            arrayList.add(task);
            list4.add(task);
            list3.add(task);
            this.allTasks.add(task);
        }
        if (null != arrayList) {
            this.sortedTasks.addAll(arrayList);
            Collections.sort(this.sortedTasks, this.getComparator());
        }
        this.lock.writeLock().unlock();
        if (null != list2 && !list2.isEmpty()) {
            this.fireTasksRemoved(list2);
        }
        if (null != arrayList && !arrayList.isEmpty()) {
            this.fireTasksAdded((List<Task>)arrayList);
        }
    }

    void clear(PushTaskScanner pushTaskScanner) {
        this.lock.writeLock().lock();
        List<Task> list = this.pushScanner2tasks.get(pushTaskScanner);
        this.pushScanner2tasks.remove(pushTaskScanner);
        if (null != list) {
            for (List<Task> list2 : this.group2tasks.values()) {
                list2.removeAll(list);
            }
            this.sortedTasks.removeAll(list);
            this.allTasks.removeAll(list);
        }
        this.lock.writeLock().unlock();
        if (null != list && !list.isEmpty()) {
            this.fireTasksRemoved(list);
        }
    }

    private int countTasks(PushTaskScanner pushTaskScanner) {
        List<Task> list = this.pushScanner2tasks.get(pushTaskScanner);
        return null == list ? 0 : list.size();
    }

    private List<Task> clear(PushTaskScanner pushTaskScanner, FileObject fileObject) {
        LinkedList<Task> linkedList = null;
        List<Task> list = this.pushScanner2tasks.get(pushTaskScanner);
        if (null != list) {
            for (Task object : list) {
                if (!fileObject.equals(Accessor.getResource(object))) continue;
                if (null == linkedList) {
                    linkedList = new LinkedList<Task>();
                }
                linkedList.add(object);
            }
        }
        if (null != linkedList) {
            this.sortedTasks.removeAll(linkedList);
            this.allTasks.removeAll(linkedList);
            list.removeAll(linkedList);
            for (List list2 : this.group2tasks.values()) {
                list2.removeAll(linkedList);
            }
        }
        return linkedList;
    }

    void update(FileTaskScanner fileTaskScanner, FileObject fileObject, List<Task> list, TaskFilter taskFilter) {
        this.lock.writeLock().lock();
        List<Task> list2 = this.clear(fileTaskScanner, fileObject);
        ArrayList<Task> arrayList = new ArrayList<Task>(list.size());
        for (Task task : list) {
            TaskGroup taskGroup;
            List<Task> list3;
            if (this.allTasks.contains(task) || taskFilter.isTaskCountLimitReached(this.countTasks(fileTaskScanner)) || !taskFilter.accept(task)) continue;
            List<Task> list4 = this.fileScanner2tasks.get(fileTaskScanner);
            if (null == list4) {
                list4 = new LinkedList<Task>();
                this.fileScanner2tasks.put(fileTaskScanner, list4);
            }
            if (null == (list3 = this.group2tasks.get(taskGroup = Accessor.getGroup(task)))) {
                list3 = new LinkedList<Task>();
                this.group2tasks.put(taskGroup, list3);
            }
            list4.add(task);
            list3.add(task);
            arrayList.add(task);
            this.allTasks.add(task);
        }
        if (!arrayList.isEmpty()) {
            this.sortedTasks.addAll(arrayList);
            Collections.sort(this.sortedTasks, this.getComparator());
        }
        this.lock.writeLock().unlock();
        if (null != list2 && !list2.isEmpty()) {
            this.fireTasksRemoved(list2);
        }
        if (!arrayList.isEmpty()) {
            this.fireTasksAdded(arrayList);
        }
    }

    public int size() {
        int n = 0;
        this.lock.readLock().lock();
        n = this.sortedTasks.size();
        this.lock.readLock().unlock();
        return n;
    }

    public List<? extends Task> getTasks() {
        return new ArrayList<Task>(this.sortedTasks);
    }

    int countTasks(FileTaskScanner fileTaskScanner) {
        List<Task> list = this.fileScanner2tasks.get(fileTaskScanner);
        return null == list ? 0 : list.size();
    }

    public int countTasks(TaskGroup taskGroup) {
        List<Task> list = this.group2tasks.get(taskGroup);
        return null == list ? 0 : list.size();
    }

    public Task getTask(int n) {
        Task task = null;
        this.lock.readLock().lock();
        if (n >= 0 && n < this.sortedTasks.size()) {
            task = this.sortedTasks.get(n);
        }
        this.lock.readLock().unlock();
        return task;
    }

    void clear(FileTaskScanner fileTaskScanner) {
        this.lock.writeLock().lock();
        List<Task> list = this.fileScanner2tasks.get(fileTaskScanner);
        this.fileScanner2tasks.remove(fileTaskScanner);
        if (null != list) {
            for (List<Task> list2 : this.group2tasks.values()) {
                list2.removeAll(list);
            }
            this.sortedTasks.removeAll(list);
            this.allTasks.removeAll(list);
        }
        this.lock.writeLock().unlock();
        if (null != list && !list.isEmpty()) {
            this.fireTasksRemoved(list);
        }
    }

    void clear(FileTaskScanner fileTaskScanner, FileObject ... fileObjectArray) {
        this.lock.readLock().lock();
        ArrayList<Task> arrayList = null;
        List<Task> list = this.fileScanner2tasks.get(fileTaskScanner);
        if (null != list) {
            for (Task object : list) {
                for (FileObject fileObject : fileObjectArray) {
                    if (!fileObject.equals(Accessor.getResource(object))) continue;
                    if (null == arrayList) {
                        arrayList = new ArrayList<Task>(fileObjectArray.length);
                    }
                    arrayList.add(object);
                }
            }
        }
        this.lock.readLock().unlock();
        if (null != arrayList && !arrayList.isEmpty()) {
            this.lock.writeLock().lock();
            this.sortedTasks.removeAll(arrayList);
            this.allTasks.removeAll(arrayList);
            list.removeAll(arrayList);
            for (List list2 : this.group2tasks.values()) {
                list2.removeAll(arrayList);
            }
            this.lock.writeLock().unlock();
            this.fireTasksRemoved(arrayList);
        }
    }

    private List<Task> clear(FileTaskScanner fileTaskScanner, FileObject fileObject) {
        List<Task> list = this.fileScanner2tasks.get(fileTaskScanner);
        if (null == list) {
            return null;
        }
        LinkedList<Task> linkedList = null;
        for (Task object : list) {
            if (!fileObject.equals(Accessor.getResource(object))) continue;
            if (null == linkedList) {
                linkedList = new LinkedList<Task>();
            }
            linkedList.add(object);
        }
        if (null != linkedList) {
            this.sortedTasks.removeAll(linkedList);
            this.allTasks.removeAll(linkedList);
            list.removeAll(linkedList);
            for (List list2 : this.group2tasks.values()) {
                list2.removeAll(linkedList);
            }
        }
        return linkedList;
    }

    void clear(FileObject fileObject) {
        LinkedList<Task> linkedList = null;
        this.lock.writeLock().lock();
        for (List<Task> list : this.fileScanner2tasks.values()) {
            for (Task task : list) {
                if (!fileObject.equals(Accessor.getResource(task))) continue;
                if (null == linkedList) {
                    linkedList = new LinkedList<Task>();
                }
                linkedList.add(task);
            }
        }
        if (null != linkedList) {
            this.sortedTasks.removeAll(linkedList);
            this.allTasks.removeAll(linkedList);
            for (List<Task> list : this.fileScanner2tasks.values()) {
                list.removeAll(linkedList);
            }
            for (List<Task> list : this.group2tasks.values()) {
                list.removeAll(linkedList);
            }
        }
        this.lock.writeLock().unlock();
        if (null != linkedList) {
            this.fireTasksRemoved(linkedList);
        }
    }

    void clear() {
        this.lock.writeLock().lock();
        this.sortedTasks.clear();
        this.allTasks.clear();
        this.fileScanner2tasks.clear();
        this.pushScanner2tasks.clear();
        this.group2tasks.clear();
        this.lock.writeLock().unlock();
        this.fireCleared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.remove((Object)listener);
        }
    }

    public int indexOf(Task task) {
        return this.sortedTasks.indexOf(task);
    }

    private Comparator<Task> getComparator() {
        if (null == this.comparator) {
            this.comparator = TaskComparator.getDefault();
        }
        return this.comparator;
    }

    public void setComparator(Comparator<Task> comparator) {
        if (((Object)this.getComparator()).equals(comparator)) {
            return;
        }
        this.lock.writeLock().lock();
        this.comparator = comparator;
        Collections.sort(this.sortedTasks, this.getComparator());
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTasksAdded(List<Task> list) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            ArrayList<Listener> arrayList = new ArrayList<Listener>((Collection<Listener>)this.listeners);
            Iterator<Listener> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().tasksAdded(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTasksRemoved(List<Task> list) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            ArrayList<Listener> arrayList = new ArrayList<Listener>((Collection<Listener>)this.listeners);
            Iterator<Listener> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().tasksRemoved(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCleared() {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            ArrayList<Listener> arrayList = new ArrayList<Listener>((Collection<Listener>)this.listeners);
            Iterator<Listener> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().cleared();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void tasksAdded(List<? extends Task> var1);

        public void tasksRemoved(List<? extends Task> var1);

        public void cleared();
    }
}

