/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.tasklist.filter.FilterRepository;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.ScanningScopeList;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.CountStatusBar;
import org.netbeans.modules.tasklist.ui.FiltersMenuButton;
import org.netbeans.modules.tasklist.ui.FoldingTaskListModel;
import org.netbeans.modules.tasklist.ui.ScopeButton;
import org.netbeans.modules.tasklist.ui.ScopeStatusBar;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.modules.tasklist.ui.TaskListTable;
import org.netbeans.modules.tasklist.ui.Util;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class TaskListTopComponent
extends TopComponent {
    private static TaskListTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/tasklist/ui/resources/taskList.png";
    private static final String PREFERRED_ID = "TaskListTopComponent";
    private TaskManagerImpl taskManager = TaskManagerImpl.getInstance();
    private PropertyChangeListener scopeListListener;
    private PropertyChangeListener scannerListListener;
    private TaskListModel model;
    private FilterRepository filters;
    private TaskListTable table;
    private PropertyChangeListener changeListener;
    private TaskList.Listener tasksListener;
    private JPanel statusBarPanel;
    private JSeparator statusSeparator;
    private JPanel tableHolderPanel;
    private JScrollPane tableScroll;
    private JToolBar toolbar;
    private JSeparator toolbarSeparator;
    private ProgressHandle progress;

    private TaskListTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(TaskListTopComponent.class, (String)"CTL_TaskListTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TaskListTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.tableScroll.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TaskListTopComponent.this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                TaskListTopComponent.this.maybePopup(mouseEvent);
            }
        });
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.tableHolderPanel = new JPanel();
        this.tableScroll = new JScrollPane();
        this.toolbarSeparator = new JSeparator();
        this.statusSeparator = new JSeparator();
        this.statusBarPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add(this.toolbar, gridBagConstraints);
        this.tableHolderPanel.setOpaque(false);
        this.tableScroll.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)this.tableHolderPanel);
        this.tableHolderPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.tableScroll, -1, 397, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tableScroll, -1, 299, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.tableHolderPanel, gridBagConstraints);
        this.toolbarSeparator.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add(this.toolbarSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add(this.statusSeparator, gridBagConstraints);
        this.statusBarPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        this.add(this.statusBarPanel, gridBagConstraints);
    }

    public static synchronized TaskListTopComponent getDefault() {
        if (instance == null) {
            instance = new TaskListTopComponent();
        }
        return instance;
    }

    public static synchronized TaskListTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            TaskListTopComponent.getLogger().log(Level.INFO, "Cannot find TaskList component. It will not be located properly in the window system.");
            return TaskListTopComponent.getDefault();
        }
        if (topComponent instanceof TaskListTopComponent) {
            return (TaskListTopComponent)topComponent;
        }
        TaskListTopComponent.getLogger().log(Level.INFO, "There seem to be multiple components with the 'TaskListTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TaskListTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (null == this.model) {
            this.toolbarSeparator.setVisible(false);
            this.statusSeparator.setVisible(false);
            this.tableScroll.setViewportView(this.createNoTasksMessage());
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        TaskListTopComponent.this.init();
                    }
                });
            }
        });
    }

    private void init() {
        TaskScanningScope taskScanningScope = Settings.getDefault().getActiveScanningScope();
        if (null == taskScanningScope) {
            taskScanningScope = ScanningScopeList.getDefault().getDefaultScope();
        }
        if (null == this.filters) {
            try {
                this.filters = FilterRepository.getDefault();
                this.filters.load();
            }
            catch (IOException iOException) {
                TaskListTopComponent.getLogger().log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        if (null == this.changeListener) {
            this.changeListener = this.createChangeListener();
            this.taskManager.addPropertyChangeListener("workingStatus", this.changeListener);
        }
        if (null == this.model) {
            this.table = new TaskListTable();
            this.model = new TaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.tasksListener = new TaskList.Listener(){

                @Override
                public void tasksAdded(List<? extends Task> list) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            TaskListTopComponent.this.tableScroll.setViewportView(TaskListTopComponent.this.table);
                            Color color = UIManager.getColor("TextArea.background");
                            if (null != color) {
                                TaskListTopComponent.this.tableScroll.getViewport().setBackground(color);
                            }
                            TaskListTopComponent.this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
                        }
                    };
                    TaskListTopComponent.this.taskManager.getTasks().removeListener(TaskListTopComponent.this.tasksListener);
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                    TaskListTopComponent.this.tasksListener = null;
                }

                @Override
                public void tasksRemoved(List<? extends Task> list) {
                }

                @Override
                public void cleared() {
                }
            };
            this.taskManager.getTasks().addListener(this.tasksListener);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TaskListTopComponent.this.tableScroll.setViewportView(TaskListTopComponent.this.createNoTasksMessage());
                    TaskListTopComponent.this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
                    TaskListTopComponent.this.statusBarPanel.add((Component)new CountStatusBar(TaskListTopComponent.this.taskManager.getTasks()), "West");
                    TaskListTopComponent.this.statusBarPanel.add((Component)new ScopeStatusBar(TaskListTopComponent.this.taskManager), "Center");
                    TaskListTopComponent.this.toolbarSeparator.setVisible(true);
                    TaskListTopComponent.this.statusSeparator.setVisible(true);
                    TaskListTopComponent.this.rebuildToolbar();
                }
            });
        }
        ScanningScopeList.getDefault().addPropertyChangeListener(this.getScopeListListener());
        ScannerList.getFileScannerList().addPropertyChangeListener(this.getScannerListListener());
        ScannerList.getPushScannerList().addPropertyChangeListener(this.getScannerListListener());
        final TaskScanningScope taskScanningScope2 = taskScanningScope;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TaskListTopComponent.this.taskManager.observe(taskScanningScope2, TaskListTopComponent.this.filters.getActive());
            }
        });
    }

    private Component createNoTasksMessage() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Color color = UIManager.getColor("TextArea.background");
        if (null != color) {
            jPanel.setBackground(color);
        }
        JLabel jLabel = new JLabel(NbBundle.getMessage(TaskListTopComponent.class, (String)"LBL_NoTasks"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setEnabled(false);
        jLabel.setOpaque(false);
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentClosed() {
        ScanningScopeList.getDefault().removePropertyChangeListener(this.getScopeListListener());
        ScannerList.getFileScannerList().removePropertyChangeListener(this.getScannerListListener());
        ScannerList.getPushScannerList().removePropertyChangeListener(this.getScannerListListener());
        this.taskManager.observe(null, null);
        if (null != this.changeListener) {
            this.taskManager.removePropertyChangeListener("workingStatus", this.changeListener);
            this.changeListener = null;
        }
        TaskListTopComponent taskListTopComponent = this;
        synchronized (taskListTopComponent) {
            if (null != this.progress) {
                this.progress.finish();
            }
            this.progress = null;
        }
        try {
            FilterRepository.getDefault().save();
        }
        catch (IOException iOException) {
            TaskListTopComponent.getLogger().log(Level.INFO, null, iOException);
        }
    }

    public void requestActive() {
        super.requestActive();
        if (null != this.table) {
            this.table.requestFocusInWindow();
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void maybePopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            JPopupMenu jPopupMenu = Util.createPopup(this.table);
            jPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private PropertyChangeListener getScopeListListener() {
        if (null == this.scopeListListener) {
            this.scopeListListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ScanningScopeList scanningScopeList = ScanningScopeList.getDefault();
                    List<TaskScanningScope> list = scanningScopeList.getTaskScanningScopes();
                    if (list.isEmpty()) {
                        TaskListTopComponent.getLogger().log(Level.INFO, "No task scanning scope found");
                    }
                    TaskListTopComponent.this.rebuildToolbar();
                }
            };
        }
        return this.scopeListListener;
    }

    private PropertyChangeListener getScannerListListener() {
        if (null == this.scannerListListener) {
            this.scannerListListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            final TaskScanningScope taskScanningScope = TaskListTopComponent.this.taskManager.getScope();
                            TaskListTopComponent.this.taskManager.observe(null, null);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    TaskListTopComponent.this.taskManager.observe(taskScanningScope, TaskListTopComponent.this.filters.getActive());
                                }
                            });
                        }
                    });
                }
            };
        }
        return this.scannerListListener;
    }

    private void rebuildToolbar() {
        this.toolbar.removeAll();
        this.toolbar.setFocusable(false);
        List<TaskScanningScope> list = ScanningScopeList.getDefault().getTaskScanningScopes();
        for (TaskScanningScope object2 : list) {
            this.toolbar.add(new ScopeButton(this.taskManager, object2));
        }
        this.toolbar.add(new JToolBar.Separator());
        FiltersMenuButton filtersMenuButton = new FiltersMenuButton(this.filters.getActive());
        this.toolbar.add(filtersMenuButton);
        this.toolbar.addSeparator();
        final JToggleButton jToggleButton = new JToggleButton(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/tasklist/ui/resources/groups.png")));
        jToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TaskListTopComponent.this.switchTableModel(itemEvent.getStateChange() == 1);
                Settings.getDefault().setGroupTasksByCategory(jToggleButton.isSelected());
                jToggleButton.setToolTipText(jToggleButton.isSelected() ? NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TasksAsList") : NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_GrouppedTasks"));
            }
        });
        jToggleButton.setSelected(Settings.getDefault().getGroupTasksByCategory());
        jToggleButton.setToolTipText(jToggleButton.isSelected() ? NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_TasksAsList") : NbBundle.getMessage(TaskListTopComponent.class, (String)"HINT_GrouppedTasks"));
        jToggleButton.setFocusable(false);
        this.toolbar.add(jToggleButton);
    }

    private void switchTableModel(boolean bl) {
        if (bl) {
            this.model = new FoldingTaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.statusBarPanel.removeAll();
        } else {
            this.model = new TaskListModel(this.taskManager.getTasks());
            this.table.setModel(this.model);
            this.statusBarPanel.add((Component)new CountStatusBar(this.taskManager.getTasks()), "West");
            this.statusBarPanel.add((Component)new ScopeStatusBar(this.taskManager), "Center");
        }
        this.statusBarPanel.setVisible(!bl);
        this.statusSeparator.setVisible(!bl);
    }

    private static Logger getLogger() {
        return Logger.getLogger(TaskListTopComponent.class.getName());
    }

    private PropertyChangeListener createChangeListener() {
        return new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskListTopComponent taskListTopComponent = TaskListTopComponent.this;
                synchronized (taskListTopComponent) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        if (null == TaskListTopComponent.this.progress) {
                            TaskListTopComponent.this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(TaskListTopComponent.class, (String)"LBL_ScanProgress"), (Cancellable)new Cancellable(){

                                public boolean cancel() {
                                    TaskListTopComponent.this.taskManager.abort();
                                    return true;
                                }
                            });
                            TaskListTopComponent.this.progress.start();
                            TaskListTopComponent.this.progress.switchToIndeterminate();
                        }
                    } else {
                        if (null != TaskListTopComponent.this.progress) {
                            TaskListTopComponent.this.progress.finish();
                        }
                        TaskListTopComponent.this.progress = null;
                    }
                }
            }
        };
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return TaskListTopComponent.getDefault();
        }
    }
}

