/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;

public class HTMLAutoCompletion {
    private static int equalsSignInsertedOffset = -1;

    public static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (c == '=') {
            HTMLAutoCompletion.completeQuotes(baseDocument, n, caret);
        } else if (c == '\"') {
            HTMLAutoCompletion.handleQuotationMark(baseDocument, n, caret);
        } else {
            equalsSignInsertedOffset = -1;
        }
    }

    static void charDeleted(BaseDocument baseDocument, int n, Caret caret, char c) {
        equalsSignInsertedOffset = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleQuotationMark(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        if (equalsSignInsertedOffset != -1) {
            if (n == equalsSignInsertedOffset + "=\"".length()) {
                baseDocument.remove(n, 1);
                caret.setDot(n);
            }
        } else {
            baseDocument.readLock();
            try {
                TokenSequence tokenSequence = HTMLSyntaxSupport.getJoinedHtmlSequence((Document)baseDocument);
                if (tokenSequence == null) {
                    return;
                }
                tokenSequence.move(n);
                if (!tokenSequence.moveNext()) {
                    return;
                }
                Token token = tokenSequence.token();
                if (token.id() == HTMLTokenId.VALUE && "\"\"".equals(baseDocument.getText(n, 2))) {
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                }
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        equalsSignInsertedOffset = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void completeQuotes(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        baseDocument.readLock();
        try {
            TokenSequence tokenSequence = HTMLSyntaxSupport.getJoinedHtmlSequence((Document)baseDocument);
            if (tokenSequence == null) {
                return;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return;
            }
            Token token = tokenSequence.token();
            int n2 = n + 1;
            if (token != null && token.id() == HTMLTokenId.OPERATOR) {
                baseDocument.insertString(n2, "\"\"", null);
                caret.setDot(n2 + 1);
                equalsSignInsertedOffset = n;
            }
        }
        finally {
            baseDocument.readUnlock();
        }
    }
}

