/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.io.IOException;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.openide.util.Exceptions;

public class HTMLBracesMatching
implements BracesMatcher,
BracesMatcherFactory {
    private MatcherContext context;
    private LanguagePath htmlLanguagePath;
    private static final String BLOCK_COMMENT_START = "<!--";
    private static final String BLOCK_COMMENT_END = "-->";
    static boolean testMode = false;

    public HTMLBracesMatching() {
        this(null, null);
    }

    private HTMLBracesMatching(MatcherContext matcherContext, LanguagePath languagePath) {
        this.context = matcherContext;
        this.htmlLanguagePath = languagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Token token;
            if (!testMode && MatcherContext.isTaskCanceled()) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence tokenSequence = HTMLSyntaxSupport.getJoinedHtmlSequence((Document)this.context.getDocument());
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
            if (tokenSequence.language() == HTMLTokenId.language()) {
                tokenSequence.move(this.context.getSearchOffset());
                if (tokenSequence.moveNext()) {
                    if (this.context.isSearchingBackward() && tokenSequence.offset() + tokenSequence.token().length() < this.context.getSearchOffset()) {
                        int[] nArray = null;
                        return nArray;
                    }
                    token = tokenSequence.token();
                    if (this.tokenInTag(token)) {
                        do {
                            Token token2;
                            if (!this.tokenInTag(token2 = tokenSequence.token())) {
                                int[] nArray = null;
                                return nArray;
                            }
                            if (token2.id() != HTMLTokenId.TAG_OPEN_SYMBOL) continue;
                            int n = -1;
                            while (tokenSequence.moveNext()) {
                                Token token3 = tokenSequence.token();
                                if (!this.tokenInTag(token3) || token3.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                                    int[] nArray = null;
                                    return nArray;
                                }
                                if (token3.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                                    if ("/>".equals(((Object)token3.text()).toString())) {
                                        int[] nArray = null;
                                        return nArray;
                                    }
                                    int n2 = token2.offset(tokenHierarchy);
                                    int n3 = token3.offset(tokenHierarchy) + token3.length();
                                    int[] nArray = new int[]{n2, n3, n2, n, n3 - 1, n3};
                                    return nArray;
                                }
                                if (token3.id() != HTMLTokenId.TAG_OPEN && token3.id() != HTMLTokenId.TAG_CLOSE) continue;
                                n = token3.offset(tokenHierarchy) + token3.length();
                            }
                            break;
                        } while (tokenSequence.movePrevious());
                    } else if (token.id() == HTMLTokenId.BLOCK_COMMENT) {
                        String string = ((Object)token.text()).toString();
                        if (string.startsWith(BLOCK_COMMENT_START) && this.context.getSearchOffset() < token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()) {
                            int[] nArray = new int[]{token.offset(tokenHierarchy), token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()};
                            return nArray;
                        }
                        if (string.endsWith(BLOCK_COMMENT_END) && this.context.getSearchOffset() >= token.offset(tokenHierarchy) + string.length() - BLOCK_COMMENT_END.length()) {
                            int[] nArray = new int[]{token.offset(tokenHierarchy) + token.length() - BLOCK_COMMENT_END.length(), token.offset(tokenHierarchy) + token.length()};
                            return nArray;
                        }
                    }
                }
            }
            token = null;
            return token;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean tokenInTag(Token token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.VALUE_JAVASCRIPT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.EOL;
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (!testMode && MatcherContext.isTaskCanceled()) {
            return null;
        }
        Source source = Source.forDocument((Document)this.context.getDocument());
        if (source == null) {
            return null;
        }
        final int[][] nArrayArray = new int[1][];
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    int n;
                    if (!testMode && MatcherContext.isTaskCanceled()) {
                        return;
                    }
                    compilationController.toPhase(Phase.PARSED);
                    HtmlParserResult htmlParserResult = (HtmlParserResult)compilationController.getEmbeddedResult("text/html", HTMLBracesMatching.this.context.getSearchOffset());
                    if (htmlParserResult == null) {
                        nArrayArray[0] = new int[]{HTMLBracesMatching.this.context.getSearchOffset(), HTMLBracesMatching.this.context.getSearchOffset()};
                        return;
                    }
                    AstNode astNode = htmlParserResult.root();
                    AstNode astNode2 = AstNodeUtils.findDescendant((AstNode)astNode, (int)(n = htmlParserResult.getTranslatedSource() == null ? HTMLBracesMatching.this.context.getSearchOffset() : htmlParserResult.getTranslatedSource().getAstOffset(HTMLBracesMatching.this.context.getSearchOffset())));
                    if (astNode2 != null) {
                        if (astNode2.type() == AstNode.NodeType.OPEN_TAG) {
                            AstNode astNode3 = astNode2.parent();
                            if (astNode3.type() == AstNode.NodeType.UNMATCHED_TAG) {
                                DTD.Element element = htmlParserResult.dtd().getElement(astNode2.name().toUpperCase());
                                nArrayArray[0] = (int[])(element != null && (element.hasOptionalEnd() || element.isEmpty()) ? new int[]{HTMLBracesMatching.this.context.getSearchOffset(), HTMLBracesMatching.this.context.getSearchOffset()} : null);
                            } else {
                                AstNode astNode4 = (AstNode)astNode3.children().get(astNode3.children().size() - 1);
                                nArrayArray[0] = HTMLBracesMatching.this.translate(new int[]{astNode4.startOffset(), astNode4.endOffset()}, htmlParserResult.getTranslatedSource());
                            }
                        } else if (astNode2.type() == AstNode.NodeType.ENDTAG) {
                            AstNode astNode5 = astNode2.parent();
                            if (astNode5.type() == AstNode.NodeType.UNMATCHED_TAG) {
                                DTD.Element element = htmlParserResult.dtd().getElement(astNode2.name().toUpperCase());
                                nArrayArray[0] = (int[])(element != null && element.hasOptionalStart() ? new int[]{HTMLBracesMatching.this.context.getSearchOffset(), HTMLBracesMatching.this.context.getSearchOffset()} : null);
                            } else {
                                AstNode astNode6 = (AstNode)astNode5.children().get(0);
                                nArrayArray[0] = HTMLBracesMatching.this.translate(new int[]{astNode6.startOffset(), astNode6.startOffset() + astNode6.name().length() + 1, astNode6.endOffset() - 1, astNode6.endOffset()}, htmlParserResult.getTranslatedSource());
                            }
                        } else if (astNode2.type() == AstNode.NodeType.COMMENT) {
                            int n2 = astNode2.startOffset();
                            if (n >= astNode2.startOffset() && n <= astNode2.startOffset() + HTMLBracesMatching.BLOCK_COMMENT_START.length()) {
                                nArrayArray[0] = HTMLBracesMatching.this.translate(new int[]{astNode2.endOffset() - HTMLBracesMatching.BLOCK_COMMENT_END.length(), astNode2.endOffset()}, htmlParserResult.getTranslatedSource());
                            } else if (n >= astNode2.endOffset() - HTMLBracesMatching.BLOCK_COMMENT_END.length() && n <= astNode2.endOffset()) {
                                nArrayArray[0] = HTMLBracesMatching.this.translate(new int[]{astNode2.startOffset(), astNode2.startOffset() + HTMLBracesMatching.BLOCK_COMMENT_START.length()}, htmlParserResult.getTranslatedSource());
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return nArrayArray[0];
    }

    private int[] translate(int[] nArray, TranslatedSource translatedSource) {
        if (translatedSource == null) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = translatedSource.getLexicalOffset(nArray[i]);
        }
        return nArray2;
    }

    public BracesMatcher createMatcher(final MatcherContext matcherContext) {
        final HTMLBracesMatching[] hTMLBracesMatchingArray = new HTMLBracesMatching[]{null};
        matcherContext.getDocument().render(new Runnable(){

            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)matcherContext.getDocument());
                if (tokenHierarchy.tokenSequence().language() == HTMLTokenId.language()) {
                    hTMLBracesMatchingArray[0] = new HTMLBracesMatching(matcherContext, tokenHierarchy.tokenSequence().languagePath());
                    return;
                }
                List list = tokenHierarchy.embeddedTokenSequences(matcherContext.getSearchOffset(), matcherContext.isSearchingBackward());
                for (TokenSequence tokenSequence : list) {
                    Language language = tokenSequence.language();
                    if (language != HTMLTokenId.language()) continue;
                    hTMLBracesMatchingArray[0] = new HTMLBracesMatching(matcherContext, tokenSequence.languagePath());
                    return;
                }
            }
        });
        return hTMLBracesMatchingArray[0];
    }
}

