/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indent;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.editor.ext.html.HTMLLexerFormatter;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.openide.filesystems.FileObject;

public class HtmlIndentTask
implements IndentTask {
    private Context context;
    private FileObject fo;

    HtmlIndentTask(Context context) {
        this.context = context;
        this.fo = NbEditorUtilities.getFileObject((Document)context.document());
    }

    public void reindent() throws BadLocationException {
        long l = System.currentTimeMillis();
        this.getFormatter().process(this.context);
        Logger.getLogger("TIMER").log(Level.FINE, "HTML Reindent", new Object[]{this.fo, System.currentTimeMillis() - l});
    }

    public ExtraLock indentLock() {
        return null;
    }

    private HTMLLexerFormatter getFormatter() {
        MimePath mimePath = MimePath.parse((String)this.context.mimePath());
        LanguagePath languagePath = LanguagePath.get((Language)Language.find((String)mimePath.getMimeType(0)));
        for (int i = 1; i < mimePath.size(); ++i) {
            languagePath = languagePath.embedded(Language.find((String)mimePath.getMimeType(i)));
        }
        return new HTMLLexerFormatter(languagePath);
    }
}

