/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformConfigurator;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.wizard.CDCWizardIterator;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class DetectPanel
extends JPanel {
    private ArrayList<ChangeListener> listeners;
    private static File lastFolder = null;
    private JButton addJavadocButton;
    private JButton addSourceButton;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JList javadocList;
    private JTextField jdkName;
    private JButton removeJavadocButton;
    private JButton removeSourceButton;
    private JList sourcesList;

    public DetectPanel(FileObject fileObject, CDCPlatformDetector cDCPlatformDetector) {
        this.initComponents();
        this.sourcesList.setModel(new DefaultListModel());
        this.javadocList.setModel(new DefaultListModel());
        this.postInitComponents();
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName")});
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName"));
        CDCPlatformConfigurator cDCPlatformConfigurator = cDCPlatformDetector.getConfigurator(fileObject);
        if (cDCPlatformConfigurator != null) {
            JPanel jPanel = cDCPlatformConfigurator.getConfigurationTools();
            jPanel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DetectPanel.this.fireChange();
                }
            });
            this.jTabbedPane1.insertTab(NbBundle.getMessage(DetectPanel.class, (String)"TXT_Configuration"), null, jPanel, null, 0);
        }
    }

    public void addNotify() {
        super.addNotify();
    }

    private void postInitComponents() {
        this.jdkName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }
        });
    }

    protected void handleNameChange() {
        this.fireChange();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jdkName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.sourcesList = new JList();
        this.jPanel6 = new JPanel();
        this.addSourceButton = new JButton();
        this.removeSourceButton = new JButton();
        this.jPanel5 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.javadocList = new JList();
        this.jPanel7 = new JPanel();
        this.addJavadocButton = new JButton();
        this.removeJavadocButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_DetectPanel"));
        this.jLabel3.setLabelFor(this.jdkName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_DetailsPanel_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jdkName, gridBagConstraints);
        this.jdkName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformName"));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.sourcesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.sourcesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel6.setLayout(new GridLayout(2, 0, 6, 6));
        Mnemonics.setLocalizedText((AbstractButton)this.addSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_AddSources"));
        this.addSourceButton.setEnabled(false);
        this.addSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.addSourceButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.addSourceButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeSourceButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_RemoveSources"));
        this.removeSourceButton.setEnabled(false);
        this.removeSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.removeSourceButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel6.add(this.removeSourceButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"TXT_Sources"), this.jPanel4);
        this.jPanel5.setLayout(new GridBagLayout());
        this.javadocList.setSelectionMode(0);
        this.javadocList.setEnabled(false);
        this.jScrollPane2.setViewportView(this.javadocList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.jPanel5.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel7.setLayout(new GridLayout(2, 0, 0, 6));
        Mnemonics.setLocalizedText((AbstractButton)this.addJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_AddJavadoc"));
        this.addJavadocButton.setEnabled(false);
        this.addJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.addJavadocButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.addJavadocButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeJavadocButton, (String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_RemoveJavadoc"));
        this.removeJavadocButton.setEnabled(false);
        this.removeJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.removeJavadocButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel7.add(this.removeJavadocButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel5.add((Component)this.jPanel7, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(DetectPanel.class, (String)"TXT_JavaDoc"), this.jPanel5);
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void removeJavadocButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.javadocList.getSelectedIndex();
        ((DefaultListModel)this.javadocList.getModel()).remove(n);
        int n2 = this.javadocList.getModel().getSize();
        if (n2 != 0) {
            this.javadocList.setSelectedIndex(0);
        }
        this.removeJavadocButton.setEnabled(n2 != 0);
    }

    private void addJavadocButtonActionPerformed(ActionEvent actionEvent) {
        this.addResource("javadoc");
    }

    private void addSourceButtonActionPerformed(ActionEvent actionEvent) {
        this.addResource("src");
    }

    private void removeSourceButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.sourcesList.getSelectedIndex();
        ((DefaultListModel)this.sourcesList.getModel()).remove(n);
        int n2 = this.sourcesList.getModel().getSize();
        if (n2 != 0) {
            this.sourcesList.setSelectedIndex(0);
        }
        this.removeSourceButton.setEnabled(n2 != 0);
    }

    public final synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(changeListener);
    }

    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    public String getPlatformName() {
        return this.jdkName.getText().trim();
    }

    String getSources() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.sourcesList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.sourcesList.getModel().getElementAt(i));
            if (i + 1 >= n) continue;
            stringBuffer.append(';');
        }
        String string = stringBuffer.toString();
        return string.length() == 0 ? null : string;
    }

    void setSources(String string) {
        ((DefaultListModel)this.sourcesList.getModel()).removeAllElements();
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            ((DefaultListModel)this.sourcesList.getModel()).addElement(stringTokenizer.nextToken());
        }
        this.removeSourceButton.setEnabled(this.sourcesList.getModel().getSize() != 0);
    }

    void setSources(ClassPath classPath) {
        String string = null;
        if (classPath.entries().size() > 0) {
            URL uRL = ((ClassPath.Entry)classPath.entries().get(0)).getURL();
            if ("jar".equals(uRL.getProtocol())) {
                uRL = FileUtil.getArchiveFile((URL)uRL);
            }
            string = new File(URI.create(uRL.toExternalForm())).getAbsolutePath();
        }
        this.setSources(string);
    }

    String getJavadoc() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.javadocList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.javadocList.getModel().getElementAt(i));
            if (i + 1 >= n) continue;
            stringBuffer.append(';');
        }
        String string = stringBuffer.toString();
        return string.length() == 0 ? null : string;
    }

    void setJavadoc(String string) {
        ((DefaultListModel)this.javadocList.getModel()).removeAllElements();
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            ((DefaultListModel)this.javadocList.getModel()).addElement(stringTokenizer.nextToken());
        }
        this.removeJavadocButton.setEnabled(this.javadocList.getModel().getSize() != 0);
    }

    void setJavadoc(List list) {
        ((DefaultListModel)this.javadocList.getModel()).removeAllElements();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((DefaultListModel)this.javadocList.getModel()).addElement(FileUtil.toFile((FileObject)((FileObject)iterator.next())).getAbsolutePath());
        }
        this.removeJavadocButton.setEnabled(this.javadocList.getModel().getSize() != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChange() {
        Iterator iterator = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                return;
            }
            iterator = ((ArrayList)this.listeners.clone()).iterator();
        }
        serializable = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)serializable);
        }
    }

    void updateData(String string) {
        if ("".equals(this.jdkName.getText())) {
            this.jdkName.setText(string);
            this.jdkName.selectAll();
        }
    }

    private void addResource(String string) {
        DefaultListModel defaultListModel = null;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (string.equalsIgnoreCase("javadoc")) {
            jFileChooser.setDialogTitle(NbBundle.getMessage(DetectPanel.class, (String)"TXT_OpenJavadoc"));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectJavadoc"), new String[]{"ZIP", "JAR"}));
            jFileChooser.setApproveButtonText(NbBundle.getMessage(DetectPanel.class, (String)"CTL_SelectJD"));
            jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNE_SelectJD").charAt(0));
            defaultListModel = (DefaultListModel)this.javadocList.getModel();
        } else if (string.equalsIgnoreCase("src")) {
            jFileChooser.setDialogTitle(NbBundle.getMessage(DetectPanel.class, (String)"TXT_OpenSources"));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectSources"), new String[]{"ZIP", "JAR"}));
            jFileChooser.setApproveButtonText(NbBundle.getMessage(DetectPanel.class, (String)"CTL_SelectSRC"));
            jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(DetectPanel.class, (String)"MNE_SelectSRC").charAt(0));
            defaultListModel = (DefaultListModel)this.sourcesList.getModel();
        }
        if (lastFolder != null) {
            jFileChooser.setCurrentDirectory(lastFolder);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            lastFolder = jFileChooser.getCurrentDirectory();
            if (jFileChooser.isMultiSelectionEnabled()) {
                this.addFiles(jFileChooser.getSelectedFiles(), defaultListModel);
            } else {
                this.addFiles(new File[]{jFileChooser.getSelectedFile()}, defaultListModel);
            }
        }
    }

    private void addFiles(File[] fileArray, DefaultListModel defaultListModel) {
        for (File file : fileArray) {
            File file2;
            if (!file.exists() && (file2 = file.getParentFile()) != null && file.getName().equals(file2.getName()) && file2.exists()) {
                file = file2;
            }
            defaultListModel.addElement(file.toString());
        }
    }

    static class WizardPanel
    implements WizardDescriptor.Panel,
    TaskListener,
    ChangeListener {
        protected DetectPanel component;
        private RequestProcessor.Task task;
        private final CDCWizardIterator iterator;
        private Collection<ChangeListener> changeList = new ArrayList<ChangeListener>();
        protected boolean detected;
        private boolean valid;
        private boolean configured;
        private WizardDescriptor wiz;
        protected CDCPlatform platform;
        protected FileObject installedFolder;
        protected CDCPlatformDetector detector;
        protected DetectPlatformTask detectPlatformTask = new DetectPlatformTask();

        WizardPanel(CDCWizardIterator cDCWizardIterator, CDCPlatformDetector cDCPlatformDetector) {
            this.iterator = cDCWizardIterator;
            this.detector = cDCPlatformDetector;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeList.add(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.installedFolder = this.iterator.getInstallFolder();
                this.component = new DetectPanel(this.installedFolder, this.detector);
                this.component.addChangeListener(this);
                this.configured = this.isConfigured();
                if (this.configured) {
                    this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
                    this.task.addTaskListener((TaskListener)this);
                } else {
                    this.setValid(false);
                }
            }
            return this.component;
        }

        void setValid(boolean bl) {
            if (bl == this.valid) {
                return;
            }
            this.valid = bl;
            this.fireStateChange();
        }

        public HelpCtx getHelp() {
            return new HelpCtx("cdc.detectPanel");
        }

        public boolean isValid() {
            return this.valid;
        }

        public void readSettings(Object object) {
            this.wiz = (WizardDescriptor)object;
            CDCPlatform cDCPlatform = this.iterator.getPlatform();
            String string = null;
            String string2 = null;
            if (cDCPlatform != null) {
                Object object2;
                ClassPath classPath = cDCPlatform.getSourceFolders();
                if (classPath.entries().size() > 0) {
                    object2 = ((ClassPath.Entry)classPath.entries().get(0)).getURL();
                    if ("jar".equals(((URL)object2).getProtocol())) {
                        object2 = FileUtil.getArchiveFile((URL)object2);
                    }
                    string = new File(URI.create(((URL)object2).toExternalForm())).getAbsolutePath();
                }
                if ((object2 = cDCPlatform.getJavadocFolders()).size() > 0) {
                    URL uRL = (URL)object2.get(0);
                    if ("jar".equals(uRL.getProtocol())) {
                        uRL = FileUtil.getArchiveFile((URL)uRL);
                    }
                    string2 = new File(URI.create(uRL.toExternalForm())).getAbsolutePath();
                }
                this.component.setSources(string);
                this.component.setJavadoc(string2);
            }
            this.component.jdkName.setEditable(false);
            if (this.task != null) {
                this.task.schedule(0);
            } else {
                this.checkValid();
                this.fireStateChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.changeList.isEmpty()) {
                    return;
                }
                changeListenerArray = this.changeList.toArray(new ChangeListener[0]);
            }
            object = new ChangeEvent(this);
            for (ChangeListener changeListener : changeListenerArray) {
                changeListener.stateChanged((ChangeEvent)object);
            }
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeList.remove(changeListener);
        }

        public void storeSettings(Object object) {
            if (this.isValid()) {
                Object object2;
                Object object3;
                Object object4;
                CDCPlatform cDCPlatform = this.platform;
                String string = this.component.getPlatformName();
                this.platform.setDisplayName(string);
                String string2 = WizardPanel.createAntName(string);
                cDCPlatform.setAntName(string2);
                ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                ArrayList<URL> arrayList2 = new ArrayList<URL>();
                String string3 = this.component.getSources();
                if (string3 != null) {
                    object4 = new File(string3);
                    try {
                        object3 = ((File)object4).toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)object3)) {
                            object2 = URLMapper.findFileObject((URL)(object3 = FileUtil.getArchiveRoot((URL)object3)));
                            if (object2 != null && (object2 = object2.getFileObject("src")) != null) {
                                object3 = object2.getURL();
                            }
                            arrayList.add(ClassPathSupport.createResource((URL)object3));
                        } else {
                            arrayList.add(ClassPathSupport.createResource((URL)object3));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify((Throwable)malformedURLException);
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                    }
                }
                if ((object4 = this.component.getJavadoc()) != null) {
                    object3 = new StringTokenizer((String)object4, ";");
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        object2 = new File(((StringTokenizer)object3).nextToken());
                        try {
                            URL uRL = ((File)object2).toURI().toURL();
                            if (FileUtil.isArchiveFile((URL)uRL)) {
                                arrayList2.add(FileUtil.getArchiveRoot((URL)uRL));
                                continue;
                            }
                            arrayList2.add(uRL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().notify((Throwable)malformedURLException);
                        }
                    }
                }
                cDCPlatform.setSourceFolders(ClassPathSupport.createClassPath(arrayList));
                cDCPlatform.setJavadocFolders(arrayList2);
                this.iterator.setPlatform(cDCPlatform);
            }
        }

        public void taskFinished(Task task) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardPanel.this.detected = WizardPanel.this.detectPlatformTask.isValid();
                    if (WizardPanel.this.detected) {
                        WizardPanel.this.component.setJavadoc(WizardPanel.this.platform.getJavadocFolders());
                        WizardPanel.this.component.setSources(WizardPanel.this.platform.getSourceFolders());
                        WizardPanel.this.component.updateData(WizardPanel.this.platform.getDisplayName());
                        WizardPanel.this.component.jdkName.setEditable(true);
                        WizardPanel.this.component.addSourceButton.setEnabled(true);
                        WizardPanel.this.component.addJavadocButton.setEnabled(true);
                        WizardPanel.this.component.sourcesList.setEnabled(true);
                        WizardPanel.this.component.javadocList.setEnabled(true);
                    }
                    WizardPanel.this.checkValid();
                }
            });
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.checkValid();
        }

        protected void checkValid() {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
            boolean bl = true;
            boolean bl2 = false;
            String string = this.component.getPlatformName();
            boolean bl3 = this.isConfigured();
            if (bl3 && !this.configured) {
                this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
                this.task.addTaskListener((TaskListener)this);
                this.task.schedule(0);
                this.configured = bl3;
            }
            if (!this.configured) {
                CDCPlatformConfigurator cDCPlatformConfigurator = this.detector.getConfigurator(this.installedFolder);
                if (cDCPlatformConfigurator != null) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)cDCPlatformConfigurator.getInfo());
                } else {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_PlatformNotSet"));
                }
                bl = false;
            } else {
                boolean bl4;
                boolean bl5 = bl4 = string.length() > 0;
                if (!this.detected) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_NoSDKRegistry"));
                } else if (!bl4) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_InvalidDisplayName"));
                } else {
                    JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < javaPlatformArray.length; ++i) {
                        if (!string.equals(javaPlatformArray[i].getDisplayName())) continue;
                        bl2 = true;
                        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_UsedDisplayName"));
                        break;
                    }
                }
                bl = this.detected && bl4 && !bl2;
            }
            this.setValid(bl);
        }

        private static String createAntName(String string) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException();
            }
            String string2 = PropertyUtils.getUsablePropertyName((String)string);
            if (WizardPanel.platformExists(string2)) {
                String string3 = string2;
                int n = 1;
                string2 = string3 + Integer.toString(n);
                while (WizardPanel.platformExists(string2)) {
                    string2 = string3 + Integer.toString(++n);
                }
            }
            return string2;
        }

        private static boolean platformExists(String string) {
            JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
            JavaPlatform[] javaPlatformArray = javaPlatformManager.getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                String string2;
                if (!(javaPlatformArray[i] instanceof CDCPlatform) || !string.equals(string2 = ((CDCPlatform)javaPlatformArray[i]).getAntName())) continue;
                return true;
            }
            return false;
        }

        private boolean isConfigured() {
            CDCPlatformConfigurator cDCPlatformConfigurator = this.detector.getConfigurator(this.installedFolder);
            if (cDCPlatformConfigurator == null) {
                return true;
            }
            return cDCPlatformConfigurator.isConfigured();
        }

        private class DetectPlatformTask
        implements Runnable {
            private boolean valid = false;

            private DetectPlatformTask() {
            }

            public boolean isValid() {
                return this.valid;
            }

            public void run() {
                try {
                    WizardPanel.this.platform = WizardPanel.this.detector.detectPlatform(WizardPanel.this.installedFolder);
                    this.valid = WizardPanel.this.platform != null;
                }
                catch (IOException iOException) {
                    this.valid = false;
                }
            }
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

