/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.table;

import com.sun.data.provider.TableDataProvider;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignEvent;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Position;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.event.DesignContextListener;
import com.sun.rave.designtime.faces.FacesDesignProject;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.component.table.TableColumnDesignState;
import com.sun.webui.jsf.component.table.TableDataProviderDesignState;
import com.sun.webui.jsf.component.table.TableDesignState;
import com.sun.webui.jsf.component.table.TableRowGroupDesignState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TableBindToDataPanel
extends JPanel
implements DesignContextListener {
    private DesignBean designBean = null;
    private TableDesignState tableDesignState;
    private TableRowGroupDesignState tableRowGroupDesignState;
    private DefaultListModel selectedColumnListModel = new DefaultListModel();
    private DefaultListModel availableColumnListModel = new DefaultListModel();
    private DefaultComboBoxModel dataProviderComboBoxModel = new DefaultComboBoxModel();
    private Map dataProviderList = new HashMap();
    private TableDataProviderDesignState currentTableDataProviderDesignState;
    private TableColumnDesignState currentTableColumnDesignState;
    private DesignContext[] designContexts;
    private JButton addAllButton;
    private JButton addButton;
    private JButton addDataProviderButton;
    private JPanel addRemoveButtonPanel;
    private JPanel addRemoveColumnsPanel;
    private JPanel addReoveAllButtonPanel;
    private JList availableColumns;
    private JComboBox cbxTableDataprovider;
    private JPanel columnSelectionpanel;
    private JButton downButton;
    private JPanel getDataPanel;
    private JList jList1;
    private JLabel lblAvailableColumns;
    private JLabel lblSelectedColumns;
    private JLabel lblTableDataProvider;
    private JPanel middleButtons;
    private JButton newColumnButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private JPanel rightButtons;
    private JScrollPane scrollAvailable;
    private JScrollPane scrollSelected;
    private JList selectedColumns;
    private JButton upButton;
    private JPanel upDownButtonPanel;

    public TableBindToDataPanel(DesignBean bean) {
        this.designBean = bean;
        this.designContexts = this.getDesignContexts(this.designBean);
        this.initComponents();
        this.initialize();
        this.addDataProviderButton.setVisible(false);
    }

    private DesignContext[] getDesignContexts(DesignBean designBean) {
        DesignProject designProject = designBean.getDesignContext().getProject();
        DesignContext[] contexts = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{"request", "session", "application"}) : new DesignContext[]{};
        DesignContext[] designContexts = new DesignContext[contexts.length + 1];
        designContexts[0] = designBean.getDesignContext();
        System.arraycopy(contexts, 0, designContexts, 1, contexts.length);
        return designContexts;
    }

    private void initialize() {
        this.tableDesignState = this.designBean.getInstance() instanceof TableRowGroup ? new TableDesignState(this.designBean.getBeanParent(), this.designBean) : new TableDesignState(this.designBean);
        this.tableDesignState.loadState();
        this.tableRowGroupDesignState = this.tableDesignState.getTableRowGroupDesignState();
        this.tableRowGroupDesignState.loadState();
        DesignBean currentModelBean = this.tableRowGroupDesignState.getDataProviderBean();
        for (int i = 0; i < this.designContexts.length; ++i) {
            DesignBean[] dpBeans = this.designContexts[i].getBeansOfType(TableDataProvider.class);
            for (int j = 0; j < dpBeans.length; ++j) {
                DesignBean tableDataProvider = dpBeans[j];
                if (!(tableDataProvider.getInstance() instanceof TableDataProvider)) continue;
                TableDataProviderDesignState tableDataProviderDesignState = new TableDataProviderDesignState(tableDataProvider);
                if (currentModelBean == tableDataProvider) {
                    this.currentTableDataProviderDesignState = tableDataProviderDesignState;
                    tableDataProviderDesignState.setColumnDesignStates(this.tableRowGroupDesignState.getColumnDesignStates());
                    tableDataProviderDesignState.setSelectedColumnNames(this.tableRowGroupDesignState.getSelectedColumnNames());
                }
                tableDataProviderDesignState.initialize();
                this.dataProviderList.put(tableDataProvider, tableDataProviderDesignState);
                this.dataProviderComboBoxModel.addElement(tableDataProvider);
            }
            DesignBean[] objectListBeans = this.designContexts[i].getBeansOfType(List.class);
            for (int j = 0; j < objectListBeans.length; ++j) {
                DesignBean objectList = objectListBeans[j];
                TableDataProviderDesignState tableDataProviderDesignState = new TableDataProviderDesignState(objectList);
                if (currentModelBean == objectList) {
                    this.currentTableDataProviderDesignState = tableDataProviderDesignState;
                    tableDataProviderDesignState.setColumnDesignStates(this.tableRowGroupDesignState.getColumnDesignStates());
                    tableDataProviderDesignState.setSelectedColumnNames(this.tableRowGroupDesignState.getSelectedColumnNames());
                }
                tableDataProviderDesignState.initialize();
                this.dataProviderList.put(objectList, tableDataProviderDesignState);
                this.dataProviderComboBoxModel.addElement(objectList);
            }
            DesignBean[] objectArrayBeans = this.designContexts[i].getBeansOfType(Object[].class);
            for (int j = 0; j < objectArrayBeans.length; ++j) {
                DesignBean objectArray = objectArrayBeans[j];
                TableDataProviderDesignState tableDataProviderDesignState = new TableDataProviderDesignState(objectArray);
                if (currentModelBean == objectArray) {
                    this.currentTableDataProviderDesignState = tableDataProviderDesignState;
                    tableDataProviderDesignState.setColumnDesignStates(this.tableRowGroupDesignState.getColumnDesignStates());
                    tableDataProviderDesignState.setSelectedColumnNames(this.tableRowGroupDesignState.getSelectedColumnNames());
                }
                tableDataProviderDesignState.initialize();
                this.dataProviderList.put(objectArray, tableDataProviderDesignState);
                this.dataProviderComboBoxModel.addElement(objectArray);
            }
        }
        this.cbxTableDataprovider.setRenderer(new DPComboRenderer());
        this.cbxTableDataprovider.setModel(this.dataProviderComboBoxModel);
        this.setTableDataProviderDesignState(this.currentTableDataProviderDesignState);
        this.cbxTableDataprovider.setSelectedItem(currentModelBean);
    }

    public void addNotify() {
        super.addNotify();
        for (int i = 0; i < this.designContexts.length; ++i) {
            this.designContexts[i].addDesignContextListener((DesignContextListener)this);
        }
    }

    public void removeNotify() {
        for (int i = 0; i < this.designContexts.length; ++i) {
            this.designContexts[i].removeDesignContextListener((DesignContextListener)this);
        }
        super.removeNotify();
    }

    private void setTableDataProviderDesignState(TableDataProviderDesignState tblDataProviderDesignState) {
        this.currentTableDataProviderDesignState = tblDataProviderDesignState;
        this.selectedColumnListModel = this.currentTableDataProviderDesignState.getSelectedColumnListModel();
        this.selectedColumns.setModel(this.selectedColumnListModel);
        if (this.selectedColumnListModel.size() > 0) {
            this.selectedColumns.setSelectedIndex(0);
        }
        this.availableColumnListModel = this.currentTableDataProviderDesignState.getAvailableColumnListModel();
        this.availableColumns.setModel(this.availableColumnListModel);
        if (this.availableColumnListModel.size() > 0) {
            this.availableColumns.setSelectedIndex(0);
        }
    }

    public boolean isModified() {
        return true;
    }

    public Result applyChanges() {
        this.tableDesignState.clearProperties();
        this.tableRowGroupDesignState.clearProperties();
        this.tableRowGroupDesignState.setSelectedColumnNames(this.currentTableDataProviderDesignState.getSelectedColumnNames());
        this.tableRowGroupDesignState.setAvailableColumnNames(this.currentTableDataProviderDesignState.getAvailableColumnNames());
        this.tableRowGroupDesignState.setColumnDesignStates(this.currentTableDataProviderDesignState.getColumnDesignStates());
        if (this.currentTableDataProviderDesignState.getDataProviderBean() != this.tableRowGroupDesignState.getDataProviderBean()) {
            this.tableRowGroupDesignState.setDataProviderBean(this.currentTableDataProviderDesignState.getDataProviderBean(), false);
        }
        this.tableDesignState.saveState();
        Result result = new Result(true);
        return result;
    }

    private void initComponents() {
        this.jList1 = new JList();
        this.addRemoveColumnsPanel = new JPanel();
        this.getDataPanel = new JPanel();
        this.lblTableDataProvider = new JLabel();
        this.cbxTableDataprovider = new JComboBox();
        this.addDataProviderButton = new JButton();
        this.columnSelectionpanel = new JPanel();
        this.scrollAvailable = new JScrollPane();
        this.availableColumns = new JList();
        this.scrollSelected = new JScrollPane();
        this.selectedColumns = new JList();
        this.middleButtons = new JPanel();
        this.addRemoveButtonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addReoveAllButtonPanel = new JPanel();
        this.removeAllButton = new JButton();
        this.addAllButton = new JButton();
        this.rightButtons = new JPanel();
        this.upDownButtonPanel = new JPanel();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.newColumnButton = new JButton();
        this.lblAvailableColumns = new JLabel();
        this.lblSelectedColumns = new JLabel();
        this.setLayout(new BorderLayout());
        this.addRemoveColumnsPanel.setLayout(new BorderLayout());
        this.getDataPanel.setLayout(new BorderLayout(5, 5));
        this.getDataPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.lblTableDataProvider.setDisplayedMnemonic('G');
        this.lblTableDataProvider.setLabelFor(this.cbxTableDataprovider);
        this.lblTableDataProvider.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("TABLE_DATA_PROVIDER_TITLE"));
        this.lblTableDataProvider.setVerifyInputWhenFocusTarget(false);
        this.getDataPanel.add((Component)this.lblTableDataProvider, "West");
        this.cbxTableDataprovider.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TableBindToDataPanel.this.cbxTableDataproviderItemStateChanged(evt);
            }
        });
        this.getDataPanel.add((Component)this.cbxTableDataprovider, "Center");
        this.cbxTableDataprovider.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("DP_COMBO_ACCESS_DESC"));
        this.addDataProviderButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_DATAPROVIDER_BUTTON_MNEMONIC").charAt(0));
        this.addDataProviderButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_DP_BUTTON_LBL"));
        this.addDataProviderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.addDataProviderButtonActionPerformed(evt);
            }
        });
        this.getDataPanel.add((Component)this.addDataProviderButton, "East");
        this.addRemoveColumnsPanel.add((Component)this.getDataPanel, "North");
        this.columnSelectionpanel.setLayout(new GridBagLayout());
        this.scrollAvailable.setMinimumSize(new Dimension(150, 150));
        this.scrollAvailable.setPreferredSize(new Dimension(150, 150));
        this.scrollAvailable.setViewportView(this.availableColumns);
        this.availableColumns.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("AVAILABLE_COL_ACCESS_DESC"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 9, 6);
        this.columnSelectionpanel.add((Component)this.scrollAvailable, gridBagConstraints);
        this.scrollSelected.setMinimumSize(new Dimension(150, 150));
        this.scrollSelected.setPreferredSize(new Dimension(150, 150));
        this.selectedColumns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TableBindToDataPanel.this.selectedColumnsValueChanged(evt);
            }
        });
        this.scrollSelected.setViewportView(this.selectedColumns);
        this.selectedColumns.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("SELECTED_COL_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 9, 0);
        this.columnSelectionpanel.add((Component)this.scrollSelected, gridBagConstraints);
        this.middleButtons.setLayout(new GridBagLayout());
        this.addRemoveButtonPanel.setLayout(new GridLayout(2, 0, 0, 5));
        this.addButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_TO_BUTTON_LBL"));
        this.addButton.setMargin(new Insets(2, 7, 2, 7));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.addRemoveButtonPanel.add(this.addButton);
        this.addButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_COLUMN_ACCESS_DESC"));
        this.removeButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("REMOVE_FROM_BUTTON_LBL"));
        this.removeButton.setMargin(new Insets(2, 7, 2, 7));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.addRemoveButtonPanel.add(this.removeButton);
        this.removeButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("REMOVE_COLUMN_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.middleButtons.add((Component)this.addRemoveButtonPanel, gridBagConstraints);
        this.addReoveAllButtonPanel.setLayout(new GridLayout(2, 0, 0, 5));
        this.removeAllButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("REMOVE_ALL_BUTTON_LBL"));
        this.removeAllButton.setMargin(new Insets(2, 7, 2, 7));
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        this.addReoveAllButtonPanel.add(this.removeAllButton);
        this.removeAllButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("REMOVE_ALL_COLUMN_ACCESS_DESC"));
        this.addAllButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_ALL_BUTTON_MNEMONIC").charAt(0));
        this.addAllButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_ALL_BUTTON"));
        this.addAllButton.setMargin(new Insets(2, 7, 2, 7));
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        this.addReoveAllButtonPanel.add(this.addAllButton);
        this.addAllButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_ALL_COLUMN_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.middleButtons.add((Component)this.addReoveAllButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 9, 0);
        this.columnSelectionpanel.add((Component)this.middleButtons, gridBagConstraints);
        this.rightButtons.setLayout(new GridBagLayout());
        this.upDownButtonPanel.setLayout(new GridLayout(2, 0, 0, 5));
        this.upButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("UP_BUTTON_MNEMONIC").charAt(0));
        this.upButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("UP_BUTTON_LBL"));
        this.upButton.setMargin(new Insets(2, 7, 2, 7));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.upDownButtonPanel.add(this.upButton);
        this.upButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("MOVE_COLUMN_UP_ACCESS_DESC"));
        this.downButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("DOWN_BUTTON_MNEMONIC").charAt(0));
        this.downButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("DOWN_BUTON_LBL"));
        this.downButton.setMargin(new Insets(2, 7, 2, 7));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.downButtonActionPerformed(evt);
            }
        });
        this.upDownButtonPanel.add(this.downButton);
        this.downButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("MOVE_COLUMN_DOWN_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.rightButtons.add((Component)this.upDownButtonPanel, gridBagConstraints);
        this.newColumnButton.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("NEW_BUTTON_MNEMONIC").charAt(0));
        this.newColumnButton.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("NEW_BUTTON_LABEL"));
        this.newColumnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableBindToDataPanel.this.newColumnButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.rightButtons.add((Component)this.newColumnButton, gridBagConstraints);
        this.newColumnButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("ADD_NEW_COLUMN_ACCESS_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 9, 6);
        this.columnSelectionpanel.add((Component)this.rightButtons, gridBagConstraints);
        this.lblAvailableColumns.setDisplayedMnemonic('b');
        this.lblAvailableColumns.setLabelFor(this.availableColumns);
        this.lblAvailableColumns.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("AVAILABLE_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 6, 6);
        this.columnSelectionpanel.add((Component)this.lblAvailableColumns, gridBagConstraints);
        this.lblSelectedColumns.setDisplayedMnemonic('S');
        this.lblSelectedColumns.setLabelFor(this.selectedColumns);
        this.lblSelectedColumns.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/table/Bundle").getString("SELECTED_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.columnSelectionpanel.add((Component)this.lblSelectedColumns, gridBagConstraints);
        this.addRemoveColumnsPanel.add((Component)this.columnSelectionpanel, "Center");
        this.add((Component)this.addRemoveColumnsPanel, "Center");
    }

    private void cbxTableDataproviderItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setTableDataProviderDesignState((TableDataProviderDesignState)this.dataProviderList.get(evt.getItem()));
        }
    }

    private void addDataProviderButtonActionPerformed(ActionEvent evt) {
    }

    private void selectedColumnsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            // empty if block
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.availableColumns.getSelectedIndex();
        Object[] selections = this.availableColumns.getSelectedValues();
        for (int i = 0; i < selections.length; ++i) {
            if (!this.selectedColumnListModel.contains(selections[i])) {
                this.selectedColumnListModel.addElement(selections[i]);
                this.selectedColumns.setSelectedValue(selections[i], true);
            }
            this.availableColumnListModel.removeElement(selections[i]);
        }
        if (this.availableColumnListModel.size() == 0) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
        } else if (--selectedIndex >= 0) {
            this.availableColumns.setSelectedIndex(selectedIndex);
        } else {
            this.availableColumns.setSelectedIndex(this.availableColumnListModel.size() - 1);
        }
        this.removeButton.setEnabled(true);
        this.removeAllButton.setEnabled(true);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.selectedColumns.getSelectedIndex();
        Object[] selections = this.selectedColumns.getSelectedValues();
        for (int i = 0; i < selections.length; ++i) {
            if (!this.availableColumnListModel.contains(selections[i])) {
                this.availableColumnListModel.addElement(selections[i]);
                this.availableColumns.setSelectedValue(selections[i], true);
            }
            this.selectedColumnListModel.removeElement(selections[i]);
        }
        if (this.selectedColumnListModel.size() == 0) {
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        } else if (--selectedIndex >= 0) {
            this.selectedColumns.setSelectedIndex(selectedIndex);
        } else {
            this.selectedColumns.setSelectedIndex(this.selectedColumnListModel.size() - 1);
        }
        this.addButton.setEnabled(true);
        this.addAllButton.setEnabled(true);
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.selectedColumnListModel.size(); ++i) {
            if (this.availableColumnListModel.contains(this.selectedColumnListModel.getElementAt(i))) continue;
            this.availableColumnListModel.addElement(this.selectedColumnListModel.getElementAt(i));
            this.availableColumns.setSelectedIndex(i);
        }
        this.selectedColumnListModel.removeAllElements();
        this.addButton.setEnabled(true);
        this.addAllButton.setEnabled(true);
        this.removeButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.availableColumnListModel.size(); ++i) {
            if (this.selectedColumnListModel.contains(this.availableColumnListModel.getElementAt(i))) continue;
            this.selectedColumnListModel.addElement(this.availableColumnListModel.getElementAt(i));
            this.selectedColumns.setSelectedIndex(i);
        }
        this.availableColumnListModel.removeAllElements();
        this.removeButton.setEnabled(true);
        this.removeAllButton.setEnabled(true);
        this.addButton.setEnabled(false);
        this.addAllButton.setEnabled(false);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int index = this.selectedColumns.getSelectedIndex();
        if (index > 0) {
            Object currentObject = this.selectedColumnListModel.get(index);
            Object prevObject = this.selectedColumnListModel.get(index - 1);
            this.selectedColumnListModel.setElementAt(currentObject, index - 1);
            this.selectedColumnListModel.setElementAt(prevObject, index);
            this.selectedColumns.setSelectedIndex(index - 1);
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int index = this.selectedColumns.getSelectedIndex();
        if (index < this.selectedColumnListModel.getSize()) {
            Object currentObject = this.selectedColumnListModel.get(index);
            Object prevObject = this.selectedColumnListModel.get(index + 1);
            this.selectedColumnListModel.setElementAt(currentObject, index + 1);
            this.selectedColumnListModel.setElementAt(prevObject, index);
            this.selectedColumns.setSelectedIndex(index + 1);
        }
    }

    private void newColumnButtonActionPerformed(ActionEvent evt) {
        String name = this.currentTableDataProviderDesignState.getUniqueColumnName("column");
        TableColumnDesignState colDesignState = new TableColumnDesignState(name, name, "text");
        this.currentTableDataProviderDesignState.addColumnDesignStates(colDesignState);
        this.selectedColumns.setSelectedValue(name, true);
    }

    public void beanCreated(DesignBean designBean) {
        if (designBean.getInstance() instanceof TableDataProvider) {
            // empty if block
        }
    }

    public void instanceNameChanged(DesignBean designBean, String oldInstanceName) {
        if (designBean.getInstance() instanceof TableDataProvider) {
            this.cbxTableDataprovider.repaint();
        }
    }

    public void propertyChanged(DesignProperty prop, Object oldValue) {
        if (prop.getDesignBean().getInstance() instanceof TableDataProvider && prop.getPropertyDescriptor().getDisplayName().equals("CachedRowSet") && !this.dataProviderList.keySet().contains(prop.getDesignBean())) {
            TableDataProviderDesignState tableDataProviderDesignState;
            this.currentTableDataProviderDesignState = tableDataProviderDesignState = new TableDataProviderDesignState(prop.getDesignBean());
            tableDataProviderDesignState.initialize();
            this.dataProviderList.put(prop.getDesignBean(), tableDataProviderDesignState);
            this.dataProviderComboBoxModel.addElement(prop.getDesignBean());
            this.setTableDataProviderDesignState(this.currentTableDataProviderDesignState);
            this.cbxTableDataprovider.setSelectedItem(prop.getDesignBean());
        }
    }

    public void beanChanged(DesignBean designBean) {
    }

    public void contextActivated(DesignContext context) {
    }

    public void contextDeactivated(DesignContext context) {
    }

    public void contextChanged(DesignContext context) {
    }

    public void beanDeleted(DesignBean designBean) {
    }

    public void beanMoved(DesignBean designBean, DesignBean oldParent, Position pos) {
    }

    public void beanContextActivated(DesignBean designBean) {
    }

    public void beanContextDeactivated(DesignBean designBean) {
    }

    public void eventChanged(DesignEvent event) {
    }

    class DPComboRenderer
    extends DefaultListCellRenderer {
        DPComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DesignBean) {
                DesignBean dataProviderBean = (DesignBean)value;
                if (!((TableDataProviderDesignState)TableBindToDataPanel.this.dataProviderList.get(dataProviderBean)).isBroken()) {
                    this.setText("<html><p><b>" + dataProviderBean.getInstanceName() + "</b>  &nbsp; (<i>" + dataProviderBean.getDesignContext().getDisplayName() + "</i>)</P></html>");
                } else {
                    this.setText("<html><P><font color=\"#FF0000\"><b>" + dataProviderBean.getInstanceName() + "</b></font>  &nbsp; (<i>" + dataProviderBean.getDesignContext().getDisplayName() + "</i>)</p></html>");
                }
            }
            return this;
        }
    }
}

