/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.util;

import com.sun.rave.designtime.CategoryDescriptor;
import com.sun.rave.faces.event.Action;
import com.sun.rave.propertyeditors.SelectOneDomainEditor;
import com.sun.webui.jsf.component.util.DesignMessageUtil;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesignUtil {
    private static Pattern numericalSuffixPattern = Pattern.compile("\\d*$");

    public static String getNumericalSuffix(String name) {
        Matcher matcher = numericalSuffixPattern.matcher(name);
        matcher.find();
        return matcher.group();
    }

    public static void updateInputEventSetDescriptors(BeanInfo beanInfo) {
        EventSetDescriptor[] eventSetDescriptors = beanInfo.getEventSetDescriptors();
        if (eventSetDescriptors != null) {
            for (EventSetDescriptor descriptor : eventSetDescriptors) {
                if (descriptor.getName().equals("validate")) {
                    descriptor.setValue("defaultEventBody", DesignMessageUtil.getMessage(beanInfo.getClass(), "validateHandler"));
                    descriptor.setValue("parameterNames", new String[]{"context", "component", "value"});
                }
                if (!descriptor.getName().equals("valueChange")) continue;
                descriptor.setValue("parameterNames", new String[]{"event"});
            }
        }
    }

    public static EventSetDescriptor[] generateCommandEventSetDescriptors(BeanInfo beanInfo) {
        try {
            PropertyDescriptor actionDescriptor = null;
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length && actionDescriptor == null; ++i) {
                if (!propertyDescriptors[i].getName().equals("actionExpression")) continue;
                actionDescriptor = propertyDescriptors[i];
            }
            EventSetDescriptor actionEventDescriptor = new EventSetDescriptor("action", Action.class, new Method[]{Action.class.getMethod("action", new Class[0])}, null, null);
            actionEventDescriptor.setDisplayName(DesignMessageUtil.getMessage(DesignUtil.class, "DesignUtil.event.action"));
            actionEventDescriptor.setValue("bindingProperty", actionDescriptor);
            actionEventDescriptor.setShortDescription(actionDescriptor.getShortDescription());
            actionEventDescriptor.setValue("defaultEventBody", DesignMessageUtil.getMessage(beanInfo.getClass(), "actionHandler"));
            return new EventSetDescriptor[]{actionEventDescriptor};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void hideProperties(BeanInfo beanInfo, String[] hide) {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        block0: for (int i = 0; i < descriptors.length; ++i) {
            for (int h = 0; h < hide.length; ++h) {
                if (!descriptors[i].getName().equals(hide[h])) continue;
                descriptors[i].setHidden(true);
                continue block0;
            }
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(BeanInfo beanInfo, String name) {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!name.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        return null;
    }

    public static void applyPropertyCategoryAndEditor(BeanInfo beanInfo, String name, CategoryDescriptor category, String editor) {
        PropertyDescriptor propertyDescriptor = DesignUtil.getPropertyDescriptor(beanInfo, name);
        if (propertyDescriptor == null) {
            System.err.println("com.sun.webui.jsf.component.util.DesignUtil.applyPropertyCategoryAndEditor: Warning: could not find property " + name + " for beanInfo " + beanInfo.getClass().getName());
            return;
        }
        if (category != null) {
            propertyDescriptor.setValue("category", category);
        }
        if (editor != null) {
            propertyDescriptor.setPropertyEditorClass(DesignUtil.loadClass(editor));
        }
    }

    public static void applyPropertyCategory(BeanInfo beanInfo, String name, CategoryDescriptor category) {
        DesignUtil.applyPropertyCategoryAndEditor(beanInfo, name, category, null);
    }

    public static void applyPropertyDomain(BeanInfo beaninfo, String name, Class domainClass) {
        PropertyDescriptor p = DesignUtil.getPropertyDescriptor(beaninfo, name);
        if (p != null) {
            p.setPropertyEditorClass(SelectOneDomainEditor.class);
            p.setValue("com.sun.rave.propertyeditors.DOMAIN_CLASS", domainClass);
        }
    }

    private static Class loadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseStyle(String styleValue, String attribute, String defaultValue) {
        if (styleValue == null || attribute == null || defaultValue == null) {
            return null;
        }
        String temp = styleValue.trim().toLowerCase();
        if ((temp = temp.replaceAll("-" + attribute, "!!!!!!!")).indexOf(attribute) == -1) {
            StringBuilder sb = new StringBuilder();
            temp = styleValue.charAt(styleValue.length() - 1) == ';' ? sb.append(styleValue).append(" ").append(defaultValue).toString() : sb.append(styleValue).append("; ").append(defaultValue).toString();
            return temp;
        }
        return styleValue;
    }
}

