/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.util.DesignMessageUtil;
import com.sun.webui.jsf.renderkit.html.AbstractDesignTimeRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class FieldDesignTimeRenderer
extends AbstractDesignTimeRenderer {
    public FieldDesignTimeRenderer(Renderer renderer) {
        super(renderer);
    }

    protected String getShadowText(FacesContext context, Field field) {
        return DesignMessageUtil.getMessage(FieldDesignTimeRenderer.class, "field.readOnly.value");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Field field = (Field)component;
        if (field.isReadOnly()) {
            UIComponent label;
            ResponseWriter writer = context.getResponseWriter();
            Object value = field.getText();
            writer.startElement("span", (UIComponent)field);
            writer.writeAttribute("id", (Object)field.getId(), "id");
            String style = field.getStyle();
            if (style != null && style.length() > 0) {
                writer.writeAttribute("style", (Object)style, null);
            }
            String styleClass = field.getStyleClass();
            StringBuffer styleClassBuffer = new StringBuffer();
            if (styleClass != null) {
                styleClassBuffer.append(styleClass);
            }
            if ((label = field.getLabelComponent(context, "")) != null) {
                writer.writeAttribute("class", (Object)styleClassBuffer.toString(), null);
                styleClassBuffer.setLength(0);
                RenderingUtilities.renderComponent((UIComponent)label, (FacesContext)context);
                Theme theme = ThemeUtilities.getTheme((FacesContext)context);
                Icon icon = ThemeUtilities.getIcon((Theme)theme, (String)"DOT");
                icon.setId(component.getId().concat("_spacer"));
                icon.setHeight(1);
                icon.setWidth(10);
                RenderingUtilities.renderComponent((UIComponent)icon, (FacesContext)context);
                writer.startElement("span", (UIComponent)field);
                writer.writeAttribute("id", (Object)field.getId().concat("_readOnly"), "id");
            }
            if (value == null) {
                if (styleClassBuffer.length() > 0) {
                    styleClassBuffer.append(' ');
                }
                styleClassBuffer.append(UNINITITIALIZED_STYLE_CLASS);
                writer.writeAttribute("class", (Object)styleClassBuffer.toString(), null);
                writer.writeText((Object)this.getShadowText(context, field), null);
            } else {
                String stringValue = this.getTextValue(field, value);
                writer.writeAttribute("class", (Object)styleClassBuffer.toString(), null);
                writer.writeText((Object)stringValue, null);
            }
            writer.endElement("span");
        } else {
            super.encodeBegin(context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Field field = (Field)component;
        if (!field.isReadOnly()) {
            super.encodeEnd(context, component);
        }
    }

    protected String getTextValue(Field field, Object value) {
        String stringValue = ConversionUtilities.convertValueToString((UIComponent)field, (Object)value);
        return stringValue;
    }
}

