/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.railsprojects.MigrateAction;
import org.netbeans.modules.ruby.railsprojects.RailsFileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerManager;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.GotoTest;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.TestNotifier;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunner;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class RailsActionProvider
implements ActionProvider,
ScriptDescProvider {
    public static final String COMMAND_RDOC = "rdoc";
    public static final String COMMAND_AUTOTEST = "autotest";
    public static final String COMMAND_RAILS_CONSOLE = "rails-console";
    public static final String COMMAND_RSPEC = "rspec";
    private static final String TEST_TASK_NAME = "test";
    private static final String RSPEC_TASK_NAME = "spec";
    private static final String[] supportedActions = new String[]{"autotest", "rdoc", "rails-console", "run", "run.single", "debug", "debug.single", "test", "rspec", "test.single", "debug.test.single", "delete", "copy", "move", "rename"};
    RailsProject project;
    private final UpdateHelper updateHelper;
    final Set<String> bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single"));
    private static final Logger LOGGER = Logger.getLogger(RailsActionProvider.class.getName());

    public RailsActionProvider(RailsProject railsProject, UpdateHelper updateHelper) {
        this.updateHelper = updateHelper;
        this.project = railsProject;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    private RubyPlatform getPlatform() {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        if (rubyPlatform == null) {
            rubyPlatform = RubyPlatformManager.getDefaultPlatform();
        }
        return rubyPlatform;
    }

    private boolean isMigrationFile(FileObject fileObject) {
        if (fileObject.getParent() == null || !fileObject.getParent().getName().equals("migrate")) {
            return false;
        }
        if (fileObject.getParent().getParent() == null || !fileObject.getParent().getParent().getName().equals("db")) {
            return false;
        }
        if (!fileObject.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        return MigrateAction.getMigrationVersion(fileObject.getName()) != null;
    }

    private FileObject getCurrentFile(Lookup lookup) {
        FileObject fileObject = null;
        FileObject[] fileObjectArray = this.findSources(lookup);
        if (fileObjectArray != null && fileObjectArray.length > 0) {
            fileObject = fileObjectArray[0];
        } else {
            for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
                FileObject fileObject2 = dataObject.getPrimaryFile();
                if (!fileObject2.getMIMEType().equals("text/x-ruby")) continue;
                fileObject = fileObject2;
                break;
            }
        }
        return fileObject;
    }

    private void saveFile(FileObject fileObject) {
        try {
            SaveCookie saveCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        boolean bl = "debug".equals(string);
        boolean bl2 = "debug.single".equals(string);
        if ("run".equals(string) || bl) {
            LifecycleManager.getDefault().saveAll();
            this.runServer("", bl);
            return;
        }
        if (TEST_TASK_NAME.equals(string)) {
            boolean bl3;
            TestRunner testRunner = this.getTestRunner(TestRunner.TestType.TEST_UNIT);
            boolean bl4 = bl3 = RakeSupport.getRakeTask((Project)this.project, (String)TEST_TASK_NAME) != null;
            if (bl3) {
                File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setPWD(file);
                rakeRunner.setFileLocator((RubyFileLocator)new RailsFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.setDebug("debug.single".equals(string));
                rakeRunner.run(new String[]{TEST_TASK_NAME});
            } else if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if ("test.single".equals(string) || "debug.test.single".equals(string)) {
            if (!RubyPlatform.platformFor((Project)this.project).isValidRuby(true)) {
                return;
            }
            FileObject fileObject = this.getCurrentFile(lookup);
            if (fileObject == null) {
                return;
            }
            this.saveFile(fileObject);
            DeclarationFinder.DeclarationLocation declarationLocation = new GotoTest().findTest(fileObject, -1);
            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                fileObject = declarationLocation.getFileObject();
                this.saveFile(fileObject);
            } else if (RubyUtils.isRhtmlFile((FileObject)fileObject)) {
                return;
            }
            boolean bl5 = "debug.test.single".equals(string);
            RSpecSupport rSpecSupport = new RSpecSupport((Project)this.project);
            if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)fileObject)) {
                TestRunner testRunner = this.getTestRunner(TestRunner.TestType.RSPEC);
                if (testRunner != null) {
                    testRunner.runTest(fileObject, bl5);
                } else {
                    rSpecSupport.runRSpec(null, fileObject, fileObject.getName(), (FileLocator)new RailsFileLocator(lookup, (Project)this.project), true, bl5, new String[0]);
                }
                return;
            }
            TestRunner testRunner = this.getTestRunner(TestRunner.TestType.TEST_UNIT);
            if (testRunner != null) {
                testRunner.getInstance().runTest(fileObject, bl5);
            } else {
                this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl5, new OutputRecognizer[]{new TestNotifier(true, true)});
            }
            return;
        }
        if ("run.single".equals(string) || bl2) {
            if (!RubyPlatform.platformFor((Project)this.project).isValidRuby(true)) {
                return;
            }
            FileObject fileObject = this.getCurrentFile(lookup);
            if (fileObject == null) {
                return;
            }
            if (RakeSupport.isRakeFile((FileObject)fileObject)) {
                LifecycleManager.getDefault().saveAll();
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setRakeFile(fileObject);
                rakeRunner.setFileLocator((RubyFileLocator)new RailsFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.setDebug("debug.single".equals(string));
                rakeRunner.run(new String[0]);
                return;
            }
            RSpecSupport rSpecSupport = new RSpecSupport((Project)this.project);
            if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)fileObject)) {
                TestRunner testRunner = this.getTestRunner(TestRunner.TestType.RSPEC);
                boolean bl6 = "debug.single".equals(string);
                if (testRunner != null) {
                    testRunner.runTest(fileObject, bl6);
                } else {
                    LifecycleManager.getDefault().saveAll();
                    rSpecSupport.runRSpec(null, fileObject, fileObject.getName(), (FileLocator)new RailsFileLocator(lookup, (Project)this.project), true, bl2, new String[0]);
                }
                return;
            }
            this.saveFile(fileObject);
            if (this.isMigrationFile(fileObject)) {
                String string2 = fileObject.getName();
                Long l = MigrateAction.getMigrationVersion(string2);
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setPWD(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
                rakeRunner.setFileLocator((RubyFileLocator)new RailsFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.setParameters(new String[]{"VERSION=" + l});
                rakeRunner.run(new String[]{"db:migrate"});
                return;
            }
            String string3 = "";
            String string4 = fileObject.getName();
            if (fileObject.getExt().equals("rhtml") || fileObject.getExt().equals("erb")) {
                if (string4.endsWith(".html")) {
                    string4 = string4.substring(0, string4.length() - ".html".length());
                }
                if (!string4.startsWith("_")) {
                    string3 = string4;
                }
                FileObject fileObject2 = this.project.getProjectDirectory();
                for (FileObject fileObject3 = fileObject.getParent(); fileObject3 != null && fileObject3 != fileObject2 && (!fileObject3.getName().equals("views") || fileObject3.getParent() != null && !fileObject3.getParent().getName().equals("app")); fileObject3 = fileObject3.getParent()) {
                    string3 = fileObject3.getNameExt() + "/" + string3;
                }
            } else if (string4.endsWith("_controller")) {
                String string5;
                int n;
                FileObject fileObject4;
                FileObject fileObject5;
                string3 = string4.substring(0, string4.length() - "_controller".length());
                FileObject fileObject6 = this.project.getProjectDirectory();
                for (fileObject5 = fileObject.getParent(); fileObject5 != null && fileObject5 != fileObject6; fileObject5 = fileObject5.getParent()) {
                    if (fileObject5.getName().equals("controllers") && (fileObject5.getParent() == null || fileObject5.getParent().getName().equals("app"))) {
                        fileObject5 = fileObject5.getParent();
                        break;
                    }
                    string3 = fileObject5.getNameExt() + "/" + string3;
                }
                JTextComponent jTextComponent = GsfUtilities.getOpenPane();
                if (fileObject5 != null && jTextComponent != null && jTextComponent.getCaret() != null && (fileObject4 = GsfUtilities.findFileObject((JTextComponent)jTextComponent)) != null && (n = jTextComponent.getCaret().getDot()) >= 0 && (string5 = AstUtilities.getMethodName((FileObject)fileObject, (int)n)) != null) {
                    string3 = string3 + "/" + string5;
                }
            } else if (string4.endsWith("_helper")) {
                string3 = string4.substring(0, string4.length() - "_helper".length());
                FileObject fileObject7 = this.project.getProjectDirectory();
                for (FileObject fileObject8 = fileObject.getParent(); fileObject8 != null && fileObject8 != fileObject7 && (!fileObject8.getName().equals("helpers") || fileObject8.getParent() != null && !fileObject8.getParent().getName().equals("app")); fileObject8 = fileObject8.getParent()) {
                    string3 = fileObject8.getNameExt() + "/" + string3;
                }
            } else if (string4.endsWith("_test")) {
                TestRunner testRunner = this.getTestRunner(TestRunner.TestType.TEST_UNIT);
                if (testRunner != null) {
                    testRunner.getInstance().runTest(fileObject, "debug.single".equals(string));
                } else {
                    this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl2, new OutputRecognizer[]{new TestNotifier(true, true)});
                }
                return;
            }
            if (string3.length() == 0) {
                this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, bl2, null);
                return;
            }
            this.runServer(string3, bl || bl2);
            return;
        }
        if (COMMAND_RDOC.equals(string)) {
            if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)true)) {
                return;
            }
            LifecycleManager.getDefault().saveAll();
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            Runnable runnable = new Runnable(){

                public void run() {
                    FileObject fileObject;
                    FileObject fileObject2 = RailsActionProvider.this.project.getProjectDirectory().getFileObject("doc/app");
                    if (fileObject2 != null && (fileObject = fileObject2.getFileObject("index.html")) != null) {
                        try {
                            URL uRL = FileUtil.toFile((FileObject)fileObject).toURI().toURL();
                            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().notify((Throwable)malformedURLException);
                        }
                    }
                }
            };
            RailsFileLocator railsFileLocator = new RailsFileLocator(lookup, (Project)this.project);
            String string6 = NbBundle.getMessage(RailsActionProvider.class, (String)"RakeDoc");
            new RubyExecution(new ExecutionDescriptor(this.getPlatform(), string6, file, RubyPlatform.gemManagerFor((Project)this.project).getRake()).additionalArgs(new String[]{"appdoc"}).postBuild(runnable).fileLocator((FileLocator)railsFileLocator).addStandardRecognizers(), this.project.evaluator().getProperty("source.encoding")).run();
            return;
        }
        if (COMMAND_RSPEC.equals(string)) {
            boolean bl7 = RakeSupport.getRakeTask((Project)this.project, (String)RSPEC_TASK_NAME) != null;
            TestRunner testRunner = this.getTestRunner(TestRunner.TestType.RSPEC);
            if (bl7) {
                File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                RakeRunner rakeRunner = new RakeRunner((Project)this.project);
                rakeRunner.setPWD(file);
                rakeRunner.setFileLocator(new RubyFileLocator(lookup, (Project)this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.run(new String[]{RSPEC_TASK_NAME});
            } else if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if (COMMAND_AUTOTEST.equals(string)) {
            if (AutoTestSupport.isInstalled((Project)this.project)) {
                AutoTestSupport autoTestSupport = new AutoTestSupport(lookup, (Project)this.project, this.project.evaluator().getProperty("source.encoding"));
                autoTestSupport.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                autoTestSupport.start();
            }
            return;
        }
        if (COMMAND_RAILS_CONSOLE.equals(string)) {
            this.openRailsConsole(lookup);
            return;
        }
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
    }

    private void openRailsConsole(Lookup lookup) {
        String string = NbBundle.getMessage(RailsActionProvider.class, (String)"RailsConsole");
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String string2 = "script" + File.separator + "console";
        String string3 = this.project.evaluator().getProperty("javac.classpath");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Utilities.isWindows() && !this.getPlatform().isJRuby()) {
            arrayList.add("--irb=irb.bat --noreadline");
        } else {
            arrayList.add("--irb=irb --noreadline");
        }
        String string4 = this.project.evaluator().getProperty("rails.env");
        if (string4 != null && !"".equals(string4.trim())) {
            arrayList.add(string4);
        }
        new RubyExecution(new ExecutionDescriptor(this.getPlatform(), string, file, string2).showSuspended(false).showProgress(false).classPath(string3).allowInput().additionalArgs(arrayList.toArray(new String[arrayList.size()])).fileLocator((FileLocator)new RailsFileLocator(lookup, (Project)this.project)).addStandardRecognizers(), this.project.evaluator().getProperty("source.encoding")).run();
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
        if (topComponent != null) {
            topComponent.requestActive();
        } else {
            LOGGER.info("Could not find the output window using id output");
        }
    }

    private void runRubyScript(FileObject fileObject, String string, String string2, Lookup lookup, boolean bl, OutputRecognizer[] outputRecognizerArray) {
        if (!this.getPlatform().showWarningIfInvalid()) {
            return;
        }
        ExecutionDescriptor executionDescriptor = this.getScriptDescriptor(null, fileObject, string, string2, lookup, bl, outputRecognizerArray);
        RubyExecution rubyExecution = new RubyExecution(executionDescriptor, this.project.evaluator().getProperty("source.encoding"));
        rubyExecution.run();
    }

    public ExecutionDescriptor getScriptDescriptor(File file, FileObject fileObject, String string, String string2, Lookup lookup, boolean bl, OutputRecognizer[] outputRecognizerArray) {
        String string3 = SharedRubyProjectProperties.getRubyOptions((RubyBaseProject)this.project);
        String string4 = RubyProjectUtil.getLoadPath((Project)this.project);
        string3 = string3 != null ? string4 + " " + string3 : string4;
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        if (!new File(string).exists() && fileObjectArray != null && fileObjectArray.length > 0) {
            FileObject fileObject2;
            boolean bl2 = false;
            for (FileObject fileObject3 : fileObjectArray) {
                fileObject2 = fileObject3.getFileObject(string);
                if (fileObject2 == null) continue;
                string = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
                bl2 = true;
                break;
            }
            if (!bl2 && fileObjectArray2 != null) {
                for (FileObject fileObject3 : fileObjectArray2) {
                    fileObject2 = fileObject3.getFileObject(string);
                    if (fileObject2 == null) continue;
                    string = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
                    break;
                }
            }
        }
        if (file == null) {
            file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        String string5 = this.project.evaluator().getProperty("javac.classpath");
        String string6 = this.project.evaluator().getProperty("jvm.args");
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor(this.getPlatform(), string2, file, string);
        executionDescriptor.debug(bl);
        executionDescriptor.showSuspended(true);
        executionDescriptor.allowInput();
        executionDescriptor.initialArgs(string3);
        executionDescriptor.jvmArguments(string6);
        executionDescriptor.classPath(string5);
        executionDescriptor.additionalArgs(this.getApplicationArguments());
        executionDescriptor.fileLocator((FileLocator)new RailsFileLocator(lookup, (Project)this.project));
        executionDescriptor.addStandardRecognizers();
        executionDescriptor.addOutputRecognizer((OutputRecognizer)RubyExecution.RUBY_TEST_OUTPUT);
        if (outputRecognizerArray != null) {
            for (OutputRecognizer outputRecognizer : outputRecognizerArray) {
                executionDescriptor.addOutputRecognizer(outputRecognizer);
            }
        }
        return executionDescriptor;
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        return this.getPlatform() != null;
    }

    private FileObject[] findSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = RailsActionProvider.findSelectedFiles(lookup, fileObjectArray[i], "text/x-ruby", true);
            if (fileObjectArray2 != null) {
                return fileObjectArray2;
            }
            fileObjectArray2 = RailsActionProvider.findSelectedFiles(lookup, fileObjectArray[i], "application/x-httpd-eruby", true);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    static FileObject[] findSelectedFiles(Lookup lookup, FileObject fileObject, String string, boolean bl) {
        if (fileObject != null && !fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject);
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            boolean bl2;
            FileObject fileObject2 = dataObject.getPrimaryFile();
            boolean bl3 = bl2 = FileUtil.toFile((FileObject)fileObject2) != null;
            if (fileObject != null) {
                bl2 &= FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject == fileObject2;
            }
            if (string != null) {
                bl2 &= fileObject2.getMIMEType().equals(string);
            }
            if (bl2) {
                linkedHashSet.add(fileObject2);
                continue;
            }
            if (!bl) continue;
            return null;
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        return linkedHashSet.toArray(new FileObject[linkedHashSet.size()]);
    }

    private String[] getApplicationArguments() {
        String string = this.project.evaluator().getProperty("application.args");
        return string == null || string.trim().length() == 0 ? null : Utilities.parseParameters((String)string);
    }

    private void runServer(String string, boolean bl) {
        if (!bl) {
            this.runServer(string, false, false);
        } else {
            boolean bl2;
            boolean bl3;
            if (!WebClientToolsSessionStarterService.isAvailable()) {
                bl3 = false;
                bl2 = true;
            } else {
                boolean bl4 = WebClientToolsProjectUtils.showDebugDialog((Project)this.project);
                if (!bl4) {
                    return;
                }
                bl2 = WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project);
                bl3 = WebClientToolsProjectUtils.getClientDebugProperty((Project)this.project);
            }
            assert (bl2 || bl3);
            this.runServer(string, bl2, bl3);
        }
    }

    private void runServer(String string, boolean bl, boolean bl2) {
        RailsServerManager railsServerManager = (RailsServerManager)this.project.getLookup().lookup(RailsServerManager.class);
        if (railsServerManager != null) {
            railsServerManager.setDebug(bl);
            railsServerManager.setClientDebug(bl2);
            railsServerManager.showUrl(string);
        }
    }

    private TestRunner getTestRunner(TestRunner.TestType testType) {
        Collection collection = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner testRunner : collection) {
            if (!testRunner.supports(testType)) continue;
            return testRunner;
        }
        return null;
    }
}

