/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final RailsProject project;

    public RailsProjectOperations(RailsProject railsProject) {
        this.project = railsProject;
    }

    private static void addFile(FileObject fileObject, String string, Set<FileObject> set) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            set.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        RailsProjectOperations.addFile(fileObject, "nbproject", linkedHashSet);
        RailsProjectOperations.addFile(fileObject, "build.xml", linkedHashSet);
        RailsProjectOperations.addFile(fileObject, "xml-resources", linkedHashSet);
        RailsProjectOperations.addFile(fileObject, "catalog.xml", linkedHashSet);
        return new ArrayList<FileObject>(linkedHashSet);
    }

    public List<FileObject> getDataFiles() {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        linkedHashSet.addAll(Arrays.asList(this.project.getSourceRoots().getRoots()));
        linkedHashSet.addAll(Arrays.asList(this.project.getTestSourceRoots().getRoots()));
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "app", linkedHashSet);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "tmp", linkedHashSet);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "test", linkedHashSet);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "README", linkedHashSet);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "Rakefile", linkedHashSet);
        return new ArrayList<FileObject>(linkedHashSet);
    }

    public void notifyDeleting() throws IOException {
        this.project.notifyDeleting();
    }

    public void notifyDeleted() throws IOException {
        this.project.getRakeProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(file);
        this.project.setName(string);
    }

    public void notifyMoving() throws IOException {
        if (!this.project.getUpdateHelper().requestSave()) {
            throw new IOException(NbBundle.getMessage(RailsProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, String string) {
        if (project == null) {
            this.project.getRakeProjectHelper().notifyDeleted();
            return;
        }
        this.project.setName(string);
        this.project.getReferenceHelper().fixReferences(file);
    }
}

