/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.database.RailsJdbcConnection;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class ConfigurableRailsAdapter
implements RailsDatabaseConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ConfigurableRailsAdapter.class.getName());
    private final RailsDatabaseConfiguration delegate;
    private final String userName;
    private final String password;
    private final String database;
    private final boolean jdbc;

    public ConfigurableRailsAdapter(RailsDatabaseConfiguration railsDatabaseConfiguration, String string, String string2, String string3, boolean bl) {
        this.delegate = railsDatabaseConfiguration;
        this.userName = string;
        this.password = string2;
        this.database = string3;
        this.jdbc = bl;
    }

    public String railsGenerationParam() {
        return this.delegate.railsGenerationParam();
    }

    public void editConfig(RailsProject railsProject) {
        this.delegate.editConfig(railsProject);
        this.edit(railsProject.getProjectDirectory());
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (this.jdbc && jdbcInfo != null) {
            RailsJdbcConnection.bundleDrivers(railsProject, jdbcInfo.getDriverClass());
        }
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    private void changeAttribute(Document document, String string, String string2, String string3) throws BadLocationException {
        Parameters.notWhitespace((CharSequence)"attributeName", (CharSequence)string);
        if (string2 == null || "".equals(string2.trim())) {
            return;
        }
        String string4 = document.getText(0, document.getLength());
        int n = string4.indexOf(string);
        if (n == -1) {
            if (string3 != null) {
                RailsAdapters.addProperty(document, string, string2, string3);
            } else {
                return;
            }
        }
        int n2 = n + string.length();
        int n3 = 0;
        for (int i = n2; i < string4.length() && string4.charAt(i) != '\n'; ++i) {
            ++n3;
        }
        document.remove(n2, n3);
        document.insertString(n2, string2 != null ? " " + string2 : "", null);
    }

    private void edit(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("config/database.yml");
        if (fileObject2 != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    this.setDatabase(styledDocument);
                    this.changeAttribute(styledDocument, "username:", this.userName, "url:");
                    this.changeAttribute(styledDocument, "password:", this.password, "username:");
                    this.handleTestAndProduction(styledDocument);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void handleTestAndProduction(Document document) throws BadLocationException {
        String string = this.getText(document);
        int n = string.indexOf("development:\n");
        int n2 = string.indexOf("test:\n");
        if (n2 == -1) {
            LOGGER.warning("Could not find 'test:' in database.yml. Its content is: " + string);
            return;
        }
        document.remove(n2, document.getLength() - n2);
        String string2 = document.getText(n, n2 - n);
        String string3 = !this.isEmpty(this.database) ? this.database : RailsAdapters.getPropertyValue(document, "database:");
        PlainDocument plainDocument = new PlainDocument();
        String string4 = string2.replace("development:\n", "test:\n");
        int n3 = string4.lastIndexOf("# Warning: The database defined as \"test\" will be erased");
        if (n3 != -1) {
            string4 = string4.substring(0, n3);
        }
        plainDocument.insertString(0, string4, null);
        this.changeDatabase(plainDocument, this.getTestDatabaseName(string3));
        PlainDocument plainDocument2 = new PlainDocument();
        String string5 = string4.replace("test:\n", "production:\n");
        plainDocument2.insertString(0, string5, null);
        this.changeDatabase(plainDocument2, this.getProductionDatabaseName(string3));
        document.insertString(document.getLength(), this.getText(plainDocument) + this.getText(plainDocument2), null);
    }

    private void changeDatabase(Document document, String string) throws BadLocationException {
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (!this.jdbc || jdbcInfo == null) {
            this.changeAttribute(document, "database:", string, null);
        } else {
            this.changeAttribute(document, "url:", jdbcInfo.getURL("localhost", string), "adapter:");
        }
    }

    private String getText(Document document) throws BadLocationException {
        return document.getText(0, document.getLength());
    }

    private void setDatabase(Document document) throws BadLocationException {
        JdbcInfo jdbcInfo = this.getJdbcInfo();
        if (!this.jdbc || jdbcInfo == null) {
            this.changeAttribute(document, "database:", this.database, null);
            return;
        }
        String string = !this.isEmpty(this.database) ? this.database : RailsAdapters.getPropertyValue(document, "database:");
        this.changeAttribute(document, "adapter:", "jdbc", null);
        RailsAdapters.addProperty(document, "url:", jdbcInfo.getURL("localhost", string), "adapter:");
        RailsAdapters.addProperty(document, "driver:", jdbcInfo.getDriverClass(), "adapter:");
        RailsAdapters.removeProperty(document, "database:");
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    public JdbcInfo getJdbcInfo() {
        return this.delegate.getJdbcInfo();
    }

    public String getDatabaseName(String string) {
        return this.delegate.getDatabaseName(string);
    }

    public String getTestDatabaseName(String string) {
        return this.delegate.getTestDatabaseName(string);
    }

    public String getProductionDatabaseName(String string) {
        return this.delegate.getProductionDatabaseName(string);
    }
}

