/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

class JavaDBAdapter
implements RailsDatabaseConfiguration {
    JavaDBAdapter() {
    }

    public String railsGenerationParam() {
        return null;
    }

    public String getDisplayName() {
        return "javadb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editConfig(RailsProject railsProject) {
        FileObject fileObject = railsProject.getProjectDirectory().getFileObject("config/database.yml");
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)railsProject);
        if (fileObject != null) {
            BaseDocument baseDocument = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    if (styledDocument instanceof BaseDocument) {
                        baseDocument = (BaseDocument)styledDocument;
                        baseDocument.atomicLock();
                    }
                    styledDocument.remove(0, styledDocument.getLength());
                    String string = "# JavaDB Setup\n#\n# You may need to copy derby.jar into\n#  TODO: location " + rubyPlatform.getLibDir() + "\n" + "# With Java SE 6 and later this is not necessary.\n" + "development:\n" + "  adapter: derby\n" + "  database: db/development.db\n" + "\n" + "# Warning: The database defined as 'test' will be erased and\n" + "# re-generated from your development database when you run 'rake'.\n" + "# Do not set this db to the same as development or production.\n" + "test:\n" + "  adapter: derby\n" + "  database: db/test.db\n" + "\n" + "production:\n" + "  adapter: derby\n" + "  database: db/production.db\n";
                    styledDocument.insertString(0, string, null);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (baseDocument != null) {
                    baseDocument.atomicUnlock();
                }
            }
        }
    }

    public JdbcInfo getJdbcInfo() {
        return new JdbcInfo(){

            public String getDriverClass() {
                return "org.apache.derby.jdbc.ClientDriver";
            }

            public String getURL(String string, String string2) {
                return "jdbc:derby://" + string + ":1527/" + string2;
            }
        };
    }

    public String getDatabaseName(String string) {
        return "db/development.db";
    }

    public String getTestDatabaseName(String string) {
        return "db/test.db";
    }

    public String getProductionDatabaseName(String string) {
        return "db/production.db";
    }
}

