/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.JdbcConnectionsPanel;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.RailsAdaptersPanel;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DatabaseConfigPanelVisual
extends JPanel {
    private JdbcConnectionsPanel jdbcPanel;
    private RailsAdaptersPanel adaptersPanel;
    private boolean initialized;
    private JPanel adapterConfigurationPanel;
    private ButtonGroup configureOptionsButtonGroup;
    private JLabel databaseAccessConfLabel;
    private JPanel ideConnectionsPanel;
    private JSeparator jSeparator1;
    private JRadioButton useIDEConnections;
    private JCheckBox useJdbc;
    private JRadioButton useRailsAdapter;

    public DatabaseConfigPanelVisual() {
        this.initComponents();
        this.configureOptionsButtonGroup.add(this.useIDEConnections);
        this.configureOptionsButtonGroup.add(this.useRailsAdapter);
        this.jdbcPanel = new JdbcConnectionsPanel();
        this.adaptersPanel = new RailsAdaptersPanel();
        this.ideConnectionsPanel.add((Component)this.jdbcPanel, "Center");
        this.adapterConfigurationPanel.add((Component)this.adaptersPanel, "Center");
        this.setName(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"LAB_ConfigureDatabase"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"TXT_NewRoRApp"));
        this.initInnerPanels();
    }

    private boolean isJdbc() {
        return this.useJdbc.isSelected();
    }

    private boolean useIdeConnections() {
        return this.useIDEConnections.isSelected();
    }

    private SettingsPanel getActivePanel() {
        return this.useIdeConnections() ? this.jdbcPanel : this.adaptersPanel;
    }

    void read(WizardDescriptor wizardDescriptor) {
        RubyPlatform rubyPlatform = (RubyPlatform)wizardDescriptor.getProperty("platform");
        boolean bl = rubyPlatform.isJRuby();
        if (!this.initialized) {
            this.useIDEConnections.setSelected(bl);
            this.useRailsAdapter.setSelected(!bl);
            this.initialized = true;
        }
        if (!bl) {
            this.useJdbc.setSelected(false);
        }
        this.useJdbc.setEnabled(bl);
        this.jdbcPanel.read(wizardDescriptor);
        this.adaptersPanel.read(wizardDescriptor);
        this.initInnerPanels();
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("useJdbc", (Object)this.isJdbc());
        this.getActivePanel().store(wizardDescriptor);
    }

    private void initInnerPanels() {
        boolean bl = this.useIdeConnections();
        this.setEnabled(this.jdbcPanel, bl);
        this.setEnabled(this.adaptersPanel, !bl);
    }

    private void setEnabled(JPanel jPanel, boolean bl) {
        jPanel.setEnabled(bl);
        for (Component component : jPanel.getComponents()) {
            component.setEnabled(bl);
        }
    }

    private void initComponents() {
        this.configureOptionsButtonGroup = new ButtonGroup();
        this.ideConnectionsPanel = new JPanel();
        this.adapterConfigurationPanel = new JPanel();
        this.useIDEConnections = new JRadioButton();
        this.useRailsAdapter = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.useJdbc = new JCheckBox();
        this.databaseAccessConfLabel = new JLabel();
        this.setPreferredSize(null);
        this.ideConnectionsPanel.setLayout(new BorderLayout());
        this.adapterConfigurationPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.useIDEConnections, (String)NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"LBL_ConfigureUsingIDEConnections"));
        this.useIDEConnections.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseConfigPanelVisual.this.useIDEConnectionsActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.useRailsAdapter, (String)NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"LBL_ConfigureDirectly"));
        this.useRailsAdapter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseConfigPanelVisual.this.useRailsAdapterActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.useJdbc, (String)NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"UseJdbc"));
        Mnemonics.setLocalizedText((JLabel)this.databaseAccessConfLabel, (String)NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"LBL_DatabaseAccessInformation"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.useRailsAdapter, -1, -1, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.adapterConfigurationPanel, -1, 265, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jSeparator1, -1, 289, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.databaseAccessConfLabel, -1, 204, Short.MAX_VALUE).add(85, 85, 85)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.ideConnectionsPanel, -1, 277, Short.MAX_VALUE))).add(0, 0, 0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.useIDEConnections, -1, 245, Short.MAX_VALUE).add(32, 32, 32)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.useJdbc, -1, 277, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.databaseAccessConfLabel, -2, 17, -2).addPreferredGap(1).add((Component)this.useIDEConnections, -2, 22, -2).addPreferredGap(0).add((Component)this.ideConnectionsPanel, -1, 100, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.useRailsAdapter, -2, 22, -2).addPreferredGap(0).add((Component)this.adapterConfigurationPanel, -1, 114, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.useJdbc, -2, 22, -2)));
        this.useIDEConnections.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"ACSD_ConfigureUsingIDEConnections"));
        this.useRailsAdapter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"ACSD_ConfigureDirectly"));
        this.useJdbc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"ASCD_UseJdbc"));
        this.databaseAccessConfLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"ASCN_DatabaseAccessInformation"));
        this.databaseAccessConfLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"ASCD_DatabaseAccessInformation"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"ASCN_DatabaseConfigPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DatabaseConfigPanelVisual.class, (String)"ASCN_DatabaseConfigPanel"));
    }

    private void useIDEConnectionsActionPerformed(ActionEvent actionEvent) {
        this.initInnerPanels();
    }

    private void useRailsAdapterActionPerformed(ActionEvent actionEvent) {
        this.initInnerPanels();
    }
}

