/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculateName;
    private JButton jButton3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField projectLocation;
    private JTextField projectName;

    public PanelProjectLocationExtSrc(PanelConfigureProject panelConfigureProject) {
        this.firer = panelConfigureProject;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectName(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectName(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectName(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
        this.projectLocation.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectName() {
        if (this.calculateName) {
            File file;
            String string = this.projectLocation.getText().trim();
            if (string.length() > 0) {
                file = new File(string);
                try {
                    File file2 = file.getCanonicalFile();
                    if (file2 != null) {
                        file = file2;
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                this.projectName.setText(file.getName());
            }
            file = new File(this.projectLocation.getText());
            this.calculateName = true;
        }
    }

    private synchronized void setCalculateProjectName(boolean bl) {
        this.calculateName = bl;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        Object var2_2 = null;
        String string = null;
        File file = (File)wizardDescriptor.getProperty("projdir");
        if (file == null) {
            file = ProjectChooser.getProjectsFolder();
            this.projectLocation.setText(file.getAbsolutePath());
            this.setCalculateProjectName(true);
            this.calculateProjectName();
            this.setCalculateProjectName(true);
            string = this.projectName.getText();
        } else {
            string = (String)wizardDescriptor.getProperty("name");
            boolean bl = this.calculateName;
            this.projectLocation.setText(file.getAbsolutePath());
            this.setCalculateProjectName(bl);
        }
        this.projectLocation.selectAll();
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("name", (Object)this.projectName.getText());
        File file = new File(this.projectLocation.getText());
        wizardDescriptor.putProperty("projdir", (Object)file);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String string = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText(), this.projectLocation.getText());
        if (string == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return false;
    }

    static String checkValidity(String string, String string2) {
        if (string.length() == 0 || string.indexOf(47) > 0 || string.indexOf(92) > 0 || string.indexOf(58) > 0) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectName");
        }
        File file = new File(string2).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file) == null) {
            return NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
        }
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        if (file == null || !file.canWrite()) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderReadOnly");
        }
        File file2 = FileUtil.normalizeFile((File)new File(string2));
        File[] fileArray = file2.listFiles();
        boolean bl = false;
        if (file2.exists() && fileArray != null && fileArray.length > 0) {
            String string3 = null;
            for (int i = 0; i < fileArray.length; ++i) {
                String string4 = fileArray[i].getName();
                if ("nbproject".equals(string4)) {
                    string3 = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_NetBeansProject");
                } else if ("config".equals(string4)) {
                    bl = true;
                }
                if (string3 == null) continue;
                String string5 = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(string5, string3);
            }
        }
        if (!bl) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_NoRails");
        }
        return null;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.projectLocation = new JTextField();
        this.jButton3 = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_ProjectNameAndLocationLabel"));
        this.jLabel5.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_ProjectName_Label"));
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_BrowseLocation_Button3"));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel4, -2, 400, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel6).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectName, -1, 221, Short.MAX_VALUE).add((Component)this.projectLocation, -1, 221, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButton3)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jButton3).add((Component)this.projectLocation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.projectName, -2, -1, -2)).addContainerGap(40, Short.MAX_VALUE)));
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        this.jButton3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jPanel1"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void browseProjectLocation(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_SelectProjectLocation"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocation.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }
}

