/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.util.NbBundle;

class RailsInstallationValidator {
    private static final String RAILS_GEM_NAME = "rails";
    private static final String RAILS_COMMAND_NAME = "rails";

    RailsInstallationValidator() {
    }

    static RailsInstallationInfo getRailsInstallation(RubyPlatform rubyPlatform) {
        GemManager gemManager = rubyPlatform.getGemManager();
        if (gemManager == null) {
            return new RailsInstallationInfo(null, false, NbBundle.getMessage(RailsInstallationValidator.class, (String)"GemProblem"));
        }
        if (!rubyPlatform.isValidRuby(false)) {
            return new RailsInstallationInfo(null, false, NbBundle.getMessage(RailsInstallationValidator.class, (String)"NoRuby"));
        }
        boolean bl = false;
        String string = null;
        String string2 = gemManager.getLatestVersion("rails");
        if (string2 == null) {
            string = NbBundle.getMessage(RailsInstallationValidator.class, (String)"NoRails");
        } else {
            bl = gemManager.getRails() != null;
            string = bl ? NbBundle.getMessage(RailsInstallationValidator.class, (String)"RailsOk") : NbBundle.getMessage(RailsInstallationValidator.class, (String)"NotFound", (Object)"rails");
        }
        return new RailsInstallationInfo(string2, bl, string);
    }

    static class RailsInstallationInfo {
        private final String version;
        private final boolean valid;
        private final String message;

        public RailsInstallationInfo(String string, boolean bl, String string2) {
            if (bl && string == null) {
                throw new IllegalArgumentException("A valid Rails installation must have a version");
            }
            this.version = string;
            this.valid = bl;
            this.message = string2;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

