/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LaunchingDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-LaunchingDICookie";
    private LaunchingConnector launchingConnector;
    private Map<String, ? extends Connector.Argument> args;
    private String mainClassName;
    private boolean suspend;

    private LaunchingDICookie(LaunchingConnector launchingConnector, Map<String, ? extends Connector.Argument> map, String string, boolean bl) {
        this.launchingConnector = launchingConnector;
        this.args = map;
        this.mainClassName = string;
        this.suspend = bl;
    }

    public static LaunchingDICookie create(String string, String string2, String string3, boolean bl) {
        return new LaunchingDICookie(LaunchingDICookie.findLaunchingConnector(), LaunchingDICookie.getArgs(string2, string3), string, bl);
    }

    public static LaunchingDICookie create(String string, String[] stringArray, String string2, boolean bl) {
        String string3 = "";
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            string3 = string3 + " \"" + stringArray[i] + "\"";
        }
        String string4 = System.getProperty("java.home") + "\\bin\\java -Xdebug -Xnoagent -Xrunjdwp:transport=" + LaunchingDICookie.getTransportName() + ",address=name,suspend=" + (bl ? "y" : "n") + " -classpath \"" + string2 + "\" " + string + string3;
        String string5 = "name";
        return new LaunchingDICookie(LaunchingDICookie.findLaunchingConnector(), LaunchingDICookie.getArgs(string4, string5), string, bl);
    }

    public static String getTransportName() {
        return LaunchingDICookie.findLaunchingConnector().transport().name();
    }

    public String getClassName() {
        return this.mainClassName;
    }

    public boolean getSuspend() {
        return this.suspend;
    }

    public String getCommandLine() {
        Connector.Argument argument = this.args.get("command");
        if (argument == null) {
            return null;
        }
        return argument.value();
    }

    @Override
    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException, VMStartException {
        return this.launchingConnector.launch(this.args);
    }

    private static Map<String, ? extends Connector.Argument> getArgs(String string, String string2) {
        Map<String, Connector.Argument> map = LaunchingDICookie.findLaunchingConnector().defaultArguments();
        map.get("command").setValue(string);
        map.get("address").setValue(string2);
        return map;
    }

    private static LaunchingConnector findLaunchingConnector() {
        for (LaunchingConnector launchingConnector : Bootstrap.virtualMachineManager().launchingConnectors()) {
            if (launchingConnector.name().indexOf("RawCommandLineLaunch") <= -1) continue;
            return launchingConnector;
        }
        return null;
    }
}

