/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.AnyAttribute;
import org.netbeans.modules.xml.schema.model.AnyElement;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ComplexExtension;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xpath.ext.schema.AbstractSchemaSearchVisitor;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.XPathSchemaContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingSchemaSearchVisitor
extends AbstractSchemaSearchVisitor {
    private HashMap<String, ArrayList<SchemaModel>> mModelsCache = new HashMap();
    private XPathSchemaContext mParentContext;
    private String mySoughtName;
    private String mySoughtNamespace;
    private boolean isAttribute;
    private List<SchemaComponent> myFound = new ArrayList<SchemaComponent>();
    private boolean mHasAny = false;
    private boolean mHasAnyAttribute = false;
    private GlobalComplexType myGlobalComplexType;

    public List<SchemaComponent> getFound() {
        return this.myFound;
    }

    public boolean hasAny() {
        return this.mHasAny;
    }

    public boolean hasAnyAttribute() {
        return this.mHasAnyAttribute;
    }

    private boolean isChildFound() {
        return this.myFound.size() > 0;
    }

    public void lookForSubcomponent(XPathSchemaContext xPathSchemaContext, SchemaComponent schemaComponent, String string, String string2, boolean bl) {
        assert (string != null) : "At least sought name has to be specified!";
        this.myFound.clear();
        this.mParentContext = xPathSchemaContext;
        this.mySoughtName = string;
        this.mySoughtNamespace = string2;
        this.isAttribute = bl;
        this.lookForSubcomponentImpl(schemaComponent);
    }

    public void lookForSubcomponentImpl(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof org.netbeans.modules.xml.schema.model.Element) {
            if (schemaComponent instanceof TypeContainer) {
                LocalType localType;
                NamedComponentReference namedComponentReference = ((TypeContainer)schemaComponent).getType();
                if (namedComponentReference != null && (localType = this.resolve(schemaComponent, namedComponentReference, GlobalType.class, false)) != null) {
                    localType.accept((SchemaVisitor)this);
                }
                if ((localType = ((TypeContainer)schemaComponent).getInlineType()) != null) {
                    localType.accept((SchemaVisitor)this);
                }
            } else if (schemaComponent instanceof ElementReference) {
                NamedComponentReference namedComponentReference = ((ElementReference)schemaComponent).getRef();
                if (namedComponentReference != null) {
                    GlobalElement globalElement = this.resolve(schemaComponent, namedComponentReference, GlobalElement.class, true);
                    this.lookForSubcomponentImpl((SchemaComponent)globalElement);
                } else if (schemaComponent instanceof DocumentComponent) {
                    SchemaComponent schemaComponent2 = schemaComponent;
                    String string = schemaComponent2.getPeer().getAttribute("type");
                    if ((string = this.removePrefix(string)) == null || string.equals("")) {
                        NodeList nodeList = schemaComponent2.getPeer().getElementsByTagName("xs:extension");
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            if (!(node instanceof Element)) continue;
                            Element element = (Element)node;
                            this.findInType(element.getAttribute("base"), schemaComponent);
                            if (this.isChildFound()) break;
                        }
                        this.findElement(this.mySoughtName, (DocumentComponent)schemaComponent2, schemaComponent);
                    } else {
                        this.findInType(string, schemaComponent);
                    }
                }
            }
        } else if (schemaComponent instanceof ComplexType) {
            this.visitChildren(schemaComponent);
        } else if (schemaComponent instanceof Schema) {
            this.visitChildren(schemaComponent);
        }
    }

    @Override
    public void visit(ElementReference elementReference) {
        GlobalElement globalElement;
        NamedComponentReference namedComponentReference;
        if (!this.isXdmDomUsed((SchemaComponent)elementReference)) {
            this.checkComponent((SchemaComponent)elementReference);
        }
        if ((namedComponentReference = elementReference.getRef()) != null && (globalElement = this.resolve((SchemaComponent)elementReference, namedComponentReference, GlobalElement.class, true)) != null) {
            this.visit(globalElement);
        }
    }

    @Override
    public void visit(AttributeReference attributeReference) {
        GlobalAttribute globalAttribute;
        NamedComponentReference namedComponentReference;
        if (!this.isXdmDomUsed((SchemaComponent)attributeReference)) {
            this.checkComponent((SchemaComponent)attributeReference);
        }
        if ((namedComponentReference = attributeReference.getRef()) != null && (globalAttribute = this.resolve((SchemaComponent)attributeReference, namedComponentReference, GlobalAttribute.class, true)) != null) {
            this.visit(globalAttribute);
        }
    }

    @Override
    public void visit(AttributeGroupReference attributeGroupReference) {
        GlobalAttributeGroup globalAttributeGroup;
        NamedComponentReference namedComponentReference = attributeGroupReference.getGroup();
        if (namedComponentReference != null && (globalAttributeGroup = this.resolve((SchemaComponent)attributeGroupReference, namedComponentReference, GlobalAttributeGroup.class, false)) != null) {
            this.visit(globalAttributeGroup);
        }
    }

    @Override
    public void visit(GroupReference groupReference) {
        GlobalGroup globalGroup;
        NamedComponentReference namedComponentReference = groupReference.getRef();
        if (namedComponentReference != null && (globalGroup = this.resolve((SchemaComponent)groupReference, namedComponentReference, GlobalGroup.class, false)) != null) {
            this.visit(globalGroup);
        }
    }

    @Override
    public void visit(SimpleExtension simpleExtension) {
        GlobalType globalType;
        NamedComponentReference namedComponentReference = simpleExtension.getBase();
        if (namedComponentReference != null && (globalType = this.resolve((SchemaComponent)simpleExtension, namedComponentReference, GlobalType.class, false)) != null) {
            this.visitChildren((SchemaComponent)globalType);
        }
        this.visitChildren((SchemaComponent)simpleExtension);
    }

    @Override
    public void visit(ComplexExtension complexExtension) {
        GlobalType globalType;
        NamedComponentReference namedComponentReference = complexExtension.getBase();
        if (namedComponentReference != null && (globalType = this.resolve((SchemaComponent)complexExtension, namedComponentReference, GlobalType.class, false)) != null) {
            this.visitChildren((SchemaComponent)globalType);
        }
        this.visitChildren((SchemaComponent)complexExtension);
    }

    private <RefCls extends NamedReferenceable<SchemaComponent> & SchemaComponent> RefCls resolve(SchemaComponent schemaComponent, NamedComponentReference<? extends RefCls> namedComponentReference, Class<RefCls> clazz, boolean bl) {
        SchemaComponent schemaComponent2;
        SchemaModel schemaModel;
        String string = namedComponentReference.getRefString();
        String[] stringArray = string.split(":", 2);
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 1) {
            string3 = stringArray[0];
            if (bl && !this.mySoughtName.equals(string3)) {
                return null;
            }
            string2 = "";
        } else if (stringArray.length == 2) {
            string3 = stringArray[1];
            if (bl && !this.mySoughtName.equals(string3)) {
                return null;
            }
            string2 = stringArray[0];
        }
        ArrayList<Object> arrayList = null;
        String string4 = this.getNamespaceUri(schemaComponent, string2);
        if (string4 != null) {
            if (bl && this.mySoughtNamespace != null && !this.mySoughtNamespace.equals(string4)) {
                return null;
            }
            arrayList = this.mModelsCache.get(string4);
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    schemaModel = arrayList.get(i);
                    Schema schema = schemaModel.getSchema();
                    if (schema == null) continue;
                    List list = schema.getChildren();
                    Object object = list.iterator();
                    while (object.hasNext()) {
                        String string5;
                        SchemaComponent schemaComponent3 = (SchemaComponent)object.next();
                        if (!clazz.isInstance(schemaComponent3) || !(schemaComponent3 instanceof Named) || !string3.equals(string5 = ((Named)schemaComponent3).getName())) continue;
                        return (RefCls)((NamedReferenceable)clazz.cast(schemaComponent3));
                    }
                }
            }
        }
        if ((schemaComponent2 = (SchemaComponent)namedComponentReference.get()) == null) {
            return null;
        }
        schemaModel = schemaComponent2.getModel();
        if (schemaModel != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(schemaModel);
                this.mModelsCache.put(string4, arrayList);
            } else {
                boolean bl2 = false;
                for (Object object : arrayList) {
                    if (!object.equals(schemaModel)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    arrayList.add(schemaModel);
                }
            }
        }
        return (RefCls)((NamedReferenceable)clazz.cast(schemaComponent2));
    }

    private String getNamespaceUri(SchemaComponent schemaComponent, String string) {
        SchemaComponent schemaComponent2;
        Map map = ((AbstractDocumentComponent)schemaComponent).getPrefixes();
        String string2 = (String)map.get(string);
        if (string2 == null && (schemaComponent2 = (SchemaComponent)schemaComponent.getParent()) != null) {
            string2 = this.getNamespaceUri(schemaComponent2, string);
        }
        return string2;
    }

    private void findElement(String string, DocumentComponent documentComponent, SchemaComponent schemaComponent) {
        this.findElement(string, documentComponent, schemaComponent, "xs:element");
        this.findElement(string, documentComponent, schemaComponent, "xsd:element");
    }

    private void findElement(String string, DocumentComponent documentComponent, SchemaComponent schemaComponent, String string2) {
        if (string == null || string.equals("")) {
            return;
        }
        NodeList nodeList = documentComponent.getPeer().getElementsByTagName(string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equals((element = (Element)node).getAttribute("name"))) continue;
            this.myFound.add(schemaComponent);
            return;
        }
    }

    private String removePrefix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private void findInType(String string, SchemaComponent schemaComponent) {
        Schema schema = schemaComponent.getModel().getSchema();
        boolean bl = this.findInType(string, schemaComponent, schema);
        if (bl) {
            return;
        }
        Collection collection = schema.getImports();
        for (Import import_ : collection) {
            try {
                SchemaModel schemaModel = import_.resolveReferencedModel();
                bl = this.findInType(string, schemaComponent, schemaModel.getSchema());
                if (!bl) continue;
                return;
            }
            catch (CatalogModelException catalogModelException) {
            }
        }
    }

    private boolean findInType(final String string, SchemaComponent schemaComponent, Schema schema) {
        if (string == null || string.equals("")) {
            return false;
        }
        this.myGlobalComplexType = null;
        schema.accept((SchemaVisitor)new DeepSchemaVisitor(){

            public void visit(GlobalComplexType globalComplexType) {
                if (string.equals(globalComplexType.getName())) {
                    CachingSchemaSearchVisitor.this.myGlobalComplexType = globalComplexType;
                }
            }
        });
        if (this.myGlobalComplexType != null) {
            this.myGlobalComplexType.accept((SchemaVisitor)this);
            return true;
        }
        return false;
    }

    private String getName(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof Named) {
            return ((Named)schemaComponent).getName();
        }
        return "";
    }

    @Override
    protected void checkComponent(SchemaComponent schemaComponent) {
        Set<String> set;
        Object object;
        if (schemaComponent instanceof ElementReference && schemaComponent instanceof DocumentComponent) {
            object = schemaComponent;
            set = object.getPeer().getAttribute("ref");
            if (this.mySoughtName.equals(set = this.removePrefix((String)((Object)set)))) {
                this.addSchemaComponent(schemaComponent);
                return;
            }
        }
        if (schemaComponent instanceof Named && this.mySoughtName.equals(object = ((Named)schemaComponent).getName())) {
            if (this.mySoughtNamespace == null || this.mySoughtNamespace.length() == 0) {
                this.addSchemaComponent(schemaComponent);
            } else {
                set = XPathSchemaContext.Utilities.getEffectiveNamespaces(schemaComponent, this.mParentContext);
                if (set.contains(this.mySoughtNamespace)) {
                    this.addSchemaComponent(schemaComponent);
                }
            }
        }
        if (schemaComponent instanceof AnyElement) {
            this.mHasAny = true;
        }
        if (schemaComponent instanceof AnyAttribute) {
            this.mHasAnyAttribute = true;
        }
    }

    private void addSchemaComponent(SchemaComponent schemaComponent) {
        if (!(schemaComponent instanceof Named)) {
            this.myFound.add(schemaComponent);
            return;
        }
        boolean bl = true;
        for (SchemaComponent schemaComponent2 : this.myFound) {
            if (!(schemaComponent2 instanceof Named)) continue;
            String string = ((Named)schemaComponent2).getName();
            String string2 = ((Named)schemaComponent).getName();
            String string3 = null;
            String string4 = null;
            Set<String> set = XPathSchemaContext.Utilities.getEffectiveNamespaces(schemaComponent2, this.mParentContext);
            if (set != null && set.size() > 0) {
                string3 = set.iterator().next();
            }
            if ((set = XPathSchemaContext.Utilities.getEffectiveNamespaces(schemaComponent, this.mParentContext)) != null && set.size() > 0) {
                string4 = set.iterator().next();
            }
            if (string == null || !string.equals(string2) || !this.equals(string3, string4)) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.myFound.add(schemaComponent);
        }
    }

    private boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        return object == null || object2 == null ? false : object.equals(object2);
    }
}

