/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeTestType;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathAxis;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContextHolder;
import org.netbeans.modules.xml.xpath.ext.schema.resolver.SchemaCompHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface XPathSchemaContext {
    public XPathSchemaContext getParentContext();

    public Set<SchemaCompPair> getSchemaCompPairs();

    public Set<SchemaCompPair> getUsedSchemaCompPairs();

    public void setUsedSchemaCompH(Set<SchemaCompHolder> var1);

    public boolean isLastInChain();

    public void setLastInChain(boolean var1);

    public boolean equalsChain(XPathSchemaContext var1);

    public String toStringWithoutParent();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Utilities {
        public static SchemaComponent getSchemaComp(XPathSchemaContext xPathSchemaContext) {
            SchemaCompHolder schemaCompHolder = Utilities.getSchemaCompHolder(xPathSchemaContext);
            if (schemaCompHolder != null) {
                return schemaCompHolder.getSchemaComponent();
            }
            return null;
        }

        public static SchemaCompHolder getSchemaCompHolder(XPathSchemaContext xPathSchemaContext) {
            SchemaCompPair schemaCompPair;
            if (xPathSchemaContext == null) {
                return null;
            }
            Set<SchemaCompPair> set = null;
            set = xPathSchemaContext.isLastInChain() ? xPathSchemaContext.getSchemaCompPairs() : xPathSchemaContext.getUsedSchemaCompPairs();
            if (set != null && set.size() > 0 && (schemaCompPair = set.iterator().next()) != null) {
                SchemaCompHolder schemaCompHolder = schemaCompPair.getCompHolder();
                return schemaCompHolder;
            }
            return null;
        }

        public static boolean equalsChain(XPathSchemaContext xPathSchemaContext, XPathSchemaContext xPathSchemaContext2) {
            if (Utilities.equals(xPathSchemaContext, xPathSchemaContext2)) {
                boolean bl;
                XPathSchemaContext xPathSchemaContext3 = xPathSchemaContext.getParentContext();
                XPathSchemaContext xPathSchemaContext4 = xPathSchemaContext2.getParentContext();
                return !(xPathSchemaContext3 != null && xPathSchemaContext4 != null ? !(bl = Utilities.equalsChain(xPathSchemaContext3, xPathSchemaContext4)) : xPathSchemaContext3 == null && xPathSchemaContext4 != null || xPathSchemaContext3 != null && xPathSchemaContext4 == null);
            }
            return false;
        }

        public static boolean equals(XPathSchemaContext xPathSchemaContext, XPathSchemaContext xPathSchemaContext2) {
            assert (xPathSchemaContext != null && xPathSchemaContext2 != null);
            Set<SchemaCompPair> set = xPathSchemaContext.getSchemaCompPairs();
            Set<SchemaCompPair> set2 = xPathSchemaContext2.getSchemaCompPairs();
            assert (set != null && set2 != null);
            if (set.size() != set2.size()) {
                return false;
            }
            for (SchemaCompPair schemaCompPair : set) {
                if (set2.contains(schemaCompPair)) continue;
                return false;
            }
            return true;
        }

        public static XPathLocationPath generateRelativePath(XPathExpressionPath xPathExpressionPath, XPathSchemaContext xPathSchemaContext) {
            LocationStep locationStep;
            int n;
            Object object;
            Object object2;
            LocationStep[] locationStepArray = xPathExpressionPath.getSteps();
            if (locationStepArray == null || locationStepArray.length == 0) {
                return null;
            }
            LocationStep locationStep2 = locationStepArray[locationStepArray.length - 1];
            XPathSchemaContext xPathSchemaContext2 = locationStep2.getSchemaContext();
            if (xPathSchemaContext2 == null) {
                return null;
            }
            XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
            XPathSchemaContext xPathSchemaContext3 = null;
            if (xPathExpression instanceof XPathSchemaContextHolder) {
                xPathSchemaContext3 = ((XPathSchemaContextHolder)((Object)xPathExpression)).getSchemaContext();
            }
            if (xPathSchemaContext3 == null) {
                return null;
            }
            assert (xPathSchemaContext3.getParentContext() == null) : "the root expression has to have not chained schema context";
            List<XPathSchemaContext> list = Utilities.getInversedContextChain(xPathSchemaContext2);
            List<XPathSchemaContext> list2 = Utilities.getInversedContextChain(xPathSchemaContext);
            Iterator<XPathSchemaContext> iterator = list.iterator();
            Iterator<XPathSchemaContext> iterator2 = list2.iterator();
            Object object3 = null;
            int n2 = -1;
            while (iterator.hasNext() && iterator2.hasNext() && (object2 = iterator2.next()).equals(object = iterator.next())) {
                ++n2;
                object3 = object2;
            }
            if (object3 == null) {
                return null;
            }
            if (object3.equals(xPathSchemaContext3)) {
                return null;
            }
            object2 = locationStep2.getModel().getFactory();
            object = new ArrayList();
            int n3 = list2.size() - n2 - 1;
            XPathSchemaContext xPathSchemaContext4 = xPathSchemaContext.getParentContext();
            for (n = 0; n < n3; ++n) {
                locationStep = object2.newLocationStep(XPathAxis.PARENT, new StepNodeTypeTest(StepNodeTestType.NODETYPE_NODE, null), null);
                locationStep.setSchemaContext(xPathSchemaContext4);
                ((ArrayList)object).add(locationStep);
            }
            for (n = n2; n < locationStepArray.length; ++n) {
                locationStep = locationStepArray[n];
                ((ArrayList)object).add(locationStep);
            }
            if (((ArrayList)object).size() == 0 && xPathSchemaContext2.equalsChain(xPathSchemaContext)) {
                LocationStep locationStep3 = object2.newLocationStep(XPathAxis.SELF, new StepNodeTypeTest(StepNodeTestType.NODETYPE_NODE, null), null);
                ((ArrayList)object).add(locationStep3);
            }
            XPathLocationPath xPathLocationPath = object2.newXPathLocationPath(((ArrayList)object).toArray(new LocationStep[((ArrayList)object).size()]));
            return xPathLocationPath;
        }

        public static List<XPathSchemaContext> getInversedContextChain(XPathSchemaContext xPathSchemaContext) {
            LinkedList<XPathSchemaContext> linkedList = new LinkedList<XPathSchemaContext>();
            while (xPathSchemaContext != null) {
                linkedList.addFirst(xPathSchemaContext);
                xPathSchemaContext = xPathSchemaContext.getParentContext();
            }
            return linkedList;
        }

        public static Set<String> getEffectiveNamespaces(SchemaComponent schemaComponent, XPathSchemaContext xPathSchemaContext) {
            SchemaModel schemaModel = schemaComponent.getModel();
            String string = schemaModel.getEffectiveNamespace(schemaComponent);
            if (string != null && string.length() != 0) {
                return Collections.singleton(string);
            }
            if (xPathSchemaContext == null) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<Object> hashSet2 = null;
            HashSet<SchemaModel> hashSet3 = new HashSet<SchemaModel>();
            while (xPathSchemaContext != null) {
                Set<SchemaCompPair> set = xPathSchemaContext.getUsedSchemaCompPairs();
                HashSet hashSet4 = null;
                if (hashSet2 != null && !hashSet2.isEmpty()) {
                    hashSet4 = new HashSet(hashSet2);
                }
                for (SchemaCompPair schemaCompPair : set) {
                    SchemaCompHolder schemaCompHolder;
                    Object object;
                    SchemaCompHolder schemaCompHolder2 = schemaCompPair.getCompHolder();
                    if (schemaCompHolder2 == null || hashSet4 != null && !hashSet4.contains(schemaCompHolder2)) continue;
                    SchemaModel schemaModel2 = schemaCompHolder2.getSchemaComponent().getModel();
                    hashSet2 = new HashSet<Object>();
                    if (schemaModel2 == schemaModel) {
                        object = schemaCompPair.getParetnCompHolder();
                        if (object == null) continue;
                        hashSet2.add(object);
                        continue;
                    }
                    object = schemaModel2.getSchema().getTargetNamespace();
                    if (object == null || ((String)object).length() == 0) {
                        schemaCompHolder = schemaCompPair.getParetnCompHolder();
                        if (schemaCompHolder == null) continue;
                        hashSet2.add(schemaCompHolder);
                        continue;
                    }
                    if (hashSet3.contains(schemaModel2)) {
                        schemaCompHolder = schemaCompPair.getParetnCompHolder();
                        if (schemaCompHolder == null) continue;
                        hashSet2.add(schemaCompHolder);
                        continue;
                    }
                    string = schemaModel2.getEffectiveNamespace(schemaComponent);
                    if (string != null) {
                        hashSet.add(string);
                    }
                    hashSet3.add(schemaModel2);
                }
                if (hashSet2 == null || hashSet2.isEmpty()) break;
                xPathSchemaContext = xPathSchemaContext.getParentContext();
            }
            return hashSet;
        }
    }

    public static final class SchemaCompPair {
        private SchemaCompHolder mCompHolder;
        private SchemaCompHolder mParentCompHolder;

        public SchemaCompPair(SchemaCompHolder schemaCompHolder, SchemaCompHolder schemaCompHolder2) {
            assert (schemaCompHolder != null);
            this.mCompHolder = schemaCompHolder;
            this.mParentCompHolder = schemaCompHolder2;
        }

        public SchemaCompPair(SchemaComponent schemaComponent, SchemaCompHolder schemaCompHolder) {
            assert (schemaComponent != null);
            this.mCompHolder = SchemaCompHolder.Factory.construct(schemaComponent);
            this.mParentCompHolder = schemaCompHolder;
        }

        public SchemaCompHolder getCompHolder() {
            return this.mCompHolder;
        }

        public SchemaCompHolder getParetnCompHolder() {
            return this.mParentCompHolder;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            SchemaCompHolder schemaCompHolder = this.getParetnCompHolder();
            if (schemaCompHolder != null) {
                SchemaCompPair.appendCompName(stringBuilder, schemaCompHolder);
                stringBuilder.append(">");
            }
            SchemaCompHolder schemaCompHolder2 = this.getCompHolder();
            SchemaCompPair.appendCompName(stringBuilder, schemaCompHolder2);
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof SchemaCompPair) {
                SchemaCompPair schemaCompPair = (SchemaCompPair)object;
                return schemaCompPair.mCompHolder == this.mCompHolder && schemaCompPair.mParentCompHolder == this.mParentCompHolder;
            }
            return false;
        }

        public static void appendCompName(StringBuilder stringBuilder, SchemaCompHolder schemaCompHolder) {
            switch (schemaCompHolder.getComponentType()) {
                case ATTRIBUTE: 
                case PSEUDO_ATTRIBUTE: {
                    stringBuilder.append("@");
                }
                case ELEMENT: 
                case PSEUDO_ELEMENT: {
                    stringBuilder.append(schemaCompHolder.getName());
                    break;
                }
                default: {
                    stringBuilder.append("???");
                }
            }
        }
    }
}

