/*
 * Decompiled with CFR 0.152.
 */
package com.sun.errorhandler;

import com.sun.errorhandler.DebugClientThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExceptionHandler
extends HttpServlet {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.errorhandler.Bundle", Locale.getDefault());
    private static int debugLevel = 0;
    private boolean readPropertiesAlready = false;

    public static int getDebugLevel() {
        return debugLevel;
    }

    public void init(ServletConfig sc) {
        try {
            super.init(sc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initProps() {
        if (!this.readPropertiesAlready) {
            this.readPropertiesAlready = true;
            String errH = this.getInitParameter("errorHost");
            if (errH != null) {
                DebugClientThread.errorHost = errH;
                String errP = this.getInitParameter("errorPort");
                if (errP != null) {
                    DebugClientThread.setErrorPort(errP);
                } else {
                    DebugClientThread.setErrorPort("0");
                }
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.initProps();
        this.generateResponse(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.initProps();
        if (request.getParameter("debug") != null || request.getParameter("errorHost") != null || request.getParameter("errorPort") != null) {
            this.setDebugVars(request);
        }
        this.generateResponse(request, response);
    }

    public void generateResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String request_uri = (String)request.getAttribute("javax.servlet.error.request_uri");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<HTML>");
        out.println("<HEAD>");
        out.println("<TITLE>");
        out.println(rb.getString("EH_pagetitle"));
        out.println("</TITLE>");
        out.print("<style>I{font-family:");
        out.print("Verdana,UTF-8");
        out.println(";font-weight:italic;font-size:8pt;color:maroon}</style>");
        out.println("</HEAD>");
        out.println("<BODY BGCOLOR='white'>");
        out.println("<CENTER><B>");
        out.println(rb.getString("EH_pagetitle"));
        out.println("</B></CENTER>");
        out.println("<P>");
        out.println("<FONT COLOR='blue'>");
        out.println("<BR><B>");
        out.println(rb.getString("EH_Description"));
        out.println("</B> ");
        out.println(rb.getString("EH_Reason"));
        out.println("<BR>");
        ArrayList<Throwable> eList = new ArrayList<Throwable>();
        for (Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception"); exception != null; exception = exception.getCause()) {
            eList.add(exception);
        }
        for (int ecnt = eList.size() - 1; ecnt >= 0; --ecnt) {
            this.displayMessage((Throwable)eList.get(ecnt), out);
        }
        out.println("</FONT>");
        out.println("</P>");
        if (ExceptionHandler.getDebugLevel() > 0) {
            out.println("<HR><P>Debugging on.</P>");
            out.println("<P>Errors will be sent to " + DebugClientThread.errorHost + " port " + DebugClientThread.getErrorPort() + "</P>");
        }
        out.println("</BODY>");
        out.println("</HTML>");
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayMessage(Throwable exception, PrintWriter out) {
        String expTypeFullName = exception.getClass().getName();
        String expTypeName = expTypeFullName.substring(expTypeFullName.lastIndexOf(".") + 1);
        StackTraceElement[] ste = exception.getStackTrace();
        int stackCount = -1;
        String fileName = null;
        for (int i = 0; i < ste.length; ++i) {
            fileName = ste[i].getFileName();
            if (fileName == null) continue;
            String className = ste[i].getClassName();
            try {
                Class<?> clazz = Class.forName(className);
                URL url = clazz.getResource(fileName);
                InputStream is1 = url.openStream();
                if (is1 == null) continue;
                is1.close();
                stackCount = i;
                break;
            }
            catch (Exception ex) {
                continue;
            }
        }
        out.println("<BR><B>");
        out.println(rb.getString("EH_ExceptionDetails"));
        out.println("</B> ");
        out.println(expTypeFullName);
        out.println("<BR>");
        String xmsg = exception.getLocalizedMessage();
        if (xmsg == null) {
            xmsg = exception.getMessage();
        }
        out.println("&nbsp;&nbsp;" + xmsg + "<BR>");
        out.println("<BR><B>");
        out.println(rb.getString("EH_PossibleSource"));
        out.println("</B><BR>");
        out.println("&nbsp;&nbsp;");
        out.println(rb.getString("EH_ClassName"));
        out.println(" <I>" + (ste.length < 1 ? rb.getString("EH_unknownValue") : ste[0].getClassName()) + "</I> <BR>");
        out.println("&nbsp;&nbsp;");
        out.println(rb.getString("EH_FileName"));
        out.println(" <I>" + (ste.length < 1 ? rb.getString("EH_unknownValue") : ste[0].getFileName()) + "</I> <BR>");
        out.println("&nbsp;&nbsp;");
        out.println(rb.getString("EH_MethodName"));
        out.println(" <I>" + (ste.length < 1 ? rb.getString("EH_unknownValue") : ste[0].getMethodName()) + "</I> <BR>");
        out.println("&nbsp;&nbsp;");
        out.println(rb.getString("EH_LineNumber"));
        out.println(" <I>" + (ste.length < 1 ? rb.getString("EH_unknownValue") : Integer.toString(ste[0].getLineNumber())) + "</I> <BR>");
        out.println("<BR>");
        if (stackCount != -1) {
            int lineNumber = ste[stackCount].getLineNumber();
            String className = ste[stackCount].getClassName();
            fileName = ste[stackCount].getFileName();
            try {
                Class<?> clazz = Class.forName(className);
                URL url = clazz.getResource(fileName);
                if (url != null) {
                    InputStream is = url.openStream();
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
                    out.println("<table width=100% bgcolor=\"#ffffcc\"><tr><td><code>");
                    for (int i = 0; i < lineNumber + 3; ++i) {
                        String line = reader.readLine();
                        int lineNo = reader.getLineNumber();
                        if (lineNo < lineNumber - 3) continue;
                        if (lineNo == lineNumber) {
                            out.println("<FONT COLOR='red' BGCOLOR='white'><B>");
                            out.println(lineNo + ": " + this.appendHTMLChar(line) + "<BR>");
                            out.println("</B></FONT>");
                            continue;
                        }
                        out.println(lineNo + ": " + this.appendHTMLChar(line) + "<BR>");
                    }
                    out.println("</code></td></tr></table>");
                    is.close();
                    reader.close();
                }
            }
            catch (Exception ex) {}
        } else {
            out.println("<table width=100% bgcolor=\"#ffffcc\"><tr><td><code>");
            out.println(rb.getString("EH_NoSourceLong"));
            out.println("<BR></code></td></tr></table>");
        }
        out.println("<BR><B>");
        out.println(rb.getString("EH_StackTrace"));
        out.println(" </B><BR><BR>");
        out.println("<table width=100% bgcolor=\"#eeddff\"><tr><td><code>");
        for (int i = 0; i < ste.length; ++i) {
            int lineNumber = ste[i].getLineNumber();
            String cName = ste[i].getClassName();
            String fName = ste[i].getFileName();
            String mName = ste[i].getMethodName();
            if (i == stackCount) {
                out.println("<FONT COLOR='brown' BGCOLOR='white'><B>");
            }
            if (fName != null) {
                out.println(cName + "." + mName + "(" + fName + ":" + lineNumber + ")<BR>");
            } else {
                out.println(cName + "." + mName + "(");
                out.println(rb.getString("EH_NoSourceShort"));
                out.println(")<BR>");
            }
            if (i != stackCount) continue;
            out.println("</B></FONT>");
        }
        out.println("</code></td></tr></table>");
        if (stackCount == -1) {
            stackCount = 0;
        }
    }

    public String appendHTMLChar(String str) {
        StringBuffer sb = new StringBuffer();
        int len = str.length();
        block8: for (int i = 0; i < len; ++i) {
            char chr = str.charAt(i);
            switch (chr) {
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block8;
                }
                case '\n': {
                    sb.append("<br>");
                    continue block8;
                }
                default: {
                    sb.append(chr);
                }
            }
        }
        return sb.toString();
    }

    private void setDebugVars(HttpServletRequest request) {
        String val = request.getParameter("debug");
        if (val != null) {
            debugLevel = "1".equals(val = val.trim()) || "true".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) ? 1 : 0;
        }
        if ((val = request.getParameter("errorHost")) != null) {
            DebugClientThread.errorHost = !"".equals(val) ? null : val;
        }
        if ((val = request.getParameter("errorPort")) != null) {
            DebugClientThread.setErrorPort(val);
        }
    }
}

