/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view;

import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProvider;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProviderRegistry;
import org.netbeans.modules.websvc.design.view.widget.AbstractTitledWidget;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.CheckBoxWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsitWidget
extends AbstractTitledWidget {
    private transient FileObject implementationClass;
    private transient Widget buttons;
    private transient Widget configButtons;
    private transient ButtonWidget advancedButton;
    private transient ImageLabelWidget headerLabelWidget;
    private Service service;
    private PropertyChangeListener configListener;
    private Object key = new Object();

    public WsitWidget(ObjectScene objectScene, Service service, FileObject fileObject) {
        super(objectScene, 12, BORDER_COLOR);
        this.implementationClass = fileObject;
        this.service = service;
        this.setOpaque(true);
        this.setBackground(TITLE_COLOR_PARAMETER);
        this.configListener = new WSConfigurationListener(this);
        this.createContent();
    }

    private void createContent() {
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), null, NbBundle.getMessage(WsitWidget.class, (String)"LBL_Wsit"));
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)8));
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.getHeaderWidget().addChild(this.buttons);
        this.getContentWidget().setBorder(BorderFactory.createEmptyBorder((int)12));
        this.configButtons = new Widget(this.getScene());
        this.configButtons.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)12));
        this.getContentWidget().addChild(this.configButtons);
        this.populateConfigWidget();
        Widget widget = new Widget(this.getScene());
        widget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.RIGHT_BOTTOM, (int)12));
        this.advancedButton = new ButtonWidget(this.getScene(), new AdvancedAction(this.service, this.implementationClass));
        this.advancedButton.setOpaque(true);
        this.advancedButton.setRoundedBorder(ButtonWidget.BORDER_RADIUS, 4, 0, null);
        widget.addChild((Widget)this.advancedButton);
        this.getContentWidget().addChild(widget);
    }

    private void populateConfigWidget() {
        for (WSConfigurationProvider wSConfigurationProvider : this.getConfigProviders()) {
            final WSConfiguration wSConfiguration = wSConfigurationProvider.getWSConfiguration(this.service, this.implementationClass);
            if (wSConfiguration == null) continue;
            CheckBoxWidget checkBoxWidget = new CheckBoxWidget(this.getScene(), wSConfiguration.getDisplayName()){

                protected Object hashKey() {
                    return wSConfiguration;
                }

                protected void notifyAdded() {
                    super.notifyAdded();
                    wSConfiguration.registerListener(WsitWidget.this.configListener);
                    this.setVisible(wSConfiguration.isEnabled());
                    WsitWidget.this.determineVisibility();
                }

                protected void notifyRemoved() {
                    super.notifyRemoved();
                    wSConfiguration.unregisterListener(WsitWidget.this.configListener);
                }
            };
            checkBoxWidget.setSelected(wSConfiguration.isSet());
            checkBoxWidget.setAction(new ConfigWidgetAction(wSConfiguration));
            checkBoxWidget.setToolTipText(wSConfiguration.getDescription());
            checkBoxWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
            this.configButtons.addChild((Widget)checkBoxWidget);
        }
    }

    private void determineVisibility() {
        for (Widget widget : this.configButtons.getChildren()) {
            if (!widget.isVisible()) continue;
            this.setVisible(true);
            return;
        }
        this.setVisible(false);
    }

    protected Paint getBodyPaint(Rectangle rectangle) {
        return TITLE_COLOR_PARAMETER;
    }

    @Override
    public Object hashKey() {
        return this.key;
    }

    private Set<WSConfigurationProvider> getConfigProviders() {
        return WSConfigurationProviderRegistry.getDefault().getWSConfigurationProviders();
    }

    final class WSConfigurationListener
    implements PropertyChangeListener {
        private WsitWidget widget;

        private WSConfigurationListener(WsitWidget wsitWidget2) {
            this.widget = wsitWidget2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            ObjectScene objectScene = (ObjectScene)this.widget.getScene();
            String string = propertyChangeEvent.getPropertyName();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof WSConfiguration) {
                Widget widget = objectScene.findWidget(object);
                if ("value".equals(string)) {
                    if (widget instanceof CheckBoxWidget) {
                        ((CheckBoxWidget)widget).setSelected((Boolean)object2);
                        objectScene.validate();
                        this.widget.revalidate(true);
                    }
                } else if ("enabled".equals(string) && widget instanceof CheckBoxWidget) {
                    ((CheckBoxWidget)widget).setVisible((Boolean)object2);
                    this.widget.determineVisibility();
                    this.widget.revalidate();
                }
            }
        }
    }

    class AdvancedAction
    extends AbstractAction {
        private transient FileObject implementationClass;
        private Service service;
        private EditWSAttributesCookie cookie;

        public AdvancedAction(Service service, FileObject fileObject) {
            super(NbBundle.getMessage(WsitWidget.class, (String)"LBL_Wsit_Advanced"));
            this.putValue("ShortDescription", NbBundle.getMessage(AdvancedAction.class, (String)"Hint_Wsit_Advanced"));
            this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AdvancedAction.class, (String)"LBL_Wsit_Advanced_mnem_pos")));
            this.implementationClass = fileObject;
            this.service = service;
            this.setEnabled(false);
            this.initializeCookie();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.cookie == null) {
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    AdvancedAction.this.cookie.openWSAttributesEditor();
                }
            }, 10);
        }

        private void initializeCookie() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.implementationClass);
            if (project == null) {
                return;
            }
            JAXWSView jAXWSView = JAXWSView.getJAXWSView();
            if (jAXWSView == null) {
                return;
            }
            final Node node = jAXWSView.createJAXWSView(project);
            if (node == null) {
                return;
            }
            final FileObject fileObject = this.implementationClass;
            final Service service = this.service;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Node node2 : node.getChildren().getNodes()) {
                        Service service2 = (Service)node2.getLookup().lookup(Service.class);
                        if (service2 == null || node2.getLookup().lookup(FileObject.class) != fileObject || !service2.getName().equals(service.getName())) continue;
                        AdvancedAction.this.cookie = (EditWSAttributesCookie)node2.getLookup().lookup(EditWSAttributesCookie.class);
                        AdvancedAction.this.setEnabled(AdvancedAction.this.cookie != null);
                        return;
                    }
                }
            });
        }
    }

    class ConfigWidgetAction
    extends AbstractAction {
        WSConfiguration config;

        public ConfigWidgetAction(WSConfiguration wSConfiguration) {
            this.config = wSConfiguration;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("toggle-button-selected")) {
                this.config.set();
            } else {
                this.config.unset();
            }
        }
    }
}

