/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.panels;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.design.view.panels.SelectSchemaPanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportSchemaDialog {
    private Dialog dialog;
    private SelectSchemaPanel sPanel;
    private AddImportedSchemaDialogDesc dlgDesc;

    public ImportSchemaDialog(Project project) {
        this.sPanel = new SelectSchemaPanel(project);
        this.dlgDesc = new AddImportedSchemaDialogDesc(this.sPanel);
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.dlgDesc);
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public boolean okButtonPressed() {
        return this.dlgDesc.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Set<Schema> getSelectedSchemas() {
        HashSet<Schema> hashSet = new HashSet<Schema>();
        Node[] nodeArray = this.sPanel.getSelectedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            FileObject fileObject = this.getFileObjectFromNode(nodeArray[i]);
            if (fileObject == null) continue;
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
            hashSet.add(schemaModel.getSchema());
        }
        return hashSet;
    }

    private FileObject getFileObjectFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    class AddImportedSchemaDialogDesc
    extends DialogDescriptor {
        Project project;
        final SelectSchemaPanel sPanel;
        private Object[] closingOptionsWithoutOK;
        private Object[] closingOptionsWithOK;

        public AddImportedSchemaDialogDesc(SelectSchemaPanel selectSchemaPanel) {
            super((Object)selectSchemaPanel, NbBundle.getMessage(ImportSchemaDialog.class, (String)"TTL_SelectSchema"));
            this.closingOptionsWithoutOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION};
            this.closingOptionsWithOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION, DialogDescriptor.OK_OPTION};
            this.sPanel = selectSchemaPanel;
            this.setButtonListener(new AddImportedSchemaActionListener(selectSchemaPanel));
        }

        class AddImportedSchemaActionListener
        implements ActionListener {
            SelectSchemaPanel sPanel;

            public AddImportedSchemaActionListener(SelectSchemaPanel selectSchemaPanel) {
                this.sPanel = selectSchemaPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                    boolean bl = true;
                    Object var3_3 = null;
                    Node[] nodeArray = this.sPanel.getSelectedNodes();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        FileObject fileObject = ImportSchemaDialog.this.getFileObjectFromNode(node);
                    }
                    if (!bl) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message(var3_3, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        AddImportedSchemaDialogDesc.this.setClosingOptions(AddImportedSchemaDialogDesc.this.closingOptionsWithoutOK);
                    } else {
                        AddImportedSchemaDialogDesc.this.setClosingOptions(AddImportedSchemaDialogDesc.this.closingOptionsWithOK);
                    }
                }
            }
        }
    }
}

