/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.beans.editor.EncodingEditor;
import org.netbeans.modules.xml.tax.beans.editor.VersionEditor;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeDTD;
import org.netbeans.tax.TreeException;

public class TreeDTDCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = -6359067211795222437L;
    private JComboBox cbVersion;
    private JLabel versionLabel;
    private JComboBox cbEncoding;
    private JLabel encodingLabel;
    private JPanel fillPanel;

    public TreeDTDCustomizer() {
        this.initComponents();
        this.versionLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_dtd_version"));
        this.encodingLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_dtd_encoding"));
        this.initAccessibility();
    }

    protected final TreeDTD getDTD() {
        return (TreeDTD)this.getTreeObject();
    }

    protected final void safePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.safePropertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName().equals("version")) {
            this.updateVersionComponent();
        } else if (propertyChangeEvent.getPropertyName().equals("encoding")) {
            this.updateEncodingComponent();
        }
    }

    protected final void updateDTDVersion() {
        if (this.cbVersion.getSelectedItem() == null) {
            return;
        }
        try {
            this.getDTD().setVersion(TreeDTDCustomizer.text2null((String)this.cbVersion.getSelectedItem()));
        }
        catch (TreeException treeException) {
            this.updateVersionComponent();
            TAXUtil.notifyTreeException(treeException);
        }
    }

    protected final void updateVersionComponent() {
        this.cbVersion.setSelectedItem(TreeDTDCustomizer.null2text(this.getDTD().getVersion()));
    }

    protected final void updateDTDEncoding() {
        if (this.cbEncoding.getSelectedItem() == null) {
            return;
        }
        try {
            this.getDTD().setEncoding(TreeDTDCustomizer.text2null((String)this.cbEncoding.getSelectedItem()));
        }
        catch (TreeException treeException) {
            this.updateEncodingComponent();
            TAXUtil.notifyTreeException(treeException);
        }
    }

    protected final void updateEncodingComponent() {
        this.cbEncoding.setSelectedItem(TreeDTDCustomizer.null2text(this.getDTD().getEncoding()));
    }

    protected void initComponentValues() {
        this.updateVersionComponent();
        this.updateEncodingComponent();
    }

    protected void updateReadOnlyStatus(boolean bl) {
        this.cbVersion.setEnabled(bl);
        this.cbEncoding.setEnabled(bl);
    }

    private void initComponents() {
        this.versionLabel = new JLabel();
        this.cbVersion = new JComboBox();
        this.encodingLabel = new JLabel();
        this.cbEncoding = new JComboBox();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.versionLabel.setText(Util.THIS.getString("PROP_dtd_version"));
        this.versionLabel.setLabelFor(this.cbVersion);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.versionLabel, gridBagConstraints);
        this.cbVersion.setModel(new DefaultComboBoxModel<String>(VersionEditor.getItems()));
        this.cbVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeDTDCustomizer.this.cbVersionActionPerformed(actionEvent);
            }
        });
        this.cbVersion.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TreeDTDCustomizer.this.cbVersionFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cbVersion, gridBagConstraints);
        this.encodingLabel.setText(Util.THIS.getString("PROP_dtd_encoding"));
        this.encodingLabel.setLabelFor(this.cbEncoding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.encodingLabel, gridBagConstraints);
        this.cbEncoding.setModel(new DefaultComboBoxModel<String>(EncodingEditor.getItems()));
        this.cbEncoding.setEditable(true);
        this.cbEncoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeDTDCustomizer.this.cbEncodingActionPerformed(actionEvent);
            }
        });
        this.cbEncoding.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TreeDTDCustomizer.this.cbEncodingFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cbEncoding, gridBagConstraints);
        this.fillPanel.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void cbEncodingFocusLost(FocusEvent focusEvent) {
        this.updateDTDEncoding();
    }

    private void cbEncodingActionPerformed(ActionEvent actionEvent) {
        this.updateDTDEncoding();
    }

    private void cbVersionFocusLost(FocusEvent focusEvent) {
        this.updateDTDVersion();
    }

    private void cbVersionActionPerformed(ActionEvent actionEvent) {
        this.updateDTDVersion();
    }

    public void initAccessibility() {
        this.cbVersion.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_cbVersion"));
        this.cbEncoding.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_cbEncoding"));
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeDTDCustomizer"));
    }
}

