/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std;

import com.sun.jsfcl.std.RaveStringCustomEditor;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class RaveStringEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    private boolean editable = true;
    protected String instructions = null;
    private boolean oneline = false;
    private boolean customEd = true;

    public boolean isEditable() {
        return this.editable;
    }

    protected boolean forceOneline() {
        return false;
    }

    public String getAsText() {
        if (this.getValue() == null) {
            return "";
        }
        return super.getAsText();
    }

    public void setAsText(String string) {
        this.setValue(string);
    }

    public void setValue(Object object) {
        String string = (String)object;
        if ("".equals(string) && this.getValue() == null) {
            return;
        }
        super.setValue(string);
    }

    protected void superSetValue(Object object) {
        super.setValue(object);
    }

    public String getJavaInitializationString() {
        String string = (String)this.getValue();
        if (string == null) {
            return "\"\"";
        }
        return "\"" + RaveStringEditor.toAscii(string) + "\"";
    }

    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    public Component getCustomEditor() {
        return new RaveStringCustomEditor(this.getAsText(), this.isEditable(), this.oneline, this.instructions, this.getIgnoreCrs(), this);
    }

    public Object getCustomEditorValue(String string) {
        return string;
    }

    private static String toAscii(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 6);
        char[] cArray = string.toCharArray();
        block9: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        stringBuffer.append(c);
                        continue block9;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            Node.Property property = (Node.Property)featureDescriptor;
            this.editable = property.canWrite();
            if (this.useOriginalShortDescriptionForInstructions()) {
                this.instructions = (String)property.getValue("originalShortDescription");
                if (this.instructions == null) {
                    this.instructions = property.getShortDescription();
                }
            } else {
                this.instructions = (String)property.getValue("instructions");
            }
            this.oneline = this.forceOneline() ? true : Boolean.TRUE.equals(property.getValue("oneline"));
            this.customEd = !Boolean.TRUE.equals(property.getValue("suppressCustomEditor"));
        }
    }

    protected boolean useOriginalShortDescriptionForInstructions() {
        return false;
    }

    protected boolean getIgnoreCrs() {
        return false;
    }
}

