/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std;

import com.sun.java.swing.plaf.windows.WindowsFileChooserUI;
import com.sun.jsfcl.std.URLPropertyEditor;
import com.sun.jsfcl.util.ComponentBundle;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageProducer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.visualweb.extension.openide.awt.JFileChooser_RAVE;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class URLPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
ChangeListener,
EnhancedCustomPropertyEditor,
DocumentListener {
    static String copyString = "Copy";
    static String linkString = "Link";
    protected static WeakHashMap lastDirectoryByProject = new WeakHashMap();
    protected static final String LAST_DIRECTORY_KEY_NO_PROJECT = "DEFAULT";
    private static final ComponentBundle bundle = ComponentBundle.getBundle(URLPanel.class);
    JTabbedPane tabs = new JTabbedPane();
    JFileChooser filePanel;
    HTTPPanel httpPanel;
    JTextField valueTextField = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel valueLabel = new JLabel();
    URLPropertyEditor ure;
    JRadioButton copyButton = new JRadioButton(bundle.getMessage("copy"));
    JRadioButton linkButton = new JRadioButton(bundle.getMessage("link"));
    ButtonGroup group = new ButtonGroup();
    RadioListener myListener = new RadioListener();
    private boolean initialized = false;
    protected DesignProperty liveProperty;
    protected DesignContext liveContext;
    protected Node.Property property;
    private File baseDirectory;
    protected boolean ignoreValueTextFieldChanges;
    JToggleButton shortCutPanelMyProjectButton;
    protected File relativeRootDirectoryCache;
    protected boolean relativeRootDirectoryCacheSet;
    protected File relativeDirectoryCache;
    protected boolean relativeDirectoryCacheSet;
    protected String propertyValue;
    protected File delayedFileToAdd;
    protected File delayedSetLastDirectoryUsed;

    public URLPanel(URLPropertyEditor uRLPropertyEditor) {
        this();
        this.ure = uRLPropertyEditor;
    }

    public URLPanel() {
        try {
            this.jbInit();
            this.copyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLPanel.class, (String)"COPY_BUTTON_ACCESS_DESC"));
            this.linkButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLPanel.class, (String)"LINK_BUTTON_ACCESS_DESC"));
            this.copyButton.setMnemonic(NbBundle.getMessage(URLPanel.class, (String)"COPY_BUTTON_MNEMONIC").charAt(0));
            this.linkButton.setMnemonic(NbBundle.getMessage(URLPanel.class, (String)"LINK_BUTTON_MNEMONIC").charAt(0));
            this.valueTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(URLPanel.class, (String)"VALUE_TEXTFIELD_ACCESS_NAME"));
            this.valueTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLPanel.class, (String)"VALUE_TEXTFIELD_ACCESS_DESC"));
            this.tabs.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLPanel.class, (String)"TAB_PANE_ACCESS_DESC"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Image loadImage(final String string, final Class clazz) {
        try {
            ImageProducer imageProducer = (ImageProducer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = clazz.getResource(string);
                    if (uRL == null) {
                        return null;
                    }
                    try {
                        return uRL.getContent();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
            if (imageProducer == null) {
                return null;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            return toolkit.createImage(imageProducer);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void jbInit() throws Exception {
        this.copyButton.setActionCommand(copyString);
        this.linkButton.setActionCommand(linkString);
        this.group.add(this.copyButton);
        this.group.add(this.linkButton);
        this.linkButton.setSelected(true);
        this.copyButton.addActionListener(this.myListener);
        this.linkButton.addActionListener(this.myListener);
        this.setLayout(this.gridBagLayout1);
        this.valueLabel.setText(bundle.getMessage("urlPanelCurrSetting"));
        this.valueTextField.setText("");
        this.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 2, 8), 0, 0));
        this.add((Component)this.valueTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 4, 8), 0, 0));
        this.add((Component)this.tabs, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        this.add((Component)this.copyButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.linkButton, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected File getLastDirectoryUsed() {
        String string = this.getDesignProperty() == null ? LAST_DIRECTORY_KEY_NO_PROJECT : this.getDesignProperty().getDesignBean().getDesignContext().getProject();
        File file = (File)lastDirectoryByProject.get(string);
        if (file == null) {
            file = this.getRelativeRootDirectory();
            lastDirectoryByProject.put(string, file);
        }
        return file;
    }

    protected void setLastDirectoryUsed(File file) {
        String string = this.getDesignProperty() == null ? LAST_DIRECTORY_KEY_NO_PROJECT : this.getDesignProperty().getDesignBean().getDesignContext().getProject();
        lastDirectoryByProject.put(string, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.filePanel) {
            File file = this.filePanel.getSelectedFile();
            if (file == null) {
                file = this.filePanel.getCurrentDirectory();
            }
            this.processValueFile(file);
            this.ignoreValueTextFieldChanges = true;
            try {
                this.valueTextField.setText(this.propertyValue);
            }
            finally {
                this.ignoreValueTextFieldChanges = false;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.shortCutPanelMyProjectButton) {
            this.filePanel.setCurrentDirectory(this.getRelativeRootDirectory());
            return;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    protected DesignProperty getDesignProperty() {
        return this.liveProperty;
    }

    public void setDesignProperty(DesignProperty designProperty) {
        this.liveProperty = designProperty;
        if (designProperty != null) {
            this.liveContext = designProperty.getDesignBean().getDesignContext();
        }
    }

    public void setProperty(Node.Property property) {
        this.property = property;
    }

    public void setDesignContext(DesignContext designContext) {
        this.liveContext = designContext;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.httpPanel.textField.getDocument()) {
            this.httpTextFieldChanged();
        }
        if (documentEvent.getDocument() == this.valueTextField.getDocument()) {
            this.valueTextFieldChanged();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.httpPanel.textField.getDocument()) {
            this.httpTextFieldChanged();
        }
        if (documentEvent.getDocument() == this.valueTextField.getDocument()) {
            this.valueTextFieldChanged();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.httpPanel.textField.getDocument()) {
            this.httpTextFieldChanged();
        }
        if (documentEvent.getDocument() == this.valueTextField.getDocument()) {
            this.valueTextFieldChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void httpTextFieldChanged() {
        this.processValueUri(this.httpPanel.textField.getText());
        this.ignoreValueTextFieldChanges = true;
        try {
            this.valueTextField.setText(this.propertyValue);
        }
        finally {
            this.ignoreValueTextFieldChanges = false;
        }
    }

    public void valueTextFieldChanged() {
        if (this.ignoreValueTextFieldChanges) {
            return;
        }
        this.processValueString(this.valueTextField.getText());
    }

    public void initialize() {
        if (!this.initialized) {
            this.filePanel = JFileChooser_RAVE.getJFileChooser();
            if (this.filePanel.getUI() instanceof WindowsFileChooserUI) {
                try {
                    this.tweakWindowsFileChooserUI(this.filePanel, (WindowsFileChooserUI)this.filePanel.getUI());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.filePanel.setControlButtonsAreShown(false);
            this.filePanel.setFileSelectionMode(2);
            this.filePanel.addPropertyChangeListener("SelectedFileChangedProperty", this);
            this.tabs.add((Component)this.filePanel, bundle.getMessage("file"));
            this.httpPanel = new HTTPPanel();
            this.tabs.add((Component)this.httpPanel, bundle.getMessage("url"));
            this.tabs.addChangeListener(this);
            String string = null;
            if (this.liveProperty == null) {
                if (this.property != null) {
                    try {
                        string = (String)this.property.getValue();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            } else {
                string = (String)this.liveProperty.getValue();
            }
            if (string == null || string.trim().length() == 0) {
                this.tabs.setSelectedComponent(this.filePanel);
            } else {
                this.tabs.setSelectedComponent(this.httpPanel);
            }
            this.httpPanel.textField.setText(string);
            this.httpTextFieldChanged();
            this.valueTextField.getDocument().addDocumentListener(this);
            this.httpPanel.textField.getDocument().addDocumentListener(this);
            File file = this.getLastDirectoryUsed();
            this.filePanel.setCurrentDirectory(file);
            this.initialized = true;
        }
    }

    protected void tweakWindowsFileChooserUI(JFileChooser jFileChooser, WindowsFileChooserUI windowsFileChooserUI) {
        Component[] componentArray;
        Object object;
        Object object2;
        String string;
        int n;
        JToolBar jToolBar;
        Object object3;
        File file = this.getRelativeRootDirectory();
        if (file == null) {
            return;
        }
        try {
            object3 = WindowsFileChooserUI.class.getDeclaredField("shortCutPanel");
            boolean bl = ((AccessibleObject)object3).isAccessible();
            ((Field)object3).setAccessible(true);
            jToolBar = (JToolBar)((Field)object3).get(windowsFileChooserUI);
            ((Field)object3).setAccessible(false);
        }
        catch (Exception exception) {
            return;
        }
        if (jToolBar == null) {
            return;
        }
        object3 = jFileChooser.getFileSystemView();
        if (((FileSystemView)object3).isFileSystemRoot(file)) {
            file = ((FileSystemView)object3).createFileObject(file.getAbsolutePath());
        }
        if ((n = (string = ((FileSystemView)object3).getSystemDisplayName(file)).lastIndexOf(File.separatorChar)) >= 0 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        boolean bl = false;
        try {
            object2 = Class.forName("com.sun.java.swing.plaf.windows.XPStyle");
            object = ((Class)object2).getDeclaredMethod("getXP", new Class[0]);
            ((Method)object).setAccessible(true);
            componentArray = ((Method)object).invoke(null, new Object[0]);
            ((Method)object).setAccessible(false);
            bl = componentArray != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = null;
        if (bl) {
            object = URLPanel.loadImage("urlpanel_myproject.png", this.getClass());
            object2 = new ImageIcon((Image)object, bundle.getMessage("myProject"));
        }
        if (object2 == null) {
            object2 = ((FileSystemView)object3).getSystemIcon(file);
            string = bundle.getMessage("myProject");
        }
        object = new Dimension(83, bl ? 69 : 54);
        this.shortCutPanelMyProjectButton = new JToggleButton(string, (Icon)object2);
        if (bl) {
            this.shortCutPanelMyProjectButton.setIconTextGap(2);
            this.shortCutPanelMyProjectButton.setMargin(new Insets(2, 2, 2, 2));
            this.shortCutPanelMyProjectButton.setText("<html><center>" + bundle.getMessage("myProject") + "</center></html>");
        } else {
            componentArray = new Color(UIManager.getColor("List.selectionForeground").getRGB());
            this.shortCutPanelMyProjectButton.setBackground(jFileChooser.getBackground());
            this.shortCutPanelMyProjectButton.setForeground(jFileChooser.getForeground());
        }
        this.shortCutPanelMyProjectButton.setHorizontalTextPosition(0);
        this.shortCutPanelMyProjectButton.setVerticalTextPosition(3);
        this.shortCutPanelMyProjectButton.setAlignmentX(0.5f);
        this.shortCutPanelMyProjectButton.setPreferredSize((Dimension)object);
        this.shortCutPanelMyProjectButton.addActionListener(this);
        jToolBar.add((Component)this.shortCutPanelMyProjectButton, 0);
        jToolBar.add(Box.createRigidArea(new Dimension(1, 1)), 1);
        componentArray = jToolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JToggleButton)) continue;
            JToggleButton jToggleButton = (JToggleButton)componentArray[i];
            ButtonModel buttonModel = jToggleButton.getModel();
            try {
                Field field = buttonModel.getClass().getSuperclass().getDeclaredField("group");
                field.setAccessible(true);
                ButtonGroup buttonGroup = (ButtonGroup)field.get(buttonModel);
                field.setAccessible(false);
                if (buttonGroup == null) continue;
                buttonGroup.add(this.shortCutPanelMyProjectButton);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected File getRelativeRootDirectory() {
        if (!this.relativeRootDirectoryCacheSet) {
            this.relativeRootDirectoryCache = this.getRelativeRootDirectoryImp();
            this.relativeRootDirectoryCacheSet = true;
            if (this.relativeDirectoryCache != null && this.relativeRootDirectoryCache != null && this.relativeDirectoryCache.getPath().equals(this.relativeRootDirectoryCache.getPath())) {
                this.relativeRootDirectoryCache = this.relativeDirectoryCache;
            }
        }
        return this.relativeRootDirectoryCache;
    }

    protected File getRelativeDirectory() {
        if (!this.relativeDirectoryCacheSet) {
            this.relativeDirectoryCache = this.getRelativeDirectoryImp();
            this.relativeDirectoryCacheSet = true;
        }
        return this.relativeDirectoryCache;
    }

    protected File getFileFromUrl(URL uRL) {
        File file = null;
        if (uRL != null && "file".equals(uRL.getProtocol())) {
            file = uRL.getAuthority() == null ? new File(uRL.getPath()) : new File(uRL.getAuthority(), uRL.getPath());
        }
        if (file != null && file.isFile()) {
            file = file.getParentFile();
        }
        return file;
    }

    protected File getRelativeRootDirectoryImp() {
        File file = this.getRelativeDirectory();
        if (file == null) {
            return null;
        }
        try {
            boolean bl;
            while (file != null && !(bl = this.isProjectRootFolder(file))) {
                file = file.getParentFile();
            }
            if (file == null) {
                return this.getRelativeDirectory();
            }
            if (this.liveContext == null) {
                file = new File(file, "src/web");
            } else {
                String string = (String)this.liveContext.getProject().getProjectData("sourceRoot");
                file = new File(file, string);
                file = new File(file, "web");
            }
            return file;
        }
        catch (Exception exception) {
            return this.getRelativeDirectory();
        }
    }

    public boolean isProjectRootFolder(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File file2 = new File(file, "project-data");
        if (!file2.exists()) {
            return false;
        }
        return (file2 = new File(file2, "project.prj")).exists();
    }

    public void setRelativeRootDirectory(File file) {
        this.relativeRootDirectoryCache = file;
        this.relativeRootDirectoryCacheSet = true;
    }

    protected File getRelativeDirectoryImp() {
        if (this.liveContext == null) {
            return null;
        }
        URL uRL = this.liveContext.resolveResource("");
        File file = this.getFileFromUrl(uRL);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
        return file;
    }

    public void setRelativeDirectory(File file) {
        this.relativeDirectoryCache = file;
        if (file != null && file.isFile()) {
            this.relativeDirectoryCache = this.relativeDirectoryCache.getParentFile();
        }
        this.relativeDirectoryCacheSet = true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            Object object = this.getPropertyValueImp();
            return object;
        }
        catch (IllegalStateException illegalStateException) {
            JOptionPane.showMessageDialog(this, illegalStateException.getMessage(), bundle.getMessage("urlPanelErroDialogTitle"), 2);
            throw illegalStateException;
        }
    }

    protected Object getPropertyValueImp() {
        if (this.delayedFileToAdd != null) {
            if (!this.delayedFileToAdd.exists()) {
                throw new IllegalStateException(bundle.getMessage("fileSpecifiedNotExist"));
            }
            try {
                DesignProject designProject = this.liveContext.getProject();
                URI uRI = new URI("web/resources/" + URLPanel.encodeUrl(this.delayedFileToAdd.getName()));
                if (designProject.getResourceFile(uRI) == null) {
                    designProject.addResource(this.delayedFileToAdd.toURI().toURL(), uRI);
                }
                this.propertyValue = "/resources/" + this.delayedFileToAdd.getName();
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
            }
        }
        if (this.delayedSetLastDirectoryUsed != null) {
            this.setLastDirectoryUsed(this.delayedSetLastDirectoryUsed);
        }
        return this.propertyValue;
    }

    private static String encodeUrl(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n = string.lastIndexOf(35);
        if (n > 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        block13: for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= ' ') {
                stringBuffer.append('%');
                stringBuffer.append(Integer.toHexString(cArray[i]));
                continue;
            }
            switch (cArray[i]) {
                case '\t': {
                    stringBuffer.append("%09");
                    continue block13;
                }
                case ' ': {
                    stringBuffer.append("%20");
                    continue block13;
                }
                case '#': {
                    stringBuffer.append("%23");
                    continue block13;
                }
                case '%': {
                    stringBuffer.append("%25");
                    continue block13;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block13;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block13;
                }
                case '[': {
                    stringBuffer.append("%5B");
                    continue block13;
                }
                case ']': {
                    stringBuffer.append("%5D");
                    continue block13;
                }
                case '{': {
                    stringBuffer.append("%7B");
                    continue block13;
                }
                case '}': {
                    stringBuffer.append("%7D");
                    continue block13;
                }
                case '~': {
                    stringBuffer.append("%7E");
                    continue block13;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (string2 != null) {
            stringBuffer.append('#');
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() == string.length()) {
            return string;
        }
        return stringBuffer.toString();
    }

    protected void processValueFile(File file) {
        if (file.isAbsolute()) {
            try {
                file = file.getCanonicalFile();
                String string = file.toURI().toString();
                String string2 = this.getRelativeRootDirectory() == null ? null : this.getRelativeRootDirectory().toURI().toString();
                if (string2 != null && string.startsWith(string2)) {
                    this.linkButton.setSelected(true);
                    this.linkButton.setEnabled(true);
                    this.copyButton.setEnabled(false);
                    this.delayedFileToAdd = null;
                    this.delayedSetLastDirectoryUsed = file.getParentFile();
                    this.propertyValue = string.substring(string2.length());
                    if (this.getRelativeRootDirectory() != this.getRelativeDirectory()) {
                        int n;
                        File file2 = file;
                        if (file.isFile()) {
                            file2 = file.getParentFile();
                        }
                        ArrayList arrayList = this.getPathList(file2, this.getRelativeRootDirectory());
                        ArrayList arrayList2 = this.getPathList(this.getRelativeDirectory(), this.getRelativeRootDirectory());
                        for (int i = 0; i < arrayList.size() && i < arrayList2.size() && arrayList.get(i).equals(arrayList2.get(i)); ++i) {
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n = i; n < arrayList2.size(); ++n) {
                            stringBuffer.append("../");
                        }
                        for (n = i; n < arrayList.size(); ++n) {
                            stringBuffer.append(arrayList.get(n));
                            stringBuffer.append("/");
                        }
                        if (file.isFile()) {
                            stringBuffer.append(file.getName());
                        }
                        this.propertyValue = stringBuffer.toString();
                    }
                    return;
                }
                this.copyButton.setSelected(true);
                this.copyButton.setEnabled(true);
                this.linkButton.setEnabled(false);
                this.delayedFileToAdd = file;
                this.delayedSetLastDirectoryUsed = file.getParentFile();
                this.propertyValue = file.getPath();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.processValueUri(file.getPath());
    }

    protected ArrayList getPathList(File file, File file2) {
        String string = file2.getPath();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!file.getPath().equals(string)) {
            File file3 = file.getParentFile();
            String string2 = file.getPath().substring(file3.getPath().length() + File.separator.length());
            arrayList.add(string2);
            file = file3;
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    protected void processValueString(String string) {
        File file = new File(string);
        try {
            file.getCanonicalPath();
            this.processValueFile(file);
            return;
        }
        catch (IOException iOException) {
            this.processValueUri(string);
            return;
        }
    }

    protected void processValueUri(String string) {
        this.delayedFileToAdd = null;
        this.delayedSetLastDirectoryUsed = null;
        this.linkButton.setSelected(true);
        this.linkButton.setEnabled(true);
        this.copyButton.setEnabled(false);
        this.propertyValue = string.replace('\\', '/');
    }

    public void customizerApply() {
        this.liveProperty.setValue(this.getPropertyValue());
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class HTTPPanel
    extends JPanel {
        JLabel httpLabel = new JLabel();
        JTextField textField = new JTextField();

        HTTPPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.httpLabel.setText(bundle.getMessage("enterUrlHttp"));
            this.httpLabel.setAlignmentX(0.0f);
            this.add(this.httpLabel);
            this.textField.setAlignmentX(0.0f);
            this.textField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(URLPanel.class, (String)"URL_TEXTFIELD_ACCESS_NAME"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLPanel.class, (String)"URL_TEXTFIELD_ACCESS_DESC"));
            this.add(this.textField);
        }
    }
}

