/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.reference;

import com.sun.jsfcl.std.reference.BaseReferenceData;
import com.sun.jsfcl.std.reference.DesignPropertyAttachedReferenceData;
import com.sun.jsfcl.std.reference.ProjectAttachedReferenceData;
import com.sun.jsfcl.std.reference.ReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.jsfcl.std.reference.ReferenceDataManager;
import java.util.List;

public class CompositeReferenceData
extends ReferenceData {
    protected BaseReferenceData baseReferenceData;
    protected List itemsSorted;
    protected ProjectAttachedReferenceData projectReferenceData;
    protected Object projectVersionMarker;
    protected DesignPropertyAttachedReferenceData livePropertyReferenceData;

    public CompositeReferenceData(ReferenceDataManager referenceDataManager, String string, ReferenceDataDefiner referenceDataDefiner, BaseReferenceData baseReferenceData, ProjectAttachedReferenceData projectAttachedReferenceData, DesignPropertyAttachedReferenceData designPropertyAttachedReferenceData) {
        super(referenceDataManager, referenceDataDefiner, string);
        this.name = string;
        this.baseReferenceData = baseReferenceData;
        this.projectReferenceData = projectAttachedReferenceData;
        if (projectAttachedReferenceData != null) {
            referenceDataDefiner = projectAttachedReferenceData.getDefiner();
        }
        this.livePropertyReferenceData = designPropertyAttachedReferenceData;
    }

    public void add(ReferenceDataItem referenceDataItem) {
        if (this.projectReferenceData != null) {
            this.projectReferenceData.add(referenceDataItem);
            this.invalidateItemsCache();
        }
    }

    public boolean canAddRemoveItems() {
        return this.projectReferenceData != null && this.projectReferenceData.canAddRemoveItems();
    }

    protected void defineItems() {
        if (this.baseReferenceData != null) {
            this.items.addAll(this.baseReferenceData.getItems());
        }
        if (this.projectReferenceData != null) {
            this.items.addAll(this.projectReferenceData.getItems());
        }
        if (this.livePropertyReferenceData != null) {
            this.items.addAll(this.livePropertyReferenceData.getItems());
        }
    }

    public List getItems() {
        if (this.items != null && this.projectReferenceData != null && this.projectReferenceData.getVersionMarker() != this.projectVersionMarker) {
            this.invalidateItemsCache();
            this.projectVersionMarker = this.projectReferenceData.getVersionMarker();
        }
        return super.getItems();
    }

    public List getItemsSorted() {
        if (this.itemsSorted != null && this.projectReferenceData != null && this.projectReferenceData.getVersionMarker() != this.projectVersionMarker) {
            this.invalidateItemsCache();
        }
        if (this.itemsSorted == null) {
            this.itemsSorted = ReferenceDataItem.sorted(this.getItems());
        }
        return this.itemsSorted;
    }

    public void invalidateItemsCache() {
        super.invalidateItemsCache();
        this.itemsSorted = null;
    }

    public void invalidateDesignContextRelatedCaches() {
        if (this.livePropertyReferenceData != null) {
            this.livePropertyReferenceData.invalidateItemsCache();
            this.invalidateItemsCache();
        }
    }

    public void remove(ReferenceDataItem referenceDataItem) {
        if (this.projectReferenceData != null) {
            this.projectReferenceData.remove(referenceDataItem);
            this.invalidateItemsCache();
        }
    }
}

