/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.util;

import com.sun.jsfcl.util.ComponentBundle;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;

public class DesignTimeComponentBundle
extends ComponentBundle {
    private static final boolean isDebugOn = Boolean.getBoolean("org.openide.util.NbBundle.DEBUG");

    public void init(String string, ClassLoader classLoader) {
        super.init(string, isDebugOn ? DebugLoader.get(classLoader) : classLoader);
    }

    private static final class DebugLoader
    extends ClassLoader {
        private static int count = 0;
        private static final Map knownIDs = new HashMap();
        private static final Map existing = new WeakHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getID(String string) {
            Map map = knownIDs;
            synchronized (map) {
                Integer n = (Integer)knownIDs.get(string);
                if (n == null) {
                    n = new Integer(++count);
                    knownIDs.put(string, n);
                    System.err.println("ComponentBundle trace: #" + n + " = " + string);
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ClassLoader get(ClassLoader classLoader) {
            Map map = existing;
            synchronized (map) {
                ClassLoader classLoader2;
                Reference reference = (Reference)existing.get(classLoader);
                if (reference != null && (classLoader2 = (ClassLoader)reference.get()) != null) {
                    return classLoader2;
                }
                classLoader2 = new DebugLoader(classLoader);
                existing.put(classLoader, new WeakReference<ClassLoader>(classLoader2));
                return classLoader2;
            }
        }

        private DebugLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public InputStream getResourceAsStream(String string) {
            InputStream inputStream = super.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            if (string.endsWith(".properties")) {
                int n = DebugLoader.getID(string);
                boolean bl = string.indexOf("/Bundle.") != -1 || string.indexOf("/Bundle_") != -1;
                return new DebugInputStream(inputStream, n, bl |= string.matches(".*/Bundle.*\\.properties"));
            }
            return inputStream;
        }

        private static final class DebugInputStream
        extends InputStream {
            protected static final HashSet debugIgnoreKeySet = new HashSet();
            private final InputStream base;
            private final int id;
            private final boolean localizable;
            private int line = 0;
            private static final int WAITING_FOR_KEY = 0;
            private static final int IN_COMMENT = 1;
            private static final int IN_KEY = 2;
            private static final int IN_KEY_BACKSLASH = 3;
            private static final int AFTER_KEY = 4;
            private static final int WAITING_FOR_VALUE = 5;
            private static final int IN_VALUE = 6;
            private static final int IN_VALUE_BACKSLASH = 7;
            private int state = 0;
            private boolean twixtCrAndNl = false;
            private String toInsert = null;
            private boolean reverseLocalizable = false;
            private StringBuffer lastComment = null;
            private StringBuffer lastKey = null;

            public DebugInputStream(InputStream inputStream, int n, boolean bl) {
                this.base = inputStream;
                this.id = n;
                this.localizable = bl;
            }

            public int read() throws IOException {
                if (this.toInsert != null) {
                    char c = this.toInsert.charAt(0);
                    this.toInsert = this.toInsert.length() > 1 ? this.toInsert.substring(1) : null;
                    return c;
                }
                int n = this.base.read();
                if (n == 10) {
                    this.twixtCrAndNl = false;
                    ++this.line;
                } else if (n == 13) {
                    if (this.twixtCrAndNl) {
                        ++this.line;
                    } else {
                        this.twixtCrAndNl = true;
                    }
                } else {
                    this.twixtCrAndNl = false;
                }
                switch (this.state) {
                    case 0: {
                        switch (n) {
                            case 33: 
                            case 35: {
                                this.state = 1;
                                this.lastComment = new StringBuffer();
                                this.lastComment.append((char)n);
                                return n;
                            }
                            case -1: 
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                return n;
                            }
                            case 92: {
                                this.state = 3;
                                return n;
                            }
                        }
                        this.state = 2;
                        this.lastKey = new StringBuffer();
                        this.lastKey.append((char)n);
                        return n;
                    }
                    case 1: {
                        switch (n) {
                            case 10: 
                            case 13: {
                                String string = this.lastComment.toString();
                                this.lastComment = null;
                                if (this.localizable && string.equals("#NOI18N")) {
                                    this.reverseLocalizable = true;
                                } else if (this.localizable && string.equals("#PARTNOI18N")) {
                                    System.err.println("ComponentBundle WARNING (" + this.id + ":" + this.line + "): #PARTNOI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && string.equals("#I18N")) {
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && string.equals("#PARTI18N")) {
                                    System.err.println("ComponentBundle WARNING (" + this.id + ":" + this.line + "): #PARTI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = false;
                                } else if (this.localizable && (string.equals("#I18N") || string.equals("#PARTI18N")) || !this.localizable && (string.equals("#NOI18N") || string.equals("#PARTNOI18N"))) {
                                    System.err.println("ComponentBundle WARNING (" + this.id + ":" + this.line + "): incongruous comment " + string + " found for bundle");
                                    this.reverseLocalizable = false;
                                }
                                this.state = 0;
                                return n;
                            }
                        }
                        this.lastComment.append((char)n);
                        return n;
                    }
                    case 2: {
                        switch (n) {
                            case 92: {
                                this.state = 3;
                                return n;
                            }
                            case 9: 
                            case 32: {
                                this.state = 4;
                                return n;
                            }
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                        }
                        this.lastKey.append((char)n);
                        return n;
                    }
                    case 3: {
                        this.lastKey.append((char)n);
                        this.state = 2;
                        return n;
                    }
                    case 4: {
                        switch (n) {
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                        }
                        return n;
                    }
                    case 5: {
                        switch (n) {
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                            case 9: 
                            case 32: {
                                return n;
                            }
                            case 92: {
                                this.state = 7;
                                return n;
                            }
                        }
                        this.state = 6;
                        return n;
                    }
                    case 6: {
                        switch (n) {
                            case 92: {
                                this.state = 7;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                if (!this.reverseLocalizable) {
                                    String string = this.lastKey.toString();
                                    this.reverseLocalizable = debugIgnoreKeySet.contains(string);
                                }
                                boolean bl = this.reverseLocalizable;
                                this.reverseLocalizable = false;
                                this.state = 0;
                                if (this.localizable ^ bl) {
                                    this.toInsert = "[" + this.id + ":" + this.line + "]" + new Character((char)n);
                                    return 32;
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 7: {
                        this.state = 6;
                        return n;
                    }
                }
                throw new IOException("should never happen");
            }

            public static void main(String[] stringArray) throws Exception {
                int n;
                if (stringArray.length != 1) {
                    throw new Exception();
                }
                boolean bl = Boolean.valueOf(stringArray[0]);
                DebugInputStream debugInputStream = new DebugInputStream(System.in, 123, bl);
                while ((n = debugInputStream.read()) != -1) {
                    System.out.write(n);
                }
            }

            static {
                debugIgnoreKeySet.add("currentVersion");
                debugIgnoreKeySet.add("SplashRunningTextBounds");
                debugIgnoreKeySet.add("SplashProgressBarBounds");
                debugIgnoreKeySet.add("SplashRunningTextColor");
                debugIgnoreKeySet.add("SplashProgressBarColor");
                debugIgnoreKeySet.add("SplashProgressBarColor");
                debugIgnoreKeySet.add("SplashProgressBarEdgeColor");
                debugIgnoreKeySet.add("SplashProgressBarCornerColor");
                debugIgnoreKeySet.add("SplashRunningTextFontSize");
                debugIgnoreKeySet.add("SPLASH_WIDTH");
                debugIgnoreKeySet.add("SPLASH_HEIGHT");
                debugIgnoreKeySet.add("SplashShowProgressBar");
                debugIgnoreKeySet.add("WelcomeLabelFontSize");
                debugIgnoreKeySet.add("WelcomeLabelLine2FontSize");
                debugIgnoreKeySet.add("OpenIDE-Module-Display-Category");
                debugIgnoreKeySet.add("LBL_WebAppAppNameStub");
                debugIgnoreKeySet.add("FOLDER_RaveProjects");
            }
        }
    }
}

