/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.netbeans.modules.visualweb.propertyeditors.PropertyPanelBase;
import org.netbeans.modules.visualweb.propertyeditors.StyleClassPropertyEditor;

public class StyleClassPropertyPanel
extends PropertyPanelBase {
    static final String SELECT_ACTION = "select";
    static final String DESELECT_ACTION = "deselect";
    static final String SELECT_ALL_ACTION = "select_all";
    static final String DESELECT_ALL_ACTION = "deselect_all";
    StyleClassPropertyEditor editor;
    DefaultListModel availableListModel;
    DefaultListModel selectedListModel;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availableListScrollPane;
    private JButton deselectAllButton;
    private JButton deselectButton;
    private JButton selectAllButton;
    private JButton selectButton;
    private JPanel selectButtonPanel;
    private JLabel selectedLabel;
    private JList selectedList;
    private JScrollPane selectedListScrollPane;
    private JLabel titleLabel;

    public StyleClassPropertyPanel(StyleClassPropertyEditor styleClassPropertyEditor) {
        super(styleClassPropertyEditor);
        assert (styleClassPropertyEditor != null);
        this.editor = styleClassPropertyEditor;
        this.selectedListModel = new DefaultListModel();
        String[] stringArray = styleClassPropertyEditor.getStyleClasses();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            this.selectedListModel.addElement(stringArray[i]);
            hashSet.add(stringArray[i]);
        }
        this.availableListModel = new DefaultListModel();
        String[] stringArray2 = styleClassPropertyEditor.getAvailableStyleClasses();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (hashSet.contains(stringArray2[i])) continue;
            this.availableListModel.addElement(stringArray2[i]);
        }
        this.initComponents();
        this.availableList.addKeyListener(new ListKeyListener(this.availableList));
    }

    public Object getPropertyValue() {
        if (this.selectedListModel.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.selectedListModel.get(0));
        for (int i = 1; i < this.selectedListModel.size(); ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(this.selectedListModel.get(i));
        }
        return stringBuffer.toString();
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.availableListScrollPane = new JScrollPane();
        this.availableList = new JList(this.availableListModel);
        this.selectButtonPanel = new JPanel();
        this.selectButton = new JButton();
        this.deselectButton = new JButton();
        this.selectAllButton = new JButton();
        this.deselectAllButton = new JButton();
        this.selectedListScrollPane = new JScrollPane();
        this.selectedList = new JList(this.selectedListModel);
        this.availableLabel = new JLabel();
        this.selectedLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle");
        this.titleLabel.setText(resourceBundle.getString("StyleClassPropertyEditor.title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 6, 11);
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.availableListScrollPane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleName(resourceBundle.getString("StyleClassPropertyEditor.availableList.AccessibleName"));
        this.availableList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("StyleClassPropertyEditor.availableList.AccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.add((Component)this.availableListScrollPane, gridBagConstraints);
        this.selectButtonPanel.setLayout(new BoxLayout(this.selectButtonPanel, 1));
        this.selectButton.setFont(this.selectButton.getFont().deriveFont(1));
        this.selectButton.setText(">");
        this.selectButton.setActionCommand(SELECT_ACTION);
        this.selectButton.setAlignmentY(0.0f);
        this.selectButton.setMinimumSize(new Dimension(45, 23));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleClassPropertyPanel.this.handleButtonAction(actionEvent);
            }
        });
        this.selectButtonPanel.add(this.selectButton);
        this.selectButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("StyleClassPropertyEditor.addButton.AccessibleDescription"));
        this.deselectButton.setFont(this.deselectButton.getFont().deriveFont(1));
        this.deselectButton.setText("<");
        this.deselectButton.setActionCommand(DESELECT_ACTION);
        this.deselectButton.setMinimumSize(new Dimension(45, 23));
        this.selectButtonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleClassPropertyPanel.this.handleButtonAction(actionEvent);
            }
        });
        this.selectButtonPanel.add(this.deselectButton);
        this.deselectButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("StyleClassPropertyEditor.removeButton.AccessibleDescription"));
        this.selectAllButton.setFont(this.selectAllButton.getFont().deriveFont(1));
        this.selectAllButton.setText(">>");
        this.selectAllButton.setActionCommand(SELECT_ALL_ACTION);
        this.selectButtonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleClassPropertyPanel.this.handleButtonAction(actionEvent);
            }
        });
        this.selectButtonPanel.add(this.selectAllButton);
        this.selectAllButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("StyleClassPropertyEditor.addAllButton.AccessibleDescription"));
        this.deselectAllButton.setFont(this.deselectAllButton.getFont().deriveFont(1));
        this.deselectAllButton.setText("<<");
        this.deselectAllButton.setActionCommand(DESELECT_ALL_ACTION);
        this.selectButtonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.deselectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleClassPropertyPanel.this.handleButtonAction(actionEvent);
            }
        });
        this.selectButtonPanel.add(this.deselectAllButton);
        this.deselectAllButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("StyleClassPropertyEditor.removeAllButton.AccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.selectButtonPanel, gridBagConstraints);
        this.selectedListScrollPane.setViewportView(this.selectedList);
        this.selectedList.getAccessibleContext().setAccessibleName(resourceBundle.getString("StyleClassPropertyEditor.selectedList.AccessibleName"));
        this.selectedList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("StyleClassPropertyEditor.selectedList.AccessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.add((Component)this.selectedListScrollPane, gridBagConstraints);
        this.availableLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("StyleClassPropertyEditor.availableStyleClasses.mnemonic").charAt(0));
        this.availableLabel.setLabelFor(this.availableList);
        this.availableLabel.setText(resourceBundle.getString("StyleClassPropertyEditor.availableStyleClasses"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.add((Component)this.availableLabel, gridBagConstraints);
        this.selectedLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/propertyeditors/Bundle").getString("StyleClassPropertyEditor.selectedStyleClasses.mnemonic").charAt(0));
        this.selectedLabel.setLabelFor(this.selectedList);
        this.selectedLabel.setText(resourceBundle.getString("StyleClassPropertyEditor.selectedStyleClasses"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.selectedLabel, gridBagConstraints);
    }

    private void handleButtonAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SELECT_ACTION)) {
            int[] nArray = this.availableList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.selectedListModel.addElement(this.availableListModel.remove(nArray[i]));
            }
        } else if (string.equals(DESELECT_ACTION)) {
            int[] nArray = this.selectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                String string2 = (String)this.selectedListModel.remove(nArray[i]);
                this.availableListModel.add(-1 - Arrays.binarySearch(this.availableListModel.toArray(), string2), string2);
            }
        } else if (string.equals(SELECT_ALL_ACTION)) {
            for (int i = 0; i < this.availableListModel.size(); ++i) {
                this.selectedListModel.addElement(this.availableListModel.get(i));
            }
            this.availableListModel.removeAllElements();
        } else if (string.equals(DESELECT_ALL_ACTION)) {
            for (int i = 0; i < this.selectedListModel.size(); ++i) {
                String string3 = (String)this.selectedListModel.get(i);
                this.availableListModel.add(-1 - Arrays.binarySearch(this.availableListModel.toArray(), string3), string3);
            }
            this.selectedListModel.removeAllElements();
        }
    }

    class ListKeyListener
    implements KeyListener {
        static final long BUFFER_ERASE_DELAY = 350L;
        JList list;
        StringBuffer keyStrokeBuffer;
        Timer keyStrokeTimer;
        TimerTask bufferEraseTask;

        ListKeyListener(JList jList) {
            this.list = jList;
            this.keyStrokeBuffer = new StringBuffer(16);
            this.keyStrokeTimer = new Timer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (!Character.isISOControl(c)) {
                StringBuffer stringBuffer = this.keyStrokeBuffer;
                synchronized (stringBuffer) {
                    if (this.bufferEraseTask != null) {
                        this.bufferEraseTask.cancel();
                    }
                    this.keyStrokeBuffer.append(c);
                    this.bufferEraseTask = new TimerTask(){

                        public void run() {
                            ListKeyListener.this.keyStrokeBuffer.setLength(0);
                        }
                    };
                    this.repositionSelectedItem(this.keyStrokeBuffer.toString());
                    this.keyStrokeTimer.schedule(this.bufferEraseTask, 350L);
                }
            }
        }

        private void repositionSelectedItem(String string) {
            int n;
            int n2 = this.list.getSelectedIndex() - 1;
            ListModel listModel = this.list.getModel();
            if (n2 >= 0) {
                for (n = n2 + 1; n < listModel.getSize(); ++n) {
                    if (!((String)listModel.getElementAt(n)).regionMatches(true, 0, string, 0, string.length())) continue;
                    this.list.setSelectedIndex(n);
                    this.list.ensureIndexIsVisible(n);
                    return;
                }
            }
            for (n = 0; n < listModel.getSize(); ++n) {
                if (!((String)listModel.getElementAt(n)).regionMatches(true, 0, string, 0, string.length())) continue;
                this.list.setSelectedIndex(n);
                this.list.ensureIndexIsVisible(n);
                return;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }
}

