/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css.model;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.visualweb.propertyeditors.css.model.CssStyleData;

public class ColorModel {
    private Color color = Color.BLACK;
    private Map colorNameHexMap = new HashMap();

    public ColorModel() {
        this.colorNameHexMap.put("black", "#000000");
        this.colorNameHexMap.put("gray", "#808080");
        this.colorNameHexMap.put("white", "#FFFFFF");
        this.colorNameHexMap.put("maroon", "#800000");
        this.colorNameHexMap.put("red", "#FF0000");
        this.colorNameHexMap.put("purple", "#800080");
        this.colorNameHexMap.put("fuchsia", "#FF00FF");
        this.colorNameHexMap.put("green", "#008000");
        this.colorNameHexMap.put("lime", "#00FF00");
        this.colorNameHexMap.put("olive", "#808000");
        this.colorNameHexMap.put("orange", "#FFA500");
        this.colorNameHexMap.put("yellow", "#FFFF00");
        this.colorNameHexMap.put("navy", "#000080");
        this.colorNameHexMap.put("blue", "#0000FF");
        this.colorNameHexMap.put("teal", "#008080");
        this.colorNameHexMap.put("aqua", "#00FFFF");
    }

    public DefaultComboBoxModel getColorList() {
        return new ColorList();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String string) {
        if (string.startsWith(CssStyleData.NOT_SET)) {
            this.setColor(Color.BLACK);
        } else if (string.startsWith("#")) {
            this.setHexColor(string);
        } else if (string.startsWith("rgb")) {
            String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                    int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
                    this.color = new Color(n, n2, n3);
                }
            }
            catch (Exception exception) {
                this.color = Color.BLACK;
            }
        } else {
            String string3 = (String)this.colorNameHexMap.get(string);
            if (string3 != null) {
                this.setHexColor(string3);
            }
        }
    }

    public void setHexColor(String string) {
        int n = 0;
        if (string.startsWith("#")) {
            n = 1;
        }
        try {
            int n2 = Integer.parseInt(string.substring(n, n + 2), 16);
            int n3 = Integer.parseInt(string.substring(n + 2, n + 4), 16);
            int n4 = Integer.parseInt(string.substring(n + 4, n + 6), 16);
            this.color = new Color(n2, n3, n4);
        }
        catch (Exception exception) {
            this.color = Color.BLACK;
        }
    }

    public String getHexColor() {
        String string;
        String string2;
        String string3 = Integer.toHexString(this.color.getRed());
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(this.color.getGreen())).length() < 2) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(this.color.getBlue())).length() < 2) {
            string = "0" + string;
        }
        String string4 = "#" + string3 + string2 + string;
        return string4;
    }

    public class ColorList
    extends DefaultComboBoxModel {
        public ColorList() {
            this.addElement(CssStyleData.NOT_SET);
            Iterator iterator = ColorModel.this.colorNameHexMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.addElement(iterator.next());
            }
        }
    }
}

