/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.resolver;

import com.sun.rave.propertyeditors.resolver.PropertyEditorResolver;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import org.netbeans.modules.visualweb.propertyeditors.ConverterPropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.DoublePropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.IntegerPropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.LongPropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.MethodBindingPropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.PropertyEditorBase;
import org.netbeans.modules.visualweb.propertyeditors.StringPropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.ValidatorPropertyEditor;
import org.netbeans.modules.visualweb.propertyeditors.binding.ValueBindingPropertyEditor;

public final class PropertyEditorResolverImpl
implements PropertyEditorResolver {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(PropertyEditorResolverImpl.class.getName());
    private static final String[] exportedPropertyEditorPackageNames = new String[]{"com.sun.rave.propertyeditors", "com.sun.rave.propertyeditors.css", "com.sun.rave.propertyeditors.binding", "com.sun.jsfcl.std.css"};

    public PropertyEditor getEditor(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            return null;
        }
        PropertyEditor propertyEditor = null;
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (clazz == null) {
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            if (clazz2.isPrimitive()) {
                if (clazz2 == Short.TYPE) {
                    propertyEditor = new IntegerPropertyEditor();
                } else if (clazz2 == Integer.TYPE) {
                    propertyEditor = new IntegerPropertyEditor();
                } else if (clazz2 == Long.TYPE) {
                    propertyEditor = new LongPropertyEditor();
                } else if (clazz2 == Float.TYPE) {
                    propertyEditor = new DoublePropertyEditor();
                } else if (clazz2 == Double.TYPE) {
                    propertyEditor = new DoublePropertyEditor();
                }
            }
            if (String.class.isAssignableFrom(clazz2)) {
                propertyEditor = new StringPropertyEditor();
            } else if (Integer.class.isAssignableFrom(clazz2)) {
                propertyEditor = new IntegerPropertyEditor();
            } else if (Long.class.isAssignableFrom(clazz2)) {
                propertyEditor = new LongPropertyEditor();
            } else if (Double.class.isAssignableFrom(clazz2)) {
                propertyEditor = new DoublePropertyEditor();
            } else if (Converter.class.isAssignableFrom(clazz2)) {
                propertyEditor = new ConverterPropertyEditor();
            } else if (Validator.class.isAssignableFrom(clazz2)) {
                propertyEditor = new ValidatorPropertyEditor();
            } else if (ValueBinding.class.isAssignableFrom(clazz2) || ValueExpression.class.isAssignableFrom(clazz2)) {
                propertyEditor = new ValueBindingPropertyEditor();
            } else if (MethodBinding.class.isAssignableFrom(clazz2) || MethodExpression.class.isAssignableFrom(clazz2)) {
                propertyEditor = new MethodBindingPropertyEditor();
            }
        } else if (PropertyEditorResolverImpl.isExportedPropertyEditorClass(clazz)) {
            try {
                String string = clazz.getName();
                String string2 = bundle.getString(string);
                if (string2 != null) {
                    ClassLoader classLoader = PropertyEditorResolverImpl.class.getClassLoader();
                    Class<?> clazz3 = classLoader.loadClass(string2);
                    propertyEditor = (PropertyEditor)clazz3.newInstance();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (PropertyEditorBase.class.isAssignableFrom(clazz)) {
            try {
                propertyEditor = (PropertyEditor)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return propertyEditor;
    }

    private static boolean isExportedPropertyEditorClass(Class clazz) {
        for (String string : exportedPropertyEditorPackageNames) {
            if (!string.equals(clazz.getPackage().getName())) continue;
            return true;
        }
        return false;
    }
}

